/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain.constraints;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.drools.ansible.rulebook.integration.api.domain.conditions.ConditionParseUtil;
import org.drools.ansible.rulebook.integration.api.domain.constraints.ListContainsConstraint;

public class Operators {
    private static final Map<String, BiPredicate> OPERATORS_MAP = new HashMap<String, BiPredicate>();

    public static Predicate<?> toOperatorPredicate(String operator, Object value) {
        String regexPattern;
        String string = regexPattern = value instanceof String ? ConditionParseUtil.toRegexPattern((String)value, operator) : null;
        if (regexPattern != null) {
            Pattern pattern = Pattern.compile(regexPattern);
            return a -> a != null && pattern.matcher(a.toString()).matches();
        }
        BiPredicate op = OPERATORS_MAP.get(operator);
        if (op == null) {
            throw new UnsupportedOperationException("Unknown operator: " + operator);
        }
        return a -> a != null && op.test(a, value);
    }

    static {
        OPERATORS_MAP.put("==", (a, b) -> a.equals(b));
        OPERATORS_MAP.put("!=", (a, b) -> !a.equals(b));
        OPERATORS_MAP.put(">", (a, b) -> ((Comparable)a).compareTo(b) > 0);
        OPERATORS_MAP.put(">=", (a, b) -> ((Comparable)a).compareTo(b) >= 0);
        OPERATORS_MAP.put("<", (a, b) -> ((Comparable)a).compareTo(b) < 0);
        OPERATORS_MAP.put("<=", (a, b) -> ((Comparable)a).compareTo(b) <= 0);
        OPERATORS_MAP.put("in", (a, b) -> ListContainsConstraint.listContains(b, a));
        OPERATORS_MAP.put("not in", (a, b) -> !ListContainsConstraint.listContains(b, a));
        OPERATORS_MAP.put("contains", (a, b) -> ListContainsConstraint.listContains(a, b));
        OPERATORS_MAP.put("not contains", (a, b) -> !ListContainsConstraint.listContains(a, b));
    }
}

