/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain.conditions;

import java.util.List;
import java.util.Map;
import org.drools.ansible.rulebook.integration.api.RuleConfigurationOption;
import org.drools.ansible.rulebook.integration.api.domain.RuleGenerationContext;
import org.drools.ansible.rulebook.integration.api.domain.conditions.AstCondition;
import org.drools.ansible.rulebook.integration.api.domain.conditions.Condition;
import org.drools.ansible.rulebook.integration.api.domain.conditions.ConditionExpression;
import org.drools.ansible.rulebook.integration.api.domain.constraints.ConditionFactory;
import org.drools.ansible.rulebook.integration.api.domain.constraints.ExistsField;
import org.drools.ansible.rulebook.integration.api.domain.constraints.ItemInListConstraint;
import org.drools.ansible.rulebook.integration.api.domain.constraints.ItemNotInListConstraint;
import org.drools.ansible.rulebook.integration.api.domain.constraints.ListContainsConstraint;
import org.drools.ansible.rulebook.integration.api.domain.constraints.ListNotContainsConstraint;
import org.drools.ansible.rulebook.integration.api.domain.constraints.SearchMatchesConstraint;
import org.drools.ansible.rulebook.integration.api.domain.constraints.SelectAttrConstraint;
import org.drools.ansible.rulebook.integration.api.domain.constraints.SelectConstraint;
import org.drools.ansible.rulebook.integration.api.domain.temporal.OnceAfterDefinition;
import org.drools.ansible.rulebook.integration.api.domain.temporal.OnceWithinDefinition;
import org.drools.ansible.rulebook.integration.api.domain.temporal.TimeWindowDefinition;
import org.drools.ansible.rulebook.integration.api.domain.temporal.TimedOutDefinition;
import org.drools.ansible.rulebook.integration.api.rulesmodel.BetaParsedCondition;
import org.drools.ansible.rulebook.integration.api.rulesmodel.ParsedCondition;
import org.drools.model.ConstraintOperator;
import org.drools.model.Index;
import org.drools.model.PrototypeExpression;
import org.drools.model.view.ViewItem;

public class MapCondition
implements Condition {
    private Map<?, ?> map;
    private String patternBinding;

    public MapCondition() {
    }

    public MapCondition(Map<?, ?> map) {
        this.map = map;
    }

    public Map<?, ?> getMap() {
        return this.map;
    }

    public void setMap(Map<?, ?> map) {
        this.map = map;
    }

    private String getPatternBinding(RuleGenerationContext ruleContext) {
        if (this.patternBinding == null) {
            this.patternBinding = ruleContext.generateBinding();
        }
        return this.patternBinding;
    }

    private MapCondition withPatternBinding(String patternBinding) {
        this.patternBinding = patternBinding;
        return this;
    }

    @Override
    public ViewItem toPattern(RuleGenerationContext ruleContext) {
        return MapCondition.map2Ast(ruleContext, MapCondition.parseConditionAttributes(ruleContext, this), null).toPattern(ruleContext);
    }

    private static MapCondition parseConditionAttributes(RuleGenerationContext ruleContext, MapCondition condition) {
        MapCondition.parseThrottle(ruleContext, condition);
        MapCondition.parseTimeOut(ruleContext, condition);
        return condition;
    }

    private static void parseThrottle(RuleGenerationContext ruleContext, MapCondition condition) {
        Map throttle = (Map)condition.getMap().remove("throttle");
        if (throttle != null) {
            List groupByAttributes = (List)throttle.get("group_by_attributes");
            String onceWithin = (String)throttle.get("once_within");
            if (onceWithin != null) {
                ruleContext.setTimeConstraint(OnceWithinDefinition.parseOnceWithin(onceWithin, groupByAttributes));
                return;
            }
            String onceAfter = (String)throttle.get("once_after");
            if (onceAfter != null) {
                ruleContext.setTimeConstraint(OnceAfterDefinition.parseOnceAfter(onceAfter, groupByAttributes));
                return;
            }
            throw new IllegalArgumentException("Invalid throttle definition");
        }
    }

    private static void parseTimeOut(RuleGenerationContext ruleContext, MapCondition condition) {
        String timeOut = (String)condition.getMap().remove("timeout");
        if (timeOut != null) {
            if (condition.getMap().containsKey("NotAllCondition")) {
                ruleContext.setTimeConstraint(TimedOutDefinition.parseTimedOut(timeOut));
            } else {
                ruleContext.setTimeConstraint(TimeWindowDefinition.parseTimeWindow(timeOut));
            }
        }
    }

    private static Condition map2Ast(RuleGenerationContext ruleContext, MapCondition condition, AstCondition.MultipleConditions parent) {
        String expressionName;
        assert (condition.getMap().size() == 1);
        Map.Entry<?, ?> entry = condition.getMap().entrySet().iterator().next();
        switch (expressionName = (String)entry.getKey()) {
            case "NotAllCondition": {
                if (ruleContext.getTimeConstraint().filter(tc -> tc instanceof TimedOutDefinition).isEmpty()) {
                    throw new IllegalArgumentException("NotAllCondition requires a timeout");
                }
            }
            case "AnyCondition": 
            case "AllCondition": {
                AstCondition.MultipleConditions conditions = expressionName.equals("AnyCondition") ? new AstCondition.AnyCondition(ruleContext) : new AstCondition.AllCondition(ruleContext);
                List innerMaps = (List)entry.getValue();
                ruleContext.setMultiplePatterns(innerMaps.size() > 1);
                for (Map subC : innerMaps) {
                    conditions.addCondition(MapCondition.map2Ast(ruleContext, new MapCondition(subC), conditions));
                }
                ruleContext.setMultiplePatterns(false);
                return conditions;
            }
        }
        return MapCondition.pattern2Ast(ruleContext, condition.withPatternBinding(condition.getPatternBinding(ruleContext)), parent);
    }

    private static AstCondition.PatternCondition pattern2Ast(RuleGenerationContext ruleContext, MapCondition condition, AstCondition.MultipleConditions parent) {
        String expressionName;
        assert (condition.getMap().size() == 1);
        Map.Entry<?, ?> entry = condition.getMap().entrySet().iterator().next();
        switch (expressionName = (String)entry.getKey()) {
            case "AssignmentExpression": {
                Map expression = (Map)entry.getValue();
                Map assignment = (Map)expression.get("lhs");
                assert (assignment.size() == 1);
                String binding = (String)assignment.values().iterator().next();
                Map assigned = (Map)expression.get("rhs");
                assert (assigned.size() == 1);
                return MapCondition.pattern2Ast(ruleContext, new MapCondition(assigned).withPatternBinding(binding), parent);
            }
            case "NegateExpression": {
                String binding = condition.getPatternBinding(ruleContext);
                return MapCondition.pattern2Ast(ruleContext, new MapCondition((Map)entry.getValue()).withPatternBinding(binding), parent).negate(ruleContext);
            }
            case "AndExpression": 
            case "OrExpression": {
                String binding = condition.getPatternBinding(ruleContext);
                MapCondition lhs = new MapCondition((Map)((Map)entry.getValue()).get("lhs")).withPatternBinding(binding);
                MapCondition rhs = new MapCondition((Map)((Map)entry.getValue()).get("rhs")).withPatternBinding(binding);
                AstCondition.CombinedPatternCondition combinedPatternCondition = expressionName.equals("OrExpression") ? new AstCondition.OrCondition(binding) : new AstCondition.AndCondition(binding);
                return combinedPatternCondition.withLhs(MapCondition.pattern2Ast(ruleContext, lhs, null)).withRhs(MapCondition.pattern2Ast(ruleContext, rhs, null));
            }
        }
        return new AstCondition.SingleCondition<AstCondition.MultipleConditions>(parent, condition.parseSingle(ruleContext, entry)).withPatternBinding(ruleContext, condition.getPatternBinding(ruleContext));
    }

    private ParsedCondition parseSingle(RuleGenerationContext ruleContext, Map.Entry entry) {
        String expressionName = (String)entry.getKey();
        if (expressionName.equals("Boolean")) {
            return new ParsedCondition(PrototypeExpression.fixedValue(true), (ConstraintOperator)Index.ConstraintType.EQUAL, PrototypeExpression.fixedValue(entry.getValue()));
        }
        if (entry.getValue() instanceof String) {
            return new ParsedCondition(ConditionExpression.mapEntry2Expr(ruleContext, entry).getPrototypeExpression(), (ConstraintOperator)Index.ConstraintType.EQUAL, PrototypeExpression.fixedValue(true));
        }
        return this.parseExpression(ruleContext, expressionName, (Map)entry.getValue());
    }

    private ParsedCondition parseExpression(RuleGenerationContext ruleContext, String expressionName, Map<?, ?> expression) {
        ConstraintOperator operator = MapCondition.decodeOperation(expressionName);
        if (operator instanceof ConditionFactory) {
            return ((ConditionFactory)((Object)operator)).createParsedCondition(ruleContext, expressionName, expression);
        }
        ConditionExpression left = ConditionExpression.map2Expr(ruleContext, expression.get("lhs"));
        ConditionExpression right = ConditionExpression.map2Expr(ruleContext, expression.get("rhs"));
        return right.isBeta() ? new BetaParsedCondition(left.getPrototypeExpression(), operator, right.getBetaVariable(), right.getPrototypeExpression()) : new ParsedCondition(left.getPrototypeExpression(), operator, right.getPrototypeExpression()).withImplicitPattern(this.hasImplicitPattern(ruleContext, left, right));
    }

    private boolean hasImplicitPattern(RuleGenerationContext ruleContext, ConditionExpression left, ConditionExpression right) {
        boolean hasImplicitPattern;
        boolean bl = hasImplicitPattern = left.isField() && right.isField() && !left.getPrototypeName().equals(right.getPrototypeName()) && !ruleContext.isExistingBoundVariable(right.getPrototypeName());
        if (hasImplicitPattern && !ruleContext.hasOption(RuleConfigurationOption.ALLOW_IMPLICIT_JOINS)) {
            throw new UnsupportedOperationException("Cannot have an implicit pattern without using ALLOW_IMPLICIT_JOINS option");
        }
        return hasImplicitPattern;
    }

    private static ConstraintOperator decodeOperation(String expressionName) {
        switch (expressionName) {
            case "EqualsExpression": {
                return Index.ConstraintType.EQUAL;
            }
            case "NotEqualsExpression": {
                return Index.ConstraintType.NOT_EQUAL;
            }
            case "GreaterThanExpression": {
                return Index.ConstraintType.GREATER_THAN;
            }
            case "GreaterThanOrEqualToExpression": {
                return Index.ConstraintType.GREATER_OR_EQUAL;
            }
            case "LessThanExpression": {
                return Index.ConstraintType.LESS_THAN;
            }
            case "LessThanOrEqualToExpression": {
                return Index.ConstraintType.LESS_OR_EQUAL;
            }
            case "IsDefinedExpression": 
            case "IsNotDefinedExpression": {
                return ExistsField.INSTANCE;
            }
            case "ListContainsItemExpression": {
                return ListContainsConstraint.INSTANCE;
            }
            case "ListNotContainsItemExpression": {
                return ListNotContainsConstraint.INSTANCE;
            }
            case "ItemInListExpression": {
                return ItemInListConstraint.INSTANCE;
            }
            case "ItemNotInListExpression": {
                return ItemNotInListConstraint.INSTANCE;
            }
            case "SearchMatchesExpression": 
            case "SearchNotMatchesExpression": {
                return SearchMatchesConstraint.INSTANCE;
            }
            case "SelectExpression": 
            case "SelectNotExpression": {
                return SelectConstraint.INSTANCE;
            }
            case "SelectAttrExpression": 
            case "SelectAttrNotExpression": {
                return SelectAttrConstraint.INSTANCE;
            }
        }
        throw new UnsupportedOperationException("Unrecognized operation type: " + expressionName);
    }

    public String toString() {
        return "MapCondition{map=" + this.map + "}";
    }
}

