/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain.conditions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.drools.ansible.rulebook.integration.api.domain.RuleGenerationContext;
import org.drools.ansible.rulebook.integration.api.domain.conditions.ConditionParseUtil;
import org.drools.model.PrototypeDSL;
import org.drools.model.PrototypeExpression;
import org.drools.model.PrototypeVariable;

public class ConditionExpression {
    private final PrototypeExpression prototypeExpression;
    private final boolean field;
    private final String prototypeName;
    private final PrototypeVariable betaVariable;

    public ConditionExpression(PrototypeExpression prototypeExpression) {
        this(prototypeExpression, false, null, null);
    }

    public ConditionExpression(PrototypeExpression prototypeExpression, boolean field, String prototypeName, PrototypeVariable betaVariable) {
        this.prototypeExpression = prototypeExpression;
        this.field = field;
        this.prototypeName = prototypeName;
        this.betaVariable = betaVariable;
    }

    public ConditionExpression composeWith(PrototypeExpression.BinaryOperation.Operator decodeBinaryOperator, ConditionExpression rhs) {
        PrototypeExpression composed = this.prototypeExpression.composeWith(decodeBinaryOperator, rhs.prototypeExpression);
        if (this.field) {
            return new ConditionExpression(composed, true, this.prototypeName, this.betaVariable);
        }
        if (rhs.field) {
            return new ConditionExpression(composed, true, this.prototypeName, this.betaVariable);
        }
        return new ConditionExpression(composed);
    }

    public boolean isBeta() {
        return this.betaVariable != null;
    }

    public String getFieldName() {
        return ((PrototypeExpression.PrototypeFieldValue)this.prototypeExpression).getFieldName();
    }

    public PrototypeExpression getPrototypeExpression() {
        return this.prototypeExpression;
    }

    public boolean isField() {
        return this.field;
    }

    public String getPrototypeName() {
        return this.prototypeName;
    }

    public PrototypeVariable getBetaVariable() {
        return this.betaVariable;
    }

    public static ConditionExpression map2Expr(RuleGenerationContext ruleContext, Object expr) {
        if (expr instanceof String) {
            return ConditionExpression.createFieldExpression(ruleContext, (String)expr);
        }
        if (expr instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object item : (Collection)expr) {
                Map.Entry itemEntry = ((Map)item).entrySet().iterator().next();
                if (ConditionParseUtil.isKnownType((String)itemEntry.getKey())) {
                    list.add(ConditionParseUtil.toJsonValue(itemEntry));
                    continue;
                }
                throw new UnsupportedOperationException("Unknown list item: " + itemEntry);
            }
            return new ConditionExpression(PrototypeExpression.fixedValue(list));
        }
        Map exprMap = (Map)expr;
        assert (exprMap.size() == 1);
        Map.Entry entry = exprMap.entrySet().iterator().next();
        return ConditionExpression.mapEntry2Expr(ruleContext, expr, entry);
    }

    public static ConditionExpression mapEntry2Expr(RuleGenerationContext ruleContext, Map.Entry entry) {
        return ConditionExpression.mapEntry2Expr(ruleContext, null, entry);
    }

    public static ConditionExpression mapEntry2Expr(RuleGenerationContext ruleContext, Object expr, Map.Entry entry) {
        String key = (String)entry.getKey();
        Object value = entry.getValue();
        if (ConditionParseUtil.isKnownType(key)) {
            return new ConditionExpression(PrototypeExpression.fixedValue(ConditionParseUtil.toJsonValue(key, value)));
        }
        if (value instanceof String) {
            Object fieldName = ConditionExpression.ignoreKey(key) ? (String)value : key + "." + value;
            return ConditionExpression.createFieldExpression(ruleContext, (String)fieldName);
        }
        if (value instanceof Map) {
            Map expression = (Map)value;
            return ConditionExpression.map2Expr(ruleContext, expression.get("lhs")).composeWith(ConditionExpression.decodeBinaryOperator(key), ConditionExpression.map2Expr(ruleContext, expression.get("rhs")));
        }
        throw new UnsupportedOperationException("Invalid expression: " + (expr != null ? expr : entry));
    }

    private static ConditionExpression createFieldExpression(RuleGenerationContext ruleContext, String fieldName) {
        PrototypeDSL.PrototypePatternDef boundPattern;
        int dotPos = fieldName.indexOf(46);
        String prototypeName = fieldName;
        PrototypeVariable betaVariable = null;
        if (dotPos > 0 && (boundPattern = ruleContext.getBoundPattern(prototypeName = fieldName.substring(0, dotPos))) != null) {
            fieldName = fieldName.substring(dotPos + 1);
            betaVariable = (PrototypeVariable)boundPattern.getFirstVariable();
        }
        return new ConditionExpression(PrototypeDSL.fieldName2PrototypeExpression(fieldName), true, prototypeName, betaVariable);
    }

    private static boolean ignoreKey(String key) {
        return key.equalsIgnoreCase("fact") || key.equalsIgnoreCase("facts") || key.equalsIgnoreCase("event") || key.equalsIgnoreCase("events");
    }

    private static PrototypeExpression.BinaryOperation.Operator decodeBinaryOperator(String operator) {
        switch (operator) {
            case "AdditionExpression": {
                return PrototypeExpression.BinaryOperation.Operator.ADD;
            }
            case "SubtractionExpression": {
                return PrototypeExpression.BinaryOperation.Operator.SUB;
            }
            case "MultiplicationExpression": {
                return PrototypeExpression.BinaryOperation.Operator.MUL;
            }
            case "DivisionExpression": {
                return PrototypeExpression.BinaryOperation.Operator.DIV;
            }
        }
        throw new UnsupportedOperationException("Unrecognized binary operator " + operator);
    }

    public String toString() {
        return "ConditionExpression{prototypeExpression=" + this.prototypeExpression + ", field=" + this.field + ", prototypeName='" + this.prototypeName + "'}";
    }
}

