/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.drools.ansible.rulebook.integration.api.RuleConfigurationOption;
import org.drools.ansible.rulebook.integration.api.RuleConfigurationOptions;
import org.drools.ansible.rulebook.integration.api.domain.actions.Action;
import org.drools.ansible.rulebook.integration.api.domain.conditions.Condition;
import org.drools.ansible.rulebook.integration.api.domain.temporal.TimeConstraint;
import org.drools.ansible.rulebook.integration.api.rulesengine.RulesExecutionController;
import org.drools.ansible.rulebook.integration.api.rulesmodel.PrototypeFactory;
import org.drools.model.DSL;
import org.drools.model.Drools;
import org.drools.model.PatternDSL;
import org.drools.model.PrototypeDSL;
import org.drools.model.PrototypeVariable;
import org.drools.model.Rule;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.view.ViewItem;

public class RuleGenerationContext {
    private final RuleConfigurationOptions options = new RuleConfigurationOptions();
    private final StackedContext<String, PrototypeDSL.PrototypePatternDef> patterns = new StackedContext();
    private String ruleName;
    private int bindingsCounter = 0;
    private boolean multiplePatterns = false;
    private Condition condition;
    private Action action;
    private ViewItem lhs;
    private TimeConstraint timeConstraint;

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public void addOptions(Iterable<RuleConfigurationOption> options) {
        this.options.addOptions(options);
    }

    public PrototypeDSL.PrototypePatternDef getOrCreatePattern(String binding, String name) {
        return this.patterns.computeIfAbsent(binding, b -> PrototypeDSL.protoPattern(PrototypeDSL.variable(PrototypeFactory.getPrototype(name), b)));
    }

    public PrototypeVariable getPatternVariable(String binding) {
        PrototypeDSL.PrototypePatternDef patternDef = this.patterns.get(binding);
        return patternDef != null ? (PrototypeVariable)patternDef.getFirstVariable() : null;
    }

    public boolean isExistingBoundVariable(String binding) {
        return this.patterns.get(binding) != null;
    }

    public PrototypeDSL.PrototypePatternDef getBoundPattern(String binding) {
        return this.patterns.get(binding);
    }

    public void pushContext() {
        this.patterns.pushContext();
    }

    public void popContext() {
        this.patterns.popContext();
    }

    public void setMultiplePatterns(boolean multiplePatterns) {
        this.multiplePatterns = multiplePatterns;
    }

    public String generateBinding() {
        Object binding = !this.multiplePatterns && this.bindingsCounter == 0 ? "m" : "m_" + this.bindingsCounter;
        ++this.bindingsCounter;
        return binding;
    }

    public boolean hasOption(RuleConfigurationOption option) {
        return this.options.hasOption(option);
    }

    public static boolean isGeneratedBinding(String binding) {
        return binding.equals("m") || binding.startsWith("m_");
    }

    public Optional<TimeConstraint> getTimeConstraint() {
        return Optional.ofNullable(this.timeConstraint);
    }

    public void setTimeConstraint(TimeConstraint timeConstraint) {
        if (this.timeConstraint != null) {
            throw new IllegalArgumentException("Cannot add more than one time constraint to the same rule");
        }
        this.timeConstraint = timeConstraint;
    }

    public boolean hasTemporalConstraint() {
        this.getOrCreateLHS();
        return this.timeConstraint != null;
    }

    public boolean requiresAsyncExecution() {
        this.getOrCreateLHS();
        return this.timeConstraint != null && this.timeConstraint.requiresAsyncExecution();
    }

    public List<Rule> createRules(RulesExecutionController rulesExecutionController) {
        Rule generatedRule = this.createRule(rulesExecutionController);
        List<Rule> syntheticRules = this.getSyntheticRules();
        if (syntheticRules.isEmpty()) {
            return Collections.singletonList(generatedRule);
        }
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(generatedRule);
        rules.addAll(syntheticRules);
        return rules;
    }

    private Rule createRule(RulesExecutionController rulesExecutionController) {
        ViewItem pattern = this.getOrCreateLHS();
        RuleItemBuilder consequence = this.createConsequence(rulesExecutionController, this.action);
        return this.getTimeConstraint().map(tc -> tc.buildTimedRule(this.ruleName, pattern, consequence)).orElse(PatternDSL.rule(this.ruleName).build(pattern, consequence));
    }

    private ViewItem getOrCreateLHS() {
        if (this.lhs == null) {
            this.lhs = this.condition.toPattern(this);
        }
        return this.lhs;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RuleItemBuilder createConsequence(RulesExecutionController rulesExecutionController, Action action) {
        void var3_7;
        Variable<?>[] consequenceVariables;
        Variable<?>[] variableArray = consequenceVariables = this.timeConstraint != null ? this.timeConstraint.getTimeConstraintConsequenceVariables() : null;
        if (consequenceVariables != null) {
            if (consequenceVariables.length == 1) {
                ConsequenceBuilder._1<Object> _110 = DSL.on(consequenceVariables[0]).execute((drools, fact) -> {
                    this.timeConstraint.executeTimeConstraintConsequence((Drools)drools, fact);
                    this.defaultConsequence(rulesExecutionController, action, (Drools)drools);
                });
                return var3_7;
            } else {
                if (consequenceVariables.length != 2) throw new UnsupportedOperationException();
                ConsequenceBuilder._2<Object, Object> _25 = DSL.on(consequenceVariables[0], consequenceVariables[1]).execute((drools, fact1, fact2) -> {
                    this.timeConstraint.executeTimeConstraintConsequence((Drools)drools, fact1, fact2);
                    this.defaultConsequence(rulesExecutionController, action, (Drools)drools);
                });
            }
            return var3_7;
        } else {
            ConsequenceBuilder._0 _02 = DSL.execute(drools -> this.defaultConsequence(rulesExecutionController, action, (Drools)drools));
        }
        return var3_7;
    }

    private void defaultConsequence(RulesExecutionController rulesExecutionController, Action action, Drools drools) {
        if (rulesExecutionController.executeActions()) {
            action.execute(drools);
        }
    }

    private List<Rule> getSyntheticRules() {
        return this.timeConstraint != null ? this.timeConstraint.getControlRules(this) : Collections.emptyList();
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    private static class StackedContext<K, V> {
        private final Deque<Map<K, V>> stack = new ArrayDeque<Map<K, V>>();

        public StackedContext() {
            this.pushContext();
        }

        public void pushContext() {
            this.stack.addFirst(new HashMap());
        }

        public void popContext() {
            this.stack.removeFirst();
        }

        public V get(K key) {
            for (Map<K, V> map : this.stack) {
                V value = map.get(key);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        public void put(K key, V value) {
            this.stack.getFirst().put(key, value);
        }

        public V computeIfAbsent(K key, Function<K, V> f) {
            V value = this.get(key);
            if (value != null) {
                return value;
            }
            value = f.apply(key);
            this.put(key, value);
            return value;
        }
    }
}

