/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.ansible.rulebook.integration.api.RuleConfigurationOption;
import org.drools.ansible.rulebook.integration.api.RuleConfigurationOptions;
import org.drools.ansible.rulebook.integration.api.domain.RuleGenerationContext;
import org.drools.ansible.rulebook.integration.api.domain.RulesSet;
import org.drools.ansible.rulebook.integration.api.domain.actions.Action;
import org.drools.ansible.rulebook.integration.api.domain.actions.MapAction;
import org.drools.ansible.rulebook.integration.api.domain.conditions.AstCondition;
import org.drools.ansible.rulebook.integration.api.domain.conditions.Condition;
import org.drools.ansible.rulebook.integration.api.domain.temporal.Throttle;
import org.drools.ansible.rulebook.integration.api.domain.temporal.TimeWindowDefinition;
import org.drools.ansible.rulebook.integration.api.rulesengine.RulesExecutionController;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Rule {
    private boolean enabled;
    private final RuleGenerationContext ruleGenerationContext = new RuleGenerationContext();

    public String getName() {
        return this.ruleGenerationContext.getRuleName();
    }

    public void setName(String name) {
        this.ruleGenerationContext.setRuleName(name);
    }

    public void setCondition(Condition condition) {
        this.ruleGenerationContext.setCondition(condition);
    }

    public Rule withOptions(RuleConfigurationOptions options) {
        this.ruleGenerationContext.addOptions(options.getOptions());
        return this;
    }

    public AstCondition withCondition() {
        AstCondition condition = new AstCondition(this.ruleGenerationContext);
        this.ruleGenerationContext.setCondition(condition);
        return condition;
    }

    public void setAction(MapAction action) {
        this.ruleGenerationContext.setAction(action);
    }

    public void setGenericAction(Action action) {
        this.ruleGenerationContext.setAction(action);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setThrottle(Throttle throttle) {
        this.ruleGenerationContext.setTimeConstraint(throttle.asTimeConstraint());
    }

    public void setTimeout(String timeWindow) {
        this.ruleGenerationContext.setTimeConstraint(TimeWindowDefinition.parseTimeWindow(timeWindow));
    }

    public boolean hasTemporalConstraint() {
        return this.ruleGenerationContext.hasTemporalConstraint();
    }

    public boolean requiresAsyncExecution() {
        return this.ruleGenerationContext.requiresAsyncExecution();
    }

    public String toString() {
        return "Rule{name='" + this.ruleGenerationContext.getRuleName() + "', condition='" + this.ruleGenerationContext.getCondition() + "', action='" + this.ruleGenerationContext.getAction() + "'}";
    }

    List<org.drools.model.Rule> toExecModelRules(RulesSet rulesSet, RulesExecutionController rulesExecutionController, AtomicInteger ruleCounter) {
        if (this.ruleGenerationContext.getRuleName() == null) {
            this.ruleGenerationContext.setRuleName("r_" + ruleCounter.getAndIncrement());
        }
        List<org.drools.model.Rule> rules = this.ruleGenerationContext.createRules(rulesExecutionController);
        if (this.ruleGenerationContext.hasTemporalConstraint()) {
            rulesSet.withOptions(RuleConfigurationOption.EVENTS_PROCESSING);
        }
        return rules;
    }
}

