/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.ansible.rulebook.integration.api.RulesExecutor;
import org.drools.ansible.rulebook.integration.api.io.RuleExecutorChannel;
import org.drools.ansible.rulebook.integration.api.rulesengine.AsyncExecutor;

public class RulesExecutorContainer {
    private Map<Long, RulesExecutor> rulesExecutors = new ConcurrentHashMap<Long, RulesExecutor>();
    private AsyncExecutor asyncExecutor;
    private RuleExecutorChannel channel;

    public RulesExecutorContainer allowAsync() {
        if (this.asyncExecutor == null) {
            this.asyncExecutor = new AsyncExecutor();
            this.channel = new RuleExecutorChannel().accept(this.asyncExecutor);
        }
        return this;
    }

    public RulesExecutor register(RulesExecutor rulesExecutor) {
        this.rulesExecutors.put(rulesExecutor.getId(), rulesExecutor);
        rulesExecutor.setRulesExecutorContainer(this);
        return rulesExecutor;
    }

    public void dispose(long rulesExecutorId) {
        this.rulesExecutors.remove(rulesExecutorId);
    }

    public void disposeAll() {
        this.rulesExecutors.values().forEach(RulesExecutor::dispose);
        this.rulesExecutors.clear();
        if (this.channel != null) {
            this.asyncExecutor.shutdown();
            this.channel.shutdown();
        }
    }

    public RulesExecutor get(Long id) {
        return this.rulesExecutors.get(id);
    }

    public AsyncExecutor getAsyncExecutor() {
        return this.asyncExecutor;
    }

    public RuleExecutorChannel getChannel() {
        return this.channel;
    }

    public int port() {
        if (this.channel == null) {
            this.allowAsync();
        }
        return this.channel.port();
    }
}

