"""Module exposing Baker-Campbell-Hausdorff approximation coefficents."""
import geomstats.backend as gs


BCH_COEFFICIENTS = gs.array([
    (1, 1, 0, 1, 1),
    (2, 2, 0, 1, 1),
    (3, 2, 1, -1, 2),
    (4, 3, 1, 1, 12),
    (5, 3, 2, -1, 12),
    (6, 4, 1, 0, 1),
    (7, 4, 2, 1, 24),
    (8, 5, 2, 0, 1),
    (9, 6, 1, -1, 720),
    (10, 6, 2, -1, 180),
    (11, 7, 2, 1, 180),
    (12, 8, 2, 1, 720),
    (13, 4, 3, -1, 120),
    (14, 5, 3, -1, 360),
    (15, 9, 1, 0, 1),
    (16, 9, 2, -1, 1440),
    (17, 10, 2, -1, 360),
    (18, 11, 2, -1, 1440),
    (19, 12, 2, 0, 1),
    (20, 6, 3, 0, 1),
    (21, 7, 3, -1, 240),
    (22, 8, 3, -1, 720),
    (23, 5, 4, 1, 240),
    (24, 15, 1, 1, 30240),
    (25, 15, 2, 1, 5040),
    (26, 16, 2, 1, 3780),
    (27, 17, 2, -1, 3780),
    (28, 18, 2, -1, 5040),
    (29, 19, 2, -1, 30240),
    (30, 9, 3, 1, 2016),
    (31, 10, 3, 23, 15120),
    (32, 11, 3, 1, 5040),
    (33, 12, 3, -1, 10080),
    (34, 13, 3, 1, 1260),
    (35, 14, 3, 1, 5040),
    (36, 6, 4, 1, 5040),
    (37, 7, 4, -1, 10080),
    (38, 8, 4, 1, 1680),
    (39, 6, 5, 13, 15120),
    (40, 7, 5, -1, 1120),
    (41, 8, 5, -1, 5040),
    (42, 24, 1, 0, 1),
    (43, 24, 2, 1, 60480),
    (44, 25, 2, 1, 10080),
    (45, 26, 2, 23, 120960),
    (46, 27, 2, 1, 10080),
    (47, 28, 2, 1, 60480),
    (48, 29, 2, 0, 1),
    (49, 15, 3, 0, 1),
    (50, 16, 3, 1, 4032),
    (51, 17, 3, 23, 30240),
    (52, 18, 3, 1, 2240),
    (53, 19, 3, 1, 15120),
    (54, 20, 3, 0, 1),
    (55, 21, 3, 1, 2520),
    (56, 22, 3, 1, 10080),
    (57, 9, 4, 0, 1),
    (58, 10, 4, 1, 10080),
    (59, 11, 4, -1, 20160),
    (60, 12, 4, -1, 20160),
    (61, 13, 4, 0, 1),
    (62, 14, 4, -1, 2520),
    (63, 9, 5, 1, 4032),
    (64, 10, 5, 1, 840),
    (65, 11, 5, 1, 1440),
    (66, 12, 5, 1, 12096),
    (67, 13, 5, 1, 1260),
    (68, 14, 5, 1, 10080),
    (69, 7, 6, -1, 10080),
    (70, 8, 6, -13, 30240),
    (71, 8, 7, -1, 3360),
    (72, 42, 1, -1, 1209600),
    (73, 42, 2, -1, 151200),
    (74, 43, 2, -1, 56700),
    (75, 44, 2, -1, 75600),
    (76, 45, 2, 1, 75600),
    (77, 46, 2, 1, 56700),
    (78, 47, 2, 1, 151200),
    (79, 48, 2, 1, 1209600),
    (80, 24, 3, -1, 43200),
    (81, 25, 3, -37, 302400),
    (82, 26, 3, -11, 60480),
    (83, 27, 3, -11, 302400),
    (84, 28, 3, 11, 302400),
    (85, 29, 3, 1, 100800),
    (86, 30, 3, -1, 7560),
    (87, 31, 3, -11, 30240),
    (88, 32, 3, -19, 100800),
    (89, 33, 3, -1, 43200),
    (90, 34, 3, -1, 10080),
    (91, 35, 3, -1, 50400),
    (92, 15, 4, -1, 33600),
    (93, 16, 4, -13, 120960),
    (94, 17, 4, -1, 10080),
    (95, 18, 4, -11, 201600),
    (96, 19, 4, -1, 43200),
    (97, 20, 4, -1, 7560),
    (98, 21, 4, -1, 10080),
    (99, 22, 4, 1, 50400),
    (100, 23, 4, 1, 20160),
    (101, 15, 5, -23, 302400),
    (102, 16, 5, -1, 5760),
    (103, 17, 5, 13, 151200),
    (104, 18, 5, 19, 120960),
    (105, 19, 5, 1, 33600),
    (106, 20, 5, -13, 30240),
    (107, 21, 5, -23, 100800),
    (108, 22, 5, -1, 100800),
    (109, 23, 5, -1, 33600),
    (110, 9, 6, -1, 60480),
    (111, 10, 6, -1, 90720),
    (112, 11, 6, 1, 30240),
    (113, 12, 6, -11, 302400),
    (114, 13, 6, 1, 15120),
    (115, 14, 6, 1, 3780),
    (116, 9, 7, -11, 120960),
    (117, 10, 7, -1, 6720),
    (118, 11, 7, -1, 14400),
    (119, 12, 7, -11, 120960),
    (120, 13, 7, -1, 20160),
    (121, 14, 7, 17, 100800),
    (122, 9, 8, -1, 20160),
    (123, 10, 8, 17, 151200),
    (124, 11, 8, 1, 6048),
    (125, 12, 8, 1, 60480),
    (126, 13, 8, -1, 100800),
    (127, 14, 8, 1, 37800),
    (128, 72, 1, 0, 1),
    (129, 72, 2, -1, 2419200),
    (130, 73, 2, -1, 302400),
    (131, 74, 2, -37, 3628800),
    (132, 75, 2, -1, 67200),
    (133, 76, 2, -37, 3628800),
    (134, 77, 2, -1, 302400),
    (135, 78, 2, -1, 2419200),
    (136, 79, 2, 0, 1),
    (137, 42, 3, 0, 1),
    (138, 43, 3, -1, 86400),
    (139, 44, 3, -37, 604800),
    (140, 45, 3, -1, 8960),
    (141, 46, 3, -37, 453600),
    (142, 47, 3, -1, 40320),
    (143, 48, 3, -1, 403200),
    (144, 49, 3, 0, 1),
    (145, 50, 3, -1, 15120),
    (146, 51, 3, -11, 60480),
    (147, 52, 3, -11, 86400),
    (148, 53, 3, -1, 50400),
    (149, 54, 3, 0, 1),
    (150, 55, 3, -1, 20160),
    (151, 56, 3, -1, 100800),
    (152, 24, 4, 0, 1),
    (153, 25, 4, -1, 67200),
    (154, 26, 4, -13, 241920),
    (155, 27, 4, -1, 17280),
    (156, 28, 4, -1, 43200),
    (157, 29, 4, -1, 604800),
    (158, 30, 4, 0, 1),
    (159, 31, 4, -1, 15120),
    (160, 32, 4, -1, 20160),
    (161, 33, 4, 13, 302400),
    (162, 34, 4, 0, 1),
    (163, 35, 4, 1, 20160),
    (164, 36, 4, 0, 1),
    (165, 37, 4, 0, 1),
    (166, 38, 4, 1, 40320),
    (167, 24, 5, -1, 86400),
    (168, 25, 5, -1, 10080),
    (169, 26, 5, -29, 120960),
    (170, 27, 5, -73, 362880),
    (171, 28, 5, -13, 201600),
    (172, 29, 5, -1, 172800),
    (173, 30, 5, -1, 7560),
    (174, 31, 5, -1, 1728),
    (175, 32, 5, -101, 201600),
    (176, 33, 5, -1, 14400),
    (177, 34, 5, -1, 6720),
    (178, 35, 5, -1, 50400),
    (179, 36, 5, -1, 15120),
    (180, 37, 5, -1, 13440),
    (181, 38, 5, 19, 201600),
    (182, 39, 5, -13, 60480),
    (183, 40, 5, -1, 3360),
    (184, 41, 5, -1, 33600),
    (185, 15, 6, 0, 1),
    (186, 16, 6, -1, 120960),
    (187, 17, 6, -1, 181440),
    (188, 18, 6, 1, 40320),
    (189, 19, 6, 1, 56700),
    (190, 20, 6, 0, 1),
    (191, 21, 6, 1, 30240),
    (192, 22, 6, 1, 7560),
    (193, 23, 6, 1, 30240),
    (194, 15, 7, -1, 67200),
    (195, 16, 7, -1, 10080),
    (196, 17, 7, -1, 6720),
    (197, 18, 7, -13, 241920),
    (198, 19, 7, 1, 201600),
    (199, 20, 7, -1, 15120),
    (200, 21, 7, -1, 13440),
    (201, 22, 7, 13, 67200),
    (202, 23, 7, 1, 8064),
    (203, 15, 8, -23, 604800),
    (204, 16, 8, -1, 5760),
    (205, 17, 8, -1, 5040),
    (206, 18, 8, -1, 13440),
    (207, 19, 8, -1, 172800),
    (208, 20, 8, -13, 60480),
    (209, 21, 8, -1, 3150),
    (210, 22, 8, -1, 60480),
    (211, 23, 8, 1, 12600),
    (212, 10, 9, 1, 120960),
    (213, 11, 9, 11, 241920),
    (214, 12, 9, 11, 241920),
    (215, 13, 9, 0, 1),
    (216, 14, 9, 1, 15120),
    (217, 11, 10, 1, 8640),
    (218, 12, 10, 1, 10368),
    (219, 13, 10, 1, 30240),
    (220, 14, 10, 19, 60480),
    (221, 12, 11, 1, 24192),
    (222, 13, 11, -1, 40320),
    (223, 14, 11, 1, 3600),
    (224, 13, 12, -43, 604800),
    (225, 14, 12, 1, 30240),
    (226, 14, 13, 1, 6720),
    (227, 128, 1, 1, 47900160),
    (228, 128, 2, 1, 4790016),
    (229, 129, 2, 1, 1247400),
    (230, 130, 2, 1, 712800),
    (231, 131, 2, 1, 1247400),
    (232, 132, 2, -1, 1247400),
    (233, 133, 2, -1, 712800),
    (234, 134, 2, -1, 1247400),
    (235, 135, 2, -1, 4790016),
    (236, 136, 2, -1, 47900160),
    (237, 72, 3, 1, 1064448),
    (238, 73, 3, 139, 19958400),
    (239, 74, 3, 53, 2851200),
    (240, 75, 3, 271, 13305600),
    (241, 76, 3, 41, 7983360),
    (242, 77, 3, -1, 190080),
    (243, 78, 3, -23, 6652800),
    (244, 79, 3, -5, 9580032),
    (245, 80, 3, 1, 89100),
    (246, 81, 3, 53, 950400),
    (247, 82, 3, 239, 2661120),
    (248, 83, 3, 29, 570240),
    (249, 84, 3, 1, 158400),
    (250, 85, 3, -1, 2217600),
    (251, 86, 3, 7, 190080),
    (252, 87, 3, 13, 133056),
    (253, 88, 3, 17, 266112),
    (254, 89, 3, 1, 118800),
    (255, 90, 3, 1, 55440),
    (256, 91, 3, 1, 332640),
    (257, 42, 4, 13, 6652800),
    (258, 43, 4, 67, 5702400),
    (259, 44, 4, 163, 6652800),
    (260, 45, 4, 37, 1774080),
    (261, 46, 4, 19, 2851200),
    (262, 47, 4, 1, 1900800),
    (263, 48, 4, 1, 2217600),
    (264, 49, 4, 7, 237600),
    (265, 50, 4, 47, 443520),
    (266, 51, 4, 5, 44352),
    (267, 52, 4, 277, 6652800),
    (268, 53, 4, 1, 118800),
    (269, 54, 4, 43, 665280),
    (270, 55, 4, 31, 443520),
    (271, 56, 4, -43, 2217600),
    (272, 57, 4, 1, 73920),
    (273, 58, 4, 13, 443520),
    (274, 59, 4, 29, 2661120),
    (275, 60, 4, -61, 13305600),
    (276, 61, 4, 1, 147840),
    (277, 62, 4, -59, 1330560),
    (278, 42, 5, 89, 19958400),
    (279, 43, 5, 41, 1900800),
    (280, 44, 5, 61, 2217600),
    (281, 45, 5, -23, 3193344),
    (282, 46, 5, -67, 2217600),
    (283, 47, 5, -31, 1900800),
    (284, 48, 5, -19, 8553600),
    (285, 49, 5, 67, 950400),
    (286, 50, 5, 59, 295680),
    (287, 51, 5, 157, 1330560),
    (288, 52, 5, -13, 739200),
    (289, 53, 5, -53, 6652800),
    (290, 54, 5, 17, 95040),
    (291, 55, 5, 1, 5280),
    (292, 56, 5, 23, 1108800),
    (293, 57, 5, 59, 887040),
    (294, 58, 5, 167, 1330560),
    (295, 59, 5, 811, 13305600),
    (296, 60, 5, 17, 739200),
    (297, 61, 5, 17, 221760),
    (298, 62, 5, -97, 1663200),
    (299, 63, 5, 19, 380160),
    (300, 64, 5, 1, 55440),
    (301, 65, 5, -403, 6652800),
    (302, 66, 5, -29, 2661120),
    (303, 67, 5, 17, 221760),
    (304, 68, 5, 1, 831600),
    (305, 24, 6, 7, 2851200),
    (306, 25, 6, 31, 2851200),
    (307, 26, 6, 59, 3991680),
    (308, 27, 6, 31, 3991680),
    (309, 28, 6, 97, 19958400),
    (310, 29, 6, 1, 316800),
    (311, 30, 6, 1, 57024),
    (312, 31, 6, 13, 498960),
    (313, 32, 6, -1, 95040),
    (314, 33, 6, -23, 2494800),
    (315, 34, 6, -1, 73920),
    (316, 35, 6, -17, 221760),
    (317, 36, 6, 1, 199584),
    (318, 37, 6, -1, 55440),
    (319, 38, 6, -23, 665280),
    (320, 39, 6, 31, 1995840),
    (321, 40, 6, -1, 88704),
    (322, 41, 6, 13, 6652800),
    (323, 24, 7, 53, 5702400),
    (324, 25, 7, 163, 4435200),
    (325, 26, 7, 107, 2661120),
    (326, 27, 7, 13, 1596672),
    (327, 28, 7, -1, 887040),
    (328, 29, 7, 7, 1900800),
    (329, 30, 7, 31, 380160),
    (330, 31, 7, 29, 190080),
    (331, 32, 7, 7, 126720),
    (332, 33, 7, 1, 49280),
    (333, 34, 7, 1, 29568),
    (334, 35, 7, -1, 12320),
    (335, 36, 7, 53, 1330560),
    (336, 37, 7, 1, 126720),
    (337, 38, 7, -163, 4435200),
    (338, 39, 7, 53, 665280),
    (339, 40, 7, 1, 24640),
    (340, 41, 7, 67, 1108800),
    (341, 24, 8, 7, 950400),
    (342, 25, 8, 107, 6652800),
    (343, 26, 8, -13, 798336),
    (344, 27, 8, -193, 3991680),
    (345, 28, 8, -1, 35200),
    (346, 29, 8, -29, 8553600),
    (347, 30, 8, 173, 2661120),
    (348, 31, 8, 1, 17820),
    (349, 32, 8, -53, 1330560),
    (350, 33, 8, -13, 1663200),
    (351, 34, 8, 67, 1330560),
    (352, 35, 8, -17, 3326400),
    (353, 36, 8, 53, 1330560),
    (354, 37, 8, 53, 1663200),
    (355, 38, 8, 1, 49280),
    (356, 39, 8, -23, 3991680),
    (357, 40, 8, -229, 2217600),
    (358, 41, 8, -19, 3326400),
    (359, 15, 9, 1, 887040),
    (360, 16, 9, 13, 15966720),
    (361, 17, 9, -1, 190080),
    (362, 18, 9, -17, 5322240),
    (363, 19, 9, 23, 7983360),
    (364, 20, 9, -1, 124740),
    (365, 21, 9, -13, 266112),
    (366, 22, 9, -13, 266112),
    (367, 23, 9, -47, 1330560),
    (368, 15, 10, 167, 19958400),
    (369, 16, 10, 7, 380160),
    (370, 17, 10, 13, 1995840),
    (371, 18, 10, 107, 7983360),
    (372, 19, 10, 13, 739200),
    (373, 20, 10, 13, 1995840),
    (374, 21, 10, -19, 266112),
    (375, 22, 10, -73, 1330560),
    (376, 23, 10, -37, 443520),
    (377, 15, 11, 89, 6652800),
    (378, 16, 11, 19, 887040),
    (379, 17, 11, -19, 1995840),
    (380, 18, 11, -1, 380160),
    (381, 19, 11, 31, 2217600),
    (382, 20, 11, 19, 443520),
    (383, 21, 11, -1, 83160),
    (384, 22, 11, 17, 1330560),
    (385, 23, 11, -1, 23100),
    (386, 15, 12, 7, 1900800),
    (387, 16, 12, -179, 15966720),
    (388, 17, 12, -23, 570240),
    (389, 18, 12, -29, 1064448),
    (390, 19, 12, -43, 23950080),
    (391, 20, 12, 37, 3991680),
    (392, 21, 12, -1, 33264),
    (393, 22, 12, -1, 887040),
    (394, 23, 12, 1, 133056),
    (395, 15, 13, 61, 3326400),
    (396, 16, 13, 167, 2661120),
    (397, 17, 13, 79, 1330560),
    (398, 18, 13, 59, 2661120),
    (399, 19, 13, 1, 110880),
    (400, 20, 13, 1, 14784),
    (401, 21, 13, 13, 443520),
    (402, 22, 13, -31, 443520),
    (403, 23, 13, -13, 147840),
    (404, 15, 14, 1, 23100),
    (405, 16, 14, 23, 177408),
    (406, 17, 14, 13, 142560),
    (407, 18, 14, 1, 332640),
    (408, 19, 14, -1, 554400),
    (409, 20, 14, 29, 133056),
    (410, 21, 14, 1, 4158),
    (411, 22, 14, 37, 1663200),
    (412, 23, 14, -13, 277200),
    (413, 227, 1, 0, 1),
    (414, 227, 2, 1, 95800320),
    (415, 228, 2, 1, 9580032),
    (416, 229, 2, 139, 319334400),
    (417, 230, 2, 13, 13305600),
    (418, 231, 2, 61, 47900160),
    (419, 232, 2, 13, 13305600),
    (420, 233, 2, 139, 319334400),
    (421, 234, 2, 1, 9580032),
    (422, 235, 2, 1, 95800320),
    (423, 236, 2, 0, 1),
    (424, 128, 3, 0, 1),
    (425, 129, 3, 1, 2128896),
    (426, 130, 3, 139, 39916800),
    (427, 131, 3, 13, 1267200),
    (428, 132, 3, 61, 3991680),
    (429, 133, 3, 13, 1064448),
    (430, 134, 3, 139, 26611200),
    (431, 135, 3, 1, 912384),
    (432, 136, 3, 1, 11975040),
    (433, 137, 3, 0, 1),
    (434, 138, 3, 1, 178200),
    (435, 139, 3, 53, 1900800),
    (436, 140, 3, 23, 456192),
    (437, 141, 3, 1, 24640),
    (438, 142, 3, 127, 8870400),
    (439, 143, 3, 5, 3193344),
    (440, 144, 3, 0, 1),
    (441, 145, 3, 7, 380160),
    (442, 146, 3, 13, 266112),
    (443, 147, 3, 1, 27720),
    (444, 148, 3, 67, 13305600),
    (445, 149, 3, 0, 1),
    (446, 150, 3, 1, 110880),
    (447, 151, 3, 1, 665280),
    (448, 72, 4, 0, 1),
    (449, 73, 4, 13, 13305600),
    (450, 74, 4, 67, 11404800),
    (451, 75, 4, 359, 26611200),
    (452, 76, 4, 17, 1140480),
    (453, 77, 4, 331, 39916800),
    (454, 78, 4, 113, 53222400),
    (455, 79, 4, 1, 6386688),
    (456, 80, 4, 0, 1),
    (457, 81, 4, 7, 475200),
    (458, 82, 4, 47, 887040),
    (459, 83, 4, 247, 3991680),
    (460, 84, 4, 83, 3326400),
    (461, 85, 4, 1, 13305600),
    (462, 86, 4, 0, 1),
    (463, 87, 4, 43, 1330560),
    (464, 88, 4, 31, 887040),
    (465, 89, 4, -23, 1663200),
    (466, 90, 4, 0, 1),
    (467, 91, 4, -1, 110880),
    (468, 92, 4, 0, 1),
    (469, 93, 4, 1, 147840),
    (470, 94, 4, 13, 887040),
    (471, 95, 4, 29, 5322240),
    (472, 96, 4, -29, 6652800),
    (473, 97, 4, 0, 1),
    (474, 98, 4, 1, 295680),
    (475, 99, 4, -59, 2661120),
    (476, 100, 4, -1, 295680),
    (477, 72, 5, 1, 2128896),
    (478, 73, 5, 19, 3326400),
    (479, 74, 5, 131, 5702400),
    (480, 75, 5, 677, 15966720),
    (481, 76, 5, 19, 483840),
    (482, 77, 5, 211, 11404800),
    (483, 78, 5, 23, 5702400),
    (484, 79, 5, 1, 3548160),
    (485, 80, 5, 1, 89100),
    (486, 81, 5, 173, 1900800),
    (487, 82, 5, 79, 354816),
    (488, 83, 5, 97, 443520),
    (489, 84, 5, 211, 2419200),
    (490, 85, 5, 7, 760320),
    (491, 86, 5, 7, 126720),
    (492, 87, 5, 157, 665280),
    (493, 88, 5, 101, 443520),
    (494, 89, 5, 197, 6652800),
    (495, 90, 5, 1, 27720),
    (496, 91, 5, 1, 221760),
    (497, 92, 5, 7, 475200),
    (498, 93, 5, 17, 197120),
    (499, 94, 5, 361, 2661120),
    (500, 95, 5, 5, 76032),
    (501, 96, 5, -1, 483840),
    (502, 97, 5, 43, 665280),
    (503, 98, 5, 1, 9240),
    (504, 99, 5, -61, 831600),
    (505, 100, 5, -17, 443520),
    (506, 101, 5, 67, 1900800),
    (507, 102, 5, 1, 6336),
    (508, 103, 5, 283, 1330560),
    (509, 104, 5, 1, 9856),
    (510, 105, 5, 19, 1900800),
    (511, 106, 5, 17, 95040),
    (512, 107, 5, 67, 221760),
    (513, 108, 5, 13, 415800),
    (514, 109, 5, -1, 15840),
    (515, 42, 6, 0, 1),
    (516, 43, 6, 7, 5702400),
    (517, 44, 6, 31, 5702400),
    (518, 45, 6, 43, 5322240),
    (519, 46, 6, 13, 2993760),
    (520, 47, 6, 1, 4435200),
    (521, 48, 6, -13, 26611200),
    (522, 49, 6, 0, 1),
    (523, 50, 6, 1, 114048),
    (524, 51, 6, 13, 997920),
    (525, 52, 6, -1, 124740),
    (526, 53, 6, -13, 831600),
    (527, 54, 6, 0, 1),
    (528, 55, 6, -1, 147840),
    (529, 56, 6, -17, 443520),
    (530, 57, 6, 0, 1),
    (531, 58, 6, 1, 399168),
    (532, 59, 6, -1, 110880),
    (533, 60, 6, -1, 49896),
    (534, 61, 6, 0, 1),
    (535, 62, 6, -17, 665280),
    (536, 63, 6, 1, 114048),
    (537, 64, 6, 83, 3991680),
    (538, 65, 6, -17, 887040),
    (539, 66, 6, -29, 665280),
    (540, 67, 6, -1, 73920),
    (541, 68, 6, -17, 133056),
    (542, 69, 6, -1, 399168),
    (543, 70, 6, -31, 3991680),
    (544, 42, 7, 13, 13305600),
    (545, 43, 7, 1, 95040),
    (546, 44, 7, 457, 13305600),
    (547, 45, 7, 305, 6386688),
    (548, 46, 7, 401, 13305600),
    (549, 47, 7, 59, 7603200),
    (550, 48, 7, 1, 3628800),
    (551, 49, 7, 7, 475200),
    (552, 50, 7, 499, 5322240),
    (553, 51, 7, 397, 2661120),
    (554, 52, 7, 31, 492800),
    (555, 53, 7, -311, 26611200),
    (556, 54, 7, 43, 1330560),
    (557, 55, 7, 23, 443520),
    (558, 56, 7, -139, 2217600),
    (559, 57, 7, 1, 73920),
    (560, 58, 7, 131, 2661120),
    (561, 59, 7, 79, 5322240),
    (562, 60, 7, -79, 1900800),
    (563, 61, 7, 1, 147840),
    (564, 62, 7, -1, 10395),
    (565, 63, 7, 197, 2661120),
    (566, 64, 7, 47, 221760),
    (567, 65, 7, 769, 6652800),
    (568, 66, 7, -13, 332640),
    (569, 67, 7, 1, 13860),
    (570, 68, 7, -89, 415800),
    (571, 69, 7, -53, 2661120),
    (572, 70, 7, -53, 887040),
    (573, 71, 7, -103, 1478400),
    (574, 42, 8, 89, 39916800),
    (575, 43, 8, 1, 57600),
    (576, 44, 8, 31, 665280),
    (577, 45, 8, 59, 1064448),
    (578, 46, 8, 71, 2280960),
    (579, 47, 8, 43, 5702400),
    (580, 48, 8, 1, 1995840),
    (581, 49, 8, 67, 1900800),
    (582, 50, 8, 1, 6048),
    (583, 51, 8, 185, 798336),
    (584, 52, 8, 151, 1330560),
    (585, 53, 8, 119, 11404800),
    (586, 54, 8, 17, 190080),
    (587, 55, 8, 19, 120960),
    (588, 56, 8, 17, 1330560),
    (589, 57, 8, 59, 1774080),
    (590, 58, 8, 1, 10080),
    (591, 59, 8, 173, 2661120),
    (592, 60, 8, -13, 1330560),
    (593, 61, 8, 17, 443520),
    (594, 62, 8, -1, 14400),
    (595, 63, 8, 41, 354816),
    (596, 64, 8, 131, 443520),
    (597, 65, 8, 19, 98560),
    (598, 66, 8, 1, 71280),
    (599, 67, 8, 67, 332640),
    (600, 68, 8, -13, 1108800),
    (601, 69, 8, -1, 60480),
    (602, 70, 8, -29, 570240),
    (603, 71, 8, -53, 887040),
    (604, 24, 9, 0, 1),
    (605, 25, 9, 1, 1774080),
    (606, 26, 9, 13, 31933440),
    (607, 27, 9, -53, 15966720),
    (608, 28, 9, -43, 7983360),
    (609, 29, 9, -43, 15966720),
    (610, 30, 9, 0, 1),
    (611, 31, 9, -1, 249480),
    (612, 32, 9, -13, 532224),
    (613, 33, 9, -239, 7983360),
    (614, 34, 9, 0, 1),
    (615, 35, 9, -7, 380160),
    (616, 36, 9, 0, 1),
    (617, 37, 9, -1, 147840),
    (618, 38, 9, -47, 2661120),
    (619, 39, 9, -1, 249480),
    (620, 40, 9, -71, 1774080),
    (621, 41, 9, -13, 197120),
    (622, 24, 10, 7, 5702400),
    (623, 25, 10, 1, 103950),
    (624, 26, 10, 149, 7983360),
    (625, 27, 10, 193, 23950080),
    (626, 28, 10, -71, 13305600),
    (627, 29, 10, -53, 11404800),
    (628, 30, 10, 1, 114048),
    (629, 31, 10, 13, 798336),
    (630, 32, 10, -131, 2661120),
    (631, 33, 10, -89, 1108800),
    (632, 34, 10, -1, 147840),
    (633, 35, 10, -29, 332640),
    (634, 36, 10, 1, 399168),
    (635, 37, 10, -1, 42240),
    (636, 38, 10, -179, 2661120),
    (637, 39, 10, 1, 90720),
    (638, 40, 10, -1, 12672),
    (639, 41, 10, -31, 184800),
    (640, 24, 11, 53, 11404800),
    (641, 25, 11, 383, 13305600),
    (642, 26, 11, 37, 665280),
    (643, 27, 11, 29, 725760),
    (644, 28, 11, 461, 53222400),
    (645, 29, 11, -7, 5702400),
    (646, 30, 11, 31, 760320),
    (647, 31, 11, 19, 166320),
    (648, 32, 11, 107, 2661120),
    (649, 33, 11, -29, 604800),
    (650, 34, 11, 1, 59136),
    (651, 35, 11, -113, 1330560),
    (652, 36, 11, 53, 2661120),
    (653, 37, 11, -1, 665280),
    (654, 38, 11, -1, 14080),
    (655, 39, 11, 23, 295680),
    (656, 40, 11, 97, 2661120),
    (657, 41, 11, -1387, 13305600),
    (658, 24, 12, 53, 11404800),
    (659, 25, 12, 391, 15966720),
    (660, 26, 12, 677, 15966720),
    (661, 27, 12, 1, 33264),
    (662, 28, 12, 131, 15966720),
    (663, 29, 12, 1, 2280960),
    (664, 30, 12, 139, 3193344),
    (665, 31, 12, 233, 1995840),
    (666, 32, 12, 17, 221760),
    (667, 33, 12, 43, 15966720),
    (668, 34, 12, 5, 133056),
    (669, 35, 12, -1, 147840),
    (670, 36, 12, 29, 1140480),
    (671, 37, 12, 19, 665280),
    (672, 38, 12, -1, 66528),
    (673, 39, 12, 293, 3991680),
    (674, 40, 12, 37, 443520),
    (675, 41, 12, -1, 266112),
    (676, 24, 13, 0, 1),
    (677, 25, 13, 61, 6652800),
    (678, 26, 13, 167, 5322240),
    (679, 27, 13, 37, 1140480),
    (680, 28, 13, 1, 110880),
    (681, 29, 13, -67, 26611200),
    (682, 30, 13, 0, 1),
    (683, 31, 13, 1, 29568),
    (684, 32, 13, 13, 887040),
    (685, 33, 13, -1, 21120),
    (686, 34, 13, 0, 1),
    (687, 35, 13, -1, 27720),
    (688, 36, 13, 0, 1),
    (689, 37, 13, -1, 295680),
    (690, 38, 13, -13, 295680),
    (691, 39, 13, 1, 29568),
    (692, 40, 13, 1, 49280),
    (693, 41, 13, -7, 63360),
    (694, 24, 14, 1, 178200),
    (695, 25, 14, 659, 13305600),
    (696, 26, 14, 1, 7920),
    (697, 27, 14, 509, 3991680),
    (698, 28, 14, 689, 13305600),
    (699, 29, 14, 61, 11404800),
    (700, 30, 14, 7, 126720),
    (701, 31, 14, 17, 66528),
    (702, 32, 14, 337, 1330560),
    (703, 33, 14, 191, 6652800),
    (704, 34, 14, 1, 18480),
    (705, 35, 14, 1, 332640),
    (706, 36, 14, 43, 1330560),
    (707, 37, 14, 19, 332640),
    (708, 38, 14, -101, 2217600),
    (709, 39, 14, 1, 5040),
    (710, 40, 14, 13, 38016),
    (711, 41, 14, 43, 1663200),
    (712, 16, 15, -1, 1774080),
    (713, 17, 15, -167, 39916800),
    (714, 18, 15, -211, 26611200),
    (715, 19, 15, -1, 199584),
    (716, 20, 15, 0, 1),
    (717, 21, 15, -61, 6652800),
    (718, 22, 15, -1, 46200),
    (719, 23, 15, -37, 6652800),
    (720, 17, 16, -37, 2661120),
    (721, 18, 16, -899, 31933440),
    (722, 19, 16, -89, 5322240),
    (723, 20, 16, -1, 249480),
    (724, 21, 16, -1, 17920),
    (725, 22, 16, -563, 5322240),
    (726, 23, 16, -19, 483840),
    (727, 18, 17, -1, 42240),
    (728, 19, 17, -1307, 79833600),
    (729, 20, 17, 13, 3991680),
    (730, 21, 17, -7, 95040),
    (731, 22, 17, -11, 72576),
    (732, 23, 17, -17, 221760),
    (733, 19, 18, -79, 15966720),
    (734, 20, 18, 43, 1596672),
    (735, 21, 18, -1, 147840),
    (736, 22, 18, -7, 95040),
    (737, 23, 18, -1, 18480),
    (738, 20, 19, 1, 44352),
    (739, 21, 19, 323, 13305600),
    (740, 22, 19, -29, 5322240),
    (741, 23, 19, -19, 1900800),
    (742, 21, 20, -1, 29568),
    (743, 22, 20, -29, 266112),
    (744, 23, 20, -41, 1330560),
    (745, 22, 21, -2, 10395),
    (746, 23, 21, -1, 10080),
    (747, 23, 22, -19, 369600),
    (748, 413, 1, -691, 1307674368000),
    (749, 413, 2, -691, 108972864000),
    (750, 414, 2, -1283, 40864824000),
    (751, 415, 2, -2663, 32691859200),
    (752, 416, 2, -127, 1135134000),
    (753, 417, 2, -191, 3405402000),
    (754, 418, 2, 191, 3405402000),
    (755, 419, 2, 127, 1135134000),
    (756, 420, 2, 2663, 32691859200),
    (757, 421, 2, 1283, 40864824000),
    (758, 422, 2, 691, 108972864000),
    (759, 423, 2, 691, 1307674368000),
    (760, 227, 3, -691, 19813248000),
    (761, 228, 3, -43331, 130767436800),
    (762, 229, 3, -18253, 14529715200),
    (763, 230, 3, -86773, 36324288000),
    (764, 231, 3, -35027, 15567552000),
    (765, 232, 3, -7549, 12108096000),
    (766, 233, 3, 4591, 7264857600),
    (767, 234, 3, 80719, 130767436800),
    (768, 235, 3, 6301, 31135104000),
    (769, 236, 3, 691, 31135104000),
    (770, 237, 3, -1283, 1816214400),
    (771, 238, 3, -18253, 3632428800),
    (772, 239, 3, -70517, 5189184000),
    (773, 240, 3, -89801, 5189184000),
    (774, 241, 3, -1103, 110073600),
    (775, 242, 3, -1831, 1210809600),
    (776, 243, 3, 2647, 3962649600),
    (777, 244, 3, 31621, 217945728000),
    (778, 245, 3, -2663, 518918400),
    (779, 246, 3, -21443, 864864000),
    (780, 247, 3, -43399, 1037836800),
    (781, 248, 3, -26671, 908107200),
    (782, 249, 3, -1051, 134534400),
    (783, 250, 3, -12821, 21794572800),
    (784, 251, 3, -127, 10810800),
    (785, 252, 3, -4003, 129729600),
    (786, 253, 3, -1193, 55036800),
    (787, 254, 3, -3167, 1210809600),
    (788, 255, 3, -191, 43243200),
    (789, 256, 3, -191, 302702400),
    (790, 128, 4, -4309, 43589145600),
    (791, 129, 4, -23579, 29059430400),
    (792, 130, 4, -9469, 3632428800),
    (793, 131, 4, -42773, 10378368000),
    (794, 132, 4, -16691, 5189184000),
    (795, 133, 4, -1471, 1614412800),
    (796, 134, 4, 19, 80720640),
    (797, 135, 4, 14479, 87178291200),
    (798, 136, 4, 113, 24216192000),
    (799, 137, 4, -2663, 908107200),
    (800, 138, 4, -8923, 518918400),
    (801, 139, 4, -32057, 864864000),
    (802, 140, 4, -37607, 1037836800),
    (803, 141, 4, -1201, 75675600),
    (804, 142, 4, -43, 15724800),
    (805, 143, 4, -10987, 21794572800),
    (806, 144, 4, -109, 5241600),
    (807, 145, 4, -8623, 115315200),
    (808, 146, 4, -109, 1281280),
    (809, 147, 4, -151, 4586400),
    (810, 148, 4, -2837, 1210809600),
    (811, 149, 4, -73, 2402400),
    (812, 150, 4, -227, 6177600),
    (813, 151, 4, 2293, 302702400),
    (814, 152, 4, -43, 17297280),
    (815, 153, 4, -3977, 345945600),
    (816, 154, 4, -38231, 2075673600),
    (817, 155, 4, -12613, 1037836800),
    (818, 156, 4, -3667, 1210809600),
    (819, 157, 4, -599, 1452971520),
    (820, 158, 4, -127, 6289920),
    (821, 159, 4, -23827, 518918400),
    (822, 160, 4, -7213, 345945600),
    (823, 161, 4, 2053, 302702400),
    (824, 162, 4, -359, 43243200),
    (825, 163, 4, 551, 21621600),
    (826, 164, 4, -127, 34594560),
    (827, 165, 4, -67, 49420800),
    (828, 166, 4, 2053, 345945600),
    (829, 128, 5, -28129, 130767436800),
    (830, 129, 5, -4987, 3228825600),
    (831, 130, 5, -6631, 1651104000),
    (832, 131, 5, -24883, 6227020800),
    (833, 132, 5, 7913, 12108096000),
    (834, 133, 5, 3109, 691891200),
    (835, 134, 5, 117167, 32691859200),
    (836, 135, 5, 18833, 16144128000),
    (837, 136, 5, 1073, 8717829120),
    (838, 137, 5, -23579, 3632428800),
    (839, 138, 5, -171089, 5189184000),
    (840, 139, 5, -32581, 576576000),
    (841, 140, 5, -269, 8153600),
    (842, 141, 5, 5807, 1210809600),
    (843, 142, 5, 142381, 14529715200),
    (844, 143, 5, 337037, 217945728000),
    (845, 144, 5, -4573, 96096000),
    (846, 145, 5, -12889, 86486400),
    (847, 146, 5, -9287, 67267200),
    (848, 147, 5, -7321, 201801600),
    (849, 148, 5, -13127, 7264857600),
    (850, 149, 5, -907, 11793600),
    (851, 150, 5, -3877, 40360320),
    (852, 151, 5, -3149, 302702400),
    (853, 152, 5, -11503, 1037836800),
    (854, 153, 5, -77629, 1729728000),
    (855, 154, 5, -17651, 296524800),
    (856, 155, 5, -103249, 3632428800),
    (857, 156, 5, -8783, 2421619200),
    (858, 157, 5, -27691, 14529715200),
    (859, 158, 5, -16427, 172972800),
    (860, 159, 5, -25933, 129729600),
    (861, 160, 5, -773, 7567560),
    (862, 161, 5, -137, 14414400),
    (863, 162, 5, -1097, 17297280),
    (864, 163, 5, 2281, 55036800),
    (865, 164, 5, -14771, 518918400),
    (866, 165, 5, -953, 43243200),
    (867, 166, 5, 3277, 242161920),
    (868, 167, 5, -49871, 5189184000),
    (869, 168, 5, -9, 320320),
    (870, 169, 5, -85681, 7264857600),
    (871, 170, 5, 1039, 41513472),
    (872, 171, 5, 32321, 1452971520),
    (873, 172, 5, 4439, 1482624000),
    (874, 173, 5, -541, 6406400),
    (875, 174, 5, -117181, 908107200),
    (876, 175, 5, -55753, 2421619200),
    (877, 176, 5, 2053, 1452971520),
    (878, 177, 5, -1801, 24216192),
    (879, 178, 5, -391, 110073600),
    (880, 179, 5, -14563, 259459200),
    (881, 180, 5, -29401, 605404800),
    (882, 181, 5, -23081, 2421619200),
    (883, 182, 5, -14489, 908107200),
    (884, 183, 5, 31, 3294720),
    (885, 184, 5, 313, 181621440),
    (886, 72, 6, -2663, 14529715200),
    (887, 73, 6, -13703, 10897286400),
    (888, 74, 6, -5077, 1556755200),
    (889, 75, 6, -20773, 5189184000),
    (890, 76, 6, -7523, 3113510400),
    (891, 77, 6, -569, 726485760),
    (892, 78, 6, -1013, 3632428800),
    (893, 79, 6, -2663, 18681062400),
    (894, 80, 6, -2857, 778377600),
    (895, 81, 6, -2129, 129729600),
    (896, 82, 6, -12827, 518918400),
    (897, 83, 6, -1151, 77837760),
    (898, 84, 6, -2279, 605404800),
    (899, 85, 6, -37, 30270240),
    (900, 86, 6, -467, 34594560),
    (901, 87, 6, -2213, 86486400),
    (902, 88, 6, -373, 172972800),
    (903, 89, 6, 6739, 605404800),
    (904, 90, 6, 61, 43243200),
    (905, 91, 6, 3239, 129729600),
    (906, 92, 6, -1207, 259459200),
    (907, 93, 6, -47, 3243240),
    (908, 94, 6, -49, 4118400),
    (909, 95, 6, -29, 129729600),
    (910, 96, 6, 379, 201801600),
    (911, 97, 6, -1, 87360),
    (912, 98, 6, 1021, 86486400),
    (913, 99, 6, 341, 7862400),
    (914, 100, 6, 9803, 518918400),
    (915, 101, 6, -1093, 103783680),
    (916, 102, 6, -2809, 94348800),
    (917, 103, 6, -12907, 518918400),
    (918, 104, 6, -5839, 605404800),
    (919, 105, 6, -1459, 242161920),
    (920, 106, 6, -677, 21621600),
    (921, 107, 6, -31, 17297280),
    (922, 108, 6, 21743, 605404800),
    (923, 109, 6, 2071, 37065600),
    (924, 110, 6, -191, 155675520),
    (925, 111, 6, -127, 155675520),
    (926, 112, 6, 1783, 518918400),
    (927, 113, 6, 5581, 1556755200),
    (928, 114, 6, 17, 3459456),
    (929, 115, 6, 7, 374400),
    (930, 72, 7, -18253, 29059430400),
    (931, 73, 7, -9469, 2421619200),
    (932, 74, 7, -45401, 5189184000),
    (933, 75, 7, -1493, 188697600),
    (934, 76, 7, -5723, 4843238400),
    (935, 77, 7, 209, 94348800),
    (936, 78, 7, 21299, 21794572800),
    (937, 79, 7, -113, 1793792000),
    (938, 80, 7, -13703, 1037836800),
    (939, 81, 7, -94169, 1729728000),
    (940, 82, 7, -50723, 691891200),
    (941, 83, 7, -42737, 1210809600),
    (942, 84, 7, -11839, 2421619200),
    (943, 85, 7, -7783, 2905943040),
    (944, 86, 7, -711, 12812800),
    (945, 87, 7, -1241, 10810800),
    (946, 88, 7, -6833, 134534400),
    (947, 89, 7, 293, 151351200),
    (948, 90, 7, -157, 7862400),
    (949, 91, 7, 6011, 201801600),
    (950, 92, 7, -6011, 345945600),
    (951, 93, 7, -36229, 691891200),
    (952, 94, 7, -5273, 115315200),
    (953, 95, 7, -27481, 2421619200),
    (954, 96, 7, -6571, 2421619200),
    (955, 97, 7, -201, 3203200),
    (956, 98, 7, -109, 3203200),
    (957, 99, 7, 16421, 302702400),
    (958, 100, 7, 173, 4804800),
    (959, 101, 7, -27871, 864864000),
    (960, 102, 7, -877, 11531520),
    (961, 103, 7, -4663, 121080960),
    (962, 104, 7, 19, 69189120),
    (963, 105, 7, -39863, 3632428800),
    (964, 106, 7, -937, 7207200),
    (965, 107, 7, -17, 183456),
    (966, 108, 7, 1927, 1210809600),
    (967, 109, 7, 167, 2522520),
    (968, 110, 7, -433, 41513472),
    (969, 111, 7, -1037, 74131200),
    (970, 112, 7, 1633, 345945600),
    (971, 113, 7, 1907, 302702400),
    (972, 114, 7, 27, 1601600),
    (973, 115, 7, 127, 1572480),
    (974, 116, 7, -12671, 691891200),
    (975, 117, 7, -31, 1153152),
    (976, 118, 7, -1199, 220147200),
    (977, 119, 7, -239, 46126080),
    (978, 120, 7, -37, 57657600),
    (979, 121, 7, 8909, 151351200),
    (980, 72, 8, -2663, 4843238400),
    (981, 73, 8, -49769, 18162144000),
    (982, 74, 8, -1117, 311351040),
    (983, 75, 8, 17081, 7264857600),
    (984, 76, 8, 3221, 345945600),
    (985, 77, 8, 38029, 4670265600),
    (986, 78, 8, 17477, 6054048000),
    (987, 79, 8, 4247, 14529715200),
    (988, 80, 8, -60143, 5189184000),
    (989, 81, 8, -12191, 324324000),
    (990, 82, 8, -39827, 1452971520),
    (991, 83, 8, 6631, 454053600),
    (992, 84, 8, 121967, 6227020800),
    (993, 85, 8, 36409, 13621608000),
    (994, 86, 8, -53041, 1037836800),
    (995, 87, 8, -158087, 1816214400),
    (996, 88, 8, -15649, 605404800),
    (997, 89, 8, -823, 2724321600),
    (998, 90, 8, -17887, 605404800),
    (999, 91, 8, 1, 4586400),
    (1000, 92, 8, -27143, 1729728000),
    (1001, 93, 8, -10201, 259459200),
    (1002, 94, 8, -17707, 726485760),
    (1003, 95, 8, -391, 201801600),
    (1004, 96, 8, -23473, 6227020800),
    (1005, 97, 8, -1577, 23587200),
    (1006, 98, 8, -3979, 67267200),
    (1007, 99, 8, -19, 5405400),
    (1008, 100, 8, 5003, 403603200),
    (1009, 101, 8, -18503, 1037836800),
    (1010, 102, 8, -13883, 2421619200),
    (1011, 103, 8, 5851, 86486400),
    (1012, 104, 8, 7255, 108972864),
    (1013, 105, 8, 35869, 4843238400),
    (1014, 106, 8, -8599, 113513400),
    (1015, 107, 8, -23, 8408400),
    (1016, 108, 8, 13529, 3632428800),
    (1017, 109, 8, -2567, 302702400),
    (1018, 110, 8, -10643, 1037836800),
    (1019, 111, 8, -6221, 389188800),
    (1020, 112, 8, -6647, 726485760),
    (1021, 113, 8, -16781, 1816214400),
    (1022, 114, 8, 5, 2594592),
    (1023, 115, 8, 25327, 908107200),
    (1024, 116, 8, -10091, 415134720),
    (1025, 117, 8, -21667, 1210809600),
    (1026, 118, 8, 1013, 172972800),
    (1027, 119, 8, -20591, 1089728640),
    (1028, 120, 8, -6739, 302702400),
    (1029, 121, 8, 563, 75675600),
    (1030, 122, 8, 163, 161441280),
    (1031, 123, 8, 7507, 259459200),
    (1032, 124, 8, 2851, 77837760),
    (1033, 125, 8, 8989, 3632428800),
    (1034, 126, 8, 2699, 605404800),
    (1035, 127, 8, -61, 1556755200),
    (1036, 42, 9, -1457, 7264857600),
    (1037, 43, 9, -6467, 6227020800),
    (1038, 44, 9, -1901, 1037836800),
    (1039, 45, 9, -1831, 1383782400),
    (1040, 46, 9, -367, 622702080),
    (1041, 47, 9, -7751, 14529715200),
    (1042, 48, 9, -79, 220147200),
    (1043, 49, 9, -131, 64864800),
    (1044, 50, 9, -41, 9884160),
    (1045, 51, 9, 281, 172972800),
    (1046, 52, 9, 6067, 1037836800),
    (1047, 53, 9, 661, 363242880),
    (1048, 54, 9, 17, 9434880),
    (1049, 55, 9, 7031, 345945600),
    (1050, 56, 9, 859, 31449600),
    (1051, 57, 9, -37, 34594560),
    (1052, 58, 9, 7, 2965248),
    (1053, 59, 9, 10669, 1037836800),
    (1054, 60, 9, 751, 94348800),
    (1055, 61, 9, 467, 34594560),
    (1056, 62, 9, 21173, 518918400),
    (1057, 63, 9, -361, 138378240),
    (1058, 64, 9, 1871, 1037836800),
    (1059, 65, 9, 3239, 415134720),
    (1060, 66, 9, 109, 807206400),
    (1061, 67, 9, 223, 8236800),
    (1062, 68, 9, 8539, 129729600),
    (1063, 69, 9, 19, 2471040),
    (1064, 70, 9, 4913, 518918400),
    (1065, 71, 9, 2633, 138378240),
    (1066, 42, 10, -11017, 10897286400),
    (1067, 43, 10, -5191, 1037836800),
    (1068, 44, 10, -7277, 864864000),
    (1069, 45, 10, -7057, 1245404160),
    (1070, 46, 10, -821, 403603200),
    (1071, 47, 10, -1663, 1037836800),
    (1072, 48, 10, -7703, 6538371840),
    (1073, 49, 10, -6467, 518918400),
    (1074, 50, 10, -149, 4492800),
    (1075, 51, 10, -10993, 518918400),
    (1076, 52, 10, -1513, 605404800),
    (1077, 53, 10, -3331, 726485760),
    (1078, 54, 10, -3317, 259459200),
    (1079, 55, 10, 19, 800800),
    (1080, 56, 10, 37, 756756),
    (1081, 57, 10, -2071, 207567360),
    (1082, 58, 10, -5279, 518918400),
    (1083, 59, 10, 12373, 1037836800),
    (1084, 60, 10, 20101, 1816214400),
    (1085, 61, 10, 2213, 86486400),
    (1086, 62, 10, 13217, 129729600),
    (1087, 63, 10, -419, 21621600),
    (1088, 64, 10, -1, 45045),
    (1089, 65, 10, -9167, 908107200),
    (1090, 66, 10, -41, 1729728),
    (1091, 67, 10, 1433, 43243200),
    (1092, 68, 10, 17359, 165110400),
    (1093, 69, 10, 3097, 172972800),
    (1094, 70, 10, 1669, 74131200),
    (1095, 71, 10, 3721, 151351200),
    (1096, 42, 11, -607, 403603200),
    (1097, 43, 11, -32699, 5189184000),
    (1098, 44, 11, -7, 988416),
    (1099, 45, 11, 3907, 2905943040),
    (1100, 46, 11, 983, 172972800),
    (1101, 47, 11, 521, 283046400),
    (1102, 48, 11, -11519, 18162144000),
    (1103, 49, 11, -34883, 1729728000),
    (1104, 50, 11, -2087, 43243200),
    (1105, 51, 11, -5879, 242161920),
    (1106, 52, 11, 29, 151351200),
    (1107, 53, 11, -45481, 6227020800),
    (1108, 54, 11, -901, 24710400),
    (1109, 55, 11, -5539, 403603200),
    (1110, 56, 11, 10223, 605404800),
    (1111, 57, 11, -38449, 2075673600),
    (1112, 58, 11, -311, 11793600),
    (1113, 59, 11, -4919, 1452971520),
    (1114, 60, 11, -1333, 454053600),
    (1115, 61, 11, 373, 172972800),
    (1116, 62, 11, 121817, 1816214400),
    (1117, 63, 11, -9631, 415134720),
    (1118, 64, 11, -32339, 3632428800),
    (1119, 65, 11, 641, 74131200),
    (1120, 66, 11, -30581, 1089728640),
    (1121, 67, 11, -2537, 605404800),
    (1122, 68, 11, 11281, 454053600),
    (1123, 69, 11, 251, 28828800),
    (1124, 70, 11, 6359, 726485760),
    (1125, 71, 11, -2411, 172972800),
    (1126, 42, 12, -2803, 4036032000),
    (1127, 43, 12, -937, 566092800),
    (1128, 44, 12, 6043, 2421619200),
    (1129, 45, 12, 577, 55351296),
    (1130, 46, 12, 100063, 9340531200),
    (1131, 47, 12, 43963, 10378368000),
    (1132, 48, 12, 2689, 7264857600),
    (1133, 49, 12, -48199, 5189184000),
    (1134, 50, 12, -277, 24216192),
    (1135, 51, 12, 22283, 1452971520),
    (1136, 52, 12, 11839, 566092800),
    (1137, 53, 12, 571, 283046400),
    (1138, 54, 12, -6043, 302702400),
    (1139, 55, 12, -3503, 484323840),
    (1140, 56, 12, 929, 660441600),
    (1141, 57, 12, -19787, 2075673600),
    (1142, 58, 12, -731, 72648576),
    (1143, 59, 12, 1289, 2905943040),
    (1144, 60, 12, -27871, 6227020800),
    (1145, 61, 12, -6739, 605404800),
    (1146, 62, 12, 353, 103783680),
    (1147, 63, 12, 2879, 7264857600),
    (1148, 64, 12, 1171, 29652480),
    (1149, 65, 12, 5587, 110073600),
    (1150, 66, 12, 1709, 691891200),
    (1151, 67, 12, 14507, 2421619200),
    (1152, 68, 12, 2741, 2421619200),
    (1153, 69, 12, -59, 16144128),
    (1154, 70, 12, -3499, 484323840),
    (1155, 71, 12, -64109, 3632428800),
    (1156, 42, 13, -3323, 1816214400),
    (1157, 43, 13, -11017, 1037836800),
    (1158, 44, 13, -12919, 576576000),
    (1159, 45, 13, -43961, 2075673600),
    (1160, 46, 13, -5497, 605404800),
    (1161, 47, 13, -4709, 2421619200),
    (1162, 48, 13, -28267, 43589145600),
    (1163, 49, 13, -1457, 57657600),
    (1164, 50, 13, -4337, 49420800),
    (1165, 51, 13, -5353, 57657600),
    (1166, 52, 13, -12329, 403603200),
    (1167, 53, 13, -1483, 1210809600),
    (1168, 54, 13, -1063, 21621600),
    (1169, 55, 13, -1171, 28828800),
    (1170, 56, 13, 8131, 201801600),
    (1171, 57, 13, -1627, 69189120),
    (1172, 58, 13, -133, 2745600),
    (1173, 59, 13, -857, 69189120),
    (1174, 60, 13, 751, 48432384),
    (1175, 61, 13, -61, 14414400),
    (1176, 62, 13, 67, 675675),
    (1177, 63, 13, -19247, 345945600),
    (1178, 64, 13, -3131, 28828800),
    (1179, 65, 13, -58543, 1210809600),
    (1180, 66, 13, -293, 44844800),
    (1181, 67, 13, -1, 23400),
    (1182, 68, 13, 33941, 302702400),
    (1183, 69, 13, 373, 24710400),
    (1184, 70, 13, 841, 24710400),
    (1185, 71, 13, 2207, 44844800),
    (1186, 42, 14, -899, 227026800),
    (1187, 43, 14, -107531, 5189184000),
    (1188, 44, 14, -16187, 432432000),
    (1189, 45, 14, -18437, 726485760),
    (1190, 46, 14, -263, 201801600),
    (1191, 47, 14, 3923, 889574400),
    (1192, 48, 14, 9833, 13621608000),
    (1193, 49, 14, -4561, 78624000),
    (1194, 50, 14, -3, 16016),
    (1195, 51, 14, -13829, 75675600),
    (1196, 52, 14, -66161, 1210809600),
    (1197, 53, 14, -16447, 4358914560),
    (1198, 54, 14, -3023, 21621600),
    (1199, 55, 14, -11969, 67267200),
    (1200, 56, 14, -1423, 86486400),
    (1201, 57, 14, -5443, 94348800),
    (1202, 58, 14, -16111, 129729600),
    (1203, 59, 14, -331, 5159700),
    (1204, 60, 14, -12293, 3632428800),
    (1205, 61, 14, -3239, 43243200),
    (1206, 62, 14, 53437, 908107200),
    (1207, 63, 14, -28201, 259459200),
    (1208, 64, 14, -41081, 227026800),
    (1209, 65, 14, -92117, 1816214400),
    (1210, 66, 14, -1123, 544864320),
    (1211, 67, 14, -57007, 302702400),
    (1212, 68, 14, -3599, 1816214400),
    (1213, 69, 14, 89, 86486400),
    (1214, 70, 14, 12359, 454053600),
    (1215, 71, 14, 541, 55036800),
    (1216, 24, 15, -157, 1729728000),
    (1217, 25, 15, -551, 5189184000),
    (1218, 26, 15, 667, 1037836800),
    (1219, 27, 15, 6427, 5189184000),
    (1220, 28, 15, 2113, 5189184000),
    (1221, 29, 15, -8927, 36324288000),
    (1222, 30, 15, 431, 518918400),
    (1223, 31, 15, 317, 43243200),
    (1224, 32, 15, 3911, 288288000),
    (1225, 33, 15, 2423, 324324000),
    (1226, 34, 15, 1471, 172972800),
    (1227, 35, 15, 17921, 864864000),
    (1228, 36, 15, 569, 259459200),
    (1229, 37, 15, 17, 1801800),
    (1230, 38, 15, 8693, 864864000),
    (1231, 39, 15, 353, 74131200),
    (1232, 40, 15, 27661, 1729728000),
    (1233, 41, 15, 6239, 576576000),
    (1234, 24, 16, -5101, 6227020800),
    (1235, 25, 16, -563, 230630400),
    (1236, 26, 16, -103, 76876800),
    (1237, 27, 16, 149, 1245404160),
    (1238, 28, 16, -1979, 968647680),
    (1239, 29, 16, -1637, 691891200),
    (1240, 30, 16, -551, 415134720),
    (1241, 31, 16, 1579, 115315200),
    (1242, 32, 16, 20737, 691891200),
    (1243, 33, 16, 1109, 96864768),
    (1244, 34, 16, 9523, 345945600),
    (1245, 35, 16, 5821, 86486400),
    (1246, 36, 16, 1093, 207567360),
    (1247, 37, 16, 19471, 691891200),
    (1248, 38, 16, 6707, 230630400),
    (1249, 39, 16, 4399, 518918400),
    (1250, 40, 16, 347, 11531520),
    (1251, 41, 16, 6379, 1210809600),
    (1252, 24, 17, -113, 57657600),
    (1253, 25, 17, -15209, 2594592000),
    (1254, 26, 17, -1301, 311351040),
    (1255, 27, 17, -599, 435891456),
    (1256, 28, 17, -743, 172972800),
    (1257, 29, 17, -3961, 934053120),
    (1258, 30, 17, -10763, 1037836800),
    (1259, 31, 17, -1019, 389188800),
    (1260, 32, 17, 839, 66044160),
    (1261, 33, 17, -11927, 1816214400),
    (1262, 34, 17, 12839, 518918400),
    (1263, 35, 17, 120163, 1816214400),
    (1264, 36, 17, 317, 518918400),
    (1265, 37, 17, 6163, 259459200),
    (1266, 38, 17, 16453, 726485760),
    (1267, 39, 17, -59, 311351040),
    (1268, 40, 17, 2489, 403603200),
    (1269, 41, 17, -859, 23587200),
    (1270, 24, 18, -16427, 10378368000),
    (1271, 25, 18, -5987, 2075673600),
    (1272, 26, 18, 8497, 2905943040),
    (1273, 27, 18, 7, 1078272),
    (1274, 28, 18, 6103, 6227020800),
    (1275, 29, 18, -2017, 943488000),
    (1276, 30, 18, -21799, 2075673600),
    (1277, 31, 18, -739, 181621440),
    (1278, 32, 18, 473, 88058880),
    (1279, 33, 18, -72451, 6227020800),
    (1280, 34, 18, 3151, 605404800),
    (1281, 35, 18, 9797, 484323840),
    (1282, 36, 18, -4267, 1037836800),
    (1283, 37, 18, 401, 80720640),
    (1284, 38, 18, -37, 968647680),
    (1285, 39, 18, 9599, 3632428800),
    (1286, 40, 18, 853, 138378240),
    (1287, 41, 18, -130349, 3632428800),
    (1288, 24, 19, -4699, 15567552000),
    (1289, 25, 19, 5039, 4036032000),
    (1290, 26, 19, 31, 4612608),
    (1291, 27, 19, 80567, 9340531200),
    (1292, 28, 19, 6659, 1729728000),
    (1293, 29, 19, 911, 5189184000),
    (1294, 30, 19, -1063, 605404800),
    (1295, 31, 19, 593, 75675600),
    (1296, 32, 19, 26461, 2075673600),
    (1297, 33, 19, -103, 3891888000),
    (1298, 34, 19, 1, 8968960),
    (1299, 35, 19, 1457, 908107200),
    (1300, 36, 19, -1, 687960),
    (1301, 37, 19, 1, 896896),
    (1302, 38, 19, -251, 83026944),
    (1303, 39, 19, 509, 57657600),
    (1304, 40, 19, 140753, 7264857600),
    (1305, 41, 19, -10079, 3459456000),
    (1306, 24, 20, -461, 194594400),
    (1307, 25, 20, -5101, 518918400),
    (1308, 26, 20, -1453, 115315200),
    (1309, 27, 20, -8201, 1556755200),
    (1310, 28, 20, -3, 2038400),
    (1311, 29, 20, -107, 66044160),
    (1312, 30, 20, -157, 11531520),
    (1313, 31, 20, -2729, 259459200),
    (1314, 32, 20, 1907, 57657600),
    (1315, 33, 20, 71, 2293200),
    (1316, 34, 20, 271, 10810800),
    (1317, 35, 20, 2137, 21621600),
    (1318, 36, 20, -1, 1153152),
    (1319, 37, 20, 5491, 172972800),
    (1320, 38, 20, 1769, 34594560),
    (1321, 39, 20, -211, 37065600),
    (1322, 40, 20, 1751, 43243200),
    (1323, 41, 20, 27101, 605404800),
    (1324, 24, 21, -4507, 518918400),
    (1325, 25, 21, -60461, 1729728000),
    (1326, 26, 21, -1669, 37065600),
    (1327, 27, 21, -15293, 726485760),
    (1328, 28, 21, -139, 25225200),
    (1329, 29, 21, -761, 177914880),
    (1330, 30, 21, -23321, 345945600),
    (1331, 31, 21, -3173, 25945920),
    (1332, 32, 21, -36041, 1210809600),
    (1333, 33, 21, 14899, 1210809600),
    (1334, 34, 21, -71, 10810800),
    (1335, 35, 21, 37507, 302702400),
    (1336, 36, 21, -29, 915200),
    (1337, 37, 21, 397, 43243200),
    (1338, 38, 21, 6857, 110073600),
    (1339, 39, 21, -8891, 129729600),
    (1340, 40, 21, -1129, 44844800),
    (1341, 41, 21, 911, 605404800),
    (1342, 24, 22, -21443, 2594592000),
    (1343, 25, 22, -49307, 1729728000),
    (1344, 26, 22, -3373, 132088320),
    (1345, 27, 22, 503, 161441280),
    (1346, 28, 22, 839, 83026944),
    (1347, 29, 22, 17477, 15567552000),
    (1348, 30, 22, -25141, 345945600),
    (1349, 31, 22, -118777, 908107200),
    (1350, 32, 22, -1063, 23063040),
    (1351, 33, 22, -3137, 1452971520),
    (1352, 34, 22, -9067, 151351200),
    (1353, 35, 22, 1051, 134534400),
    (1354, 36, 22, -1147, 24710400),
    (1355, 37, 22, -4031, 100900800),
    (1356, 38, 22, 1381, 484323840),
    (1357, 39, 22, -13931, 227026800),
    (1358, 40, 22, -43507, 2421619200),
    (1359, 41, 22, -439, 242161920),
    (1360, 24, 23, -317, 57657600),
    (1361, 25, 23, -13807, 576576000),
    (1362, 26, 23, -3083, 86486400),
    (1363, 27, 23, -1609, 80720640),
    (1364, 28, 23, -61, 37837800),
    (1365, 29, 23, 6653, 6227020800),
    (1366, 30, 23, -17701, 345945600),
    (1367, 31, 23, -199, 1601600),
    (1368, 32, 23, -32491, 403603200),
    (1369, 33, 23, -8731, 1210809600),
    (1370, 34, 23, -269, 4804800),
    (1371, 35, 23, -163, 6726720),
    (1372, 36, 23, -18463, 518918400),
    (1373, 37, 23, -1, 21840),
    (1374, 38, 23, -2413, 1210809600),
    (1375, 39, 23, -1171, 16216200),
    (1376, 40, 23, -31721, 403603200),
    (1377, 41, 23, 629, 605404800),
    (1378, 748, 1, 0, 1),
    (1379, 748, 2, -691, 2615348736000),
    (1380, 749, 2, -691, 217945728000),
    (1381, 750, 2, -43331, 2615348736000),
    (1382, 751, 2, -4309, 87178291200),
    (1383, 752, 2, -80891, 871782912000),
    (1384, 753, 2, -1381, 12108096000),
    (1385, 754, 2, -80891, 871782912000),
    (1386, 755, 2, -4309, 87178291200),
    (1387, 756, 2, -43331, 2615348736000),
    (1388, 757, 2, -691, 217945728000),
    (1389, 758, 2, -691, 2615348736000),
    (1390, 759, 2, 0, 1),
    (1391, 413, 3, 0, 1),
    (1392, 414, 3, -691, 39626496000),
    (1393, 415, 3, -43331, 261534873600),
    (1394, 416, 3, -4309, 6457651200),
    (1395, 417, 3, -80891, 54486432000),
    (1396, 418, 3, -1381, 691891200),
    (1397, 419, 3, -80891, 48432384000),
    (1398, 420, 3, -4309, 4981616640),
    (1399, 421, 3, -43331, 163459296000),
    (1400, 422, 3, -691, 16144128000),
    (1401, 423, 3, -691, 261534873600),
    (1402, 424, 3, 0, 1),
    (1403, 425, 3, -1283, 3632428800),
    (1404, 426, 3, -18253, 7264857600),
    (1405, 427, 3, -226111, 31135104000),
    (1406, 428, 3, -863, 78624000),
    (1407, 429, 3, -90119, 9686476800),
    (1408, 430, 3, -17399, 3962649600),
    (1409, 431, 3, -457277, 435891456000),
    (1410, 432, 3, -691, 7783776000),
    (1411, 433, 3, 0, 1),
    (1412, 434, 3, -2663, 1037836800),
    (1413, 435, 3, -21443, 1729728000),
    (1414, 436, 3, -647, 28828800),
    (1415, 437, 3, -136259, 7264857600),
    (1416, 438, 3, -20287, 2905943040),
    (1417, 439, 3, -158563, 217945728000),
    (1418, 440, 3, 0, 1),
    (1419, 441, 3, -127, 21621600),
    (1420, 442, 3, -4003, 259459200),
    (1421, 443, 3, -14033, 1210809600),
    (1422, 444, 3, -10411, 7264857600),
    (1423, 445, 3, 0, 1),
    (1424, 446, 3, -191, 86486400),
    (1425, 447, 3, -191, 605404800),
    (1426, 227, 4, 0, 1),
    (1427, 228, 4, -4309, 87178291200),
    (1428, 229, 4, -23579, 58118860800),
    (1429, 230, 4, -6707, 4843238400),
    (1430, 231, 4, -39701, 15567552000),
    (1431, 232, 4, -28573, 10378368000),
    (1432, 233, 4, -103009, 58118860800),
    (1433, 234, 4, -2291, 3487131648),
    (1434, 235, 4, -3389, 27243216000),
    (1435, 236, 4, -691, 87178291200),
    (1436, 237, 4, 0, 1),
    (1437, 238, 4, -2663, 1816214400),
    (1438, 239, 4, -8923, 1037836800),
    (1439, 240, 4, -102541, 5189184000),
    (1440, 241, 4, -1063, 47174400),
    (1441, 242, 4, -8707, 660441600),
    (1442, 243, 4, -7297, 2075673600),
    (1443, 244, 4, -40427, 217945728000),
    (1444, 245, 4, 0, 1),
    (1445, 246, 4, -109, 10483200),
    (1446, 247, 4, -8623, 230630400),
    (1447, 248, 4, -2347, 51891840),
    (1448, 249, 4, -93833, 4843238400),
    (1449, 250, 4, 241, 4843238400),
    (1450, 251, 4, 0, 1),
    (1451, 252, 4, -73, 4804800),
    (1452, 253, 4, -227, 12355200),
    (1453, 254, 4, 229, 50450400),
    (1454, 255, 4, 0, 1),
    (1455, 256, 4, 191, 86486400),
    (1456, 257, 4, 0, 1),
    (1457, 258, 4, -43, 34594560),
    (1458, 259, 4, -3977, 691891200),
    (1459, 260, 4, -40571, 4151347200),
    (1460, 261, 4, -541, 74131200),
    (1461, 262, 4, -57199, 29059430400),
    (1462, 263, 4, 5567, 29059430400),
    (1463, 264, 4, 0, 1),
    (1464, 265, 4, -127, 12579840),
    (1465, 266, 4, -23827, 1037836800),
    (1466, 267, 4, -463, 43243200),
    (1467, 268, 4, 76117, 14529715200),
    (1468, 269, 4, 0, 1),
    (1469, 270, 4, -359, 86486400),
    (1470, 271, 4, 551, 43243200),
    (1471, 272, 4, 0, 1),
    (1472, 273, 4, -127, 69189120),
    (1473, 274, 4, -67, 98841600),
    (1474, 275, 4, 281, 86486400),
    (1475, 276, 4, 0, 1),
    (1476, 277, 4, 359, 86486400),
    (1477, 227, 5, -691, 39626496000),
    (1478, 228, 5, -397, 1452971520),
    (1479, 229, 5, -6301, 4151347200),
    (1480, 230, 5, -185639, 43589145600),
    (1481, 231, 5, -70859, 10378368000),
    (1482, 232, 5, -10447, 1596672000),
    (1483, 233, 5, -32741, 8717829120),
    (1484, 234, 5, -59791, 48432384000),
    (1485, 235, 5, -17803, 87178291200),
    (1486, 236, 5, -691, 59439744000),
    (1487, 237, 5, -1283, 1816214400),
    (1488, 238, 5, -12017, 1452971520),
    (1489, 239, 5, -48749, 1482624000),
    (1490, 240, 5, -108001, 1729728000),
    (1491, 241, 5, -364957, 5811886080),
    (1492, 242, 5, -37657, 1117670400),
    (1493, 243, 5, -3821539, 435891456000),
    (1494, 244, 5, -22741, 31135104000),
    (1495, 245, 5, -2663, 345945600),
    (1496, 246, 5, -17581, 288288000),
    (1497, 247, 5, -1493, 9884160),
    (1498, 248, 5, -114187, 726485760),
    (1499, 249, 5, -15661, 230630400),
    (1500, 250, 5, -1769, 254016000),
    (1501, 251, 5, -127, 5405400),
    (1502, 252, 5, -8663, 86486400),
    (1503, 253, 5, -121567, 1210809600),
    (1504, 254, 5, -42901, 3632428800),
    (1505, 255, 5, -191, 17297280),
    (1506, 256, 5, -191, 151351200),
    (1507, 257, 5, -2663, 1816214400),
    (1508, 258, 5, -1087, 76876800),
    (1509, 259, 5, -22069, 494208000),
    (1510, 260, 5, -14737, 230630400),
    (1511, 261, 5, -642569, 14529715200),
    (1512, 262, 5, -29503, 2235340800),
    (1513, 263, 5, -23129, 39626496000),
    (1514, 264, 5, -109, 5241600),
    (1515, 265, 5, -5287, 43243200),
    (1516, 266, 5, -26099, 129729600),
    (1517, 267, 5, -14081, 134534400),
    (1518, 268, 5, 6271, 1452971520),
    (1519, 269, 5, -73, 1601600),
    (1520, 270, 5, -15019, 172972800),
    (1521, 271, 5, 47039, 1210809600),
    (1522, 272, 5, -127, 12579840),
    (1523, 273, 5, -919, 24710400),
    (1524, 274, 5, -701, 31449600),
    (1525, 275, 5, 123841, 7264857600),
    (1526, 276, 5, -359, 43243200),
    (1527, 277, 5, 233, 5241600),
    (1528, 278, 5, -23579, 7264857600),
    (1529, 279, 5, -521, 21621600),
    (1530, 280, 5, -112529, 1729728000),
    (1531, 281, 5, -1229, 14826240),
    (1532, 282, 5, -381929, 7264857600),
    (1533, 283, 5, -316031, 20756736000),
    (1534, 284, 5, -1073, 871782912),
    (1535, 285, 5, -4573, 96096000),
    (1536, 286, 5, -37859, 172972800),
    (1537, 287, 5, -116447, 363242880),
    (1538, 288, 5, -276139, 1614412800),
    (1539, 289, 5, -243853, 14529715200),
    (1540, 290, 5, -907, 7862400),
    (1541, 291, 5, -5045, 24216192),
    (1542, 292, 5, -50279, 2421619200),
    (1543, 293, 5, -16427, 345945600),
    (1544, 294, 5, -12469, 86486400),
    (1545, 295, 5, -124001, 1210809600),
    (1546, 296, 5, 169289, 14529715200),
    (1547, 297, 5, -1097, 17297280),
    (1548, 298, 5, 901, 12612600),
    (1549, 299, 5, -139, 2702700),
    (1550, 300, 5, -35, 247104),
    (1551, 301, 5, -4867, 46569600),
    (1552, 302, 5, -2707, 296524800),
    (1553, 303, 5, -11189, 121080960),
    (1554, 304, 5, -6121, 2421619200),
    (1555, 128, 6, 0, 1),
    (1556, 129, 6, -2663, 29059430400),
    (1557, 130, 6, -13703, 21794572800),
    (1558, 131, 6, -109, 62899200),
    (1559, 132, 6, -9553, 3891888000),
    (1560, 133, 6, -3929, 2075673600),
    (1561, 134, 6, -11059, 14529715200),
    (1562, 135, 6, -191, 1585059840),
    (1563, 136, 6, 2663, 326918592000),
    (1564, 137, 6, 0, 1),
    (1565, 138, 6, -2857, 1556755200),
    (1566, 139, 6, -2129, 259459200),
    (1567, 140, 6, -10189, 778377600),
    (1568, 141, 6, -1, 117936),
    (1569, 142, 6, -943, 807206400),
    (1570, 143, 6, 4769, 5448643200),
    (1571, 144, 6, 0, 1),
    (1572, 145, 6, -467, 69189120),
    (1573, 146, 6, -2213, 172972800),
    (1574, 147, 6, -89, 172972800),
    (1575, 148, 6, 2357, 269068800),
    (1576, 149, 6, 0, 1),
    (1577, 150, 6, 61, 86486400),
    (1578, 151, 6, 3239, 259459200),
    (1579, 152, 6, 0, 1),
    (1580, 153, 6, -1207, 518918400),
    (1581, 154, 6, -47, 6486480),
    (1582, 155, 6, -4793, 778377600),
    (1583, 156, 6, 83, 129729600),
    (1584, 157, 6, 19289, 7264857600),
    (1585, 158, 6, 0, 1),
    (1586, 159, 6, -1, 174720),
    (1587, 160, 6, 1021, 172972800),
    (1588, 161, 6, 6179, 259459200),
    (1589, 162, 6, 0, 1),
    (1590, 163, 6, 179, 12355200),
    (1591, 164, 6, 0, 1),
    (1592, 165, 6, 127, 69189120),
    (1593, 166, 6, 9803, 1037836800),
    (1594, 167, 6, -2857, 1556755200),
    (1595, 168, 6, -1271, 94348800),
    (1596, 169, 6, -8729, 296524800),
    (1597, 170, 6, -3079, 129729600),
    (1598, 171, 6, -51461, 14529715200),
    (1599, 172, 6, 151, 41395200),
    (1600, 173, 6, -467, 34594560),
    (1601, 174, 6, -1189, 28828800),
    (1602, 175, 6, 19, 57657600),
    (1603, 176, 6, 47687, 908107200),
    (1604, 177, 6, 61, 28828800),
    (1605, 178, 6, 1097, 17297280),
    (1606, 179, 6, -1, 174720),
    (1607, 180, 6, 1849, 172972800),
    (1608, 181, 6, 5813, 103783680),
    (1609, 182, 6, -677, 43243200),
    (1610, 183, 6, 113, 43243200),
    (1611, 184, 6, 2389, 41277600),
    (1612, 185, 6, 0, 1),
    (1613, 186, 6, -191, 311351040),
    (1614, 187, 6, -127, 311351040),
    (1615, 188, 6, 857, 444787200),
    (1616, 189, 6, 211, 86486400),
    (1617, 190, 6, 0, 1),
    (1618, 191, 6, 17, 6918912),
    (1619, 192, 6, 7, 748800),
    (1620, 193, 6, 113, 34594560),
    (1621, 128, 7, -4309, 87178291200),
    (1622, 129, 7, -83, 115315200),
    (1623, 130, 7, -25447, 7264857600),
    (1624, 131, 7, -7943, 958003200),
    (1625, 132, 7, -1381, 128128000),
    (1626, 133, 7, -7331, 922521600),
    (1627, 134, 7, -14033, 4358914560),
    (1628, 135, 7, -6697, 10762752000),
    (1629, 136, 7, -289, 9686476800),
    (1630, 137, 7, -2663, 1816214400),
    (1631, 138, 7, -4507, 296524800),
    (1632, 139, 7, -171023, 3459456000),
    (1633, 140, 7, -181, 2534400),
    (1634, 141, 7, -21481, 440294400),
    (1635, 142, 7, -131653, 9686476800),
    (1636, 143, 7, -271, 8895744000),
    (1637, 144, 7, -109, 10483200),
    (1638, 145, 7, -1073, 16473600),
    (1639, 146, 7, -2669, 24710400),
    (1640, 147, 7, -3229, 62092800),
    (1641, 148, 7, 4127, 538137600),
    (1642, 149, 7, -73, 4804800),
    (1643, 150, 7, -109, 3843840),
    (1644, 151, 7, 25349, 1210809600),
    (1645, 152, 7, -43, 17297280),
    (1646, 153, 7, -133, 6589440),
    (1647, 154, 7, -199189, 4151347200),
    (1648, 155, 7, -1171, 26611200),
    (1649, 156, 7, -113873, 9686476800),
    (1650, 157, 7, 104477, 29059430400),
    (1651, 158, 7, -127, 6289920),
    (1652, 159, 7, -10027, 129729600),
    (1653, 160, 7, -311, 7862400),
    (1654, 161, 7, 1531, 31046400),
    (1655, 162, 7, -359, 43243200),
    (1656, 163, 7, 9313, 172972800),
    (1657, 164, 7, -127, 23063040),
    (1658, 165, 7, -67, 49420800),
    (1659, 166, 7, 97, 3294720),
    (1660, 167, 7, -4201, 345945600),
    (1661, 168, 7, -4217, 57657600),
    (1662, 169, 7, -22157, 148262400),
    (1663, 170, 7, -2221, 17297280),
    (1664, 171, 7, -1579, 38438400),
    (1665, 172, 7, 1537, 1482624000),
    (1666, 173, 7, -4453, 43243200),
    (1667, 174, 7, -10121, 32432400),
    (1668, 175, 7, -30449, 151351200),
    (1669, 176, 7, 19477, 345945600),
    (1670, 177, 7, -5333, 86486400),
    (1671, 178, 7, 33923, 302702400),
    (1672, 179, 7, -1109, 18532800),
    (1673, 180, 7, -2137, 43243200),
    (1674, 181, 7, 2213, 18918900),
    (1675, 182, 7, -109, 997920),
    (1676, 183, 7, -359, 2882880),
    (1677, 184, 7, 10847, 151351200),
    (1678, 185, 7, -1207, 518918400),
    (1679, 186, 7, -739, 59304960),
    (1680, 187, 7, -14083, 1037836800),
    (1681, 188, 7, 1, 184800),
    (1682, 189, 7, 2267, 179379200),
    (1683, 190, 7, -1, 174720),
    (1684, 191, 7, 2479, 172972800),
    (1685, 192, 7, 3947, 57657600),
    (1686, 193, 7, 18647, 518918400),
    (1687, 194, 7, -6011, 691891200),
    (1688, 195, 7, -893, 23063040),
    (1689, 196, 7, -16817, 345945600),
    (1690, 197, 7, -163, 13837824),
    (1691, 198, 7, 51907, 4843238400),
    (1692, 199, 7, -201, 6406400),
    (1693, 200, 7, -1097, 57657600),
    (1694, 201, 7, 48799, 605404800),
    (1695, 202, 7, 421, 7207200),
    (1696, 128, 8, -28129, 261534873600),
    (1697, 129, 8, -11281, 9686476800),
    (1698, 130, 8, -1247, 259459200),
    (1699, 131, 8, -20929, 2075673600),
    (1700, 132, 8, -35093, 2965248000),
    (1701, 133, 8, -9907, 1245404160),
    (1702, 134, 8, -281, 95256000),
    (1703, 135, 8, -5101, 9686476800),
    (1704, 136, 8, -691, 23775897600),
    (1705, 137, 8, -23579, 7264857600),
    (1706, 138, 8, -113, 4504500),
    (1707, 139, 8, -10349, 148262400),
    (1708, 140, 8, -60317, 660441600),
    (1709, 141, 8, -369703, 6227020800),
    (1710, 142, 8, -59881, 3405402000),
    (1711, 143, 8, -7877, 5588352000),
    (1712, 144, 8, -4573, 192192000),
    (1713, 145, 8, -118187, 1037836800),
    (1714, 146, 8, -623141, 3632428800),
    (1715, 147, 8, -84629, 908107200),
    (1716, 148, 8, -377387, 43589145600),
    (1717, 149, 8, -907, 23587200),
    (1718, 150, 8, -43481, 605404800),
    (1719, 151, 8, -7531, 1210809600),
    (1720, 152, 8, -11503, 2075673600),
    (1721, 153, 8, -14689, 432432000),
    (1722, 154, 8, -29467, 415134720),
    (1723, 155, 8, -230117, 3632428800),
    (1724, 156, 8, -91747, 4151347200),
    (1725, 157, 8, -5689, 13621608000),
    (1726, 158, 8, -16427, 345945600),
    (1727, 159, 8, -479, 3203200),
    (1728, 160, 8, -130411, 1210809600),
    (1729, 161, 8, 197, 12972960),
    (1730, 162, 8, -1097, 34594560),
    (1731, 163, 8, 23291, 605404800),
    (1732, 164, 8, -14771, 1037836800),
    (1733, 165, 8, -733, 49420800),
    (1734, 166, 8, 54599, 2421619200),
    (1735, 167, 8, -37801, 2075673600),
    (1736, 168, 8, -55457, 576576000),
    (1737, 169, 8, -124081, 691891200),
    (1738, 170, 8, -31987, 217945728),
    (1739, 171, 8, -161809, 3228825600),
    (1740, 172, 8, -3353, 889574400),
    (1741, 173, 8, -42337, 259459200),
    (1742, 174, 8, -93109, 201801600),
    (1743, 175, 8, -838741, 2421619200),
    (1744, 176, 8, -296293, 10897286400),
    (1745, 177, 8, -176471, 1210809600),
    (1746, 178, 8, 1, 1351350),
    (1747, 179, 8, -9143, 86486400),
    (1748, 180, 8, -739, 5381376),
    (1749, 181, 8, 11959, 269068800),
    (1750, 182, 8, -2803, 18532800),
    (1751, 183, 8, -62917, 302702400),
    (1752, 184, 8, -21347, 2421619200),
    (1753, 185, 8, -1093, 207567360),
    (1754, 186, 8, -3841, 172972800),
    (1755, 187, 8, -7979, 311351040),
    (1756, 188, 8, -1679, 454053600),
    (1757, 189, 8, 47231, 6227020800),
    (1758, 190, 8, -677, 43243200),
    (1759, 191, 8, 179, 51891840),
    (1760, 192, 8, 57977, 908107200),
    (1761, 193, 8, 3901, 86486400),
    (1762, 194, 8, -85, 3075072),
    (1763, 195, 8, -6913, 62899200),
    (1764, 196, 8, -141563, 1037836800),
    (1765, 197, 8, -7717, 145297152),
    (1766, 198, 8, 4547, 880588800),
    (1767, 199, 8, -7433, 64864800),
    (1768, 200, 8, -159989, 1210809600),
    (1769, 201, 8, 68353, 807206400),
    (1770, 202, 8, 120221, 1210809600),
    (1771, 203, 8, -18397, 1037836800),
    (1772, 204, 8, -44599, 691891200),
    (1773, 205, 8, -31, 405405),
    (1774, 206, 8, -78971, 2421619200),
    (1775, 207, 8, -4247, 2075673600),
    (1776, 208, 8, -300019, 3632428800),
    (1777, 209, 8, -39937, 345945600),
    (1778, 210, 8, -31517, 10897286400),
    (1779, 211, 8, 737, 31449600),
    (1780, 72, 9, 0, 1),
    (1781, 73, 9, -1457, 14529715200),
    (1782, 74, 9, -6467, 12454041600),
    (1783, 75, 9, -571, 593049600),
    (1784, 76, 9, -4331, 6227020800),
    (1785, 77, 9, -41, 6227020800),
    (1786, 78, 9, 2851, 11623772160),
    (1787, 79, 9, 20287, 174356582400),
    (1788, 80, 9, 0, 1),
    (1789, 81, 9, -131, 129729600),
    (1790, 82, 9, -41, 19768320),
    (1791, 83, 9, 3569, 3113510400),
    (1792, 84, 9, 2573, 518918400),
    (1793, 85, 9, 50803, 14529715200),
    (1794, 86, 9, 0, 1),
    (1795, 87, 9, 17, 18869760),
    (1796, 88, 9, 7031, 691891200),
    (1797, 89, 9, 7883, 518918400),
    (1798, 90, 9, 0, 1),
    (1799, 91, 9, 127, 21621600),
    (1800, 92, 9, 0, 1),
    (1801, 93, 9, -37, 69189120),
    (1802, 94, 9, 7, 5930496),
    (1803, 95, 9, 11839, 2075673600),
    (1804, 96, 9, 943, 172972800),
    (1805, 97, 9, 0, 1),
    (1806, 98, 9, 467, 69189120),
    (1807, 99, 9, 21173, 1037836800),
    (1808, 100, 9, 463, 138378240),
    (1809, 101, 9, -131, 129729600),
    (1810, 102, 9, -17, 5031936),
    (1811, 103, 9, 1879, 691891200),
    (1812, 104, 9, 29537, 2075673600),
    (1813, 105, 9, 346447, 29059430400),
    (1814, 106, 9, 17, 9434880),
    (1815, 107, 9, 5857, 172972800),
    (1816, 108, 9, 5147, 74131200),
    (1817, 109, 9, 367, 10810800),
    (1818, 110, 9, 0, 1),
    (1819, 111, 9, 191, 311351040),
    (1820, 112, 9, 19, 4942080),
    (1821, 113, 9, 1141, 222393600),
    (1822, 114, 9, 0, 1),
    (1823, 115, 9, 607, 103783680),
    (1824, 116, 9, -37, 69189120),
    (1825, 117, 9, 353, 138378240),
    (1826, 118, 9, 66371, 4151347200),
    (1827, 119, 9, 3077, 159667200),
    (1828, 120, 9, 467, 69189120),
    (1829, 121, 9, 19711, 518918400),
    (1830, 122, 9, -361, 276756480),
    (1831, 123, 9, 149, 64864800),
    (1832, 124, 9, 6869, 415134720),
    (1833, 125, 9, 131503, 7264857600),
    (1834, 126, 9, 223, 16473600),
    (1835, 127, 9, 9343, 172972800),
    (1836, 72, 10, -2663, 29059430400),
    (1837, 73, 10, -103, 90810720),
    (1838, 74, 10, -1063, 239500800),
    (1839, 75, 10, -9859, 1245404160),
    (1840, 76, 10, -1321, 188697600),
    (1841, 77, 10, -17651, 6227020800),
    (1842, 78, 10, -4621, 21794572800),
    (1843, 79, 10, 2663, 16144128000),
    (1844, 80, 10, -2857, 1556755200),
    (1845, 81, 10, -14983, 1037836800),
    (1846, 82, 10, -1657, 53222400),
    (1847, 83, 10, -2791, 129729600),
    (1848, 84, 10, 36851, 14529715200),
    (1849, 85, 10, 109871, 14529715200),
    (1850, 86, 10, -467, 69189120),
    (1851, 87, 10, -2489, 129729600),
    (1852, 88, 10, 83, 6652800),
    (1853, 89, 10, 39653, 908107200),
    (1854, 90, 10, 61, 86486400),
    (1855, 91, 10, 1207, 43243200),
    (1856, 92, 10, -1207, 518918400),
    (1857, 93, 10, -1693, 138378240),
    (1858, 94, 10, -133, 11404800),
    (1859, 95, 10, 1613, 172972800),
    (1860, 96, 10, 227363, 14529715200),
    (1861, 97, 10, -1, 174720),
    (1862, 98, 10, 7, 374400),
    (1863, 99, 10, 1577, 19958400),
    (1864, 100, 10, 53, 2702700),
    (1865, 101, 10, -2983, 259459200),
    (1866, 102, 10, -3151, 69189120),
    (1867, 103, 10, -563, 12972960),
    (1868, 104, 10, 1891, 207567360),
    (1869, 105, 10, 46463, 1816214400),
    (1870, 106, 10, -7379, 259459200),
    (1871, 107, 10, 1597, 34594560),
    (1872, 108, 10, 708143, 3632428800),
    (1873, 109, 10, 159, 1281280),
    (1874, 110, 10, -191, 155675520),
    (1875, 111, 10, -127, 311351040),
    (1876, 112, 10, 11, 806400),
    (1877, 113, 10, 10421, 518918400),
    (1878, 114, 10, 17, 3459456),
    (1879, 115, 10, 9829, 259459200),
    (1880, 116, 10, -353, 34594560),
    (1881, 117, 10, -529, 34594560),
    (1882, 118, 10, 4237, 129729600),
    (1883, 119, 10, 11933, 207567360),
    (1884, 120, 10, 3671, 172972800),
    (1885, 121, 10, 77647, 518918400),
    (1886, 122, 10, -7061, 415134720),
    (1887, 123, 10, -749, 24710400),
    (1888, 124, 10, 449, 31449600),
    (1889, 125, 10, 88091, 2179457280),
    (1890, 126, 10, 10853, 518918400),
    (1891, 127, 10, 1249, 8072064),
    (1892, 72, 11, -18253, 58118860800),
    (1893, 73, 11, -1021, 345945600),
    (1894, 74, 11, -527, 51891840),
    (1895, 75, 11, -7037, 415134720),
    (1896, 76, 11, -9463, 638668800),
    (1897, 77, 11, -20653, 3113510400),
    (1898, 78, 11, -7577, 6054048000),
    (1899, 79, 11, -101, 29059430400),
    (1900, 80, 11, -13703, 2075673600),
    (1901, 81, 11, -211, 5148000),
    (1902, 82, 11, -37, 439296),
    (1903, 83, 11, -255163, 3632428800),
    (1904, 84, 11, -6107, 319334400),
    (1905, 85, 11, 82837, 27243216000),
    (1906, 86, 11, -711, 25625600),
    (1907, 87, 11, -14479, 172972800),
    (1908, 88, 11, -36503, 807206400),
    (1909, 89, 11, 6533, 227026800),
    (1910, 90, 11, -157, 15724800),
    (1911, 91, 11, 16943, 605404800),
    (1912, 92, 11, -6011, 691891200),
    (1913, 93, 11, -20147, 518918400),
    (1914, 94, 11, -10037, 207567360),
    (1915, 95, 11, -77179, 7264857600),
    (1916, 96, 11, 347, 29030400),
    (1917, 97, 11, -201, 6406400),
    (1918, 98, 11, -3049, 172972800),
    (1919, 99, 11, 27973, 330220800),
    (1920, 100, 11, 1477, 49420800),
    (1921, 101, 11, -2297, 76876800),
    (1922, 102, 11, -3119, 26956800),
    (1923, 103, 11, -140747, 1037836800),
    (1924, 104, 11, -10537, 242161920),
    (1925, 105, 11, 113837, 9686476800),
    (1926, 106, 11, -3391, 28828800),
    (1927, 107, 11, -128489, 1210809600),
    (1928, 108, 11, 996209, 7264857600),
    (1929, 109, 11, 5891, 44844800),
    (1930, 110, 11, -433, 83026944),
    (1931, 111, 11, -2423, 259459200),
    (1932, 112, 11, 809, 69189120),
    (1933, 113, 11, 103, 4204200),
    (1934, 114, 11, 27, 3203200),
    (1935, 115, 11, 127, 1921920),
    (1936, 116, 11, -25703, 830269440),
    (1937, 117, 11, -10237, 148262400),
    (1938, 118, 11, -14041, 2075673600),
    (1939, 119, 11, 3007, 60540480),
    (1940, 120, 11, -31, 24710400),
    (1941, 121, 11, 634349, 3632428800),
    (1942, 122, 11, -731, 17297280),
    (1943, 123, 11, -9833, 103783680),
    (1944, 124, 11, -2027, 51891840),
    (1945, 125, 11, 79967, 3632428800),
    (1946, 126, 11, -7571, 242161920),
    (1947, 127, 11, 62221, 518918400),
    (1948, 72, 12, -18253, 58118860800),
    (1949, 73, 12, -22361, 8717829120),
    (1950, 74, 12, -1987, 249080832),
    (1951, 75, 12, -29, 2358720),
    (1952, 76, 12, -125897, 12454041600),
    (1953, 77, 12, -135491, 31135104000),
    (1954, 78, 12, -317, 372556800),
    (1955, 79, 12, -691, 15850598400),
    (1956, 80, 12, -209549, 31135104000),
    (1957, 81, 12, -19147, 518918400),
    (1958, 82, 12, -51581, 726485760),
    (1959, 83, 12, -371401, 6227020800),
    (1960, 84, 12, -25769, 1245404160),
    (1961, 85, 12, -25271, 18162144000),
    (1962, 86, 12, -15649, 518918400),
    (1963, 87, 12, -12797, 145297152),
    (1964, 88, 12, -35999, 538137600),
    (1965, 89, 12, -23393, 6227020800),
    (1966, 90, 12, -1957, 110073600),
    (1967, 91, 12, 853, 660441600),
    (1968, 92, 12, -94169, 10378368000),
    (1969, 93, 12, -241, 6486480),
    (1970, 94, 12, -1747, 36324288),
    (1971, 95, 12, -12143, 593049600),
    (1972, 96, 12, 5567, 6227020800),
    (1973, 97, 12, -373, 9609600),
    (1974, 98, 12, -12241, 242161920),
    (1975, 99, 12, 21781, 1037836800),
    (1976, 100, 12, 20719, 1452971520),
    (1977, 101, 12, -18761, 741312000),
    (1978, 102, 12, -2741, 29652480),
    (1979, 103, 12, -398399, 3632428800),
    (1980, 104, 12, -192589, 4151347200),
    (1981, 105, 12, -55079, 21794572800),
    (1982, 106, 12, -10667, 90810720),
    (1983, 107, 12, -787907, 4843238400),
    (1984, 108, 12, -71, 968647680),
    (1985, 109, 12, 524479, 14529715200),
    (1986, 110, 12, -36479, 6227020800),
    (1987, 111, 12, -3989, 311351040),
    (1988, 112, 12, -829, 726485760),
    (1989, 113, 12, 58199, 6227020800),
    (1990, 114, 12, 31, 14826240),
    (1991, 115, 12, 13631, 363242880),
    (1992, 116, 12, -59431, 2075673600),
    (1993, 117, 12, -7087, 103783680),
    (1994, 118, 12, -253817, 7264857600),
    (1995, 119, 12, 5873, 593049600),
    (1996, 120, 12, -367, 12612600),
    (1997, 121, 12, 870719, 14529715200),
    (1998, 122, 12, -34399, 1037836800),
    (1999, 123, 12, -118039, 1556755200),
    (2000, 124, 12, -107929, 2421619200),
    (2001, 125, 12, -2689, 2905943040),
    (2002, 126, 12, -110629, 2075673600),
    (2003, 127, 12, 6893, 544864320),
    (2004, 72, 13, 0, 1),
    (2005, 73, 13, -3323, 3632428800),
    (2006, 74, 13, -11017, 2075673600),
    (2007, 75, 13, -1613, 134784000),
    (2008, 76, 13, -571, 43243200),
    (2009, 77, 13, -105913, 14529715200),
    (2010, 78, 13, -4463, 2641766400),
    (2011, 79, 13, 4603, 435891456000),
    (2012, 80, 13, 0, 1),
    (2013, 81, 13, -1457, 115315200),
    (2014, 82, 13, -4337, 98841600),
    (2015, 83, 13, -2839, 57657600),
    (2016, 84, 13, -79889, 4843238400),
    (2017, 85, 13, 127, 35875840),
    (2018, 86, 13, 0, 1),
    (2019, 87, 13, -1063, 43243200),
    (2020, 88, 13, -1171, 57657600),
    (2021, 89, 13, 28033, 1210809600),
    (2022, 90, 13, 0, 1),
    (2023, 91, 13, 191, 17297280),
    (2024, 92, 13, 0, 1),
    (2025, 93, 13, -1627, 138378240),
    (2026, 94, 13, -133, 5491200),
    (2027, 95, 13, -409, 69189120),
    (2028, 96, 13, 11059, 968647680),
    (2029, 97, 13, 0, 1),
    (2030, 98, 13, -61, 28828800),
    (2031, 99, 13, 67, 1351350),
    (2032, 100, 13, 901, 86486400),
    (2033, 101, 13, -1457, 115315200),
    (2034, 102, 13, -24803, 345945600),
    (2035, 103, 13, -1259, 11531520),
    (2036, 104, 13, -1759, 40360320),
    (2037, 105, 13, 3287, 230630400),
    (2038, 106, 13, -1063, 21621600),
    (2039, 107, 13, -1787, 28828800),
    (2040, 108, 13, 34627, 302702400),
    (2041, 109, 13, 7333, 86486400),
    (2042, 110, 13, 0, 1),
    (2043, 111, 13, -17, 6918912),
    (2044, 112, 13, 373, 49420800),
    (2045, 113, 13, 809, 43243200),
    (2046, 114, 13, 0, 1),
    (2047, 115, 13, 1943, 86486400),
    (2048, 116, 13, -1627, 138378240),
    (2049, 117, 13, -6953, 172972800),
    (2050, 118, 13, -1739, 345945600),
    (2051, 119, 13, 2207, 46569600),
    (2052, 120, 13, -61, 28828800),
    (2053, 121, 13, 157, 1572480),
    (2054, 122, 13, -19247, 691891200),
    (2055, 123, 13, -41897, 518918400),
    (2056, 124, 13, -34487, 807206400),
    (2057, 125, 13, 96289, 3632428800),
    (2058, 126, 13, -1, 46800),
    (2059, 127, 13, 11899, 121080960),
    (2060, 72, 14, -1283, 3632428800),
    (2061, 73, 14, -989, 220147200),
    (2062, 74, 14, -463, 24948000),
    (2063, 75, 14, -37511, 1037836800),
    (2064, 76, 14, -48983, 1320883200),
    (2065, 77, 14, -25213, 1245404160),
    (2066, 78, 14, -145681, 27243216000),
    (2067, 79, 14, -23, 51597000),
    (2068, 80, 14, -2663, 345945600),
    (2069, 81, 14, -229, 3459456),
    (2070, 82, 14, -647, 3801600),
    (2071, 83, 14, -657997, 3632428800),
    (2072, 84, 14, -1150993, 14529715200),
    (2073, 85, 14, -77713, 9906624000),
    (2074, 86, 14, -127, 3603600),
    (2075, 87, 14, -1171, 7207200),
    (2076, 88, 14, -743, 4435200),
    (2077, 89, 14, -16189, 908107200),
    (2078, 90, 14, -191, 8648640),
    (2079, 91, 14, -191, 121080960),
    (2080, 92, 14, -109, 10483200),
    (2081, 93, 14, -491, 7413120),
    (2082, 94, 14, -409, 3628800),
    (2083, 95, 14, -429511, 7264857600),
    (2084, 96, 14, 7433, 2075673600),
    (2085, 97, 14, -73, 1601600),
    (2086, 98, 14, -4003, 43243200),
    (2087, 99, 14, 949, 19958400),
    (2088, 100, 14, 2137, 86486400),
    (2089, 101, 14, -1427, 27027000),
    (2090, 102, 14, -259601, 1037836800),
    (2091, 103, 14, -84853, 227026800),
    (2092, 104, 14, -48833, 242161920),
    (2093, 105, 14, -136319, 7264857600),
    (2094, 106, 14, -22069, 86486400),
    (2095, 107, 14, -569441, 1210809600),
    (2096, 108, 14, -2153, 56756700),
    (2097, 109, 14, 3191, 36691200),
    (2098, 110, 14, -467, 69189120),
    (2099, 111, 14, -383, 17297280),
    (2100, 112, 14, 1, 887040),
    (2101, 113, 14, 38081, 1210809600),
    (2102, 114, 14, 61, 28828800),
    (2103, 115, 14, 3023, 43243200),
    (2104, 116, 14, -14683, 259459200),
    (2105, 117, 14, -91613, 518918400),
    (2106, 118, 14, -103657, 908107200),
    (2107, 119, 14, 41, 1121120),
    (2108, 120, 14, -11659, 172972800),
    (2109, 121, 14, 479177, 3632428800),
    (2110, 122, 14, -19451, 207567360),
    (2111, 123, 14, -8921, 33022080),
    (2112, 124, 14, -212689, 1037836800),
    (2113, 125, 14, -155851, 10897286400),
    (2114, 126, 14, -40087, 242161920),
    (2115, 127, 14, 14507, 1816214400),
    (2116, 42, 15, 0, 1),
    (2117, 43, 15, -157, 3459456000),
    (2118, 44, 15, -551, 10378368000),
    (2119, 45, 15, 139, 377395200),
    (2120, 46, 15, 3767, 3891888000),
    (2121, 47, 15, 167, 188697600),
    (2122, 48, 15, 16829, 48432384000),
    (2123, 49, 15, 0, 1),
    (2124, 50, 15, 431, 1037836800),
    (2125, 51, 15, 317, 86486400),
    (2126, 52, 15, 9791, 1297296000),
    (2127, 53, 15, 3593, 648648000),
    (2128, 54, 15, 0, 1),
    (2129, 55, 15, 1471, 345945600),
    (2130, 56, 15, 17921, 1729728000),
    (2131, 57, 15, 0, 1),
    (2132, 58, 15, 569, 518918400),
    (2133, 59, 15, 17, 3603600),
    (2134, 60, 15, 7121, 1297296000),
    (2135, 61, 15, 0, 1),
    (2136, 62, 15, 1063, 172972800),
    (2137, 63, 15, 431, 1037836800),
    (2138, 64, 15, 251, 41513472),
    (2139, 65, 15, 59057, 3459456000),
    (2140, 66, 15, 3701, 235872000),
    (2141, 67, 15, 1471, 172972800),
    (2142, 68, 15, 29539, 864864000),
    (2143, 69, 15, 29, 23587200),
    (2144, 70, 15, 499, 172972800),
    (2145, 71, 15, 16759, 1153152000),
    (2146, 42, 16, -1457, 14529715200),
    (2147, 43, 16, -241, 259459200),
    (2148, 44, 16, -4727, 2075673600),
    (2149, 45, 16, -6971, 4981616640),
    (2150, 46, 16, 7, 4561920),
    (2151, 47, 16, 19477, 8302694400),
    (2152, 48, 16, 8989, 8717829120),
    (2153, 49, 16, -131, 129729600),
    (2154, 50, 16, -2273, 830269440),
    (2155, 51, 16, 17977, 2075673600),
    (2156, 52, 16, 67, 2515968),
    (2157, 53, 16, 9343, 447068160),
    (2158, 54, 16, 17, 18869760),
    (2159, 55, 16, 2759, 115315200),
    (2160, 56, 16, 17959, 345945600),
    (2161, 57, 16, -37, 69189120),
    (2162, 58, 16, 1583, 415134720),
    (2163, 59, 16, 86771, 4151347200),
    (2164, 60, 16, 163, 6589440),
    (2165, 61, 16, 467, 69189120),
    (2166, 62, 16, 11423, 259459200),
    (2167, 63, 16, -817, 415134720),
    (2168, 64, 16, 11, 786240),
    (2169, 65, 16, 60079, 1037836800),
    (2170, 66, 16, 1691, 29652480),
    (2171, 67, 16, 7103, 172972800),
    (2172, 68, 16, 82763, 518918400),
    (2173, 69, 16, 3511, 415134720),
    (2174, 70, 16, 3127, 188697600),
    (2175, 71, 16, 22609, 345945600),
    (2176, 42, 17, -11017, 21794572800),
    (2177, 43, 17, -3931, 1037836800),
    (2178, 44, 17, -619, 64864800),
    (2179, 45, 17, -1381, 138378240),
    (2180, 46, 17, -21467, 6227020800),
    (2181, 47, 17, 127, 124540416),
    (2182, 48, 17, 6151, 6810804000),
    (2183, 49, 17, -6467, 1037836800),
    (2184, 50, 17, -12433, 518918400),
    (2185, 51, 17, -4973, 311351040),
    (2186, 52, 17, 37363, 1816214400),
    (2187, 53, 17, 14059, 566092800),
    (2188, 54, 17, -3317, 518918400),
    (2189, 55, 17, 1223, 47174400),
    (2190, 56, 17, 288133, 3632428800),
    (2191, 57, 17, -2071, 415134720),
    (2192, 58, 17, -1403, 259459200),
    (2193, 59, 17, 4931, 207567360),
    (2194, 60, 17, 4153, 113513400),
    (2195, 61, 17, 2213, 172972800),
    (2196, 62, 17, 1081, 12355200),
    (2197, 63, 17, -109, 6386688),
    (2198, 64, 17, -1433, 74131200),
    (2199, 65, 17, 2269, 49420800),
    (2200, 66, 17, 28909, 435891456),
    (2201, 67, 17, 223, 4989600),
    (2202, 68, 17, 35639, 151351200),
    (2203, 69, 17, 257, 16216200),
    (2204, 70, 17, 9883, 311351040),
    (2205, 71, 17, 102329, 1037836800),
    (2206, 42, 18, -12109, 14529715200),
    (2207, 43, 18, -69661, 12454041600),
    (2208, 44, 18, -28043, 2075673600),
    (2209, 45, 18, -1, 67392),
    (2210, 46, 18, -839, 113218560),
    (2211, 47, 18, -8017, 6918912000),
    (2212, 48, 18, 2839, 14529715200),
    (2213, 49, 18, -117389, 10378368000),
    (2214, 50, 18, -9131, 207567360),
    (2215, 51, 18, -17729, 363242880),
    (2216, 52, 18, -727, 75479040),
    (2217, 53, 18, 8597, 889574400),
    (2218, 54, 18, -5429, 259459200),
    (2219, 55, 18, -5521, 484323840),
    (2220, 56, 18, 8065, 193729536),
    (2221, 57, 18, -43129, 4151347200),
    (2222, 58, 18, -7, 308880),
    (2223, 59, 18, 47, 181621440),
    (2224, 60, 18, 1513, 75479040),
    (2225, 61, 18, 89, 172972800),
    (2226, 62, 18, 9307, 145297152),
    (2227, 63, 18, -2947, 98841600),
    (2228, 64, 18, -577, 9434880),
    (2229, 65, 18, -18853, 1452971520),
    (2230, 66, 18, 109771, 4151347200),
    (2231, 67, 18, -47, 5503680),
    (2232, 68, 18, 364411, 2905943040),
    (2233, 69, 18, 415, 41513472),
    (2234, 70, 18, 17917, 726485760),
    (2235, 71, 18, 2153, 37255680),
    (2236, 42, 19, -7261, 13621608000),
    (2237, 43, 19, -34043, 10378368000),
    (2238, 44, 19, -154909, 20756736000),
    (2239, 45, 19, -139, 17418240),
    (2240, 46, 19, -713, 172972800),
    (2241, 47, 19, -9203, 10378368000),
    (2242, 48, 19, -691, 19813248000),
    (2243, 49, 19, -6557, 864864000),
    (2244, 50, 19, -414811, 14529715200),
    (2245, 51, 19, -71761, 2075673600),
    (2246, 52, 19, -1739, 119750400),
    (2247, 53, 19, -911, 2594592000),
    (2248, 54, 19, -126661, 7264857600),
    (2249, 55, 19, -1933, 80720640),
    (2250, 56, 19, 569, 296524800),
    (2251, 57, 19, -7823, 1037836800),
    (2252, 58, 19, -2473, 132088320),
    (2253, 59, 19, -14461, 1383782400),
    (2254, 60, 19, 271, 119750400),
    (2255, 61, 19, -2357, 269068800),
    (2256, 62, 19, 191, 14414400),
    (2257, 63, 19, -10961, 593049600),
    (2258, 64, 19, -304939, 7264857600),
    (2259, 65, 19, -4709, 197683200),
    (2260, 66, 19, 47, 111196800),
    (2261, 67, 19, -45641, 1614412800),
    (2262, 68, 19, 81841, 7264857600),
    (2263, 69, 19, 3383, 7264857600),
    (2264, 70, 19, 2027, 296524800),
    (2265, 71, 19, 179, 18450432),
    (2266, 42, 20, 0, 1),
    (2267, 43, 20, -461, 389188800),
    (2268, 44, 20, -5101, 1037836800),
    (2269, 45, 20, -41311, 6227020800),
    (2270, 46, 20, -613, 259459200),
    (2271, 47, 20, 23251, 14529715200),
    (2272, 48, 20, 59603, 43589145600),
    (2273, 49, 20, 0, 1),
    (2274, 50, 20, -157, 23063040),
    (2275, 51, 20, -2729, 518918400),
    (2276, 52, 20, 31, 1601600),
    (2277, 53, 20, 178439, 7264857600),
    (2278, 54, 20, 0, 1),
    (2279, 55, 20, 271, 21621600),
    (2280, 56, 20, 2137, 43243200),
    (2281, 57, 20, 0, 1),
    (2282, 58, 20, -1, 2306304),
    (2283, 59, 20, 5491, 345945600),
    (2284, 60, 20, 73, 2594592),
    (2285, 61, 20, 0, 1),
    (2286, 62, 20, 1429, 43243200),
    (2287, 63, 20, -157, 23063040),
    (2288, 64, 20, -701, 86486400),
    (2289, 65, 20, 313, 6918912),
    (2290, 66, 20, 17177, 242161920),
    (2291, 67, 20, 271, 10810800),
    (2292, 68, 20, 14251, 86486400),
    (2293, 69, 20, 71, 11531520),
    (2294, 70, 20, 9601, 518918400),
    (2295, 71, 20, 409, 5241600),
    (2296, 42, 21, -3323, 3632428800),
    (2297, 43, 21, -607, 62899200),
    (2298, 44, 21, -8929, 288288000),
    (2299, 45, 21, -1487, 34594560),
    (2300, 46, 21, -14999, 558835200),
    (2301, 47, 21, -23053, 4151347200),
    (2302, 48, 21, 3403, 3405402000),
    (2303, 49, 21, -1457, 115315200),
    (2304, 50, 21, -61, 786240),
    (2305, 51, 21, -30103, 259459200),
    (2306, 52, 21, -78943, 2421619200),
    (2307, 53, 21, 34087, 1117670400),
    (2308, 54, 21, -1063, 43243200),
    (2309, 55, 21, -53, 2246400),
    (2310, 56, 21, 15761, 172972800),
    (2311, 57, 21, -1627, 138378240),
    (2312, 58, 21, -1, 24960),
    (2313, 59, 21, -131, 172972800),
    (2314, 60, 21, 1333, 24460800),
    (2315, 61, 21, -61, 28828800),
    (2316, 62, 21, 283, 2620800),
    (2317, 63, 21, -5321, 86486400),
    (2318, 64, 21, -14411, 86486400),
    (2319, 65, 21, -5723, 100900800),
    (2320, 66, 21, 66343, 726485760),
    (2321, 67, 21, -151, 5405400),
    (2322, 68, 21, 120347, 403603200),
    (2323, 69, 21, 11, 628992),
    (2324, 70, 21, 2971, 51891840),
    (2325, 71, 21, 98431, 605404800),
    (2326, 42, 22, -899, 454053600),
    (2327, 43, 22, -164977, 10378368000),
    (2328, 44, 22, -15689, 345945600),
    (2329, 45, 22, -21953, 363242880),
    (2330, 46, 22, -82619, 2075673600),
    (2331, 47, 22, -52717, 4447872000),
    (2332, 48, 22, -10931, 12108096000),
    (2333, 49, 22, -4561, 157248000),
    (2334, 50, 22, -12437, 86486400),
    (2335, 51, 22, -1145, 5189184),
    (2336, 52, 22, -579727, 4843238400),
    (2337, 53, 22, -3587, 389188800),
    (2338, 54, 22, -3023, 43243200),
    (2339, 55, 22, -14579, 110073600),
    (2340, 56, 22, -12283, 2421619200),
    (2341, 57, 22, -5443, 188697600),
    (2342, 58, 22, -24229, 259459200),
    (2343, 59, 22, -1721, 25945920),
    (2344, 60, 22, 27917, 2075673600),
    (2345, 61, 22, -3239, 86486400),
    (2346, 62, 22, 99487, 1816214400),
    (2347, 63, 22, -4171, 39916800),
    (2348, 64, 22, -2477, 8255520),
    (2349, 65, 22, -1629037, 7264857600),
    (2350, 66, 22, -533887, 43589145600),
    (2351, 67, 22, -241, 1330560),
    (2352, 68, 22, 153653, 7264857600),
    (2353, 69, 22, 43, 11531520),
    (2354, 70, 22, 761, 17297280),
    (2355, 71, 22, 157121, 2421619200),
    (2356, 42, 23, -2003, 3632428800),
    (2357, 43, 23, -2507, 415134720),
    (2358, 44, 23, -1627, 78624000),
    (2359, 45, 23, -6689, 207567360),
    (2360, 46, 23, -13907, 558835200),
    (2361, 47, 23, -4129, 461260800),
    (2362, 48, 23, -1979, 1945944000),
    (2363, 49, 23, -941, 115315200),
    (2364, 50, 23, -977, 17297280),
    (2365, 51, 23, -4691, 43243200),
    (2366, 52, 23, -20281, 269068800),
    (2367, 53, 23, -47, 3548160),
    (2368, 54, 23, -227, 10810800),
    (2369, 55, 23, -1207, 19219200),
    (2370, 56, 23, -89, 3843840),
    (2371, 57, 23, -389, 46126080),
    (2372, 58, 23, -683, 17297280),
    (2373, 59, 23, -3467, 86486400),
    (2374, 60, 23, -13837, 7264857600),
    (2375, 61, 23, -179, 12355200),
    (2376, 62, 23, 337, 86486400),
    (2377, 63, 23, -2609, 57657600),
    (2378, 64, 23, -41, 257400),
    (2379, 65, 23, -92767, 605404800),
    (2380, 66, 23, -83, 2837835),
    (2381, 67, 23, -8479, 86486400),
    (2382, 68, 23, -68381, 1210809600),
    (2383, 69, 23, -19, 6918912),
    (2384, 70, 23, 17, 1201200),
    (2385, 71, 23, 131, 15135120),
    (2386, 25, 24, 157, 3459456000),
    (2387, 26, 24, 5101, 12454041600),
    (2388, 27, 24, 6739, 6227020800),
    (2389, 28, 24, 18349, 15567552000),
    (2390, 29, 24, 17257, 31135104000),
    (2391, 30, 24, 0, 1),
    (2392, 31, 24, 461, 389188800),
    (2393, 32, 24, 4507, 1037836800),
    (2394, 33, 24, 71609, 15567552000),
    (2395, 34, 24, 0, 1),
    (2396, 35, 24, 2663, 1037836800),
    (2397, 36, 24, 0, 1),
    (2398, 37, 24, 43, 34594560),
    (2399, 38, 24, 317, 115315200),
    (2400, 39, 24, 461, 389188800),
    (2401, 40, 24, 4937, 691891200),
    (2402, 41, 24, 15331, 1482624000),
    (2403, 26, 25, 499, 296524800),
    (2404, 27, 25, 31441, 6227020800),
    (2405, 28, 25, 901, 164736000),
    (2406, 29, 25, 2449, 988416000),
    (2407, 30, 25, 431, 1037836800),
    (2408, 31, 25, 137, 15966720),
    (2409, 32, 25, 30619, 1153152000),
    (2410, 33, 25, 22247, 864864000),
    (2411, 34, 25, 1471, 345945600),
    (2412, 35, 25, 757, 33264000),
    (2413, 36, 25, 569, 518918400),
    (2414, 37, 25, 557, 53222400),
    (2415, 38, 25, 63617, 3459456000),
    (2416, 39, 25, 631, 86486400),
    (2417, 40, 25, 4673, 115315200),
    (2418, 41, 25, 23743, 432432000),
    (2419, 27, 26, 1141, 177914880),
    (2420, 28, 26, 13777, 1660538880),
    (2421, 29, 26, 137, 35582976),
    (2422, 30, 26, -551, 830269440),
    (2423, 31, 26, 3671, 259459200),
    (2424, 32, 26, 1643, 31933440),
    (2425, 33, 26, 72733, 1452971520),
    (2426, 34, 26, 9523, 691891200),
    (2427, 35, 26, 61403, 1037836800),
    (2428, 36, 26, 1093, 415134720),
    (2429, 37, 26, 589, 23587200),
    (2430, 38, 26, 449, 10644480),
    (2431, 39, 26, 1597, 138378240),
    (2432, 40, 26, 156077, 2075673600),
    (2433, 41, 26, 42577, 415134720),
    (2434, 28, 27, 5543, 1245404160),
    (2435, 29, 27, 11107, 4447872000),
    (2436, 30, 27, -3349, 566092800),
    (2437, 31, 27, -179, 311351040),
    (2438, 32, 27, 8819, 242161920),
    (2439, 33, 27, 4033, 95800320),
    (2440, 34, 27, 839, 64864800),
    (2441, 35, 27, 7649, 121080960),
    (2442, 36, 27, 43, 444787200),
    (2443, 37, 27, 4643, 207567360),
    (2444, 38, 27, 30937, 726485760),
    (2445, 39, 27, 839, 778377600),
    (2446, 40, 27, 10973, 207567360),
    (2447, 41, 27, 30389, 363242880),
    (2448, 29, 28, 857, 1482624000),
    (2449, 30, 28, -17, 1965600),
    (2450, 31, 28, -114539, 7264857600),
    (2451, 32, 28, 1513, 461260800),
    (2452, 33, 28, 2789, 194594400),
    (2453, 34, 28, 5779, 4843238400),
    (2454, 35, 28, 1511, 55036800),
    (2455, 36, 28, -241, 64864800),
    (2456, 37, 28, 8123, 1614412800),
    (2457, 38, 28, 8501, 461260800),
    (2458, 39, 28, -1297, 138378240),
    (2459, 40, 28, 11581, 1614412800),
    (2460, 41, 28, 7801, 276756480),
    (2461, 30, 29, -136259, 29059430400),
    (2462, 31, 29, -6089, 566092800),
    (2463, 32, 29, -16231, 2830464000),
    (2464, 33, 29, 757, 1037836800),
    (2465, 34, 29, -47693, 14529715200),
    (2466, 35, 29, 11239, 4447872000),
    (2467, 36, 29, -42683, 14529715200),
    (2468, 37, 29, -10727, 4151347200),
    (2469, 38, 29, 67579, 31135104000),
    (2470, 39, 29, -70199, 10897286400),
    (2471, 40, 29, -123649, 20756736000),
    (2472, 41, 29, 14779, 7783776000),
    (2473, 31, 30, 157, 23063040),
    (2474, 32, 30, 23321, 691891200),
    (2475, 33, 30, 4721, 115315200),
    (2476, 34, 30, 0, 1),
    (2477, 35, 30, 127, 5405400),
    (2478, 36, 30, 0, 1),
    (2479, 37, 30, 127, 12579840),
    (2480, 38, 30, 17701, 691891200),
    (2481, 39, 30, 157, 23063040),
    (2482, 40, 30, 19237, 345945600),
    (2483, 41, 30, 83, 898560),
    (2484, 32, 31, 44699, 518918400),
    (2485, 33, 31, 437111, 3632428800),
    (2486, 34, 31, 271, 21621600),
    (2487, 35, 31, 1109, 9979200),
    (2488, 36, 31, -1, 2306304),
    (2489, 37, 31, 31, 798336),
    (2490, 38, 31, 16501, 172972800),
    (2491, 39, 31, 313, 129729600),
    (2492, 40, 31, 70639, 518918400),
    (2493, 41, 31, 118463, 454053600),
    (2494, 33, 32, 428063, 4843238400),
    (2495, 34, 32, -71, 21621600),
    (2496, 35, 32, 23071, 201801600),
    (2497, 36, 32, -29, 1830400),
    (2498, 37, 32, 1829, 115315200),
    (2499, 38, 32, 1, 10395),
    (2500, 39, 32, -4393, 74131200),
    (2501, 40, 32, 1489, 96864768),
    (2502, 41, 32, 465431, 2421619200),
    (2503, 34, 33, -163, 4729725),
    (2504, 35, 33, 311, 31449600),
    (2505, 36, 33, -13441, 518918400),
    (2506, 37, 33, -77059, 2421619200),
    (2507, 38, 33, 4549, 230630400),
    (2508, 39, 33, -6527, 80720640),
    (2509, 40, 33, -520021, 4843238400),
    (2510, 41, 33, 4723, 454053600),
    (2511, 35, 34, 191, 8648640),
    (2512, 36, 34, 0, 1),
    (2513, 37, 34, 359, 86486400),
    (2514, 38, 34, 269, 9609600),
    (2515, 39, 34, -271, 21621600),
    (2516, 40, 34, 173, 24710400),
    (2517, 41, 34, 97673, 1210809600),
    (2518, 36, 35, -73, 4804800),
    (2519, 37, 35, -23, 739200),
    (2520, 38, 35, 10993, 605404800),
    (2521, 39, 35, -3257, 37065600),
    (2522, 40, 35, -19477, 121080960),
    (2523, 41, 35, -2333, 302702400),
    (2524, 37, 36, 127, 23063040),
    (2525, 38, 36, 18463, 1037836800),
    (2526, 39, 36, 1, 2306304),
    (2527, 40, 36, 139, 5241600),
    (2528, 41, 36, 30799, 518918400),
    (2529, 38, 37, 3959, 115315200),
    (2530, 39, 37, -7811, 259459200),
    (2531, 40, 37, -571, 31449600),
    (2532, 41, 37, 1889, 25225200),
    (2533, 39, 38, -5143, 74131200),
    (2534, 40, 38, -104081, 807206400),
    (2535, 41, 38, -73373, 2421619200),
    (2536, 40, 39, 6779, 74131200),
    (2537, 41, 39, 127, 741312),
    (2538, 41, 40, 278507, 1210809600),
    (2539, 1378, 1, 1, 74724249600),
    (2540, 1378, 2, 1, 5337446400),
    (2541, 1379, 2, 277, 245188944000),
    (2542, 1380, 2, 1247, 326918592000),
    (2543, 1381, 2, 317, 40864824000),
    (2544, 1382, 2, 449, 49037788800),
    (2545, 1383, 2, 29, 6810804000),
    (2546, 1384, 2, -29, 6810804000),
    (2547, 1385, 2, -449, 49037788800),
    (2548, 1386, 2, -317, 40864824000),
    (2549, 1387, 2, -1247, 326918592000),
    (2550, 1388, 2, -277, 245188944000),
    (2551, 1389, 2, -1, 5337446400),
    (2552, 1390, 2, -1, 74724249600),
    (2553, 748, 3, 1, 821145600),
    (2554, 749, 3, 18419, 1307674368000),
    (2555, 750, 3, 8173, 118879488000),
    (2556, 751, 3, 95899, 523069747200),
    (2557, 752, 3, 49757, 174356582400),
    (2558, 753, 3, 397, 1614412800),
    (2559, 754, 3, 2221, 31135104000),
    (2560, 755, 3, -5359, 74724249600),
    (2561, 756, 3, -46117, 523069747200),
    (2562, 757, 3, -54749, 1307674368000),
    (2563, 758, 3, -2521, 261534873600),
    (2564, 759, 3, -1, 1186099200),
    (2565, 760, 3, 277, 7429968000),
    (2566, 761, 3, 8173, 23775897600),
    (2567, 762, 3, 75611, 58118860800),
    (2568, 763, 3, 16193, 6227020800),
    (2569, 764, 3, 457, 157248000),
    (2570, 765, 3, 5867, 3459456000),
    (2571, 766, 3, 2831, 9510359040),
    (2572, 767, 3, -48931, 261534873600),
    (2573, 768, 3, -347, 3405402000),
    (2574, 769, 3, -15941, 1307674368000),
    (2575, 770, 3, 1247, 2641766400),
    (2576, 771, 3, 23861, 7264857600),
    (2577, 772, 3, 7999, 889574400),
    (2578, 773, 3, 31937, 2594592000),
    (2579, 774, 3, 6053, 691891200),
    (2580, 775, 3, 383239, 130767436800),
    (2581, 776, 3, 5063, 17435658240),
    (2582, 777, 3, -727, 108972864000),
    (2583, 778, 3, 317, 129729600),
    (2584, 779, 3, 6049, 518918400),
    (2585, 780, 3, 2993, 148262400),
    (2586, 781, 3, 1457, 94348800),
    (2587, 782, 3, 213623, 43589145600),
    (2588, 783, 3, 1403, 3353011200),
    (2589, 784, 3, 449, 103783680),
    (2590, 785, 3, 2941, 259459200),
    (2591, 786, 3, 2837, 345945600),
    (2592, 787, 3, 19477, 21794572800),
    (2593, 788, 3, 29, 21621600),
    (2594, 789, 3, 29, 172972800),
    (2595, 413, 4, 631, 145297152000),
    (2596, 414, 4, 10667, 237758976000),
    (2597, 415, 4, 16853, 87178291200),
    (2598, 416, 4, 52219, 116237721600),
    (2599, 417, 4, 18727, 31135104000),
    (2600, 418, 4, 27611, 62270208000),
    (2601, 419, 4, 8923, 72648576000),
    (2602, 420, 4, -12169, 209227898880),
    (2603, 421, 4, -5023, 87178291200),
    (2604, 422, 4, -14093, 871782912000),
    (2605, 423, 4, -1247, 1307674368000),
    (2606, 424, 4, 1247, 5943974400),
    (2607, 425, 4, 48913, 29059430400),
    (2608, 426, 4, 3043, 558835200),
    (2609, 427, 4, 21817, 2395008000),
    (2610, 428, 4, 2699, 324324000),
    (2611, 429, 4, 11381, 2905943040),
    (2612, 430, 4, 8179, 11887948800),
    (2613, 431, 4, -4217, 87178291200),
    (2614, 432, 4, 683, 108972864000),
    (2615, 433, 4, 21479, 7264857600),
    (2616, 434, 4, 35531, 2075673600),
    (2617, 435, 4, 130441, 3459456000),
    (2618, 436, 4, 20549, 518918400),
    (2619, 437, 4, 145939, 7264857600),
    (2620, 438, 4, 17977, 4151347200),
    (2621, 439, 4, 33749, 87178291200),
    (2622, 440, 4, 1171, 86486400),
    (2623, 441, 4, 25303, 518918400),
    (2624, 442, 4, 997, 17297280),
    (2625, 443, 4, 9593, 403603200),
    (2626, 444, 4, 1753, 2179457280),
    (2627, 445, 4, 3869, 259459200),
    (2628, 446, 4, 23, 1209600),
    (2629, 447, 4, -289, 96864768),
    (2630, 448, 4, 59, 230630400),
    (2631, 449, 4, 25427, 14529715200),
    (2632, 450, 4, 58649, 12454041600),
    (2633, 451, 4, 131687, 20756736000),
    (2634, 452, 4, 9277, 2075673600),
    (2635, 453, 4, 5189, 3353011200),
    (2636, 454, 4, 3197, 13412044800),
    (2637, 455, 4, 397, 8302694400),
    (2638, 456, 4, 10559, 2075673600),
    (2639, 457, 4, 48757, 2075673600),
    (2640, 458, 4, 161471, 4151347200),
    (2641, 459, 4, 2047, 74131200),
    (2642, 460, 4, 21341, 2905943040),
    (2643, 461, 4, 5407, 29059430400),
    (2644, 462, 4, 61, 2965248),
    (2645, 463, 4, 6257, 129729600),
    (2646, 464, 4, 67, 2702700),
    (2647, 465, 4, -3739, 558835200),
    (2648, 466, 4, 613, 86486400),
    (2649, 467, 4, -1193, 86486400),
    (2650, 468, 4, 527, 230630400),
    (2651, 469, 4, 6451, 830269440),
    (2652, 470, 4, 16993, 2075673600),
    (2653, 471, 4, 1, 450450),
    (2654, 472, 4, -10169, 14529715200),
    (2655, 473, 4, 61, 7413120),
    (2656, 474, 4, 101, 19219200),
    (2657, 475, 4, -29, 2745600),
    (2658, 476, 4, -101, 38438400),
    (2659, 413, 5, 12049, 1307674368000),
    (2660, 414, 5, 983, 11321856000),
    (2661, 415, 5, 86371, 261534873600),
    (2662, 416, 5, 43837, 69742632960),
    (2663, 417, 5, 39547, 72648576000),
    (2664, 418, 5, -563, 8895744000),
    (2665, 419, 5, -396973, 653837184000),
    (2666, 420, 5, -6319, 10567065600),
    (2667, 421, 5, -74141, 261534873600),
    (2668, 422, 5, -1, 14929920),
    (2669, 423, 5, -839, 145297152000),
    (2670, 424, 5, 10667, 23775897600),
    (2671, 425, 5, 17261, 5283532800),
    (2672, 426, 5, 134657, 14529715200),
    (2673, 427, 5, 43411, 3459456000),
    (2674, 428, 5, 74231, 10378368000),
    (2675, 429, 5, -158231, 174356582400),
    (2676, 430, 5, -165343, 52306974720),
    (2677, 431, 5, -594509, 435891456000),
    (2678, 432, 5, -4387, 29059430400),
    (2679, 433, 5, 46531, 7264857600),
    (2680, 434, 5, 17441, 518918400),
    (2681, 435, 5, 112339, 1729728000),
    (2682, 436, 5, 57557, 1037836800),
    (2683, 437, 5, 71159, 3962649600),
    (2684, 438, 5, -151, 330220800),
    (2685, 439, 5, -92003, 217945728000),
    (2686, 440, 5, 15611, 518918400),
    (2687, 441, 5, 34337, 345945600),
    (2688, 442, 5, 5503, 51891840),
    (2689, 443, 5, 122987, 3113510400),
    (2690, 444, 5, 22909, 7264857600),
    (2691, 445, 5, 9287, 259459200),
    (2692, 446, 5, 16519, 345945600),
    (2693, 447, 5, 3499, 726485760),
    (2694, 448, 5, 63781, 58118860800),
    (2695, 449, 5, 33073, 4843238400),
    (2696, 450, 5, 1010263, 62270208000),
    (2697, 451, 5, 187309, 10378368000),
    (2698, 452, 5, 7597, 880588800),
    (2699, 453, 5, 2117, 6706022400),
    (2700, 454, 5, -9413, 11623772160),
    (2701, 455, 5, 127, 4790016000),
    (2702, 456, 5, 419, 18869760),
    (2703, 457, 5, 243119, 2594592000),
    (2704, 458, 5, 7213, 51891840),
    (2705, 459, 5, 77509, 908107200),
    (2706, 460, 5, 3083, 159667200),
    (2707, 461, 5, 18407, 7264857600),
    (2708, 462, 5, 97259, 1037836800),
    (2709, 463, 5, 1979, 9434880),
    (2710, 464, 5, 142837, 1210809600),
    (2711, 465, 5, 2237, 1452971520),
    (2712, 466, 5, 1951, 43243200),
    (2713, 467, 5, -14239, 605404800),
    (2714, 468, 5, 409, 26956800),
    (2715, 469, 5, 12461, 259459200),
    (2716, 470, 5, 181, 3773952),
    (2717, 471, 5, 111451, 7264857600),
    (2718, 472, 5, 2341, 3228825600),
    (2719, 473, 5, 31433, 518918400),
    (2720, 474, 5, 2129, 38438400),
    (2721, 475, 5, -35773, 1210809600),
    (2722, 476, 5, -5113, 345945600),
    (2723, 477, 5, 19427, 19372953600),
    (2724, 478, 5, 17, 3203200),
    (2725, 479, 5, 291341, 31135104000),
    (2726, 480, 5, 763, 197683200),
    (2727, 481, 5, -595163, 87178291200),
    (2728, 482, 5, -110519, 12454041600),
    (2729, 483, 5, -14603, 3962649600),
    (2730, 484, 5, -22469, 58118860800),
    (2731, 485, 5, 4241, 207567360),
    (2732, 486, 5, 189731, 2594592000),
    (2733, 487, 5, 332837, 4151347200),
    (2734, 488, 5, 782801, 43589145600),
    (2735, 489, 5, -2341, 176117760),
    (2736, 490, 5, -15679, 6604416000),
    (2737, 491, 5, 92429, 1037836800),
    (2738, 492, 5, 180529, 1037836800),
    (2739, 493, 5, 390941, 4843238400),
    (2740, 494, 5, 15739, 2905943040),
    (2741, 495, 5, 18511, 345945600),
    (2742, 496, 5, 22679, 7264857600),
    (2743, 497, 5, 147437, 5189184000),
    (2744, 498, 5, 7381, 94348800),
    (2745, 499, 5, 913147, 14529715200),
    (2746, 500, 5, 4079, 293529600),
    (2747, 501, 5, 118247, 29059430400),
    (2748, 502, 5, 32113, 259459200),
    (2749, 503, 5, 100057, 807206400),
    (2750, 504, 5, -6661, 2421619200),
    (2751, 505, 5, -98321, 4843238400),
    (2752, 506, 5, 33619, 2594592000),
    (2753, 507, 5, 851, 39536640),
    (2754, 508, 5, -19781, 2724321600),
    (2755, 509, 5, -2467, 118609920),
    (2756, 510, 5, -9803, 3632428800),
    (2757, 511, 5, 61631, 1037836800),
    (2758, 512, 5, 577553, 14529715200),
    (2759, 513, 5, 4351, 2905943040),
    (2760, 514, 5, -25147, 14529715200),
    (2761, 227, 6, 1247, 118879488000),
    (2762, 228, 6, 6791, 71327692800),
    (2763, 229, 6, 30887, 87178291200),
    (2764, 230, 6, 30379, 43589145600),
    (2765, 231, 6, 5557, 7185024000),
    (2766, 232, 6, 443, 943488000),
    (2767, 233, 6, 5611, 43589145600),
    (2768, 234, 6, 503, 156920924160),
    (2769, 235, 6, 1, 574801920),
    (2770, 236, 6, 1247, 261534873600),
    (2771, 237, 6, 61, 158505984),
    (2772, 238, 6, 1093, 419126400),
    (2773, 239, 6, 21533, 3113510400),
    (2774, 240, 6, 6457, 707616000),
    (2775, 241, 6, 6511, 1037836800),
    (2776, 242, 6, 3959, 1816214400),
    (2777, 243, 6, 5191, 11887948800),
    (2778, 244, 6, 907, 6538371840),
    (2779, 245, 6, 3881, 1037836800),
    (2780, 246, 6, 389, 23063040),
    (2781, 247, 6, 4283, 159667200),
    (2782, 248, 6, 9161, 518918400),
    (2783, 249, 6, 9413, 2421619200),
    (2784, 250, 6, -2861, 43589145600),
    (2785, 251, 6, 977, 103783680),
    (2786, 252, 6, 15419, 778377600),
    (2787, 253, 6, 2963, 518918400),
    (2788, 254, 6, -6463, 908107200),
    (2789, 255, 6, 191, 259459200),
    (2790, 256, 6, -2419, 259459200),
    (2791, 257, 6, 1717, 2179457280),
    (2792, 258, 6, 311, 70761600),
    (2793, 259, 6, 1909, 207567360),
    (2794, 260, 6, 199, 22239360),
    (2795, 261, 6, 6239, 1556755200),
    (2796, 262, 6, 1319, 1816214400),
    (2797, 263, 6, 17357, 130767436800),
    (2798, 264, 6, 5099, 518918400),
    (2799, 265, 6, 6613, 207567360),
    (2800, 266, 6, 3103, 103783680),
    (2801, 267, 6, 1889, 518918400),
    (2802, 268, 6, -503, 93139200),
    (2803, 269, 6, 757, 51891840),
    (2804, 270, 6, -1, 628992),
    (2805, 271, 6, -6379, 172972800),
    (2806, 272, 6, 367, 83026944),
    (2807, 273, 6, 4651, 622702080),
    (2808, 274, 6, -4267, 2075673600),
    (2809, 275, 6, -7417, 1037836800),
    (2810, 276, 6, -61, 14826240),
    (2811, 277, 6, -16847, 518918400),
    (2812, 278, 6, 37003, 21794572800),
    (2813, 279, 6, 7699, 889574400),
    (2814, 280, 6, 18721, 1153152000),
    (2815, 281, 6, 14269, 1037836800),
    (2816, 282, 6, 116243, 21794572800),
    (2817, 283, 6, 120397, 87178291200),
    (2818, 284, 6, 443, 574801920),
    (2819, 285, 6, 5651, 259459200),
    (2820, 286, 6, 22903, 345945600),
    (2821, 287, 6, 31921, 518918400),
    (2822, 288, 6, 12431, 726485760),
    (2823, 289, 6, 5891, 4358914560),
    (2824, 290, 6, 4801, 129729600),
    (2825, 291, 6, 2917, 172972800),
    (2826, 292, 6, -6221, 151351200),
    (2827, 293, 6, 1, 49140),
    (2828, 294, 6, 11189, 311351040),
    (2829, 295, 6, 1013, 207567360),
    (2830, 296, 6, -43567, 3632428800),
    (2831, 297, 6, -37, 6486480),
    (2832, 298, 6, -25681, 259459200),
    (2833, 299, 6, 493, 24710400),
    (2834, 300, 6, 26921, 778377600),
    (2835, 301, 6, 204791, 14529715200),
    (2836, 302, 6, 16487, 3353011200),
    (2837, 303, 6, 391, 51891840),
    (2838, 304, 6, -36319, 726485760),
    (2839, 305, 6, 449, 934053120),
    (2840, 306, 6, 6317, 3113510400),
    (2841, 307, 6, 3551, 1245404160),
    (2842, 308, 6, 12553, 9340531200),
    (2843, 309, 6, -17, 129729600),
    (2844, 310, 6, -1321, 7264857600),
    (2845, 311, 6, 29, 9884160),
    (2846, 312, 6, 389, 103783680),
    (2847, 313, 6, -4567, 1037836800),
    (2848, 314, 6, -101, 14414400),
    (2849, 315, 6, -1, 314496),
    (2850, 316, 6, -4061, 259459200),
    (2851, 317, 6, 29, 44478720),
    (2852, 318, 6, -109, 23063040),
    (2853, 319, 6, -157, 16473600),
    (2854, 320, 6, 137, 62270208),
    (2855, 321, 6, -3191, 518918400),
    (2856, 322, 6, -373, 28828800),
    (2857, 227, 7, 8173, 237758976000),
    (2858, 228, 7, 16853, 58118860800),
    (2859, 229, 7, 739, 754790400),
    (2860, 230, 7, 5765, 3487131648),
    (2861, 231, 7, 101, 75479040),
    (2862, 232, 7, 521, 2965248000),
    (2863, 233, 7, -581, 1067489280),
    (2864, 234, 7, -8083, 19372953600),
    (2865, 235, 7, -19273, 174356582400),
    (2866, 236, 7, -691, 237758976000),
    (2867, 237, 7, 6791, 5283532800),
    (2868, 238, 7, 9059, 1117670400),
    (2869, 239, 7, 2461, 125798400),
    (2870, 240, 7, 15409, 691891200),
    (2871, 241, 7, 46771, 4151347200),
    (2872, 242, 7, 535, 498161664),
    (2873, 243, 7, -116327, 174356582400),
    (2874, 244, 7, 45911, 435891456000),
    (2875, 245, 7, 1279, 98841600),
    (2876, 246, 7, 433, 7862400),
    (2877, 247, 7, 56807, 691891200),
    (2878, 248, 7, 3721, 74131200),
    (2879, 249, 7, 315181, 29059430400),
    (2880, 250, 7, 1717, 1452971520),
    (2881, 251, 7, 7421, 207567360),
    (2882, 252, 7, 59, 748800),
    (2883, 253, 7, 127, 3144960),
    (2884, 254, 7, -85819, 21794572800),
    (2885, 255, 7, 1931, 172972800),
    (2886, 256, 7, -4021, 345945600),
    (2887, 257, 7, 991, 372556800),
    (2888, 258, 7, 5249, 377395200),
    (2889, 259, 7, 14317, 532224000),
    (2890, 260, 7, 19469, 830269440),
    (2891, 261, 7, 127249, 14529715200),
    (2892, 262, 7, 10679, 8302694400),
    (2893, 263, 7, 6791, 11623772160),
    (2894, 264, 7, 485, 13837824),
    (2895, 265, 7, 12781, 115315200),
    (2896, 266, 7, 251, 2316600),
    (2897, 267, 7, 59, 1940400),
    (2898, 268, 7, -4811, 2905943040),
    (2899, 269, 7, 3841, 57657600),
    (2900, 270, 7, 17473, 345945600),
    (2901, 271, 7, -62389, 1210809600),
    (2902, 272, 7, 2809, 166053888),
    (2903, 273, 7, 5633, 172972800),
    (2904, 274, 7, 1913, 230630400),
    (2905, 275, 7, -8347, 908107200),
    (2906, 276, 7, 1543, 345945600),
    (2907, 277, 7, -21851, 345945600),
    (2908, 278, 7, 4049, 807206400),
    (2909, 279, 7, 7859, 345945600),
    (2910, 280, 7, 59671, 1729728000),
    (2911, 281, 7, 13619, 830269440),
    (2912, 282, 7, -4475, 871782912),
    (2913, 283, 7, -359, 75479040),
    (2914, 284, 7, 73, 111767040),
    (2915, 285, 7, 1943, 28828800),
    (2916, 286, 7, 8089, 43243200),
    (2917, 287, 7, 22351, 148262400),
    (2918, 288, 7, 94693, 2905943040),
    (2919, 289, 7, 14393, 1614412800),
    (2920, 290, 7, 577, 4118400),
    (2921, 291, 7, 43289, 345945600),
    (2922, 292, 7, -23, 827904),
    (2923, 293, 7, 1247, 18532800),
    (2924, 294, 7, 239, 1965600),
    (2925, 295, 7, 8527, 193729536),
    (2926, 296, 7, -13, 74511360),
    (2927, 297, 7, 293, 5765760),
    (2928, 298, 7, -168661, 1210809600),
    (2929, 299, 7, 7519, 148262400),
    (2930, 300, 7, 9239, 138378240),
    (2931, 301, 7, 6233, 605404800),
    (2932, 302, 7, 629, 39536640),
    (2933, 303, 7, 41413, 691891200),
    (2934, 304, 7, -15229, 440294400),
    (2935, 305, 7, 20623, 6227020800),
    (2936, 306, 7, 1109, 83026944),
    (2937, 307, 7, 8461, 461260800),
    (2938, 308, 7, 29, 2965248),
    (2939, 309, 7, 1087, 581188608),
    (2940, 310, 7, 1333, 1779148800),
    (2941, 311, 7, 61, 2661120),
    (2942, 312, 7, 19769, 518918400),
    (2943, 313, 7, -53, 31449600),
    (2944, 314, 7, -71881, 3632428800),
    (2945, 315, 7, -317, 43243200),
    (2946, 316, 7, -11707, 172972800),
    (2947, 317, 7, 1, 108108),
    (2948, 318, 7, -101, 7687680),
    (2949, 319, 7, -39007, 1037836800),
    (2950, 320, 7, 5771, 259459200),
    (2951, 321, 7, -101, 21621600),
    (2952, 322, 7, -227837, 7264857600),
    (2953, 323, 7, 3023, 593049600),
    (2954, 324, 7, 2161, 115315200),
    (2955, 325, 7, 3701, 166053888),
    (2956, 326, 7, 1475, 166053888),
    (2957, 327, 7, 697, 593049600),
    (2958, 328, 7, 2083, 1186099200),
    (2959, 329, 7, 599, 15375360),
    (2960, 330, 7, 7093, 103783680),
    (2961, 331, 7, 2407, 125798400),
    (2962, 332, 7, -2063, 377395200),
    (2963, 333, 7, 3173, 345945600),
    (2964, 334, 7, -37871, 691891200),
    (2965, 335, 7, 267, 12812800),
    (2966, 336, 7, 29, 13837824),
    (2967, 337, 7, -85079, 3228825600),
    (2968, 338, 7, 19069, 518918400),
    (2969, 339, 7, 1423, 92252160),
    (2970, 340, 7, -1481, 1210809600),
    (2971, 227, 8, 1247, 39626496000),
    (2972, 228, 8, 61319, 261534873600),
    (2973, 229, 8, 1021, 1585059840),
    (2974, 230, 8, 28811, 43589145600),
    (2975, 231, 8, -497, 1482624000),
    (2976, 232, 8, -143279, 93405312000),
    (2977, 233, 8, -23687, 14529715200),
    (2978, 234, 8, -73861, 87178291200),
    (2979, 235, 8, -5123, 23775897600),
    (2980, 236, 8, -2183, 118879488000),
    (2981, 237, 8, 13693, 11623772160),
    (2982, 238, 8, 8887, 1362160800),
    (2983, 239, 8, 6067, 479001600),
    (2984, 240, 8, 5399, 648648000),
    (2985, 241, 8, -278989, 74724249600),
    (2986, 242, 8, -619, 78586200),
    (2987, 243, 8, -520987, 145297152000),
    (2988, 244, 8, -24793, 65383718400),
    (2989, 245, 8, 74863, 6227020800),
    (2990, 246, 8, 234139, 5189184000),
    (2991, 247, 8, 56753, 1037836800),
    (2992, 248, 8, 324341, 16345929600),
    (2993, 249, 8, -291737, 87178291200),
    (2994, 250, 8, -197651, 217945728000),
    (2995, 251, 8, 5177, 148262400),
    (2996, 252, 8, 617, 8648640),
    (2997, 253, 8, 783161, 21794572800),
    (2998, 254, 8, 25043, 10897286400),
    (2999, 255, 8, 163, 10483200),
    (3000, 256, 8, 19, 49533120),
    (3001, 257, 8, 7141, 2905943040),
    (3002, 258, 8, 8059, 707616000),
    (3003, 259, 8, 37711, 2075673600),
    (3004, 260, 8, 74257, 7264857600),
    (3005, 261, 8, -37789, 37362124800),
    (3006, 262, 8, -7663, 3632428800),
    (3007, 263, 8, 22661, 145297152000),
    (3008, 264, 8, 173081, 5189184000),
    (3009, 265, 8, 99391, 1037836800),
    (3010, 266, 8, 12553, 151351200),
    (3011, 267, 8, 29369, 1362160800),
    (3012, 268, 8, 35209, 8717829120),
    (3013, 269, 8, 12497, 172972800),
    (3014, 270, 8, 223, 3027024),
    (3015, 271, 8, -67, 11404800),
    (3016, 272, 8, 70247, 4151347200),
    (3017, 273, 8, 33491, 1037836800),
    (3018, 274, 8, 9073, 660441600),
    (3019, 275, 8, 4331, 10897286400),
    (3020, 276, 8, 523, 31449600),
    (3021, 277, 8, -49087, 1816214400),
    (3022, 278, 8, 12337, 3353011200),
    (3023, 279, 8, 3217, 266112000),
    (3024, 280, 8, 1943, 471744000),
    (3025, 281, 8, -3743, 148599360),
    (3026, 282, 8, -1018247, 29059430400),
    (3027, 283, 8, -201853, 12454041600),
    (3028, 284, 8, -104717, 65383718400),
    (3029, 285, 8, 289, 5791500),
    (3030, 286, 8, 26027, 259459200),
    (3031, 287, 8, 331757, 21794572800),
    (3032, 288, 8, -1072333, 21794572800),
    (3033, 289, 8, -149161, 21794572800),
    (3034, 290, 8, 659, 5765760),
    (3035, 291, 8, 82429, 908107200),
    (3036, 292, 8, 199, 72648576),
    (3037, 293, 8, 54937, 1037836800),
    (3038, 294, 8, 141347, 1816214400),
    (3039, 295, 8, 92759, 4843238400),
    (3040, 296, 8, 89149, 7264857600),
    (3041, 297, 8, 15023, 201801600),
    (3042, 298, 8, -13, 665280),
    (3043, 299, 8, 6761, 377395200),
    (3044, 300, 8, -166763, 5448643200),
    (3045, 301, 8, -84281, 1117670400),
    (3046, 302, 8, -62549, 8717829120),
    (3047, 303, 8, 36403, 1320883200),
    (3048, 304, 8, -7123, 3632428800),
    (3049, 305, 8, 773, 249080832),
    (3050, 306, 8, 12601, 1111968000),
    (3051, 307, 8, 17131, 1245404160),
    (3052, 308, 8, 6509, 990662400),
    (3053, 309, 8, 82811, 37362124800),
    (3054, 310, 8, 1087, 594397440),
    (3055, 311, 8, 647, 27799200),
    (3056, 312, 8, 32017, 778377600),
    (3057, 313, 8, 4967, 330220800),
    (3058, 314, 8, 28087, 16345929600),
    (3059, 315, 8, 313, 86486400),
    (3060, 316, 8, -367, 11007360),
    (3061, 317, 8, 269, 22239360),
    (3062, 318, 8, 541, 518918400),
    (3063, 319, 8, -50833, 3632428800),
    (3064, 320, 8, 35339, 1556755200),
    (3065, 321, 8, 59663, 3632428800),
    (3066, 322, 8, 1759, 152409600),
    (3067, 323, 8, 1277, 161740800),
    (3068, 324, 8, 15619, 691891200),
    (3069, 325, 8, 25913, 2075673600),
    (3070, 326, 8, -5557, 467026560),
    (3071, 327, 8, -16553, 1761177600),
    (3072, 328, 8, 5183, 2490808320),
    (3073, 329, 8, 1319, 20756736),
    (3074, 330, 8, 1741, 18532800),
    (3075, 331, 8, 46931, 2075673600),
    (3076, 332, 8, 296783, 21794572800),
    (3077, 333, 8, 179, 4942080),
    (3078, 334, 8, -26903, 908107200),
    (3079, 335, 8, 277, 6918912),
    (3080, 336, 8, 439, 18627840),
    (3081, 337, 8, -2869, 2075673600),
    (3082, 338, 8, 39791, 1037836800),
    (3083, 339, 8, 19, 13970880),
    (3084, 340, 8, 1801, 44029440),
    (3085, 341, 8, 1321, 691891200),
    (3086, 342, 8, -43, 471744000),
    (3087, 343, 8, -15503, 934053120),
    (3088, 344, 8, -119179, 4358914560),
    (3089, 345, 8, -20351, 1383782400),
    (3090, 346, 8, -12091, 9340531200),
    (3091, 347, 8, 15797, 1037836800),
    (3092, 348, 8, -27553, 9340531200),
    (3093, 349, 8, -138559, 4358914560),
    (3094, 350, 8, -997, 330220800),
    (3095, 351, 8, 258439, 21794572800),
    (3096, 352, 8, -31139, 21794572800),
    (3097, 353, 8, 3859, 330220800),
    (3098, 354, 8, 20327, 6227020800),
    (3099, 355, 8, 2183, 290594304),
    (3100, 356, 8, -6653, 408648240),
    (3101, 357, 8, -285829, 4843238400),
    (3102, 358, 8, -4657, 3113510400),
    (3103, 128, 9, 1759, 104613949440),
    (3104, 129, 9, 45169, 348713164800),
    (3105, 130, 9, 17327, 43589145600),
    (3106, 131, 9, 3103, 4981616640),
    (3107, 132, 9, 6653, 12454041600),
    (3108, 133, 9, 437, 1660538880),
    (3109, 134, 9, 1457, 14529715200),
    (3110, 135, 9, 4889, 95103590400),
    (3111, 136, 9, 1277, 58118860800),
    (3112, 137, 9, 587, 1362160800),
    (3113, 138, 9, 2851, 1245404160),
    (3114, 139, 9, 9179, 2075673600),
    (3115, 140, 9, 1867, 498161664),
    (3116, 141, 9, 227, 172972800),
    (3117, 142, 9, 3427, 14529715200),
    (3118, 143, 9, 45401, 261534873600),
    (3119, 144, 9, 1621, 691891200),
    (3120, 145, 9, 1717, 276756480),
    (3121, 146, 9, 113, 46126080),
    (3122, 147, 9, -19, 4492800),
    (3123, 148, 9, -3653, 1117670400),
    (3124, 149, 9, 1, 2162160),
    (3125, 150, 9, -59, 7413120),
    (3126, 151, 9, -3709, 259459200),
    (3127, 152, 9, 79, 115315200),
    (3128, 153, 9, 269, 98841600),
    (3129, 154, 9, 1187, 355829760),
    (3130, 155, 9, 5141, 6227020800),
    (3131, 156, 9, -7, 8236800),
    (3132, 157, 9, -16537, 43589145600),
    (3133, 158, 9, 461, 138378240),
    (3134, 159, 9, 337, 622702080),
    (3135, 160, 9, -29797, 2075673600),
    (3136, 161, 9, -2591, 172972800),
    (3137, 162, 9, -953, 103783680),
    (3138, 163, 9, -17071, 518918400),
    (3139, 164, 9, -113, 415134720),
    (3140, 165, 9, -563, 92252160),
    (3141, 166, 9, -1909, 197683200),
    (3142, 167, 9, 18521, 12454041600),
    (3143, 168, 9, 2551, 461260800),
    (3144, 169, 9, 33731, 4981616640),
    (3145, 170, 9, 2957, 889574400),
    (3146, 171, 9, 13603, 9686476800),
    (3147, 172, 9, 210137, 174356582400),
    (3148, 173, 9, 11, 1397760),
    (3149, 174, 9, 25, 4447872),
    (3150, 175, 9, -15343, 1037836800),
    (3151, 176, 9, -184, 14189175),
    (3152, 177, 9, -3431, 207567360),
    (3153, 178, 9, -57007, 1037836800),
    (3154, 179, 9, -1, 622702080),
    (3155, 180, 9, -253, 13478400),
    (3156, 181, 9, -1753, 64864800),
    (3157, 182, 9, 29, 17791488),
    (3158, 183, 9, -8149, 1037836800),
    (3159, 184, 9, -226757, 29059430400),
    (3160, 185, 9, 131, 239500800),
    (3161, 186, 9, 673, 622702080),
    (3162, 187, 9, -29, 41513472),
    (3163, 188, 9, -601, 239500800),
    (3164, 189, 9, -521, 345945600),
    (3165, 190, 9, -17, 14826240),
    (3166, 191, 9, -2407, 207567360),
    (3167, 192, 9, -17441, 1037836800),
    (3168, 193, 9, -7769, 622702080),
    (3169, 194, 9, 8269, 4151347200),
    (3170, 195, 9, 1057, 237219840),
    (3171, 196, 9, 7, 9123840),
    (3172, 197, 9, -359, 118609920),
    (3173, 198, 9, -33923, 29059430400),
    (3174, 199, 9, -71, 69189120),
    (3175, 200, 9, -449, 17297280),
    (3176, 201, 9, -3439, 94348800),
    (3177, 202, 9, -1223, 38438400),
    (3178, 203, 9, 629, 319334400),
    (3179, 204, 9, 727, 155675520),
    (3180, 205, 9, 593, 177914880),
    (3181, 206, 9, 1301, 605404800),
    (3182, 207, 9, 184259, 74724249600),
    (3183, 208, 9, 991, 622702080),
    (3184, 209, 9, -3967, 345945600),
    (3185, 210, 9, -49589, 3632428800),
    (3186, 211, 9, -20681, 1037836800),
    (3187, 212, 9, -1457, 2490808320),
    (3188, 213, 9, -1057, 711659520),
    (3189, 214, 9, -163, 142331904),
    (3190, 215, 9, -1457, 830269440),
    (3191, 216, 9, -1069, 226437120),
    (3192, 128, 10, 60371, 784604620800),
    (3193, 129, 10, 3613, 6457651200),
    (3194, 130, 10, 34721, 21794572800),
    (3195, 131, 10, 82931, 37362124800),
    (3196, 132, 10, 1411, 943488000),
    (3197, 133, 10, 41, 118609920),
    (3198, 134, 10, -7543, 196151155200),
    (3199, 135, 10, 911, 19372953600),
    (3200, 136, 10, 14713, 261534873600),
    (3201, 137, 10, 45169, 21794572800),
    (3202, 138, 10, 5081, 479001600),
    (3203, 139, 10, 13709, 691891200),
    (3204, 140, 10, 17027, 1037836800),
    (3205, 141, 10, 1237, 207567360),
    (3206, 142, 10, 129517, 87178291200),
    (3207, 143, 10, 2833, 2874009600),
    (3208, 144, 10, 31, 2419200),
    (3209, 145, 10, 1949, 51891840),
    (3210, 146, 10, 1319, 43243200),
    (3211, 147, 10, 37, 13837824),
    (3212, 148, 10, -121139, 43589145600),
    (3213, 149, 10, 1847, 155675520),
    (3214, 150, 10, -391, 86486400),
    (3215, 151, 10, -2173, 74131200),
    (3216, 152, 10, 1943, 566092800),
    (3217, 153, 10, 5669, 415134720),
    (3218, 154, 10, 226033, 12454041600),
    (3219, 155, 10, 6793, 778377600),
    (3220, 156, 10, 1259, 1320883200),
    (3221, 157, 10, 9193, 17435658240),
    (3222, 158, 10, 361, 15966720),
    (3223, 159, 10, 25769, 778377600),
    (3224, 160, 10, -6673, 518918400),
    (3225, 161, 10, -341, 12230400),
    (3226, 162, 10, -7201, 518918400),
    (3227, 163, 10, -1691, 19958400),
    (3228, 164, 10, 2357, 622702080),
    (3229, 165, 10, -5491, 518918400),
    (3230, 166, 10, -12239, 518918400),
    (3231, 167, 10, 5107, 778377600),
    (3232, 168, 10, 83, 3603600),
    (3233, 169, 10, 40321, 1556755200),
    (3234, 170, 10, 97, 8895744),
    (3235, 171, 10, 1073, 222393600),
    (3236, 172, 10, 7957, 1556755200),
    (3237, 173, 10, 4721, 103783680),
    (3238, 174, 10, 105803, 1556755200),
    (3239, 175, 10, 4063, 518918400),
    (3240, 176, 10, -10039, 3113510400),
    (3241, 177, 10, -1369, 103783680),
    (3242, 178, 10, -56753, 518918400),
    (3243, 179, 10, 14717, 778377600),
    (3244, 180, 10, -19477, 1037836800),
    (3245, 181, 10, -33167, 726485760),
    (3246, 182, 10, 29, 1596672),
    (3247, 183, 10, 691, 138378240),
    (3248, 184, 10, 1531, 145297152),
    (3249, 185, 10, 379, 124540416),
    (3250, 186, 10, 9491, 1245404160),
    (3251, 187, 10, 1457, 444787200),
    (3252, 188, 10, -1147, 345945600),
    (3253, 189, 10, -14723, 7264857600),
    (3254, 190, 10, 1, 399168),
    (3255, 191, 10, -1201, 47174400),
    (3256, 192, 10, -22501, 518918400),
    (3257, 193, 10, -11743, 311351040),
    (3258, 194, 10, 509, 51891840),
    (3259, 195, 10, 1667, 69189120),
    (3260, 196, 10, 3719, 259459200),
    (3261, 197, 10, 71, 69189120),
    (3262, 198, 10, 289, 85135050),
    (3263, 199, 10, 97, 5189184),
    (3264, 200, 10, -12323, 345945600),
    (3265, 201, 10, -36067, 518918400),
    (3266, 202, 10, -2111, 26611200),
    (3267, 203, 10, 901, 113218560),
    (3268, 204, 10, 3179, 188697600),
    (3269, 205, 10, 1637, 172972800),
    (3270, 206, 10, 89087, 13076743680),
    (3271, 207, 10, 300007, 29059430400),
    (3272, 208, 10, 33977, 1556755200),
    (3273, 209, 10, 101, 86486400),
    (3274, 210, 10, -39073, 21794572800),
    (3275, 211, 10, -47, 1397088),
    (3276, 212, 10, -2987, 1245404160),
    (3277, 213, 10, -19147, 2490808320),
    (3278, 214, 10, -8557, 1556755200),
    (3279, 215, 10, -2413, 207567360),
    (3280, 216, 10, -347, 11119680),
    (3281, 217, 10, -21157, 3113510400),
    (3282, 218, 10, -4819, 1245404160),
    (3283, 219, 10, -173, 11531520),
    (3284, 220, 10, -66119, 1556755200),
    (3285, 128, 11, 29677, 261534873600),
    (3286, 129, 11, 6187, 8302694400),
    (3287, 130, 11, 39073, 21794572800),
    (3288, 131, 11, 7003, 4151347200),
    (3289, 132, 11, -2111, 10378368000),
    (3290, 133, 11, -4673, 2874009600),
    (3291, 134, 11, -2011, 1676505600),
    (3292, 135, 11, -17363, 58118860800),
    (3293, 136, 11, 1291, 87178291200),
    (3294, 137, 11, 45517, 14529715200),
    (3295, 138, 11, 109, 7484400),
    (3296, 139, 11, 48121, 2075673600),
    (3297, 140, 11, 6749, 518918400),
    (3298, 141, 11, -31813, 37362124800),
    (3299, 142, 11, -467, 247665600),
    (3300, 143, 11, 97003, 145297152000),
    (3301, 144, 11, 42967, 2075673600),
    (3302, 145, 11, 120229, 2075673600),
    (3303, 146, 11, 24049, 518918400),
    (3304, 147, 11, 93257, 10897286400),
    (3305, 148, 11, 123031, 87178291200),
    (3306, 149, 11, 1541, 57657600),
    (3307, 150, 11, 7, 374400),
    (3308, 151, 11, -23731, 1676505600),
    (3309, 152, 11, 66271, 12454041600),
    (3310, 153, 11, 51049, 2594592000),
    (3311, 154, 11, 58867, 2490808320),
    (3312, 155, 11, 104513, 10897286400),
    (3313, 156, 11, 28907, 24908083200),
    (3314, 157, 11, 2279, 1362160800),
    (3315, 158, 11, 1327, 32947200),
    (3316, 159, 11, 108923, 1556755200),
    (3317, 160, 11, 15481, 908107200),
    (3318, 161, 11, -24149, 2724321600),
    (3319, 162, 11, 611, 79833600),
    (3320, 163, 11, -197, 3175200),
    (3321, 164, 11, 1997, 188697600),
    (3322, 165, 11, -17, 2075673600),
    (3323, 166, 11, -111821, 7264857600),
    (3324, 167, 11, 34423, 4151347200),
    (3325, 168, 11, 236359, 10378368000),
    (3326, 169, 11, 4919, 479001600),
    (3327, 170, 11, -23651, 1634592960),
    (3328, 171, 11, -518117, 58118860800),
    (3329, 172, 11, 4981, 1383782400),
    (3330, 173, 11, 66617, 1037836800),
    (3331, 174, 11, 167, 1945944),
    (3332, 175, 11, 168349, 14529715200),
    (3333, 176, 11, 340019, 21794572800),
    (3334, 177, 11, 12653, 518918400),
    (3335, 178, 11, -5297, 100900800),
    (3336, 179, 11, 29363, 778377600),
    (3337, 180, 11, 45887, 3632428800),
    (3338, 181, 11, -3307, 440294400),
    (3339, 182, 11, 100769, 6227020800),
    (3340, 183, 11, -3917, 908107200),
    (3341, 184, 11, 43531, 1614412800),
    (3342, 185, 11, 1153, 230630400),
    (3343, 186, 11, 3617, 283046400),
    (3344, 187, 11, 199, 23063040),
    (3345, 188, 11, 10027, 7264857600),
    (3346, 189, 11, 4559, 2874009600),
    (3347, 190, 11, 281, 24324300),
    (3348, 191, 11, -5653, 518918400),
    (3349, 192, 11, -35473, 1210809600),
    (3350, 193, 11, -54487, 1556755200),
    (3351, 194, 11, 11213, 830269440),
    (3352, 195, 11, 23843, 830269440),
    (3353, 196, 11, 953, 79833600),
    (3354, 197, 11, 323, 311351040),
    (3355, 198, 11, 15959, 1761177600),
    (3356, 199, 11, 4331, 103783680),
    (3357, 200, 11, 5, 1729728),
    (3358, 201, 11, -15791, 691891200),
    (3359, 202, 11, -64943, 1210809600),
    (3360, 203, 11, 19, 2620800),
    (3361, 204, 11, 263, 79833600),
    (3362, 205, 11, -863, 42456960),
    (3363, 206, 11, -6389, 484323840),
    (3364, 207, 11, 83, 9979200),
    (3365, 208, 11, 503, 19958400),
    (3366, 209, 11, 1223, 3113510400),
    (3367, 210, 11, 45533, 2179457280),
    (3368, 211, 11, -15097, 3113510400),
    (3369, 212, 11, -31, 77837760),
    (3370, 213, 11, -991, 226437120),
    (3371, 214, 11, -37507, 21794572800),
    (3372, 215, 11, -17, 1397760),
    (3373, 216, 11, -97393, 3113510400),
    (3374, 217, 11, -4453, 3113510400),
    (3375, 218, 11, 89423, 13076743680),
    (3376, 219, 11, -22493, 1037836800),
    (3377, 220, 11, -6949, 111196800),
    (3378, 221, 11, 83663, 8717829120),
    (3379, 222, 11, -4597, 1037836800),
    (3380, 223, 11, -7649, 691891200),
    (3381, 128, 12, 31781, 523069747200),
    (3382, 129, 12, 113713, 348713164800),
    (3383, 130, 12, 20147, 43589145600),
    (3384, 131, 12, -343, 711659520),
    (3385, 132, 12, -80617, 37362124800),
    (3386, 133, 12, -17, 6451200),
    (3387, 134, 12, -67469, 43589145600),
    (3388, 135, 12, -149839, 348713164800),
    (3389, 136, 12, -3631, 104613949440),
    (3390, 137, 12, 10447, 6227020800),
    (3391, 138, 12, 281, 44478720),
    (3392, 139, 12, 23041, 4151347200),
    (3393, 140, 12, -77531, 14944849920),
    (3394, 141, 12, -203779, 18681062400),
    (3395, 142, 12, -100301, 18162144000),
    (3396, 143, 12, -90889, 174356582400),
    (3397, 144, 12, 29663, 2594592000),
    (3398, 145, 12, 4399, 166053888),
    (3399, 146, 12, 105683, 8717829120),
    (3400, 147, 12, -64187, 12454041600),
    (3401, 148, 12, -9857, 10897286400),
    (3402, 149, 12, 1997, 115315200),
    (3403, 150, 12, 133381, 8717829120),
    (3404, 151, 12, -71, 538137600),
    (3405, 152, 12, 181513, 62270208000),
    (3406, 153, 12, 1867, 207567360),
    (3407, 154, 12, 238061, 34871316480),
    (3408, 155, 12, -15551, 7472424960),
    (3409, 156, 12, -4007, 1383782400),
    (3410, 157, 12, 49453, 108972864000),
    (3411, 158, 12, 24839, 1037836800),
    (3412, 159, 12, 3089, 79252992),
    (3413, 160, 12, 36181, 2905943040),
    (3414, 161, 12, 3161, 889574400),
    (3415, 162, 12, 229219, 14529715200),
    (3416, 163, 12, -1147, 138378240),
    (3417, 164, 12, 1, 128700),
    (3418, 165, 12, 6379, 1162377216),
    (3419, 166, 12, -3281, 5811886080),
    (3420, 167, 12, 3383, 1153152000),
    (3421, 168, 12, 1139, 1383782400),
    (3422, 169, 12, -4285, 193729536),
    (3423, 170, 12, -13439, 355829760),
    (3424, 171, 12, -16189, 792529920),
    (3425, 172, 12, -109, 64696320),
    (3426, 173, 12, 97057, 4151347200),
    (3427, 174, 12, -883, 2905943040),
    (3428, 175, 12, -413459, 9686476800),
    (3429, 176, 12, -162143, 43589145600),
    (3430, 177, 12, 6521, 372556800),
    (3431, 178, 12, -961, 269068800),
    (3432, 179, 12, 765181, 43589145600),
    (3433, 180, 12, 2801, 528353280),
    (3434, 181, 12, 290951, 29059430400),
    (3435, 182, 12, -8693, 838252800),
    (3436, 183, 12, -33503, 830269440),
    (3437, 184, 12, -43, 145297152),
    (3438, 185, 12, 89447, 31135104000),
    (3439, 186, 12, 1667, 249080832),
    (3440, 187, 12, 38387, 8717829120),
    (3441, 188, 12, 15439, 7472424960),
    (3442, 189, 12, 869, 339655680),
    (3443, 190, 12, 1381, 141523200),
    (3444, 191, 12, 59, 10762752),
    (3445, 192, 12, 1, 3048192),
    (3446, 193, 12, -7421, 871782912),
    (3447, 194, 12, 11393, 2075673600),
    (3448, 195, 12, 7817, 1660538880),
    (3449, 196, 12, -7087, 622702080),
    (3450, 197, 12, -1241, 127733760),
    (3451, 198, 12, 167053, 43589145600),
    (3452, 199, 12, 44017, 2075673600),
    (3453, 200, 12, 4897, 830269440),
    (3454, 201, 12, 313483, 29059430400),
    (3455, 202, 12, -2203, 830269440),
    (3456, 203, 12, -11173, 20756736000),
    (3457, 204, 12, -71081, 3736212480),
    (3458, 205, 12, -21257, 484323840),
    (3459, 206, 12, -170747, 5811886080),
    (3460, 207, 12, -130777, 74724249600),
    (3461, 208, 12, -82699, 18681062400),
    (3462, 209, 12, -6037, 170270100),
    (3463, 210, 12, -167, 4843238400),
    (3464, 211, 12, 239, 27518400),
    (3465, 212, 12, 467, 311351040),
    (3466, 213, 12, 54533, 34871316480),
    (3467, 214, 12, 40357, 14944849920),
    (3468, 215, 12, -599, 172972800),
    (3469, 216, 12, -66301, 8717829120),
    (3470, 217, 12, 83, 16144128),
    (3471, 218, 12, 29119, 2490808320),
    (3472, 219, 12, -29, 19768320),
    (3473, 220, 12, -5347, 2905943040),
    (3474, 221, 12, 37969, 3487131648),
    (3475, 222, 12, -22963, 12454041600),
    (3476, 223, 12, 33463, 2724321600),
    (3477, 224, 12, -8629, 1779148800),
    (3478, 225, 12, 5633, 3962649600),
    (3479, 128, 13, 16993, 130767436800),
    (3480, 129, 13, 60371, 58118860800),
    (3481, 130, 13, 48491, 14529715200),
    (3482, 131, 13, 68759, 12454041600),
    (3483, 132, 13, 1717, 345945600),
    (3484, 133, 13, 289, 125798400),
    (3485, 134, 13, 22213, 52306974720),
    (3486, 135, 13, 2333, 174356582400),
    (3487, 136, 13, 5387, 217945728000),
    (3488, 137, 13, 1759, 484323840),
    (3489, 138, 13, 14419, 691891200),
    (3490, 139, 13, 6257, 138378240),
    (3491, 140, 13, 4583, 98841600),
    (3492, 141, 13, 1123, 49420800),
    (3493, 142, 13, 2533, 528353280),
    (3494, 143, 13, 3503, 5811886080),
    (3495, 144, 13, 703, 28828800),
    (3496, 145, 13, 5921, 69189120),
    (3497, 146, 13, 123, 1281280),
    (3498, 147, 13, 197, 5765760),
    (3499, 148, 13, -13561, 7264857600),
    (3500, 149, 13, 131, 3991680),
    (3501, 150, 13, 521, 15724800),
    (3502, 151, 13, -139, 6652800),
    (3503, 152, 13, 12841, 2075673600),
    (3504, 153, 13, 499, 17740800),
    (3505, 154, 13, 188063, 4151347200),
    (3506, 155, 13, 1171, 38438400),
    (3507, 156, 13, 11299, 1614412800),
    (3508, 157, 13, -1207, 9686476800),
    (3509, 158, 13, 331, 6918912),
    (3510, 159, 13, 13577, 129729600),
    (3511, 160, 13, 3347, 86486400),
    (3512, 161, 13, -8927, 302702400),
    (3513, 162, 13, 2329, 172972800),
    (3514, 163, 13, -13583, 172972800),
    (3515, 164, 13, 337, 25945920),
    (3516, 165, 13, 733, 345945600),
    (3517, 166, 13, -1867, 69189120),
    (3518, 167, 13, 4007, 296524800),
    (3519, 168, 13, 353, 6289920),
    (3520, 169, 13, 168611, 2075673600),
    (3521, 170, 13, 16733, 345945600),
    (3522, 171, 13, 66029, 5811886080),
    (3523, 172, 13, 6371, 2421619200),
    (3524, 173, 13, 947, 8648640),
    (3525, 174, 13, 421, 1814400),
    (3526, 175, 13, 38641, 345945600),
    (3527, 176, 13, -77269, 7264857600),
    (3528, 177, 13, 9761, 172972800),
    (3529, 178, 13, -16201, 172972800),
    (3530, 179, 13, 269, 4118400),
    (3531, 180, 13, 2323, 57657600),
    (3532, 181, 13, -142453, 2421619200),
    (3533, 182, 13, 1361, 19958400),
    (3534, 183, 13, 3659, 62899200),
    (3535, 184, 13, -5801, 691891200),
    (3536, 185, 13, 289, 49420800),
    (3537, 186, 13, 2521, 138378240),
    (3538, 187, 13, 5273, 345945600),
    (3539, 188, 13, -29, 43243200),
    (3540, 189, 13, -2113, 484323840),
    (3541, 190, 13, 83, 5765760),
    (3542, 191, 13, -817, 57657600),
    (3543, 192, 13, -901, 15724800),
    (3544, 193, 13, -713, 14826240),
    (3545, 194, 13, 967, 46126080),
    (3546, 195, 13, 2963, 46126080),
    (3547, 196, 13, 271, 4612608),
    (3548, 197, 13, 1297, 98841600),
    (3549, 198, 13, -51407, 29059430400),
    (3550, 199, 13, 35, 494208),
    (3551, 200, 13, 1579, 57657600),
    (3552, 201, 13, -2909, 31449600),
    (3553, 202, 13, -17467, 172972800),
    (3554, 203, 13, 5917, 296524800),
    (3555, 204, 13, 301, 5391360),
    (3556, 205, 13, 8101, 172972800),
    (3557, 206, 13, 25937, 1981324800),
    (3558, 207, 13, 418399, 87178291200),
    (3559, 208, 13, 1717, 21621600),
    (3560, 209, 13, 2903, 43243200),
    (3561, 210, 13, -139729, 7264857600),
    (3562, 211, 13, -29677, 605404800),
    (3563, 212, 13, -1, 912384),
    (3564, 213, 13, -9137, 830269440),
    (3565, 214, 13, -21677, 2075673600),
    (3566, 215, 13, -239, 17297280),
    (3567, 216, 13, -4747, 103783680),
    (3568, 217, 13, -7841, 518918400),
    (3569, 218, 13, -2113, 103783680),
    (3570, 219, 13, -239, 8648640),
    (3571, 220, 13, -12913, 103783680),
    (3572, 221, 13, -128771, 21794572800),
    (3573, 222, 13, -811, 172972800),
    (3574, 223, 13, -401, 4054050),
    (3575, 224, 13, 9161, 691891200),
    (3576, 225, 13, -47011, 2905943040),
    (3577, 226, 13, -521, 7862400),
    (3578, 128, 14, 2227, 8172964800),
    (3579, 129, 14, 117517, 58118860800),
    (3580, 130, 14, 12847, 2179457280),
    (3581, 131, 14, 223, 26611200),
    (3582, 132, 14, 4061, 741312000),
    (3583, 133, 14, 2333, 5748019200),
    (3584, 134, 14, -4349, 2971987200),
    (3585, 135, 14, -51859, 72648576000),
    (3586, 136, 14, -193, 2421619200),
    (3587, 137, 14, 18839, 2421619200),
    (3588, 138, 14, 6481, 155675520),
    (3589, 139, 14, 107323, 1297296000),
    (3590, 140, 14, 154061, 2075673600),
    (3591, 141, 14, 719309, 26153487360),
    (3592, 142, 14, 13879, 8717829120),
    (3593, 143, 14, -1117, 4358914560),
    (3594, 144, 14, 14207, 259459200),
    (3595, 145, 14, 191117, 1037836800),
    (3596, 146, 14, 104761, 518918400),
    (3597, 147, 14, 170461, 2179457280),
    (3598, 148, 14, 34399, 5448643200),
    (3599, 149, 14, 4489, 51891840),
    (3600, 150, 14, 2243, 19219200),
    (3601, 151, 14, 5143, 495331200),
    (3602, 152, 14, 83903, 6227020800),
    (3603, 153, 14, 13661, 235872000),
    (3604, 154, 14, 137101, 1556755200),
    (3605, 155, 14, 1224541, 21794572800),
    (3606, 156, 14, 1180273, 87178291200),
    (3607, 157, 14, 66049, 43589145600),
    (3608, 158, 14, 19627, 172972800),
    (3609, 159, 14, 200701, 778377600),
    (3610, 160, 14, 531511, 3632428800),
    (3611, 161, 14, -59, 52390800),
    (3612, 162, 14, 5971, 74131200),
    (3613, 163, 14, -173759, 3632428800),
    (3614, 164, 14, 4733, 129729600),
    (3615, 165, 14, 34319, 1037836800),
    (3616, 166, 14, -147131, 7264857600),
    (3617, 167, 14, 31, 1209600),
    (3618, 168, 14, 4747, 49896000),
    (3619, 169, 14, 70253, 622702080),
    (3620, 170, 14, 247237, 6538371840),
    (3621, 171, 14, -131563, 14529715200),
    (3622, 172, 14, -6823, 3459456000),
    (3623, 173, 14, 23171, 103783680),
    (3624, 174, 14, 702799, 1556755200),
    (3625, 175, 14, 36991, 165110400),
    (3626, 176, 14, 85961, 5448643200),
    (3627, 177, 14, 2947, 14826240),
    (3628, 178, 14, 2441, 403603200),
    (3629, 179, 14, 119879, 778377600),
    (3630, 180, 14, 1135129, 7264857600),
    (3631, 181, 14, -2029, 201801600),
    (3632, 182, 14, 1453, 12162150),
    (3633, 183, 14, 1341007, 14529715200),
    (3634, 184, 14, 2771, 605404800),
    (3635, 185, 14, 13693, 1037836800),
    (3636, 186, 14, 1393, 34214400),
    (3637, 187, 14, 709, 18532800),
    (3638, 188, 14, 73057, 7264857600),
    (3639, 189, 14, -2533, 11887948800),
    (3640, 190, 14, 449, 10108800),
    (3641, 191, 14, 599, 32432400),
    (3642, 192, 14, -2803, 50450400),
    (3643, 193, 14, -6109, 97297200),
    (3644, 194, 14, 21779, 518918400),
    (3645, 195, 14, 12457, 103783680),
    (3646, 196, 14, 10583, 103783680),
    (3647, 197, 14, 2191, 88957440),
    (3648, 198, 14, 67237, 14529715200),
    (3649, 199, 14, 45041, 259459200),
    (3650, 200, 14, 54133, 345945600),
    (3651, 201, 14, -3329, 75675600),
    (3652, 202, 14, -226153, 2421619200),
    (3653, 203, 14, 2429, 74131200),
    (3654, 204, 14, 75287, 1037836800),
    (3655, 205, 14, 249433, 9340531200),
    (3656, 206, 14, -6737, 335301120),
    (3657, 207, 14, -10411, 3632428800),
    (3658, 208, 14, 25933, 172972800),
    (3659, 209, 14, 283769, 2179457280),
    (3660, 210, 14, 5813, 1362160800),
    (3661, 211, 14, -193547, 10897286400),
    (3662, 212, 14, 95, 31135104),
    (3663, 213, 14, -16241, 1556755200),
    (3664, 214, 14, -38299, 3962649600),
    (3665, 215, 14, -71, 3459456),
    (3666, 216, 14, -108179, 1556755200),
    (3667, 217, 14, 3721, 1556755200),
    (3668, 218, 14, -9049, 1307674368),
    (3669, 219, 14, -1327, 74131200),
    (3670, 220, 14, -225371, 1556755200),
    (3671, 221, 14, 1915, 290594304),
    (3672, 222, 14, 6401, 207567360),
    (3673, 223, 14, -18307, 242161920),
    (3674, 224, 14, 227741, 8717829120),
    (3675, 225, 14, -22991, 4358914560),
    (3676, 226, 14, -697, 5702400),
    (3677, 72, 15, 331, 19372953600),
    (3678, 73, 15, 22189, 217945728000),
    (3679, 74, 15, 6823, 31135104000),
    (3680, 75, 15, 4139, 20756736000),
    (3681, 76, 15, 13, 191600640),
    (3682, 77, 15, 191, 6227020800),
    (3683, 78, 15, 463, 8072064000),
    (3684, 79, 15, 1523, 40236134400),
    (3685, 80, 15, 521, 2223936000),
    (3686, 81, 15, 181, 288288000),
    (3687, 82, 15, -113, 691891200),
    (3688, 83, 15, -197, 119750400),
    (3689, 84, 15, -1037, 741312000),
    (3690, 85, 15, -437, 1513512000),
    (3691, 86, 15, -389, 2075673600),
    (3692, 87, 15, -397, 94348800),
    (3693, 88, 15, -191, 19768320),
    (3694, 89, 15, -35813, 5189184000),
    (3695, 90, 15, -17, 4435200),
    (3696, 91, 15, -5237, 518918400),
    (3697, 92, 15, 929, 5189184000),
    (3698, 93, 15, -19, 74131200),
    (3699, 94, 15, -797, 345945600),
    (3700, 95, 15, -4093, 1297296000),
    (3701, 96, 15, -2537, 1729728000),
    (3702, 97, 15, -487, 172972800),
    (3703, 98, 15, -4819, 345945600),
    (3704, 99, 15, -28949, 1729728000),
    (3705, 100, 15, -12293, 2075673600),
    (3706, 101, 15, 4187, 10378368000),
    (3707, 102, 15, -779, 4151347200),
    (3708, 103, 15, -5611, 2075673600),
    (3709, 104, 15, -12913, 5189184000),
    (3710, 105, 15, -5113, 72648576000),
    (3711, 106, 15, -1457, 259459200),
    (3712, 107, 15, -643, 26611200),
    (3713, 108, 15, -289, 12096000),
    (3714, 109, 15, -109607, 5189184000),
    (3715, 110, 15, -43, 311351040),
    (3716, 111, 15, -809, 518918400),
    (3717, 112, 15, -1139, 345945600),
    (3718, 113, 15, -3301, 1415232000),
    (3719, 114, 15, -1997, 518918400),
    (3720, 115, 15, -1009, 103783680),
    (3721, 116, 15, -1249, 4151347200),
    (3722, 117, 15, -8083, 2075673600),
    (3723, 118, 15, -293, 39536640),
    (3724, 119, 15, -1091, 259459200),
    (3725, 120, 15, -1993, 172972800),
    (3726, 121, 15, -439, 16473600),
    (3727, 122, 15, -71, 830269440),
    (3728, 123, 15, -3013, 1556755200),
    (3729, 124, 15, -5029, 2075673600),
    (3730, 125, 15, 829, 3302208000),
    (3731, 126, 15, -23, 2594592),
    (3732, 127, 15, -1633, 96096000),
    (3733, 72, 16, 37391, 348713164800),
    (3734, 73, 16, 239, 377395200),
    (3735, 74, 16, 5777, 4151347200),
    (3736, 75, 16, 3187, 2264371200),
    (3737, 76, 16, 6011, 8302694400),
    (3738, 77, 16, 7, 17971200),
    (3739, 78, 16, 95507, 261534873600),
    (3740, 79, 16, 419, 2113413120),
    (3741, 80, 16, 22189, 12454041600),
    (3742, 81, 16, 1223, 197683200),
    (3743, 82, 16, 469, 79073280),
    (3744, 83, 16, 71, 230630400),
    (3745, 84, 16, -101, 125798400),
    (3746, 85, 16, 151297, 174356582400),
    (3747, 86, 16, 43, 12773376),
    (3748, 87, 16, -29, 6486480),
    (3749, 88, 16, -1219, 53222400),
    (3750, 89, 16, -653, 38438400),
    (3751, 90, 16, -2419, 207567360),
    (3752, 91, 16, -11777, 345945600),
    (3753, 92, 16, 107, 55351296),
    (3754, 93, 16, 5591, 1660538880),
    (3755, 94, 16, -10379, 4151347200),
    (3756, 95, 16, -27173, 4151347200),
    (3757, 96, 16, -2789, 1076275200),
    (3758, 97, 16, -199, 41513472),
    (3759, 98, 16, -11, 268800),
    (3760, 99, 16, -13667, 259459200),
    (3761, 100, 16, -929, 43243200),
    (3762, 101, 16, 1129, 296524800),
    (3763, 102, 16, 137, 19768320),
    (3764, 103, 16, 1429, 1037836800),
    (3765, 104, 16, 211, 118609920),
    (3766, 105, 16, 265819, 43589145600),
    (3767, 106, 16, -37, 5765760),
    (3768, 107, 16, -18787, 345945600),
    (3769, 108, 16, -106577, 2075673600),
    (3770, 109, 16, -3121, 49420800),
    (3771, 110, 16, 943, 2490808320),
    (3772, 111, 16, -1, 279552),
    (3773, 112, 16, -13397, 1383782400),
    (3774, 113, 16, -6953, 1037836800),
    (3775, 114, 16, -289, 20756736),
    (3776, 115, 16, -37831, 1037836800),
    (3777, 116, 16, 61, 30750720),
    (3778, 117, 16, -197, 34594560),
    (3779, 118, 16, -4603, 296524800),
    (3780, 119, 16, -1709, 276756480),
    (3781, 120, 16, -269, 7687680),
    (3782, 121, 16, -86897, 1037836800),
    (3783, 122, 16, 11509, 4981616640),
    (3784, 123, 16, 19, 25625600),
    (3785, 124, 16, 5953, 2075673600),
    (3786, 125, 16, 33799, 3269185920),
    (3787, 126, 16, -20849, 1037836800),
    (3788, 127, 16, -229, 6486480),
    (3789, 72, 17, 601, 2641766400),
    (3790, 73, 17, 27239, 21794572800),
    (3791, 74, 17, 22807, 9340531200),
    (3792, 75, 17, 11663, 6227020800),
    (3793, 76, 17, 97, 415134720),
    (3794, 77, 17, -263, 2155507200),
    (3795, 78, 17, 331, 1037836800),
    (3796, 79, 17, 24821, 87178291200),
    (3797, 80, 17, 25829, 6227020800),
    (3798, 81, 17, 4489, 311351040),
    (3799, 82, 17, 19087, 1245404160),
    (3800, 83, 17, 17, 3421440),
    (3801, 84, 17, 10349, 5337446400),
    (3802, 85, 17, 14821, 4670265600),
    (3803, 86, 17, 1219, 95800320),
    (3804, 87, 17, 20509, 1556755200),
    (3805, 88, 17, -151, 12972960),
    (3806, 89, 17, -326369, 32691859200),
    (3807, 90, 17, -673, 74131200),
    (3808, 91, 17, -3229, 86486400),
    (3809, 92, 17, 10573, 2075673600),
    (3810, 93, 17, 36523, 3113510400),
    (3811, 94, 17, 67, 13837824),
    (3812, 95, 17, -3277, 1452971520),
    (3813, 96, 17, 5647, 7472424960),
    (3814, 97, 17, 9281, 1556755200),
    (3815, 98, 17, -17239, 518918400),
    (3816, 99, 17, -1711, 33022080),
    (3817, 100, 17, -27359, 1037836800),
    (3818, 101, 17, 51049, 6227020800),
    (3819, 102, 17, 31553, 2075673600),
    (3820, 103, 17, 1831, 311351040),
    (3821, 104, 17, 103217, 13076743680),
    (3822, 105, 17, 20093, 1383782400),
    (3823, 106, 17, 131, 10108800),
    (3824, 107, 17, -13973, 518918400),
    (3825, 108, 17, -352969, 21794572800),
    (3826, 109, 17, -68171, 1210809600),
    (3827, 110, 17, 589, 249080832),
    (3828, 111, 17, -83, 145945800),
    (3829, 112, 17, -5021, 622702080),
    (3830, 113, 17, -1033, 217945728),
    (3831, 114, 17, -73, 4422600),
    (3832, 115, 17, -469, 10108800),
    (3833, 116, 17, 1679, 226437120),
    (3834, 117, 17, 629, 207567360),
    (3835, 118, 17, -179, 29652480),
    (3836, 119, 17, 11567, 1868106240),
    (3837, 120, 17, -3319, 103783680),
    (3838, 121, 17, -42473, 518918400),
    (3839, 122, 17, 983, 207567360),
    (3840, 123, 17, 1073, 389188800),
    (3841, 124, 17, 127, 13343616),
    (3842, 125, 17, 12911, 544864320),
    (3843, 126, 17, -5693, 518918400),
    (3844, 127, 17, -37381, 4670265600),
    (3845, 72, 18, 419, 2113413120),
    (3846, 73, 18, 6133, 6706022400),
    (3847, 74, 18, 1087, 958003200),
    (3848, 75, 18, -205, 332107776),
    (3849, 76, 18, -26027, 10674892800),
    (3850, 77, 18, -4649, 2490808320),
    (3851, 78, 18, -461, 1162377216),
    (3852, 79, 18, 37391, 348713164800),
    (3853, 80, 18, 6703, 1779148800),
    (3854, 81, 18, 5807, 518918400),
    (3855, 82, 18, 12449, 1660538880),
    (3856, 83, 18, -118087, 37362124800),
    (3857, 84, 18, -28051, 12454041600),
    (3858, 85, 18, 2269, 1135134000),
    (3859, 86, 18, 14383, 1037836800),
    (3860, 87, 18, 1069, 59304960),
    (3861, 88, 18, -3137, 29059430400),
    (3862, 89, 18, 6817, 12454041600),
    (3863, 90, 18, 41, 53222400),
    (3864, 91, 18, -626359, 43589145600),
    (3865, 92, 18, 102953, 20756736000),
    (3866, 93, 18, 4471, 415134720),
    (3867, 94, 18, 26863, 5811886080),
    (3868, 95, 18, -787, 24908083200),
    (3869, 96, 18, 551, 197683200),
    (3870, 97, 18, 1057, 74131200),
    (3871, 98, 18, -2803, 968647680),
    (3872, 99, 18, -5333, 372556800),
    (3873, 100, 18, -68597, 5811886080),
    (3874, 101, 18, 4951, 943488000),
    (3875, 102, 18, 149, 79073280),
    (3876, 103, 18, -318893, 21794572800),
    (3877, 104, 18, -59, 8515584),
    (3878, 105, 18, 76777, 8717829120),
    (3879, 106, 18, 30497, 2075673600),
    (3880, 107, 18, -213949, 29059430400),
    (3881, 108, 18, 444607, 29059430400),
    (3882, 109, 18, -293609, 29059430400),
    (3883, 110, 18, 37127, 12454041600),
    (3884, 111, 18, 257, 88957440),
    (3885, 112, 18, -3277, 5811886080),
    (3886, 113, 18, 4451, 2874009600),
    (3887, 114, 18, -6569, 1037836800),
    (3888, 115, 18, -6079, 290594304),
    (3889, 116, 18, 5153, 830269440),
    (3890, 117, 18, 239, 118609920),
    (3891, 118, 18, -41, 53222400),
    (3892, 119, 18, 127, 10063872),
    (3893, 120, 18, -11183, 1383782400),
    (3894, 121, 18, -9643, 461260800),
    (3895, 122, 18, -101, 251596800),
    (3896, 123, 18, -118453, 9340531200),
    (3897, 124, 18, -6707, 968647680),
    (3898, 125, 18, 1973, 129153024),
    (3899, 126, 18, -7453, 1779148800),
    (3900, 127, 18, 3149, 209563200),
    (3901, 72, 19, 1627, 24908083200),
    (3902, 73, 19, 107, 620928000),
    (3903, 74, 19, -529, 1482624000),
    (3904, 75, 19, -13861, 7472424960),
    (3905, 76, 19, -2269, 830269440),
    (3906, 77, 19, -58021, 31135104000),
    (3907, 78, 19, -124067, 217945728000),
    (3908, 79, 19, -83, 2152550400),
    (3909, 80, 19, 43, 34594560),
    (3910, 81, 19, 839, 432432000),
    (3911, 82, 19, -19003, 4981616640),
    (3912, 83, 19, -269, 29189160),
    (3913, 84, 19, -697, 129729600),
    (3914, 85, 19, -257, 726485760),
    (3915, 86, 19, 3463, 691891200),
    (3916, 87, 19, 19559, 5448643200),
    (3917, 88, 19, -17011, 4151347200),
    (3918, 89, 19, -23, 56609280),
    (3919, 90, 19, 100117, 43589145600),
    (3920, 91, 19, -7781, 7264857600),
    (3921, 92, 19, 2269, 1297296000),
    (3922, 93, 19, 1901, 807206400),
    (3923, 94, 19, -22679, 12454041600),
    (3924, 95, 19, -191, 79833600),
    (3925, 96, 19, 953, 1297296000),
    (3926, 97, 19, 25447, 3632428800),
    (3927, 98, 19, 2749, 908107200),
    (3928, 99, 19, 647, 415134720),
    (3929, 100, 19, -2719, 3632428800),
    (3930, 101, 19, -527, 10378368000),
    (3931, 102, 19, -15493, 1585059840),
    (3932, 103, 19, -10783, 461260800),
    (3933, 104, 19, -12121, 778377600),
    (3934, 105, 19, -43943, 72648576000),
    (3935, 106, 19, -6439, 3962649600),
    (3936, 107, 19, -54211, 2905943040),
    (3937, 108, 19, 83, 159667200),
    (3938, 109, 19, 19967, 4843238400),
    (3939, 110, 19, 101, 79833600),
    (3940, 111, 19, 5363, 3632428800),
    (3941, 112, 19, 1927, 1779148800),
    (3942, 113, 19, 20693, 9340531200),
    (3943, 114, 19, 67, 134534400),
    (3944, 115, 19, -613, 1089728640),
    (3945, 116, 19, 2621, 4151347200),
    (3946, 117, 19, -1333, 249080832),
    (3947, 118, 19, -3127, 553512960),
    (3948, 119, 19, 1891, 444787200),
    (3949, 120, 19, -779, 4151347200),
    (3950, 121, 19, 60661, 14529715200),
    (3951, 122, 19, -4421, 1067489280),
    (3952, 123, 19, -807, 44844800),
    (3953, 124, 19, -22969, 1383782400),
    (3954, 125, 19, 4033, 13076743680),
    (3955, 126, 19, -81797, 10897286400),
    (3956, 127, 19, 661, 269068800),
    (3957, 72, 20, 703, 2724321600),
    (3958, 73, 20, 37391, 21794572800),
    (3959, 74, 20, 9161, 2075673600),
    (3960, 75, 20, 34631, 6227020800),
    (3961, 76, 20, 107, 29652480),
    (3962, 77, 20, 3937, 3113510400),
    (3963, 78, 20, 103721, 261534873600),
    (3964, 79, 20, 47549, 261534873600),
    (3965, 80, 20, 331, 69189120),
    (3966, 81, 20, 1933, 94348800),
    (3967, 82, 20, 1361, 46126080),
    (3968, 83, 20, 121, 7862400),
    (3969, 84, 20, 893, 1037836800),
    (3970, 85, 20, -503, 792529920),
    (3971, 86, 20, 199, 12972960),
    (3972, 87, 20, 83, 3706560),
    (3973, 88, 20, -53, 3459456),
    (3974, 89, 20, -3043, 103783680),
    (3975, 90, 20, -43, 5189184),
    (3976, 91, 20, -67, 1425600),
    (3977, 92, 20, 881, 148262400),
    (3978, 93, 20, 7099, 415134720),
    (3979, 94, 20, 1583, 148262400),
    (3980, 95, 20, -1567, 259459200),
    (3981, 96, 20, -5329, 807206400),
    (3982, 97, 20, 233, 25945920),
    (3983, 98, 20, -3277, 86486400),
    (3984, 99, 20, -7277, 86486400),
    (3985, 100, 20, -619, 18532800),
    (3986, 101, 20, 211, 15966720),
    (3987, 102, 20, 49, 1347840),
    (3988, 103, 20, 521, 19219200),
    (3989, 104, 20, 167, 47174400),
    (3990, 105, 20, 4201, 3353011200),
    (3991, 106, 20, 31, 1153152),
    (3992, 107, 20, -7493, 172972800),
    (3993, 108, 20, -9109, 86486400),
    (3994, 109, 20, -8101, 74131200),
    (3995, 110, 20, 601, 207567360),
    (3996, 111, 20, 17, 311351040),
    (3997, 112, 20, -359, 26611200),
    (3998, 113, 20, -7127, 518918400),
    (3999, 114, 20, -893, 51891840),
    (4000, 115, 20, -15641, 259459200),
    (4001, 116, 20, 4987, 415134720),
    (4002, 117, 20, 41, 3706560),
    (4003, 118, 20, -1381, 69189120),
    (4004, 119, 20, -47, 2217600),
    (4005, 120, 20, -7, 183040),
    (4006, 121, 20, -24977, 172972800),
    (4007, 122, 20, 15823, 1245404160),
    (4008, 123, 20, 5519, 311351040),
    (4009, 124, 20, 41, 15724800),
    (4010, 125, 20, 43181, 16345929600),
    (4011, 126, 20, -361, 19219200),
    (4012, 127, 20, -10289, 129729600),
    (4013, 72, 21, 4993, 5811886080),
    (4014, 73, 21, 78467, 14529715200),
    (4015, 74, 21, 20173, 1556755200),
    (4016, 75, 21, 6089, 415134720),
    (4017, 76, 21, 523, 69189120),
    (4018, 77, 21, 44189, 37362124800),
    (4019, 78, 21, 17, 419126400),
    (4020, 79, 21, 19711, 72648576000),
    (4021, 80, 21, 35183, 2075673600),
    (4022, 81, 21, 7373, 103783680),
    (4023, 82, 21, 213937, 2075673600),
    (4024, 83, 21, 12503, 207567360),
    (4025, 84, 21, 1102501, 87178291200),
    (4026, 85, 21, 108611, 43589145600),
    (4027, 86, 21, 3439, 51891840),
    (4028, 87, 21, 397, 2948400),
    (4029, 88, 21, 1537, 31449600),
    (4030, 89, 21, -23249, 990662400),
    (4031, 90, 21, 83, 5765760),
    (4032, 91, 21, -323, 5241600),
    (4033, 92, 21, 239, 10644480),
    (4034, 93, 21, 3233, 47174400),
    (4035, 94, 21, 7097, 115315200),
    (4036, 95, 21, 23, 1956864),
    (4037, 96, 21, -295523, 87178291200),
    (4038, 97, 21, 18971, 259459200),
    (4039, 98, 21, 1571, 86486400),
    (4040, 99, 21, -137251, 1210809600),
    (4041, 100, 21, -10151, 172972800),
    (4042, 101, 21, 22619, 518918400),
    (4043, 102, 21, 6277, 53222400),
    (4044, 103, 21, 6829, 74131200),
    (4045, 104, 21, 4561, 198132480),
    (4046, 105, 21, 35333, 2905943040),
    (4047, 106, 21, 16493, 103783680),
    (4048, 107, 21, 1315, 13837824),
    (4049, 108, 21, -11845, 145297152),
    (4050, 109, 21, -13009, 89689600),
    (4051, 110, 21, 5711, 415134720),
    (4052, 111, 21, 29053, 1556755200),
    (4053, 112, 21, -11159, 1037836800),
    (4054, 113, 21, -26683, 1452971520),
    (4055, 114, 21, -11867, 518918400),
    (4056, 115, 21, -30223, 259459200),
    (4057, 116, 21, 9941, 207567360),
    (4058, 117, 21, 5209, 69189120),
    (4059, 118, 21, 211, 26611200),
    (4060, 119, 21, -7493, 622702080),
    (4061, 120, 21, -433, 31449600),
    (4062, 121, 21, -2107, 9884160),
    (4063, 122, 21, 16633, 415134720),
    (4064, 123, 21, 4267, 74131200),
    (4065, 124, 21, 10463, 566092800),
    (4066, 125, 21, 7733, 396264960),
    (4067, 126, 21, 23, 985600),
    (4068, 127, 21, -744239, 10897286400),
    (4069, 72, 22, 23861, 29059430400),
    (4070, 73, 22, 1747, 372556800),
    (4071, 74, 22, 60019, 6227020800),
    (4072, 75, 22, 2879, 377395200),
    (4073, 76, 22, -12781, 24908083200),
    (4074, 77, 22, -11207, 2668723200),
    (4075, 78, 22, -16829, 8072064000),
    (4076, 79, 22, -12049, 58118860800),
    (4077, 80, 22, 6959, 415134720),
    (4078, 81, 22, 24047, 370656000),
    (4079, 82, 22, 69103, 830269440),
    (4080, 83, 22, 1585607, 43589145600),
    (4081, 84, 22, -23, 111196800),
    (4082, 85, 22, -30937, 54486432000),
    (4083, 86, 22, 18869, 259459200),
    (4084, 87, 22, 158101, 1037836800),
    (4085, 88, 22, 385001, 4843238400),
    (4086, 89, 22, 194297, 43589145600),
    (4087, 90, 22, 193, 4612608),
    (4088, 91, 22, -2281, 1037836800),
    (4089, 92, 22, 11449, 494208000),
    (4090, 93, 22, 5903, 86486400),
    (4091, 94, 22, 178897, 2905943040),
    (4092, 95, 22, 166609, 9686476800),
    (4093, 96, 22, 1559, 622702080),
    (4094, 97, 22, 3671, 37065600),
    (4095, 98, 22, 241987, 2421619200),
    (4096, 99, 22, -110107, 7264857600),
    (4097, 100, 22, -20941, 968647680),
    (4098, 101, 22, 23851, 648648000),
    (4099, 102, 22, 337943, 4151347200),
    (4100, 103, 22, 73091, 2421619200),
    (4101, 104, 22, -379019, 17435658240),
    (4102, 105, 22, -653, 264176640),
    (4103, 106, 22, 173219, 1037836800),
    (4104, 107, 22, 20947, 146764800),
    (4105, 108, 22, 6763, 2075673600),
    (4106, 109, 22, -22357, 968647680),
    (4107, 110, 22, 33227, 2075673600),
    (4108, 111, 22, 44179, 1556755200),
    (4109, 112, 22, 5297, 581188608),
    (4110, 113, 22, -43063, 43589145600),
    (4111, 114, 22, 323, 103783680),
    (4112, 115, 22, -190373, 3632428800),
    (4113, 116, 22, 4769, 103783680),
    (4114, 117, 22, 149543, 2075673600),
    (4115, 118, 22, 42037, 2075673600),
    (4116, 119, 22, 911, 121927680),
    (4117, 120, 22, 11233, 230630400),
    (4118, 121, 22, -792191, 14529715200),
    (4119, 122, 22, 3943, 153753600),
    (4120, 123, 22, 8083, 778377600),
    (4121, 124, 22, -135281, 4358914560),
    (4122, 125, 22, -6991, 4843238400),
    (4123, 126, 22, 22691, 581188608),
    (4124, 127, 22, -31243, 5448643200),
    (4125, 72, 23, 1207, 2235340800),
    (4126, 73, 23, 3373, 968647680),
    (4127, 74, 23, 359, 41184000),
    (4128, 75, 23, 4373, 415134720),
    (4129, 76, 23, 661, 111767040),
    (4130, 77, 23, 28877, 37362124800),
    (4131, 78, 23, -29, 55036800),
    (4132, 79, 23, -1643, 12108096000),
    (4133, 80, 23, 3317, 296524800),
    (4134, 81, 23, 42893, 864864000),
    (4135, 82, 23, 18217, 230630400),
    (4136, 83, 23, 78079, 1452971520),
    (4137, 84, 23, 1171453, 87178291200),
    (4138, 85, 23, 2701, 8717829120),
    (4139, 86, 23, 8699, 172972800),
    (4140, 87, 23, 23, 184800),
    (4141, 88, 23, 69593, 807206400),
    (4142, 89, 23, 29507, 2724321600),
    (4143, 90, 23, 991, 28828800),
    (4144, 91, 23, 13837, 1210809600),
    (4145, 92, 23, 32569, 2075673600),
    (4146, 93, 23, 17, 320320),
    (4147, 94, 23, 61153, 1037836800),
    (4148, 95, 23, 66701, 2905943040),
    (4149, 96, 23, 116869, 87178291200),
    (4150, 97, 23, 3749, 51891840),
    (4151, 98, 23, 8159, 86486400),
    (4152, 99, 23, 251, 242161920),
    (4153, 100, 23, -1681, 172972800),
    (4154, 101, 23, 39701, 1297296000),
    (4155, 102, 23, 63241, 691891200),
    (4156, 103, 23, 301303, 3632428800),
    (4157, 104, 23, 6541, 335301120),
    (4158, 105, 23, -9041, 4843238400),
    (4159, 106, 23, 77881, 518918400),
    (4160, 107, 23, 455743, 2421619200),
    (4161, 108, 23, 3539, 165110400),
    (4162, 109, 23, -3733, 484323840),
    (4163, 110, 23, 85, 7547904),
    (4164, 111, 23, 1741, 74131200),
    (4165, 112, 23, 3251, 345945600),
    (4166, 113, 23, -5689, 1452971520),
    (4167, 114, 23, 449, 57657600),
    (4168, 115, 23, -521, 17297280),
    (4169, 116, 23, 3271, 86486400),
    (4170, 117, 23, 5377, 69189120),
    (4171, 118, 23, 89987, 2421619200),
    (4172, 119, 23, -439, 311351040),
    (4173, 120, 23, 19373, 345945600),
    (4174, 121, 23, -63181, 2421619200),
    (4175, 122, 23, 13033, 415134720),
    (4176, 123, 23, 17533, 330220800),
    (4177, 124, 23, 85453, 6227020800),
    (4178, 125, 23, -179, 41513472),
    (4179, 126, 23, 144821, 2421619200),
    (4180, 127, 23, 38713, 10897286400),
    (4181, 42, 24, 229, 31135104000),
    (4182, 43, 24, 2017, 186810624000),
    (4183, 44, 24, -211, 2830464000),
    (4184, 45, 24, -1847, 8302694400),
    (4185, 46, 24, -2753, 13343616000),
    (4186, 47, 24, -233, 4790016000),
    (4187, 48, 24, 233, 10378368000),
    (4188, 49, 24, -349, 3891888000),
    (4189, 50, 24, -163, 159667200),
    (4190, 51, 24, -73, 26611200),
    (4191, 52, 24, -86069, 31135104000),
    (4192, 53, 24, -8143, 7783776000),
    (4193, 54, 24, -451, 283046400),
    (4194, 55, 24, -12569, 2075673600),
    (4195, 56, 24, -65899, 10378368000),
    (4196, 57, 24, -109, 345945600),
    (4197, 58, 24, -5843, 3113510400),
    (4198, 59, 24, -263, 80870400),
    (4199, 60, 24, -64003, 31135104000),
    (4200, 61, 24, -3881, 1037836800),
    (4201, 62, 24, -26843, 3113510400),
    (4202, 63, 24, -2773, 4151347200),
    (4203, 64, 24, -7027, 2075673600),
    (4204, 65, 24, -291857, 62270208000),
    (4205, 66, 24, -2921, 1482624000),
    (4206, 67, 24, -47, 5930496),
    (4207, 68, 24, -1093, 69498000),
    (4208, 69, 24, -133, 74131200),
    (4209, 70, 24, -1171, 622702080),
    (4210, 71, 24, -31973, 6918912000),
    (4211, 42, 25, 17219, 217945728000),
    (4212, 43, 25, 457, 1596672000),
    (4213, 44, 25, 667, 3459456000),
    (4214, 45, 25, -1289, 4981616640),
    (4215, 46, 25, -83, 494208000),
    (4216, 47, 25, 6109, 20756736000),
    (4217, 48, 25, 190097, 653837184000),
    (4218, 49, 25, 2017, 10378368000),
    (4219, 50, 25, -1091, 461260800),
    (4220, 51, 25, -149, 17740800),
    (4221, 52, 25, -13901, 1729728000),
    (4222, 53, 25, -20989, 10378368000),
    (4223, 54, 25, -907, 148262400),
    (4224, 55, 25, -1061, 43243200),
    (4225, 56, 25, -397, 16016000),
    (4226, 57, 25, -3539, 4151347200),
    (4227, 58, 25, -14071, 2075673600),
    (4228, 59, 25, -251087, 20756736000),
    (4229, 60, 25, -36523, 5189184000),
    (4230, 61, 25, -389, 23063040),
    (4231, 62, 25, -7687, 199584000),
    (4232, 63, 25, -71, 47174400),
    (4233, 64, 25, -139, 14414400),
    (4234, 65, 25, -29747, 2594592000),
    (4235, 66, 25, -7, 6177600),
    (4236, 67, 25, -97, 3144960),
    (4237, 68, 25, -298141, 5189184000),
    (4238, 69, 25, -5399, 691891200),
    (4239, 70, 25, -7451, 943488000),
    (4240, 71, 25, -3253, 216216000),
    (4241, 42, 26, 1217, 4843238400),
    (4242, 43, 26, 12437, 12454041600),
    (4243, 44, 26, 1, 838656),
    (4244, 45, 26, 2257, 4981616640),
    (4245, 46, 26, 239, 415134720),
    (4246, 47, 26, 8819, 7472424960),
    (4247, 48, 26, 34709, 43589145600),
    (4248, 49, 26, 8069, 4151347200),
    (4249, 50, 26, 239, 207567360),
    (4250, 51, 26, -2693, 415134720),
    (4251, 52, 26, -161, 29652480),
    (4252, 53, 26, 5315, 2988969984),
    (4253, 54, 26, -2803, 415134720),
    (4254, 55, 26, -23197, 691891200),
    (4255, 56, 26, -6701, 207567360),
    (4256, 57, 26, 967, 4981616640),
    (4257, 58, 26, -5633, 778377600),
    (4258, 59, 26, -7297, 498161664),
    (4259, 60, 26, -29741, 4358914560),
    (4260, 61, 26, -4283, 159667200),
    (4261, 62, 26, -2501, 40435200),
    (4262, 63, 26, 505, 996323328),
    (4263, 64, 26, -5843, 889574400),
    (4264, 65, 26, -59, 22643712),
    (4265, 66, 26, 20693, 1634592960),
    (4266, 67, 26, -5939, 148262400),
    (4267, 68, 26, -102607, 1556755200),
    (4268, 69, 26, -12461, 1037836800),
    (4269, 70, 26, -2029, 177914880),
    (4270, 71, 26, -721, 59304960),
    (4271, 42, 27, 437, 1320883200),
    (4272, 43, 27, 8819, 7472424960),
    (4273, 44, 27, 193, 188697600),
    (4274, 45, 27, -97, 332107776),
    (4275, 46, 27, -1003, 11208637440),
    (4276, 47, 27, 12437, 12454041600),
    (4277, 48, 27, 251, 304819200),
    (4278, 49, 27, 3007, 889574400),
    (4279, 50, 27, 2137, 415134720),
    (4280, 51, 27, -1129, 1245404160),
    (4281, 52, 27, 461, 679311360),
    (4282, 53, 27, 4337, 747242496),
    (4283, 54, 27, -179, 259459200),
    (4284, 55, 27, -7361, 415134720),
    (4285, 56, 27, -129139, 8717829120),
    (4286, 57, 27, 26713, 12454041600),
    (4287, 58, 27, -107, 69189120),
    (4288, 59, 27, -21377, 3487131648),
    (4289, 60, 27, 193, 1067489280),
    (4290, 61, 27, -9161, 518918400),
    (4291, 62, 27, -36833, 871782912),
    (4292, 63, 27, 241, 111196800),
    (4293, 64, 27, -757, 415134720),
    (4294, 65, 27, 1709, 242161920),
    (4295, 66, 27, 18451, 830269440),
    (4296, 67, 27, -13901, 691891200),
    (4297, 68, 27, -5063, 264176640),
    (4298, 69, 27, -155, 20756736),
    (4299, 70, 27, -47, 8279040),
    (4300, 71, 27, 19, 3538080),
    (4301, 42, 28, 39419, 217945728000),
    (4302, 43, 28, 59, 153753600),
    (4303, 44, 28, -491, 798336000),
    (4304, 45, 28, -32603, 14944849920),
    (4305, 46, 28, -18287, 10378368000),
    (4306, 47, 28, -269, 1383782400),
    (4307, 48, 28, 65971, 217945728000),
    (4308, 49, 28, 3529, 1729728000),
    (4309, 50, 28, 131, 74131200),
    (4310, 51, 28, -3889, 1132185600),
    (4311, 52, 28, -10733, 7783776000),
    (4312, 53, 28, 1927, 576576000),
    (4313, 54, 28, 187, 94348800),
    (4314, 55, 28, -27473, 7264857600),
    (4315, 56, 28, -12959, 20756736000),
    (4316, 57, 28, 733, 415134720),
    (4317, 58, 28, 1373, 3632428800),
    (4318, 59, 28, -2777, 2767564800),
    (4319, 60, 28, 563, 199584000),
    (4320, 61, 28, -9413, 2421619200),
    (4321, 62, 28, -493, 48432384),
    (4322, 63, 28, -1643, 4151347200),
    (4323, 64, 28, -313297, 43589145600),
    (4324, 65, 28, -72649, 41513472000),
    (4325, 66, 28, 36359, 3113510400),
    (4326, 67, 28, -149033, 29059430400),
    (4327, 68, 28, 536797, 72648576000),
    (4328, 69, 28, -8719, 7264857600),
    (4329, 70, 28, 8893, 12454041600),
    (4330, 71, 28, 12547, 1257984000),
    (4331, 42, 29, 5821, 217945728000),
    (4332, 43, 29, -8597, 62270208000),
    (4333, 44, 29, -91111, 93405312000),
    (4334, 45, 29, -46117, 24908083200),
    (4335, 46, 29, -47213, 31135104000),
    (4336, 47, 29, -4547, 8895744000),
    (4337, 48, 29, -541, 31135104000),
    (4338, 49, 29, 2839, 10378368000),
    (4339, 50, 29, -111281, 74724249600),
    (4340, 51, 29, -88981, 18681062400),
    (4341, 52, 29, -991, 296524800),
    (4342, 53, 29, 491, 31135104000),
    (4343, 54, 29, 163, 475517952),
    (4344, 55, 29, -1681, 958003200),
    (4345, 56, 29, -17, 1197504000),
    (4346, 57, 29, 27799, 87178291200),
    (4347, 58, 29, -4319, 5337446400),
    (4348, 59, 29, -1367, 1132185600),
    (4349, 60, 29, 22331, 31135104000),
    (4350, 61, 29, 2861, 43589145600),
    (4351, 62, 29, 103, 566092800),
    (4352, 63, 29, -229813, 130767436800),
    (4353, 64, 29, -97849, 12454041600),
    (4354, 65, 29, -109757, 15567552000),
    (4355, 66, 29, 713, 1245404160),
    (4356, 67, 29, -22553, 6706022400),
    (4357, 68, 29, 8257, 6227020800),
    (4358, 69, 29, 10291, 37362124800),
    (4359, 70, 29, 4387, 3736212480),
    (4360, 71, 29, 44203, 15567552000),
    (4361, 42, 30, 1241, 4358914560),
    (4362, 43, 30, 17219, 12454041600),
    (4363, 44, 30, 613, 276756480),
    (4364, 45, 30, 5591, 4981616640),
    (4365, 46, 30, -19, 115315200),
    (4366, 47, 30, -47, 4151347200),
    (4367, 48, 30, 1427, 5748019200),
    (4368, 49, 30, 229, 98841600),
    (4369, 50, 30, 2033, 830269440),
    (4370, 51, 30, -277, 27675648),
    (4371, 52, 30, -12167, 691891200),
    (4372, 53, 30, -17161, 2075673600),
    (4373, 54, 30, -347, 51891840),
    (4374, 55, 30, -2939, 69189120),
    (4375, 56, 30, -1717, 31449600),
    (4376, 57, 30, 1, 2156544),
    (4377, 58, 30, -271, 31933440),
    (4378, 59, 30, -8867, 377395200),
    (4379, 60, 30, -1787, 98841600),
    (4380, 61, 30, -977, 34594560),
    (4381, 62, 30, -1457, 18532800),
    (4382, 63, 30, 31, 21288960),
    (4383, 64, 30, -521, 41513472),
    (4384, 65, 30, -12329, 415134720),
    (4385, 66, 30, -31841, 2075673600),
    (4386, 67, 30, -89, 1572480),
    (4387, 68, 30, -70963, 518918400),
    (4388, 69, 30, -6301, 415134720),
    (4389, 70, 30, -5483, 296524800),
    (4390, 71, 30, -2657, 62899200),
    (4391, 42, 31, 7741, 5448643200),
    (4392, 43, 31, 43493, 6227020800),
    (4393, 44, 31, 6313, 518918400),
    (4394, 45, 31, 5611, 622702080),
    (4395, 46, 31, 1669, 518918400),
    (4396, 47, 31, 13501, 7472424960),
    (4397, 48, 31, 11447, 8172964800),
    (4398, 49, 31, 16217, 1037836800),
    (4399, 50, 31, 3979, 103783680),
    (4400, 51, 31, 479, 32432400),
    (4401, 52, 31, -16949, 1037836800),
    (4402, 53, 31, -73907, 10059033600),
    (4403, 54, 31, 139, 25945920),
    (4404, 55, 31, -453, 6406400),
    (4405, 56, 31, -8467, 74131200),
    (4406, 57, 31, 13883, 1245404160),
    (4407, 58, 31, 883, 389188800),
    (4408, 59, 31, -14797, 389188800),
    (4409, 60, 31, -733919, 21794572800),
    (4410, 61, 31, -15419, 259459200),
    (4411, 62, 31, -153899, 778377600),
    (4412, 63, 31, 3587, 155675520),
    (4413, 64, 31, 12379, 778377600),
    (4414, 65, 31, -6841, 311351040),
    (4415, 66, 31, -9467, 6538371840),
    (4416, 67, 31, -349, 3706560),
    (4417, 68, 31, -423011, 1556755200),
    (4418, 69, 31, -6043, 172972800),
    (4419, 70, 31, -17671, 389188800),
    (4420, 71, 31, -1609, 20756736),
    (4421, 42, 32, 16187, 7264857600),
    (4422, 43, 32, 14269, 1383782400),
    (4423, 44, 32, 871, 53222400),
    (4424, 45, 32, 15979, 1660538880),
    (4425, 46, 32, 11351, 12454041600),
    (4426, 47, 32, 361, 958003200),
    (4427, 48, 32, 10321, 8072064000),
    (4428, 49, 32, 19447, 691891200),
    (4429, 50, 32, 52141, 691891200),
    (4430, 51, 32, 22717, 415134720),
    (4431, 52, 32, 227453, 29059430400),
    (4432, 53, 32, 1679, 389188800),
    (4433, 54, 32, 73, 1663200),
    (4434, 55, 32, 1861, 691891200),
    (4435, 56, 32, -94607, 1614412800),
    (4436, 57, 32, 106369, 4151347200),
    (4437, 58, 32, 39037, 1037836800),
    (4438, 59, 32, -16967, 5811886080),
    (4439, 60, 32, -357827, 29059430400),
    (4440, 61, 32, -2963, 172972800),
    (4441, 62, 32, -1019839, 7264857600),
    (4442, 63, 32, 87313, 2075673600),
    (4443, 64, 32, 107923, 2075673600),
    (4444, 65, 32, 149381, 14529715200),
    (4445, 66, 32, 428347, 17435658240),
    (4446, 67, 32, -743, 98841600),
    (4447, 68, 32, -172019, 1320883200),
    (4448, 69, 32, -1, 52800),
    (4449, 70, 32, -3259, 107627520),
    (4450, 71, 32, -18419, 691891200),
    (4451, 42, 33, 179, 138996000),
    (4452, 43, 33, 1519, 296524800),
    (4453, 44, 33, 9551, 1729728000),
    (4454, 45, 33, -25969, 14944849920),
    (4455, 46, 33, -299707, 46702656000),
    (4456, 47, 33, -35207, 10378368000),
    (4457, 48, 33, -13303, 54486432000),
    (4458, 49, 33, 1891, 108108000),
    (4459, 50, 33, 4219, 98841600),
    (4460, 51, 33, 1048213, 43589145600),
    (4461, 52, 33, -2971, 864864000),
    (4462, 53, 33, -29, 85536000),
    (4463, 54, 33, 1, 25740),
    (4464, 55, 33, 10183, 296524800),
    (4465, 56, 33, -451, 206388000),
    (4466, 57, 33, 4691, 259459200),
    (4467, 58, 33, 220313, 7264857600),
    (4468, 59, 33, 97879, 9686476800),
    (4469, 60, 33, 7703, 3891888000),
    (4470, 61, 33, 6463, 302702400),
    (4471, 62, 33, -55, 2935296),
    (4472, 63, 33, 41819, 2075673600),
    (4473, 64, 33, 397819, 43589145600),
    (4474, 65, 33, -67189, 3027024000),
    (4475, 66, 33, 97, 311351040),
    (4476, 67, 33, 749, 26956800),
    (4477, 68, 33, -1117, 127008000),
    (4478, 69, 33, 6791, 2421619200),
    (4479, 70, 33, -83651, 43589145600),
    (4480, 71, 33, 106991, 18162144000),
    (4481, 42, 34, 9277, 7264857600),
    (4482, 43, 34, 14981, 2075673600),
    (4483, 44, 34, 10579, 691891200),
    (4484, 45, 34, 1427, 94348800),
    (4485, 46, 34, 223, 31449600),
    (4486, 47, 34, 134599, 87178291200),
    (4487, 48, 34, 4117, 12454041600),
    (4488, 49, 34, 713, 43243200),
    (4489, 50, 34, 239, 4324320),
    (4490, 51, 34, 809, 14414400),
    (4491, 52, 34, 2377, 172972800),
    (4492, 53, 34, -3889, 838252800),
    (4493, 54, 34, 9, 320320),
    (4494, 55, 34, 23, 1921920),
    (4495, 56, 34, -1543, 34594560),
    (4496, 57, 34, 1591, 103783680),
    (4497, 58, 34, 7573, 259459200),
    (4498, 59, 34, 23, 14826240),
    (4499, 60, 34, -63113, 3632428800),
    (4500, 61, 34, -191, 43243200),
    (4501, 62, 34, -11093, 129729600),
    (4502, 63, 34, 7327, 207567360),
    (4503, 64, 34, 35071, 518918400),
    (4504, 65, 34, 461, 20756736),
    (4505, 66, 34, -4159, 444787200),
    (4506, 67, 34, 211, 21621600),
    (4507, 68, 34, -31373, 259459200),
    (4508, 69, 34, -1987, 172972800),
    (4509, 70, 34, -13757, 518918400),
    (4510, 71, 34, -1663, 34594560),
    (4511, 42, 35, 311, 111767040),
    (4512, 43, 35, 7769, 518918400),
    (4513, 44, 35, 17279, 576576000),
    (4514, 45, 35, 22601, 830269440),
    (4515, 46, 35, 10321, 990662400),
    (4516, 47, 35, 1459, 1779148800),
    (4517, 48, 35, -4721, 108972864000),
    (4518, 49, 35, 161, 4118400),
    (4519, 50, 35, 2537, 19219200),
    (4520, 51, 35, 13709, 94348800),
    (4521, 52, 35, 16739, 296524800),
    (4522, 53, 35, 38359, 8717829120),
    (4523, 54, 35, 199, 2162160),
    (4524, 55, 35, 8527, 69189120),
    (4525, 56, 35, 29, 3386880),
    (4526, 57, 35, 953, 23587200),
    (4527, 58, 35, 23833, 259459200),
    (4528, 59, 35, 749299, 14529715200),
    (4529, 60, 35, -2201, 1614412800),
    (4530, 61, 35, 2419, 43243200),
    (4531, 62, 35, -27733, 726485760),
    (4532, 63, 35, 583, 7257600),
    (4533, 64, 35, 2203, 13478400),
    (4534, 65, 35, 148711, 1816214400),
    (4535, 66, 35, 49223, 8717829120),
    (4536, 67, 35, 48491, 345945600),
    (4537, 68, 35, -2851, 1452971520),
    (4538, 69, 35, 5, 864864),
    (4539, 70, 35, -51049, 2421619200),
    (4540, 71, 35, -67, 3669120),
    (4541, 42, 36, 17, 39626496),
    (4542, 43, 36, 41, 17740800),
    (4543, 44, 36, 379, 83026944),
    (4544, 45, 36, 3859, 958003200),
    (4545, 46, 36, 2393, 1556755200),
    (4546, 47, 36, 277, 968647680),
    (4547, 48, 36, 39857, 261534873600),
    (4548, 49, 36, 5041, 1037836800),
    (4549, 50, 36, 211, 15375360),
    (4550, 51, 36, 8257, 1037836800),
    (4551, 52, 36, -827, 148262400),
    (4552, 53, 36, -39719, 7264857600),
    (4553, 54, 36, 41, 12972960),
    (4554, 55, 36, -3049, 172972800),
    (4555, 56, 36, -6329, 172972800),
    (4556, 57, 36, 103, 27675648),
    (4557, 58, 36, 1607, 622702080),
    (4558, 59, 36, -22921, 2075673600),
    (4559, 60, 36, -13439, 1037836800),
    (4560, 61, 36, -757, 51891840),
    (4561, 62, 36, -191, 3326400),
    (4562, 63, 36, 1207, 138378240),
    (4563, 64, 36, 14563, 1556755200),
    (4564, 65, 36, -10303, 1037836800),
    (4565, 66, 36, -2407, 220147200),
    (4566, 67, 36, -3233, 129729600),
    (4567, 68, 36, -233, 2471040),
    (4568, 69, 36, -409, 41513472),
    (4569, 70, 36, -2227, 148262400),
    (4570, 71, 36, -33139, 1037836800),
    (4571, 42, 37, 449, 302702400),
    (4572, 43, 37, 1541, 197683200),
    (4573, 44, 37, 8753, 576576000),
    (4574, 45, 37, 139, 10378368),
    (4575, 46, 37, 227, 44029440),
    (4576, 47, 37, 20873, 24908083200),
    (4577, 48, 37, 61, 172972800),
    (4578, 49, 37, 4463, 230630400),
    (4579, 50, 37, 10559, 172972800),
    (4580, 51, 37, 30539, 518918400),
    (4581, 52, 37, 1621, 107627520),
    (4582, 53, 37, -179183, 87178291200),
    (4583, 54, 37, 383, 10810800),
    (4584, 55, 37, 709, 31449600),
    (4585, 56, 37, -7741, 220147200),
    (4586, 57, 37, 731, 39536640),
    (4587, 58, 37, 3607, 103783680),
    (4588, 59, 37, 607, 94348800),
    (4589, 60, 37, -36479, 2905943040),
    (4590, 61, 37, 1, 628992),
    (4591, 62, 37, -40751, 518918400),
    (4592, 63, 37, 3221, 86486400),
    (4593, 64, 37, 34519, 518918400),
    (4594, 65, 37, 158689, 7264857600),
    (4595, 66, 37, -10601, 4358914560),
    (4596, 67, 37, 613, 28828800),
    (4597, 68, 37, -683141, 7264857600),
    (4598, 69, 37, -3083, 345945600),
    (4599, 70, 37, -3977, 172972800),
    (4600, 71, 37, -84523, 2421619200),
    (4601, 42, 38, 2143, 1452971520),
    (4602, 43, 38, 150779, 20756736000),
    (4603, 44, 38, 26569, 2075673600),
    (4604, 45, 38, 20785, 2324754432),
    (4605, 46, 38, 8807, 12454041600),
    (4606, 47, 38, -6961, 4151347200),
    (4607, 48, 38, -30487, 72648576000),
    (4608, 49, 38, 24053, 1153152000),
    (4609, 50, 38, 134947, 2075673600),
    (4610, 51, 38, 184963, 2905943040),
    (4611, 52, 38, 543941, 29059430400),
    (4612, 53, 38, -53, 115315200),
    (4613, 54, 38, 2663, 51891840),
    (4614, 55, 38, 326707, 4843238400),
    (4615, 56, 38, 3271, 372556800),
    (4616, 57, 38, 30647, 1383782400),
    (4617, 58, 38, 2357, 49420800),
    (4618, 59, 38, 21431, 830269440),
    (4619, 60, 38, 8167, 9686476800),
    (4620, 61, 38, 6379, 172972800),
    (4621, 62, 38, -163, 29652480),
    (4622, 63, 38, 77183, 2075673600),
    (4623, 64, 38, 924773, 14529715200),
    (4624, 65, 38, 22367, 1320883200),
    (4625, 66, 38, -809, 149022720),
    (4626, 67, 38, 4643, 64576512),
    (4627, 68, 38, 83287, 14529715200),
    (4628, 69, 38, 1693, 259459200),
    (4629, 70, 38, -17473, 2905943040),
    (4630, 71, 38, -3203, 691891200),
    (4631, 42, 39, 6719, 7264857600),
    (4632, 43, 39, 13549, 3113510400),
    (4633, 44, 39, 14813, 2075673600),
    (4634, 45, 39, 30269, 6227020800),
    (4635, 46, 39, 5561, 3113510400),
    (4636, 47, 39, 94573, 65383718400),
    (4637, 48, 39, 19499, 17435658240),
    (4638, 49, 39, 1181, 115315200),
    (4639, 50, 39, 505, 20756736),
    (4640, 51, 39, 79, 7862400),
    (4641, 52, 39, -577, 94348800),
    (4642, 53, 39, -34891, 130767436800),
    (4643, 54, 39, 17, 3991680),
    (4644, 55, 39, -13, 316800),
    (4645, 56, 39, -32717, 518918400),
    (4646, 57, 39, 9259, 1245404160),
    (4647, 58, 39, 601, 259459200),
    (4648, 59, 39, -8003, 389188800),
    (4649, 60, 39, -354769, 21794572800),
    (4650, 61, 39, -4801, 129729600),
    (4651, 62, 39, -46433, 389188800),
    (4652, 63, 39, 883, 62270208),
    (4653, 64, 39, 131, 12355200),
    (4654, 65, 39, -14447, 3113510400),
    (4655, 66, 39, 754673, 65383718400),
    (4656, 67, 39, -6911, 129729600),
    (4657, 68, 39, -220771, 1556755200),
    (4658, 69, 39, -773, 37065600),
    (4659, 70, 39, -39833, 1556755200),
    (4660, 71, 39, -4061, 115315200),
    (4661, 42, 40, 39827, 14529715200),
    (4662, 43, 40, 53, 4492800),
    (4663, 44, 40, 56087, 3459456000),
    (4664, 45, 40, 617, 110702592),
    (4665, 46, 40, -10799, 3353011200),
    (4666, 47, 40, -4919, 8302694400),
    (4667, 48, 40, 74309, 43589145600),
    (4668, 49, 40, 5989, 172972800),
    (4669, 50, 40, 4603, 53222400),
    (4670, 51, 40, 16351, 296524800),
    (4671, 52, 40, 209459, 29059430400),
    (4672, 53, 40, 105689, 9686476800),
    (4673, 54, 40, 9593, 172972800),
    (4674, 55, 40, 797, 98841600),
    (4675, 56, 40, -17243, 322882560),
    (4676, 57, 40, 2071, 64864800),
    (4677, 58, 40, 15559, 345945600),
    (4678, 59, 40, 349, 3228825600),
    (4679, 60, 40, -48107, 9686476800),
    (4680, 61, 40, -2917, 172972800),
    (4681, 62, 40, -369659, 2421619200),
    (4682, 63, 40, 8549, 188697600),
    (4683, 64, 40, 2011, 46126080),
    (4684, 65, 40, 5669, 807206400),
    (4685, 66, 40, 12781, 276756480),
    (4686, 67, 40, -2677, 691891200),
    (4687, 68, 40, -15073, 146764800),
    (4688, 69, 40, -6581, 345945600),
    (4689, 70, 40, -399029, 14529715200),
    (4690, 71, 40, -8297, 2421619200),
    (4691, 42, 41, 157951, 72648576000),
    (4692, 43, 41, 38099, 5189184000),
    (4693, 44, 41, 17357, 5189184000),
    (4694, 45, 41, -115469, 8717829120),
    (4695, 46, 41, -399013, 20756736000),
    (4696, 47, 41, -27679, 3113510400),
    (4697, 48, 41, -29123, 36324288000),
    (4698, 49, 41, 50881, 1729728000),
    (4699, 50, 41, 2515, 41513472),
    (4700, 51, 41, 92507, 7264857600),
    (4701, 52, 41, -467099, 18162144000),
    (4702, 53, 41, -94729, 31135104000),
    (4703, 54, 41, 17243, 259459200),
    (4704, 55, 41, 7013, 134534400),
    (4705, 56, 41, -59, 378378000),
    (4706, 57, 41, 9187, 296524800),
    (4707, 58, 41, 167053, 3632428800),
    (4708, 59, 41, 55603, 4843238400),
    (4709, 60, 41, 20441, 3027024000),
    (4710, 61, 41, 6221, 151351200),
    (4711, 62, 41, -3463, 201801600),
    (4712, 63, 41, 5233, 230630400),
    (4713, 64, 41, -4121, 139708800),
    (4714, 65, 41, -17489, 216216000),
    (4715, 66, 41, -10519, 1981324800),
    (4716, 67, 41, 78329, 2421619200),
    (4717, 68, 41, -2773, 550368000),
    (4718, 69, 41, 30517, 3632428800),
    (4719, 70, 41, 37151, 7264857600),
    (4720, 71, 41, 1513, 66528000)
])
