/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import algebra.ring.Field;
import algebra.ring.GCDRing;
import algebra.ring.Signed;
import cats.kernel.Eq;
import cats.kernel.Order;
import java.io.Serializable;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.Tuple2$mcJJ$sp;
import scala.collection.AbstractIterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.LazyList$;
import scala.collection.immutable.LazyList$Deferrer$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigDecimal$RoundingMode$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.ScalaNumericConversions;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import spire.algebra.IsReal;
import spire.algebra.NRoot;
import spire.algebra.Trig;
import spire.implicits$;
import spire.std.package$bigDecimal$;
import spire.syntax.LiteralIntAdditiveSemigroupOps$;

public final class package$ {
    public static final package$ MODULE$ = new package$();
    private static final int radix = 1000000000;

    public final byte abs(byte n) {
        return (byte)Math.abs(n);
    }

    public final short abs(short n) {
        return (short)Math.abs(n);
    }

    public final int abs(int n) {
        return Math.abs(n);
    }

    public final long abs(long n) {
        return Math.abs(n);
    }

    public final float abs(float n) {
        return Math.abs(n);
    }

    public final double abs(double n) {
        return Math.abs(n);
    }

    public final <A> A abs(A a, Signed<A> ev) {
        return ev.abs(a);
    }

    public final float ceil(float n) {
        return (float)Math.ceil(n);
    }

    public final double ceil(double n) {
        return Math.ceil(n);
    }

    public final BigDecimal ceil(BigDecimal n) {
        return n.setScale(0, BigDecimal$RoundingMode$.MODULE$.CEILING());
    }

    public final <A> A ceil(A a, IsReal<A> ev) {
        return ev.ceil(a);
    }

    public BigInt choose(long n, long k) {
        if (n < 0L || k < 0L) {
            throw new IllegalArgumentException(new StringBuilder(6).append("n=").append(n).append(", k=").append(k).toString());
        }
        if (k == 0L || k == n) {
            return scala.package$.MODULE$.BigInt().apply(1);
        }
        if (k > n) {
            return scala.package$.MODULE$.BigInt().apply(0);
        }
        if (n - k > k) {
            return this.choose(n, n - k);
        }
        return (n - k & 1L) == 1L ? this.loop$1(k + 1L, n - 1L, scala.package$.MODULE$.BigInt().apply(n)).$div(this.fact(n - k)) : this.loop$1(k + 1L, n, scala.package$.MODULE$.BigInt().apply(1)).$div(this.fact(n - k));
    }

    public BigInt fact(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException(Long.toString(n));
        }
        return n == 0L ? scala.package$.MODULE$.BigInt().apply(1) : ((n & 1L) == 1L ? this.loop$2(1L, n - 1L, scala.package$.MODULE$.BigInt().apply(n)) : this.loop$2(2L, n - 1L, scala.package$.MODULE$.BigInt().apply(n)));
    }

    public BigInt fib(long n) {
        int i;
        if (n < 0L) {
            throw new IllegalArgumentException(Long.toString(n));
        }
        for (i = 63; (n >>> i & 1L) == 0L && i >= 0; --i) {
        }
        return this.loop$3(scala.package$.MODULE$.BigInt().apply(1), scala.package$.MODULE$.BigInt().apply(0), i, n);
    }

    public final float floor(float n) {
        return (float)Math.floor(n);
    }

    public final double floor(double n) {
        return Math.floor(n);
    }

    public final BigDecimal floor(BigDecimal n) {
        return n.setScale(0, BigDecimal$RoundingMode$.MODULE$.FLOOR());
    }

    public final <A> A floor(A a, IsReal<A> ev) {
        return ev.floor(a);
    }

    public final float round(float a) {
        return Math.abs(a) >= 1.6777216E7f ? a : (float)Math.round(a);
    }

    public final double round(double a) {
        return Math.abs(a) >= 4.503599627370496E15 ? a : (double)Math.round(a);
    }

    public final BigDecimal round(BigDecimal a) {
        return a.setScale(0, BigDecimal$RoundingMode$.MODULE$.HALF_UP());
    }

    public final <A> A round(A a, IsReal<A> ev) {
        return ev.round(a);
    }

    public final double exp(double n) {
        return Math.exp(n);
    }

    public final BigDecimal exp(int k, int precision) {
        MathContext mc = new MathContext(precision + 1, RoundingMode.HALF_UP);
        int i = 2;
        BigInt num = scala.package$.MODULE$.BigInt().apply(2);
        BigInt denom = scala.package$.MODULE$.BigInt().apply(1);
        BigInt limit = scala.package$.MODULE$.BigInt().apply(10).pow(precision);
        while (denom.$less(limit)) {
            denom = denom.$times(BigInt$.MODULE$.int2bigInt(i));
            num = num.$times(BigInt$.MODULE$.int2bigInt(i)).$plus(scala.package$.MODULE$.BigInt().apply(1));
            ++i;
        }
        BigDecimal sum2 = scala.package$.MODULE$.BigDecimal().apply(num, mc).$div(scala.package$.MODULE$.BigDecimal().apply(denom, mc));
        return sum2.setScale(precision - sum2.precision() + sum2.scale(), BigDecimal$RoundingMode$.MODULE$.FLOOR()).pow(k);
    }

    public final BigDecimal exp(BigDecimal k) {
        if (k.signum() == 0) {
            return scala.package$.MODULE$.BigDecimal().apply(1);
        }
        if (k.signum() == -1) {
            return scala.package$.MODULE$.BigDecimal().apply(1).$div(this.exp(k.unary_$minus()));
        }
        BigDecimal whole = k.setScale(0, BigDecimal$RoundingMode$.MODULE$.FLOOR());
        if (whole.signum() > 1) {
            BigDecimal part = this.exp(scala.package$.MODULE$.BigDecimal().apply(1).$plus(k.$minus(whole).$div(whole)));
            return this.power$1(scala.package$.MODULE$.BigDecimal().apply(1), part, whole.toBigInt());
        }
        BigDecimal r = this.doit$1(k.mc().getPrecision() + 3, 1000, k);
        return new BigDecimal(r.bigDecimal(), k.mc());
    }

    public final <A> A exp(A a, Trig<A> t) {
        return t.exp(a);
    }

    public final double log(double n) {
        return Math.log(n);
    }

    public final double log(double n, int base) {
        return Math.log(n) / Math.log(base);
    }

    public final BigDecimal log(BigDecimal n) {
        int scale = n.mc().getPrecision();
        if (n.signum() < 1) {
            throw new IllegalArgumentException("argument <= 0");
        }
        Tuple2 tuple2 = this.rescale$1(n, 0);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        BigDecimal x = (BigDecimal)tuple2._1();
        int i = tuple2._2$mcI$sp();
        Tuple2<BigDecimal, Integer> tuple22 = new Tuple2<BigDecimal, Integer>(x, BoxesRunTime.boxToInteger(i));
        Tuple2<BigDecimal, Integer> tuple23 = tuple22;
        BigDecimal x2 = tuple23._1();
        int i2 = tuple23._2$mcI$sp();
        return this.ln$1(x2, scale).$times(scala.package$.MODULE$.BigDecimal().apply(2).pow(i2)).setScale(scale, BigDecimal$RoundingMode$.MODULE$.HALF_UP());
    }

    public BigDecimal log(BigDecimal n, int base) {
        return this.log(n).$div(this.log(scala.package$.MODULE$.BigDecimal().apply(base)));
    }

    public final <A> A log(A a, Trig<A> t) {
        return t.log(a);
    }

    public final <A> A log(A a, int base, Field<A> f, Trig<A> t) {
        return f.div(t.log(a), t.log(f.fromInt(base)));
    }

    public final BigDecimal pow(BigDecimal base, BigDecimal exponent) {
        return exponent.abs().$less$eq(BigDecimal$.MODULE$.int2bigDecimal(99999999)) && exponent.isWhole() ? base.pow(exponent.toInt()) : this.exp(this.log(base).$times(exponent));
    }

    public final BigInt pow(BigInt base, BigInt ex) {
        BigInt bigInt;
        if (ex.signum() < 0) {
            if (base.signum() == 0) {
                throw new ArithmeticException("zero can't be raised to negative power");
            }
            bigInt = BoxesRunTime.equalsNumObject(base, BoxesRunTime.boxToInteger(1)) ? base : (BoxesRunTime.equalsNumObject(base, BoxesRunTime.boxToInteger(-1)) ? (ex.testBit(0) ? scala.package$.MODULE$.BigInt().apply(1) : base) : scala.package$.MODULE$.BigInt().apply(0));
        } else {
            bigInt = ex.isValidInt() ? base.pow(ex.toInt()) : this.bigIntPow$1(scala.package$.MODULE$.BigInt().apply(1), base, ex);
        }
        return bigInt;
    }

    public final long pow(long base, long exponent) {
        long l;
        if (exponent < 0L) {
            if (base == 0L) {
                throw new ArithmeticException("zero can't be raised to negative power");
            }
            l = base == 1L ? 1L : (base == -1L ? ((exponent & 1L) == 0L ? -1L : 1L) : 0L);
        } else {
            l = this.longPow$1(1L, base, exponent);
        }
        return l;
    }

    public final double pow(double base, double exponent) {
        return Math.pow(base, exponent);
    }

    public final long gcd(long _x, long _y) {
        if (_x == 0L) {
            return Math.abs(_y);
        }
        if (_x == 1L) {
            return 1L;
        }
        if (_y == 0L) {
            return Math.abs(_x);
        }
        if (_y == 1L) {
            return 1L;
        }
        long x = _x;
        int xz = Long.numberOfTrailingZeros(x);
        x = Math.abs(x >> xz);
        long y = _y;
        int yz = Long.numberOfTrailingZeros(y);
        y = Math.abs(y >> yz);
        while (x != y) {
            if (x > y) {
                x -= y;
                x >>= Long.numberOfTrailingZeros(x);
                continue;
            }
            y -= x;
            y >>= Long.numberOfTrailingZeros(y);
        }
        return xz < yz ? x << xz : x << yz;
    }

    public final BigInt gcd(BigInt a, BigInt b) {
        return a.gcd(b);
    }

    public final <A> A gcd(A x, A y, Eq<A> evidence$1, GCDRing<A> ev) {
        return ev.gcd(x, y, evidence$1);
    }

    public final <A> A gcd(Seq<A> xs, Eq<A> evidence$2, GCDRing<A> ev) {
        return (A)xs.reduceLeft((Function2<Object, Object, Object> & Serializable)(a, b) -> ev.gcd(a, b, evidence$2));
    }

    public final <A> A gcd(A x, A y, A z, Seq<A> rest, Eq<A> evidence$3, GCDRing<A> ev) {
        return rest.isEmpty() ? ev.gcd(ev.gcd(x, y, evidence$3), z, evidence$3) : ev.gcd(ev.gcd(ev.gcd(x, y, evidence$3), z, evidence$3), this.gcd(rest, evidence$3, ev), evidence$3);
    }

    public final long lcm(long x, long y) {
        return x == 0L || y == 0L ? 0L : x / this.gcd(x, y) * y;
    }

    public final BigInt lcm(BigInt a, BigInt b) {
        return a.signum() == 0 || b.signum() == 0 ? BigInt$.MODULE$.int2bigInt(0) : a.$div(a.gcd(b)).$times(b);
    }

    public final <A> A lcm(A x, A y, Eq<A> evidence$4, GCDRing<A> ev) {
        return ev.lcm(x, y, evidence$4);
    }

    public Tuple2<Object, Object> equotmod(byte a, byte b) {
        int qt = a / b;
        int rt = a % b;
        return rt >= 0 ? new Tuple2<Object, Object>(BoxesRunTime.boxToByte((byte)qt), BoxesRunTime.boxToByte((byte)rt)) : (b > 0 ? new Tuple2<Byte, Byte>(BoxesRunTime.boxToByte((byte)(qt - 1)), BoxesRunTime.boxToByte((byte)(rt + b))) : new Tuple2<Byte, Byte>(BoxesRunTime.boxToByte((byte)(qt + 1)), BoxesRunTime.boxToByte((byte)(rt - b))));
    }

    public Tuple2<Object, Object> equotmod(short a, short b) {
        int qt = a / b;
        int rt = a % b;
        return rt >= 0 ? new Tuple2<Object, Object>(BoxesRunTime.boxToShort((short)qt), BoxesRunTime.boxToShort((short)rt)) : (b > 0 ? new Tuple2<Short, Short>(BoxesRunTime.boxToShort((short)(qt - 1)), BoxesRunTime.boxToShort((short)(rt + b))) : new Tuple2<Short, Short>(BoxesRunTime.boxToShort((short)(qt + 1)), BoxesRunTime.boxToShort((short)(rt - b))));
    }

    public Tuple2<Object, Object> equotmod(int a, int b) {
        int qt = a / b;
        int rt = a % b;
        return rt >= 0 ? new Tuple2$mcII$sp(qt, rt) : (b > 0 ? new Tuple2$mcII$sp(qt - 1, rt + b) : new Tuple2$mcII$sp(qt + 1, rt - b));
    }

    public Tuple2<Object, Object> equotmod(long a, long b) {
        long qt = a / b;
        long rt = a % b;
        return rt >= 0L ? new Tuple2$mcJJ$sp(qt, rt) : (b > 0L ? new Tuple2$mcJJ$sp(qt - 1L, rt + b) : new Tuple2$mcJJ$sp(qt + 1L, rt - b));
    }

    public Tuple2<BigInt, BigInt> equotmod(BigInt a, BigInt b) {
        Tuple2<BigInt, BigInt> tuple2 = a.$div$percent(b);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        BigInt qt = tuple2._1();
        BigInt rt = tuple2._2();
        Tuple2<BigInt, BigInt> tuple22 = new Tuple2<BigInt, BigInt>(qt, rt);
        Tuple2<BigInt, BigInt> tuple23 = tuple22;
        BigInt qt2 = tuple23._1();
        BigInt rt2 = tuple23._2();
        return rt2.signum() >= 0 ? new Tuple2<BigInt, BigInt>(qt2, rt2) : (b.signum() > 0 ? new Tuple2<BigInt, BigInt>(qt2.$minus(BigInt$.MODULE$.int2bigInt(1)), rt2.$plus(b)) : new Tuple2<BigInt, BigInt>(qt2.$plus(BigInt$.MODULE$.int2bigInt(1)), rt2.$minus(b)));
    }

    public Tuple2<BigInteger, BigInteger> equotmod(BigInteger a, BigInteger b) {
        BigInteger[] arr = a.divideAndRemainder(b);
        BigInteger qt = arr[0];
        BigInteger rt = arr[1];
        return rt.signum() >= 0 ? new Tuple2<BigInteger, BigInteger>(qt, rt) : (b.signum() > 0 ? new Tuple2<BigInteger, BigInteger>(qt.subtract(BigInteger.ONE), rt.add(b)) : new Tuple2<BigInteger, BigInteger>(qt.add(BigInteger.ONE), rt.subtract(b)));
    }

    public byte equot(byte a, byte b) {
        int qt = a / b;
        int rt = a % b;
        return rt >= 0 ? (byte)qt : (b > 0 ? (byte)(qt - 1) : (byte)(qt + 1));
    }

    public short equot(short a, short b) {
        int qt = a / b;
        int rt = a % b;
        return rt >= 0 ? (short)qt : (b > 0 ? (short)(qt - 1) : (short)(qt + 1));
    }

    public int equot(int a, int b) {
        int qt = a / b;
        int rt = a % b;
        return rt >= 0 ? qt : (b > 0 ? qt - 1 : qt + 1);
    }

    public long equot(long a, long b) {
        long qt = a / b;
        long rt = a % b;
        return rt >= 0L ? qt : (b > 0L ? qt - 1L : qt + 1L);
    }

    public BigInt equot(BigInt a, BigInt b) {
        Tuple2<BigInt, BigInt> tuple2 = a.$div$percent(b);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        BigInt qt = tuple2._1();
        BigInt rt = tuple2._2();
        Tuple2<BigInt, BigInt> tuple22 = new Tuple2<BigInt, BigInt>(qt, rt);
        Tuple2<BigInt, BigInt> tuple23 = tuple22;
        BigInt qt2 = tuple23._1();
        BigInt rt2 = tuple23._2();
        return rt2.signum() >= 0 ? qt2 : (b.signum() > 0 ? qt2.$minus(BigInt$.MODULE$.int2bigInt(1)) : qt2.$plus(BigInt$.MODULE$.int2bigInt(1)));
    }

    public BigInteger equot(BigInteger a, BigInteger b) {
        BigInteger[] arr = a.divideAndRemainder(b);
        BigInteger qt = arr[0];
        BigInteger rt = arr[1];
        return rt.signum() >= 0 ? qt : (b.signum() > 0 ? qt.subtract(BigInteger.ONE) : qt.add(BigInteger.ONE));
    }

    public byte emod(byte a, byte b) {
        int rt = a % b;
        return rt >= 0 ? (byte)rt : (b > 0 ? (byte)(rt + b) : (byte)(rt - b));
    }

    public short emod(short a, short b) {
        int rt = a % b;
        return rt >= 0 ? (short)rt : (b > 0 ? (short)(rt + b) : (short)(rt - b));
    }

    public int emod(int a, int b) {
        int rt = a % b;
        return rt >= 0 ? rt : (b > 0 ? rt + b : rt - b);
    }

    public long emod(long a, long b) {
        long rt = a % b;
        return rt >= 0L ? rt : (b > 0L ? rt + b : rt - b);
    }

    public BigInt emod(BigInt a, BigInt b) {
        BigInt rt = a.$percent(b);
        return rt.signum() >= 0 ? rt : (b.$greater(BigInt$.MODULE$.int2bigInt(0)) ? rt.$plus(b) : rt.$minus(b));
    }

    public BigInteger emod(BigInteger a, BigInteger b) {
        BigInteger rt = a.remainder(b);
        return rt.signum() >= 0 ? rt : (b.signum() > 0 ? rt.add(b) : rt.subtract(b));
    }

    public final byte min(byte x, byte y) {
        return (byte)Math.min(x, y);
    }

    public final short min(short x, short y) {
        return (short)Math.min(x, y);
    }

    public final int min(int x, int y) {
        return Math.min(x, y);
    }

    public final long min(long x, long y) {
        return Math.min(x, y);
    }

    public final float min(float x, float y) {
        return Math.min(x, y);
    }

    public final double min(double x, double y) {
        return Math.min(x, y);
    }

    public final <A> A min(A x, A y, Order<A> ev) {
        return ev.min(x, y);
    }

    public final byte max(byte x, byte y) {
        return (byte)Math.max(x, y);
    }

    public final short max(short x, short y) {
        return (short)Math.max(x, y);
    }

    public final int max(int x, int y) {
        return Math.max(x, y);
    }

    public final long max(long x, long y) {
        return Math.max(x, y);
    }

    public final float max(float x, float y) {
        return Math.max(x, y);
    }

    public final double max(double x, double y) {
        return Math.max(x, y);
    }

    public final <A> A max(A x, A y, Order<A> ev) {
        return ev.max(x, y);
    }

    public final double signum(double x) {
        return Math.signum(x);
    }

    public final float signum(float x) {
        return Math.signum(x);
    }

    public final <A> int signum(A a, Signed<A> ev) {
        return ev.signum(a);
    }

    public final double sqrt(double x) {
        return Math.sqrt(x);
    }

    public final <A> A sqrt(A a, NRoot<A> ev) {
        return ev.sqrt(a);
    }

    public final double e() {
        return Math.E;
    }

    public final <A> A e(Trig<A> ev) {
        return ev.e();
    }

    public final double pi() {
        return Math.PI;
    }

    public final <A> A pi(Trig<A> ev) {
        return ev.pi();
    }

    public final <A> A sin(A a, Trig<A> ev) {
        return ev.sin(a);
    }

    public final <A> A cos(A a, Trig<A> ev) {
        return ev.cos(a);
    }

    public final <A> A tan(A a, Trig<A> ev) {
        return ev.tan(a);
    }

    public final <A> A asin(A a, Trig<A> ev) {
        return ev.asin(a);
    }

    public final <A> A acos(A a, Trig<A> ev) {
        return ev.acos(a);
    }

    public final <A> A atan(A a, Trig<A> ev) {
        return ev.atan(a);
    }

    public final <A> A atan2(A y, A x, Trig<A> ev) {
        return ev.atan2(y, x);
    }

    public final <A> A sinh(A x, Trig<A> ev) {
        return ev.sinh(x);
    }

    public final <A> A cosh(A x, Trig<A> ev) {
        return ev.cosh(x);
    }

    public final <A> A tanh(A x, Trig<A> ev) {
        return ev.tanh(x);
    }

    public final double cbrt(double x) {
        return Math.cbrt(x);
    }

    public final double copySign(double m, double s) {
        return Math.copySign(m, s);
    }

    public final float copySign(float m, float s) {
        return Math.copySign(m, s);
    }

    public final double cosh(double x) {
        return Math.cosh(x);
    }

    public final double expm1(double x) {
        return Math.expm1(x);
    }

    public final int getExponent(double x) {
        return Math.getExponent(x);
    }

    public final int getExponent(float x) {
        return Math.getExponent(x);
    }

    public final double IEEEremainder(double x, double d) {
        return Math.IEEEremainder(x, d);
    }

    public final double log10(double x) {
        return Math.log10(x);
    }

    public final double log1p(double x) {
        return Math.log1p(x);
    }

    public final double nextAfter(double x, double y) {
        return Math.nextAfter(x, y);
    }

    public final float nextAfter(float x, float y) {
        return Math.nextAfter(x, (double)y);
    }

    public final double nextUp(double x) {
        return Math.nextUp(x);
    }

    public final float nextUp(float x) {
        return Math.nextUp(x);
    }

    public final double random() {
        return Math.random();
    }

    public final double rint(double x) {
        return Math.rint(x);
    }

    public final double scalb(double d, int s) {
        return Math.scalb(d, s);
    }

    public final float scalb(float d, int s) {
        return Math.scalb(d, s);
    }

    public final double toDegrees(double a) {
        return Math.toDegrees(a);
    }

    public final double toRadians(double a) {
        return Math.toRadians(a);
    }

    public final double ulp(double x) {
        return Math.ulp(x);
    }

    public final double ulp(float x) {
        return Math.ulp(x);
    }

    public final <A> A hypot(A x, A y, Field<A> f, NRoot<A> n, Order<A> o, Signed<A> s) {
        Object ax = package$.abs$1(x, o, f);
        Object ay = package$.abs$1(y, o, f);
        return (A)(BoxesRunTime.equals(x, f.zero()) ? ay : (BoxesRunTime.equals(y, f.zero()) ? ax : (o.gt(ax, ay) ? f.times(ax, n.sqrt(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), f.pow(f.div(y, x), 2), f))) : f.times(ay, n.sqrt(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), f.pow(f.div(x, y), 2), f))))));
    }

    private int intSearch(Function1<Object, Object> f) {
        int ceil = BoxesRunTime.unboxToInt(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 32).find(i -> !f.apply$mcZI$sp(1 << i)).getOrElse(() -> 33));
        return ceil == 0 ? 0 : BoxesRunTime.unboxToInt(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(ceil - 1), 0).by(-1).foldLeft(BoxesRunTime.boxToInteger(0), (x, i) -> {
            int y = x | 1 << i;
            return f.apply$mcZI$sp(y) ? y : x;
        }));
    }

    private LazyList<BigInt> decDiv(BigInt x, BigInt y, int r) {
        BigInt quot;
        BigInt expanded = x.$times(BigInt$.MODULE$.int2bigInt(r));
        BigInt rem = expanded.$minus((quot = expanded.$div(y)).$times(y));
        return BoxesRunTime.equalsNumObject(rem, BoxesRunTime.boxToInteger(0)) ? LazyList$Deferrer$.MODULE$.$hash$colon$colon$extension(LazyList$.MODULE$.toDeferrer((Function0<LazyList> & Serializable)() -> LazyList$.MODULE$.empty()), (Function0<BigInt> & Serializable)() -> quot) : LazyList$Deferrer$.MODULE$.$hash$colon$colon$extension(LazyList$.MODULE$.toDeferrer((Function0<LazyList> & Serializable)() -> MODULE$.decDiv(rem, y, r)), (Function0<BigInt> & Serializable)() -> quot);
    }

    private List<Object> digitize(BigInt x, int r, List<Object> prev) {
        while (!BoxesRunTime.equalsNumObject(x, BoxesRunTime.boxToInteger(0))) {
            BigInt bigInt = x.$div(BigInt$.MODULE$.int2bigInt(r));
            int n = x.$percent(BigInt$.MODULE$.int2bigInt(r)).toInt();
            prev = prev.$colon$colon(BoxesRunTime.boxToInteger(n));
            x = bigInt;
        }
        return prev;
    }

    private List<Object> digitize$default$3() {
        return scala.package$.MODULE$.Nil();
    }

    private BigInt undigitize(Seq<Object> digits, int r) {
        return digits.foldLeft(scala.package$.MODULE$.BigInt().apply(0), (Function2<BigInt, Object, BigInt> & Serializable)(x$4, x$5) -> package$.$anonfun$undigitize$1(r, x$4, BoxesRunTime.unboxToInt(x$5)));
    }

    private int radix() {
        return radix;
    }

    public BigDecimal nroot(BigDecimal a, int k, MathContext ctxt) {
        BigDecimal bigDecimal;
        if (k == 0) {
            bigDecimal = scala.package$.MODULE$.BigDecimal().apply(1);
        } else if (a.signum() < 0) {
            if (k % 2 == 0) {
                throw new ArithmeticException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%d-root of negative number"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(k)})));
            }
            bigDecimal = this.nroot(a.unary_$minus(), k, ctxt).unary_$minus();
        } else {
            BigInt underlying = scala.package$.MODULE$.BigInt().apply(a.bigDecimal().unscaledValue().toByteArray());
            BigInt scale = scala.package$.MODULE$.BigInt().apply(10).pow(a.scale());
            List<Object> intPart = this.digitize(underlying.$div(scale), this.radix(), this.digitize$default$3());
            Object fracPart = this.decDiv(underlying.$percent(scale), scale, this.radix()).map((Function1<BigInt, Object> & Serializable)x$6 -> BoxesRunTime.boxToInteger(x$6.toInt()));
            Object leader = intPart.size() % k == 0 ? LazyList$.MODULE$.empty() : LazyList$.MODULE$.fill(k - intPart.size() % k, () -> 0);
            LazyList digits = (LazyList)((IterableOps)((IterableOps)((AbstractIterable)leader).$plus$plus((IterableOnce)LazyList$.MODULE$.from((IterableOnce)intPart))).$plus$plus(fracPart)).$plus$plus(LazyList$.MODULE$.continually(() -> 0));
            BigInt radixPowK = scala.package$.MODULE$.BigInt().apply(this.radix()).pow(k);
            int maxSize = (ctxt.getPrecision() + 8) / 9 + 2;
            Tuple2 tuple2 = this.findRoot$1(digits, BigInt$.MODULE$.int2bigInt(0), BigInt$.MODULE$.int2bigInt(0), 1, k, radixPowK, maxSize);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int size = tuple2._1$mcI$sp();
            BigInt unscaled = (BigInt)tuple2._2();
            Tuple2<Integer, BigInt> tuple22 = new Tuple2<Integer, BigInt>(BoxesRunTime.boxToInteger(size), unscaled);
            Tuple2<Integer, BigInt> tuple23 = tuple22;
            int size2 = tuple23._1$mcI$sp();
            BigInt unscaled2 = tuple23._2();
            int newscale = (size2 - (intPart.size() + k - 1) / k) * 9;
            bigDecimal = scala.package$.MODULE$.BigDecimal().apply(unscaled2, newscale, ctxt);
        }
        return bigDecimal;
    }

    public boolean anyIsZero(Object n) {
        ScalaNumericConversions scalaNumericConversions;
        Object object = n;
        boolean bl = BoxesRunTime.equals(object, BoxesRunTime.boxToInteger(0)) ? true : (object instanceof ScalaNumericConversions ? (scalaNumericConversions = (ScalaNumericConversions)object).isValidInt() && scalaNumericConversions.toInt() == 0 : false);
        return bl;
    }

    public double anyToDouble(Object n) {
        double d;
        Object object = n;
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte(object);
            d = by;
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort(object);
            d = s;
        } else if (object instanceof Character) {
            char c = BoxesRunTime.unboxToChar(object);
            d = c;
        } else if (object instanceof Integer) {
            int n2 = BoxesRunTime.unboxToInt(object);
            d = n2;
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong(object);
            d = l;
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(object);
            d = f;
        } else if (object instanceof Double) {
            double d2;
            d = d2 = BoxesRunTime.unboxToDouble(object);
        } else if (object instanceof ScalaNumericConversions) {
            ScalaNumericConversions scalaNumericConversions = (ScalaNumericConversions)object;
            d = scalaNumericConversions.toDouble();
        } else {
            throw new UnsupportedOperationException(new StringBuilder(21).append(n).append(" is not a ScalaNumber").toString());
        }
        return d;
    }

    public long anyToLong(Object n) {
        long l;
        Object object = n;
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte(object);
            l = by;
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort(object);
            l = s;
        } else if (object instanceof Character) {
            char c = BoxesRunTime.unboxToChar(object);
            l = c;
        } else if (object instanceof Integer) {
            int n2 = BoxesRunTime.unboxToInt(object);
            l = n2;
        } else if (object instanceof Long) {
            long l2;
            l = l2 = BoxesRunTime.unboxToLong(object);
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(object);
            l = (long)f;
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(object);
            l = (long)d;
        } else if (object instanceof ScalaNumericConversions) {
            ScalaNumericConversions scalaNumericConversions = (ScalaNumericConversions)object;
            l = scalaNumericConversions.toLong();
        } else {
            throw new UnsupportedOperationException(new StringBuilder(21).append(n).append(" is not a ScalaNumber").toString());
        }
        return l;
    }

    public boolean anyIsWhole(Object n) {
        boolean bl;
        Object object = n;
        if (object instanceof Byte) {
            bl = true;
        } else if (object instanceof Short) {
            bl = true;
        } else if (object instanceof Character) {
            bl = true;
        } else if (object instanceof Integer) {
            bl = true;
        } else if (object instanceof Long) {
            bl = true;
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(object);
            bl = RichFloat$.MODULE$.isWhole$extension(Predef$.MODULE$.floatWrapper(f));
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(object);
            bl = RichDouble$.MODULE$.isWhole$extension(Predef$.MODULE$.doubleWrapper(d));
        } else if (object instanceof ScalaNumericConversions) {
            ScalaNumericConversions scalaNumericConversions = (ScalaNumericConversions)object;
            bl = scalaNumericConversions.isWhole();
        } else {
            throw new UnsupportedOperationException(new StringBuilder(21).append(n).append(" is not a ScalaNumber").toString());
        }
        return bl;
    }

    public boolean anyIsValidInt(Object n) {
        boolean bl;
        Object object = n;
        if (object instanceof Byte) {
            bl = true;
        } else if (object instanceof Short) {
            bl = true;
        } else if (object instanceof Character) {
            bl = true;
        } else if (object instanceof Integer) {
            bl = true;
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong(object);
            bl = RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(l));
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(object);
            bl = RichFloat$.MODULE$.isValidInt$extension(Predef$.MODULE$.floatWrapper(f));
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(object);
            bl = RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(d));
        } else if (object instanceof ScalaNumericConversions) {
            ScalaNumericConversions scalaNumericConversions = (ScalaNumericConversions)object;
            bl = scalaNumericConversions.isValidInt();
        } else {
            throw new UnsupportedOperationException(new StringBuilder(21).append(n).append(" is not a ScalaNumber").toString());
        }
        return bl;
    }

    public final double e$mDc$sp(Trig<Object> ev) {
        return ev.e$mcD$sp();
    }

    public final float e$mFc$sp(Trig<Object> ev) {
        return ev.e$mcF$sp();
    }

    public final double pi$mDc$sp(Trig<Object> ev) {
        return ev.pi$mcD$sp();
    }

    public final float pi$mFc$sp(Trig<Object> ev) {
        return ev.pi$mcF$sp();
    }

    public final double sin$mDc$sp(double a, Trig<Object> ev) {
        return ev.sin$mcD$sp(a);
    }

    public final float sin$mFc$sp(float a, Trig<Object> ev) {
        return ev.sin$mcF$sp(a);
    }

    public final double cos$mDc$sp(double a, Trig<Object> ev) {
        return ev.cos$mcD$sp(a);
    }

    public final float cos$mFc$sp(float a, Trig<Object> ev) {
        return ev.cos$mcF$sp(a);
    }

    public final double tan$mDc$sp(double a, Trig<Object> ev) {
        return ev.tan$mcD$sp(a);
    }

    public final float tan$mFc$sp(float a, Trig<Object> ev) {
        return ev.tan$mcF$sp(a);
    }

    public final double asin$mDc$sp(double a, Trig<Object> ev) {
        return ev.asin$mcD$sp(a);
    }

    public final float asin$mFc$sp(float a, Trig<Object> ev) {
        return ev.asin$mcF$sp(a);
    }

    public final double acos$mDc$sp(double a, Trig<Object> ev) {
        return ev.acos$mcD$sp(a);
    }

    public final float acos$mFc$sp(float a, Trig<Object> ev) {
        return ev.acos$mcF$sp(a);
    }

    public final double atan$mDc$sp(double a, Trig<Object> ev) {
        return ev.atan$mcD$sp(a);
    }

    public final float atan$mFc$sp(float a, Trig<Object> ev) {
        return ev.atan$mcF$sp(a);
    }

    public final double atan2$mDc$sp(double y, double x, Trig<Object> ev) {
        return ev.atan2$mcD$sp(y, x);
    }

    public final float atan2$mFc$sp(float y, float x, Trig<Object> ev) {
        return ev.atan2$mcF$sp(y, x);
    }

    public final double sinh$mDc$sp(double x, Trig<Object> ev) {
        return ev.sinh$mcD$sp(x);
    }

    public final float sinh$mFc$sp(float x, Trig<Object> ev) {
        return ev.sinh$mcF$sp(x);
    }

    public final double cosh$mDc$sp(double x, Trig<Object> ev) {
        return ev.cosh$mcD$sp(x);
    }

    public final float cosh$mFc$sp(float x, Trig<Object> ev) {
        return ev.cosh$mcF$sp(x);
    }

    public final double tanh$mDc$sp(double x, Trig<Object> ev) {
        return ev.tanh$mcD$sp(x);
    }

    public final float tanh$mFc$sp(float x, Trig<Object> ev) {
        return ev.tanh$mcF$sp(x);
    }

    public final double hypot$mDc$sp(double x, double y, Field<Object> f, NRoot<Object> n, Order<Object> o, Signed<Object> s) {
        double ax = package$.abs$2(x, o, f);
        double ay = package$.abs$2(y, o, f);
        return x == f.zero$mcD$sp() ? ay : (y == f.zero$mcD$sp() ? ax : (o.gt$mcD$sp(ax, ay) ? f.times$mcD$sp(ax, n.sqrt$mcD$sp(BoxesRunTime.unboxToDouble(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToDouble(f.pow$mcD$sp(f.div$mcD$sp(y, x), 2)), f)))) : f.times$mcD$sp(ay, n.sqrt$mcD$sp(BoxesRunTime.unboxToDouble(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToDouble(f.pow$mcD$sp(f.div$mcD$sp(x, y), 2)), f))))));
    }

    public final float hypot$mFc$sp(float x, float y, Field<Object> f, NRoot<Object> n, Order<Object> o, Signed<Object> s) {
        float ax = package$.abs$3(x, o, f);
        float ay = package$.abs$3(y, o, f);
        return x == f.zero$mcF$sp() ? ay : (y == f.zero$mcF$sp() ? ax : (o.gt$mcF$sp(ax, ay) ? f.times$mcF$sp(ax, n.sqrt$mcF$sp(BoxesRunTime.unboxToFloat(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToFloat(f.pow$mcF$sp(f.div$mcF$sp(y, x), 2)), f)))) : f.times$mcF$sp(ay, n.sqrt$mcF$sp(BoxesRunTime.unboxToFloat(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToFloat(f.pow$mcF$sp(f.div$mcF$sp(x, y), 2)), f))))));
    }

    private final BigInt loop$1(long lo, long hi, BigInt prod) {
        while (lo <= hi) {
            prod = scala.package$.MODULE$.BigInt().apply(lo).$times(scala.package$.MODULE$.BigInt().apply(hi)).$times(prod);
            --hi;
            ++lo;
        }
        return prod;
    }

    private final BigInt loop$2(long lo, long hi, BigInt prod) {
        while (lo <= hi) {
            prod = scala.package$.MODULE$.BigInt().apply(lo).$times(scala.package$.MODULE$.BigInt().apply(hi)).$times(prod);
            --hi;
            ++lo;
        }
        return prod;
    }

    private final BigInt loop$3(BigInt a, BigInt b, int i, long n$1) {
        while (true) {
            BigInt c = a.$plus(b);
            if (i < 0) break;
            if ((n$1 >>> i & 1L) == 1L) {
                BigInt bigInt = a.$plus(c).$times(b);
                --i;
                b = b.$times(b).$plus(c.$times(c));
                a = bigInt;
                continue;
            }
            BigInt bigInt = a.$times(a).$plus(b.$times(b));
            --i;
            b = a.$plus(c).$times(b);
            a = bigInt;
        }
        return b;
    }

    private final BigDecimal power$1(BigDecimal result2, BigDecimal base, BigInt exponent) {
        while (exponent.signum() != 0) {
            if (exponent.testBit(0)) {
                BigDecimal bigDecimal = result2.$times(base);
                exponent = exponent.$greater$greater(1);
                base = base.$times(base);
                result2 = bigDecimal;
                continue;
            }
            exponent = exponent.$greater$greater(1);
            base = base.$times(base);
        }
        return result2;
    }

    private final BigDecimal doit$1(int precision, int leeway, BigDecimal k$1) {
        BigDecimal sum2;
        while (true) {
            MathContext mc = new MathContext(precision, RoundingMode.HALF_UP);
            int i = 2;
            sum2 = scala.package$.MODULE$.BigDecimal().apply(1, mc).$plus(k$1);
            BigDecimal factorial = scala.package$.MODULE$.BigDecimal().apply(2, mc);
            BigDecimal kpow = k$1.$times(k$1);
            BigDecimal term = kpow.$div(factorial).setScale(precision, BigDecimal$RoundingMode$.MODULE$.HALF_UP());
            while (term.signum() != 0 && i < leeway) {
                sum2 = sum2.$plus(term);
                factorial = factorial.$times(BigDecimal$.MODULE$.int2bigDecimal(++i));
                kpow = kpow.$times(k$1);
                term = kpow.$div(factorial).setScale(precision, BigDecimal$RoundingMode$.MODULE$.HALF_UP());
            }
            if (i <= leeway) break;
            leeway *= 1000;
            precision += 3;
        }
        return sum2.setScale(k$1.mc().getPrecision() - sum2.precision() + sum2.scale(), BigDecimal$RoundingMode$.MODULE$.FLOOR());
    }

    private final BigDecimal loop$4(BigDecimal x, BigDecimal n$2, BigDecimal limit$1) {
        BigDecimal xp;
        BigDecimal term;
        while ((term = (xp = this.exp(x)).$minus(n$2).$div(xp)).$greater(limit$1)) {
            x = x.$minus(term);
        }
        return x.$minus(term);
    }

    private final BigDecimal ln$1(BigDecimal n, int scale$1) {
        int scale2 = scale$1 + 1;
        BigDecimal limit = scala.package$.MODULE$.BigDecimal().apply(5).$times(scala.package$.MODULE$.BigDecimal().apply(10).pow(-scale2));
        return this.loop$4(n.setScale(scale2, BigDecimal$RoundingMode$.MODULE$.HALF_UP()), n, limit).setScale(scale$1, BigDecimal$RoundingMode$.MODULE$.HALF_UP());
    }

    private final Tuple2 rescale$1(BigDecimal x, int n) {
        while (!x.$less(BigDecimal$.MODULE$.int2bigDecimal(64))) {
            ++n;
            x = ((NRoot)((Object)package$bigDecimal$.MODULE$.BigDecimalAlgebra())).sqrt(x);
        }
        return new Tuple2<BigDecimal, Integer>(x, BoxesRunTime.boxToInteger(n));
    }

    private final BigInt bigIntPow$1(BigInt t, BigInt b, BigInt e) {
        while (e.signum() != 0) {
            if (e.testBit(0)) {
                BigInt bigInt = t.$times(b);
                e = e.$greater$greater(1);
                b = b.$times(b);
                t = bigInt;
                continue;
            }
            e = e.$greater$greater(1);
            b = b.$times(b);
        }
        return t;
    }

    private final long longPow$1(long t, long b, long e) {
        while (e != 0L) {
            if ((e & 1L) == 1L) {
                long l = t * b;
                e >>= (int)1L;
                b *= b;
                t = l;
                continue;
            }
            e >>= (int)1L;
            b *= b;
        }
        return t;
    }

    private static final Object abs$1(Object n, Order o$1, Field f$1) {
        return o$1.lt(n, f$1.zero()) ? f$1.negate(n) : n;
    }

    public static final /* synthetic */ BigInt $anonfun$undigitize$1(int r$2, BigInt x$4, int x$5) {
        return x$4.$times(BigInt$.MODULE$.int2bigInt(r$2)).$plus(BigInt$.MODULE$.int2bigInt(x$5));
    }

    private final Tuple2 findRoot$1(LazyList digits, BigInt y, BigInt r, int i, int k$2, BigInt radixPowK$1, int maxSize$1) {
        BigInt ny;
        while (true) {
            BigInt y_ = y.$times(BigInt$.MODULE$.int2bigInt(this.radix()));
            BigInt a = this.undigitize((Seq<Object>)((LazyList)digits).take(k$2), this.radix());
            BigInt target = radixPowK$1.$times(r).$plus(a).$plus(y_.pow(k$2));
            int b2 = this.intSearch(b -> y_.$plus(BigInt$.MODULE$.int2bigInt(b)).pow(k$2).$less$eq(target));
            ny = y_.$plus(BigInt$.MODULE$.int2bigInt(b2));
            if (i == maxSize$1) break;
            BigInt nr = target.$minus(ny.pow(k$2));
            ++i;
            r = nr;
            y = ny;
            digits = ((LazyList)digits).drop(k$2);
        }
        return new Tuple2<Integer, BigInt>(BoxesRunTime.boxToInteger(i), ny);
    }

    private static final double abs$2(double n, Order o$2, Field f$3) {
        return o$2.lt$mcD$sp(n, f$3.zero$mcD$sp()) ? f$3.negate$mcD$sp(n) : n;
    }

    private static final float abs$3(float n, Order o$3, Field f$4) {
        return o$3.lt$mcF$sp(n, f$4.zero$mcF$sp()) ? f$4.negate$mcF$sp(n) : n;
    }

    private package$() {
    }
}

