/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichFloat;
import scala.runtime.ScalaRunTime$;
import spire.math.package$;

public final class FastComplex$ {
    public static final FastComplex$ MODULE$ = new FastComplex$();
    private static final long i = MODULE$.encode(0.0f, 1.0f);
    private static final long one = MODULE$.encode(1.0f, 0.0f);
    private static final long zero = MODULE$.encode(0.0f, 0.0f);

    public final long apply(float real, float imag) {
        return this.encode(real, imag);
    }

    public final long apply(double real, double imag) {
        return this.encode((float)real, (float)imag);
    }

    public final int bits(float n) {
        return Float.floatToIntBits(n);
    }

    public final float bits(int n) {
        return Float.intBitsToFloat(n);
    }

    public final float real(long d) {
        return this.bits((int)(d & 0xFFFFFFFFFFFFFFFFL));
    }

    public final float imag(long d) {
        return this.bits((int)(d >>> 32));
    }

    public final long i() {
        return i;
    }

    public final long one() {
        return one;
    }

    public final long zero() {
        return zero;
    }

    public final long encode(float real, float imag) {
        return (long)this.bits(real) & 0xFFFFFFFFL | ((long)this.bits(imag) & 0xFFFFFFFFL) << 32;
    }

    public final long polar(float magnitude, float angle) {
        return this.encode(magnitude * (float)Math.cos(angle), magnitude * (float)Math.sin(angle));
    }

    public final Tuple2<Object, Object> decode(long d) {
        return new Tuple2<Object, Object>(BoxesRunTime.boxToFloat(this.real(d)), BoxesRunTime.boxToFloat(this.imag(d)));
    }

    public final String toRepr(long d) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("FastComplex(%s -> %s)"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(d), this.decode(d)}));
    }

    public final float abs(long d) {
        float re = this.real(d);
        float im = this.imag(d);
        return (float)Math.sqrt(re * re + im * im);
    }

    public final float angle(long d) {
        return (float)Math.atan2(this.imag(d), this.real(d));
    }

    public final long conjugate(long d) {
        return this.encode(this.real(d), -this.imag(d));
    }

    public final boolean isWhole(long d) {
        return this.real(d) % 1.0f == 0.0f && this.imag(d) % 1.0f == 0.0f;
    }

    public final int signum(long d) {
        return new RichFloat(Predef$.MODULE$.floatWrapper(this.real(d))).compare(BoxesRunTime.boxToFloat(0.0f));
    }

    public final long complexSignum(long d) {
        float m = this.abs(d);
        return m == 0.0f ? this.zero() : this.divide(d, this.encode(m, 0.0f));
    }

    public final long negate(long a) {
        return this.encode(-this.real(a), -this.imag(a));
    }

    public final long add(long a, long b) {
        return this.encode(this.real(a) + this.real(b), this.imag(a) + this.imag(b));
    }

    public final long subtract(long a, long b) {
        return this.encode(this.real(a) - this.real(b), this.imag(a) - this.imag(b));
    }

    public final long multiply(long a, long b) {
        float re_a = this.real(a);
        float im_a = this.imag(a);
        float re_b = this.real(b);
        float im_b = this.imag(b);
        return this.encode(re_a * re_b - im_a * im_b, im_a * re_b + re_a * im_b);
    }

    public final long divide(long a, long b) {
        long l;
        float abs_im_b;
        float re_a = this.real(a);
        float im_a = this.imag(a);
        float re_b = this.real(b);
        float im_b = this.imag(b);
        float abs_re_b = Math.abs(re_b);
        if (abs_re_b >= (abs_im_b = Math.abs(im_b))) {
            if (abs_re_b == 0.0f) {
                throw new ArithmeticException("/0");
            }
            float ratio = im_b / re_b;
            float denom = re_b + im_b * ratio;
            l = this.encode((re_a + im_a * ratio) / denom, (im_a - re_a * ratio) / denom);
        } else {
            if (abs_im_b == 0.0f) {
                throw new ArithmeticException("/0");
            }
            float ratio = re_b / im_b;
            float denom = re_b * ratio + im_b;
            l = this.encode((re_a * ratio + im_a) / denom, (im_a * ratio - re_a) / denom);
        }
        return l;
    }

    public final long pow(long a, long b) {
        long l;
        if (b == this.zero()) {
            l = this.encode(1.0f, 0.0f);
        } else if (a == this.zero()) {
            if (this.imag(b) != 0.0f || this.real(b) < 0.0f) {
                throw new Exception("raising 0 to negative/complex power");
            }
            l = this.zero();
        } else if (this.imag(b) != 0.0f) {
            float im_b = this.imag(b);
            float re_b = this.real(b);
            float len = (float)(Math.pow(this.abs(a), re_b) / package$.MODULE$.exp(this.angle(a) * im_b));
            float phase = (float)((double)(this.angle(a) * re_b) + package$.MODULE$.log(this.abs(a)) * (double)im_b);
            l = this.polar(len, phase);
        } else {
            float len = (float)Math.pow(this.abs(a), this.real(b));
            float phase = this.angle(a) * this.real(b);
            l = this.polar(len, phase);
        }
        return l;
    }

    private FastComplex$() {
    }
}

