/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.Axis;
import org.knowm.xchart.internal.chartpart.AxisTickCalculator_;
import org.knowm.xchart.internal.chartpart.NumberFormatter;
import org.knowm.xchart.style.AxesChartStyler;

class AxisTickCalculator_Number
extends AxisTickCalculator_ {
    private final NumberFormatter numberFormatter;

    public AxisTickCalculator_Number(Axis.Direction axisDirection, double workingSpace, double minValue, double maxValue, AxesChartStyler styler) {
        super(axisDirection, workingSpace, minValue, maxValue, styler);
        this.numberFormatter = new NumberFormatter(styler, axisDirection, minValue, maxValue);
        this.axisFormat = this.numberFormatter;
        this.calculate();
    }

    private void calculate() {
        int gridStepInChartSpace;
        if (this.minValue == this.maxValue) {
            this.tickLabels.add(this.numberFormatter.format(BigDecimal.valueOf(this.maxValue).doubleValue()));
            this.tickLocations.add(this.workingSpace / 2.0);
            return;
        }
        double tickSpace = this.styler.getPlotContentSize() * this.workingSpace;
        if (tickSpace < (double)this.styler.getXAxisTickMarkSpacingHint()) {
            return;
        }
        double margin = Utils.getTickStartOffset(this.workingSpace, tickSpace);
        double span = Math.abs(Math.min(this.maxValue - this.minValue, Double.MAX_VALUE));
        int tickSpacingHint = (this.axisDirection == Axis.Direction.X ? this.styler.getXAxisTickMarkSpacingHint() : this.styler.getYAxisTickMarkSpacingHint()) - 5;
        if (this.axisDirection == Axis.Direction.Y && tickSpace < 160.0) {
            tickSpacingHint = 20;
        }
        do {
            BigDecimal cleanedFirstPosition;
            this.tickLabels.clear();
            this.tickLocations.clear();
            double significand = span / tickSpace * (double)(tickSpacingHint += 5);
            int exponent = 0;
            if (significand == 0.0) {
                exponent = 1;
            } else if (significand < 1.0) {
                while (significand < 1.0) {
                    significand *= 10.0;
                    --exponent;
                }
            } else {
                while (significand >= 10.0 || significand == Double.NEGATIVE_INFINITY) {
                    significand /= 10.0;
                    ++exponent;
                }
            }
            double gridStep = significand > 7.5 ? 10.0 * Utils.pow(10.0, exponent) : (significand > 3.5 ? 5.0 * Utils.pow(10.0, exponent) : (significand > 1.5 ? 2.0 * Utils.pow(10.0, exponent) : Utils.pow(10.0, exponent)));
            gridStepInChartSpace = (int)(gridStep / span * tickSpace);
            BigDecimal gridStepBigDecimal = new BigDecimal(gridStep, MathContext.DECIMAL64);
            int scale = Math.min(10, gridStepBigDecimal.scale());
            BigDecimal cleanedGridStep0 = gridStepBigDecimal.setScale(scale, RoundingMode.HALF_UP).stripTrailingZeros();
            BigDecimal cleanedGridStep = cleanedGridStep0.setScale(scale, 1).stripTrailingZeros();
            BigDecimal firstPosition = null;
            double firstPositionAsDouble = this.getFirstPosition(cleanedGridStep.doubleValue());
            if (Double.isNaN(firstPositionAsDouble)) {
                this.tickLabels.add(this.numberFormatter.format(BigDecimal.valueOf((this.maxValue + this.minValue) / 2.0)));
                this.tickLocations.add(this.workingSpace / 2.0);
                return;
            }
            if (firstPositionAsDouble == Double.NEGATIVE_INFINITY) {
                firstPosition = BigDecimal.valueOf(-1.7976931348623157E308);
            } else {
                try {
                    firstPosition = BigDecimal.valueOf(firstPositionAsDouble);
                }
                catch (NumberFormatException e) {
                    System.out.println("Some debug stuff. This happens once in a blue moon, and I don't know why.");
                    System.out.println("scale: " + scale);
                    System.out.println("exponent: " + exponent);
                    System.out.println("gridStep: " + gridStep);
                    System.out.println("cleanedGridStep: " + cleanedGridStep);
                    System.out.println("cleanedGridStep.doubleValue(): " + cleanedGridStep.doubleValue());
                    System.out.println("NumberFormatException caused by this number: " + this.getFirstPosition(cleanedGridStep.doubleValue()));
                }
            }
            BigDecimal value2 = cleanedFirstPosition = firstPosition.setScale(10, RoundingMode.HALF_UP).stripTrailingZeros();
            while (value2.compareTo(BigDecimal.valueOf(this.maxValue + 2.0 * cleanedGridStep.doubleValue())) < 0) {
                String tickLabel = this.numberFormatter.format(value2.doubleValue());
                this.tickLabels.add(tickLabel);
                double tickLabelPosition = margin + (value2.doubleValue() - this.minValue) / (this.maxValue - this.minValue) * tickSpace;
                this.tickLocations.add(tickLabelPosition);
                value2 = value2.add(cleanedGridStep);
            }
        } while (!this.willLabelsFitInTickSpaceHint(this.tickLabels, gridStepInChartSpace));
    }
}

