/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import java.awt.Graphics2D;
import java.util.Map;
import org.knowm.xchart.PieChartBuilder;
import org.knowm.xchart.PieSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.Legend_Pie;
import org.knowm.xchart.internal.chartpart.Plot_Pie;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.internal.style.SeriesColorMarkerLineStyle;
import org.knowm.xchart.internal.style.SeriesColorMarkerLineStyleCycler;
import org.knowm.xchart.style.PieStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.Theme;

public class PieChart
extends Chart<PieStyler, PieSeries> {
    public PieChart(int width, int height) {
        super(width, height, new PieStyler());
        this.plot = new Plot_Pie<PieStyler, PieSeries>(this);
        this.legend = new Legend_Pie<PieStyler, PieSeries>(this);
    }

    public PieChart(int width, int height, Theme theme) {
        this(width, height);
        ((PieStyler)this.styler).setTheme(theme);
    }

    public PieChart(int width, int height, Styler.ChartTheme chartTheme) {
        this(width, height, chartTheme.newInstance(chartTheme));
    }

    public PieChart(PieChartBuilder chartBuilder) {
        this(chartBuilder.width, chartBuilder.height, chartBuilder.chartTheme);
        this.setTitle(chartBuilder.title);
    }

    public PieSeries addSeries(String seriesName, Number value2) {
        PieSeries series = new PieSeries(seriesName, value2);
        if (this.seriesMap.keySet().contains(seriesName)) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< has already been used. Use unique names for each series!!!");
        }
        this.seriesMap.put(seriesName, series);
        return series;
    }

    public PieSeries updatePieSeries(String seriesName, Number value2) {
        Map seriesMap = this.getSeriesMap();
        PieSeries series = (PieSeries)seriesMap.get(seriesName);
        if (series == null) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< not found!!!");
        }
        series.replaceData(value2);
        return series;
    }

    @Override
    public void paint(Graphics2D g, int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        for (PieSeries seriesPie : this.getSeriesMap().values()) {
            PieSeries.PieSeriesRenderStyle seriesType = seriesPie.getChartPieSeriesRenderStyle();
            if (seriesType != null) continue;
            seriesPie.setChartPieSeriesRenderStyle(((PieStyler)this.getStyler()).getDefaultSeriesRenderStyle());
        }
        this.setSeriesStyles();
        this.paintBackground(g);
        this.plot.paint(g);
        this.chartTitle.paint(g);
        this.legend.paint(g);
    }

    private void setSeriesStyles() {
        SeriesColorMarkerLineStyleCycler seriesColorMarkerLineStyleCycler = new SeriesColorMarkerLineStyleCycler(((PieStyler)this.getStyler()).getSeriesColors(), ((PieStyler)this.getStyler()).getSeriesMarkers(), ((PieStyler)this.getStyler()).getSeriesLines());
        for (Series series : this.getSeriesMap().values()) {
            SeriesColorMarkerLineStyle seriesColorMarkerLineStyle = seriesColorMarkerLineStyleCycler.getNextSeriesColorMarkerLineStyle();
            if (series.getFillColor() != null) continue;
            series.setFillColor(seriesColorMarkerLineStyle.getColor());
        }
    }
}

