/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import java.util.ArrayList;
import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.distribution.EnumeratedDistribution;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NotANumberException;
import org.apache.commons.math3.exception.NotFiniteNumberException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.Pair;

public class EnumeratedIntegerDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 20130308L;
    protected final EnumeratedDistribution<Integer> innerDistribution;

    public EnumeratedIntegerDistribution(int[] singletons, double[] probabilities) throws DimensionMismatchException, NotPositiveException, MathArithmeticException, NotFiniteNumberException, NotANumberException {
        this(new Well19937c(), singletons, probabilities);
    }

    public EnumeratedIntegerDistribution(RandomGenerator rng, int[] singletons, double[] probabilities) throws DimensionMismatchException, NotPositiveException, MathArithmeticException, NotFiniteNumberException, NotANumberException {
        super(rng);
        if (singletons.length != probabilities.length) {
            throw new DimensionMismatchException(probabilities.length, singletons.length);
        }
        ArrayList samples = new ArrayList(singletons.length);
        for (int i = 0; i < singletons.length; ++i) {
            samples.add(new Pair<Integer, Double>(singletons[i], probabilities[i]));
        }
        this.innerDistribution = new EnumeratedDistribution(rng, samples);
    }

    public double probability(int x) {
        return this.innerDistribution.probability(x);
    }

    public double cumulativeProbability(int x) {
        double probability = 0.0;
        for (Pair<Integer, Double> sample : this.innerDistribution.getPmf()) {
            if (sample.getKey() > x) continue;
            probability += sample.getValue().doubleValue();
        }
        return probability;
    }

    public double getNumericalMean() {
        double mean2 = 0.0;
        for (Pair<Integer, Double> sample : this.innerDistribution.getPmf()) {
            mean2 += sample.getValue() * (double)sample.getKey().intValue();
        }
        return mean2;
    }

    public double getNumericalVariance() {
        double mean2 = 0.0;
        double meanOfSquares = 0.0;
        for (Pair<Integer, Double> sample : this.innerDistribution.getPmf()) {
            mean2 += sample.getValue() * (double)sample.getKey().intValue();
            meanOfSquares += sample.getValue() * (double)sample.getKey().intValue() * (double)sample.getKey().intValue();
        }
        return meanOfSquares - mean2 * mean2;
    }

    public int getSupportLowerBound() {
        int min2 = Integer.MAX_VALUE;
        for (Pair<Integer, Double> sample : this.innerDistribution.getPmf()) {
            if (sample.getKey() >= min2 || !(sample.getValue() > 0.0)) continue;
            min2 = sample.getKey();
        }
        return min2;
    }

    public int getSupportUpperBound() {
        int max2 = Integer.MIN_VALUE;
        for (Pair<Integer, Double> sample : this.innerDistribution.getPmf()) {
            if (sample.getKey() <= max2 || !(sample.getValue() > 0.0)) continue;
            max2 = sample.getKey();
        }
        return max2;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public int sample() {
        return this.innerDistribution.sample();
    }
}

