/*
 * Decompiled with CFR 0.152.
 */
package io.citrine.lolo.util;

import io.citrine.lolo.api.MultiTaskModelPredictionResult;
import io.citrine.lolo.api.PredictionResult;
import io.citrine.lolo.api.TrainingRow;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class LoloPyDataLoader$ {
    public static final LoloPyDataLoader$ MODULE$ = new LoloPyDataLoader$();

    public Seq<Vector<Object>> getFeatureArray(byte[] input, Integer numAttributes, boolean bigEndian) {
        ByteOrder ordering = bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        ByteBuffer buffer = ByteBuffer.wrap(input).order(ordering);
        int nDigits = input.length / 8;
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nDigits).map(x -> buffer.getDouble(x * 8)).grouped(Predef$.MODULE$.Integer2int(numAttributes)).map((Function1<IndexedSeq, Vector> & Serializable)x$1 -> x$1.toVector()).toVector();
    }

    public Seq<Object> get1DArray(byte[] input, boolean getDouble, boolean bigEndian) {
        Vector<Object> vector;
        ByteOrder ordering = bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        ByteBuffer buffer = ByteBuffer.wrap(input).order(ordering);
        if (getDouble) {
            int nDigits = input.length / 8;
            vector = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nDigits).map(x -> buffer.getDouble(x * 8)).toVector();
        } else {
            int nDigits = input.length / 4;
            vector = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nDigits).map(x -> buffer.getInt(x * 4)).toVector();
        }
        return vector;
    }

    public <T> Seq<TrainingRow<T>> buildTrainingRows(Seq<Vector<Object>> X, Seq<T> y, Seq<Object> w) {
        return (Seq)X.lazyZip(y).lazyZip(w).map((Function3<Vector, Object, Object, TrainingRow> & Serializable)(x0$1, x1$1, x2$1) -> LoloPyDataLoader$.$anonfun$buildTrainingRows$1(x0$1, x1$1, BoxesRunTime.unboxToDouble(x2$1)), BuildFrom$.MODULE$.buildFromIterableOps());
    }

    public byte[] getRegressionExpected(PredictionResult<Object> predictionResult) {
        Seq<Object> predResults = predictionResult.expected();
        return this.send1DArray(predResults);
    }

    public byte[] getMultiRegressionExpected(MultiTaskModelPredictionResult predictionResult) {
        Seq predResults = (Seq)predictionResult.expected().flatten(Predef$.MODULE$.$conforms());
        return this.send1DArray(predResults);
    }

    public byte[] getImportanceScores(PredictionResult<Object> predictionResult) {
        return this.send1DArray((Seq)((IterableOps)predictionResult.importanceScores().get()).flatten(Predef$.MODULE$.$conforms()));
    }

    public byte[] getRegressionUncertainty(PredictionResult<Object> predictionResult) {
        Seq<Object> predResults = predictionResult.uncertainty(predictionResult.uncertainty$default$1()).get();
        return this.send1DArray(predResults);
    }

    public byte[] getMultiRegressionUncertainty(MultiTaskModelPredictionResult predictionResult) {
        Seq uncertaintyResults = (Seq)predictionResult.uncertainty(predictionResult.uncertainty$default$1()).get().flatten(Predef$.MODULE$.$conforms());
        return this.send1DArray(uncertaintyResults);
    }

    public byte[] getRegressionCorrelation(MultiTaskModelPredictionResult predictionResult, int i, int j) {
        Seq<Object> correlationResults = predictionResult.uncertaintyCorrelation(i, j, predictionResult.uncertaintyCorrelation$default$3()).get();
        return this.send1DArray(correlationResults);
    }

    public byte[] send1DArray(Seq<Object> data) {
        ByteBuffer buffer = ByteBuffer.allocate(data.length() * 8).order(ByteOrder.nativeOrder());
        data.foreach((Function1<Object, ByteBuffer> & Serializable)x$1 -> buffer.putDouble(BoxesRunTime.unboxToDouble(x$1)));
        return buffer.array();
    }

    public byte[] getClassifierExpected(PredictionResult<Object> predictionResult) {
        Seq<Object> expect = predictionResult.expected();
        ByteBuffer buffer = ByteBuffer.allocate(expect.length() * 4).order(ByteOrder.nativeOrder());
        expect.foreach((Function1<Object, ByteBuffer> & Serializable)x$1 -> buffer.putInt(BoxesRunTime.unboxToInt(x$1)));
        return buffer.array();
    }

    public byte[] getClassifierProbabilities(PredictionResult<Object> predictionResult, int nClasses) {
        Range classes = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nClasses);
        Seq probs = (Seq)predictionResult.uncertainty(predictionResult.uncertainty$default$1()).get().map((Function1<Map, IndexedSeq> & Serializable)x -> classes.map(i -> BoxesRunTime.unboxToDouble(x.getOrElse(BoxesRunTime.boxToInteger(i), () -> 0.0))));
        ByteBuffer buffer = ByteBuffer.allocate(nClasses * probs.length() * 8).order(ByteOrder.nativeOrder());
        ((IterableOnceOps)probs.flatten(Predef$.MODULE$.$conforms())).foreach((Function1<Object, ByteBuffer> & Serializable)x$1 -> buffer.putDouble(BoxesRunTime.unboxToDouble(x$1)));
        return buffer.array();
    }

    public byte[] serializeObject(Object obj, int compressLevel) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DeflaterOutputStream compressedStream = new DeflaterOutputStream((OutputStream)stream, new Deflater(compressLevel));
        ObjectOutputStream oos = new ObjectOutputStream(compressedStream);
        oos.writeObject(obj);
        oos.close();
        compressedStream.close();
        return stream.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    public Object deserializeObject(byte[] bytes) {
        void var3_3;
        ObjectInputStream stream = new ObjectInputStream(new InflaterInputStream(new ByteArrayInputStream(bytes)));
        Object obj = stream.readObject();
        stream.close();
        return var3_3;
    }

    public PredictionResult<Object> makeRegressionPredictionResult(Seq<Object> thisExpected, Seq<Object> thisUncertainty) {
        return new PredictionResult<Object>(thisExpected, thisUncertainty){
            private final Seq thisExpected$1;
            private final Seq thisUncertainty$1;

            public Option<Seq<Seq<Object>>> importanceScores() {
                return PredictionResult.importanceScores$(this);
            }

            public Option<Seq<Seq<Object>>> influenceScores(Seq<Object> actuals) {
                return PredictionResult.influenceScores$(this, actuals);
            }

            public Option<Seq<Vector<Object>>> gradient() {
                return PredictionResult.gradient$(this);
            }

            public Seq<Object> expected() {
                return this.thisExpected$1;
            }

            public Option<Seq<Object>> uncertainty(boolean includeNoise) {
                return new Some<Seq<Object>>(this.thisUncertainty$1);
            }

            public boolean uncertainty$default$1() {
                return true;
            }
            {
                this.thisExpected$1 = thisExpected$1;
                this.thisUncertainty$1 = thisUncertainty$1;
                PredictionResult.$init$(this);
            }
        };
    }

    public static final /* synthetic */ TrainingRow $anonfun$buildTrainingRows$1(Vector x0$1, Object x1$1, double x2$1) {
        Tuple3<Vector, Object, Double> tuple3 = new Tuple3<Vector, Object, Double>(x0$1, x1$1, BoxesRunTime.boxToDouble(x2$1));
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Vector xi = tuple3._1();
        Object yi = tuple3._2();
        double wi = BoxesRunTime.unboxToDouble(tuple3._3());
        TrainingRow<Object> trainingRow = new TrainingRow<Object>(xi, yi, wi);
        return trainingRow;
    }

    private LoloPyDataLoader$() {
    }
}

