/*
 * Decompiled with CFR 0.152.
 */
package io.citrine.lolo.trees.splits;

import io.citrine.lolo.api.TrainingRow;
import io.citrine.lolo.trees.impurity.VarianceCalculator;
import io.citrine.lolo.trees.impurity.VarianceCalculator$;
import io.citrine.lolo.trees.splits.BoltzmannSplitter$;
import io.citrine.lolo.trees.splits.NoSplit;
import io.citrine.lolo.trees.splits.Split;
import io.citrine.lolo.trees.splits.Splitter;
import io.citrine.random.Random;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.math.Numeric$DoubleIsFractional$;
import scala.math.Ordering$DeprecatedDoubleOrdering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tuc\u0001B\u001c9\u0001\u000eC\u0001\u0002\u0019\u0001\u0003\u0016\u0004%\t!\u0019\u0005\tE\u0002\u0011\t\u0012)A\u0005\u001d\")1\r\u0001C\u0001I\")q\r\u0001C\u0001Q\"I\u00111\u0003\u0001\u0002\u0002\u0013\u0005\u0011Q\u0003\u0005\n\u00033\u0001\u0011\u0013!C\u0001\u00037A\u0011\"!\r\u0001\u0003\u0003%\t%a\r\t\u0013\u0005\u0015\u0003!!A\u0005\u0002\u0005\u001d\u0003\"CA%\u0001\u0005\u0005I\u0011AA&\u0011%\t9\u0006AA\u0001\n\u0003\nI\u0006C\u0005\u0002h\u0001\t\t\u0011\"\u0001\u0002j!I\u00111\u000f\u0001\u0002\u0002\u0013\u0005\u0013Q\u000f\u0005\n\u0003s\u0002\u0011\u0011!C!\u0003wB\u0011\"! \u0001\u0003\u0003%\t%a \t\u0013\u0005\u0005\u0005!!A\u0005B\u0005\ruaBADq!\u0005\u0011\u0011\u0012\u0004\u0007oaB\t!a#\t\r\r\fB\u0011AAK\r\u0019\t9*\u0005%\u0002\u001a\"Q\u00111T\n\u0003\u0016\u0004%\t!!(\t\u0013\u0005}5C!E!\u0002\u0013a\u0007\"CAQ'\tU\r\u0011\"\u0001b\u0011%\t\u0019k\u0005B\tB\u0003%a\nC\u0005\u0002&N\u0011)\u001a!C\u0001C\"I\u0011qU\n\u0003\u0012\u0003\u0006IA\u0014\u0005\n\u0003S\u001b\"Q3A\u0005\u0002\u0005D\u0011\"a+\u0014\u0005#\u0005\u000b\u0011\u0002(\t\r\r\u001cB\u0011AAW\u0011%\t\u0019bEA\u0001\n\u0003\tY\fC\u0005\u0002\u001aM\t\n\u0011\"\u0001\u0002F\"I\u0011\u0011Z\n\u0012\u0002\u0013\u0005\u00111\u0004\u0005\n\u0003\u0017\u001c\u0012\u0013!C\u0001\u00037A\u0011\"!4\u0014#\u0003%\t!a\u0007\t\u0013\u0005E2#!A\u0005B\u0005M\u0002\"CA#'\u0005\u0005I\u0011AA$\u0011%\tIeEA\u0001\n\u0003\ty\rC\u0005\u0002XM\t\t\u0011\"\u0011\u0002Z!I\u0011qM\n\u0002\u0002\u0013\u0005\u00111\u001b\u0005\n\u0003g\u001a\u0012\u0011!C!\u0003/D\u0011\"!\u001f\u0014\u0003\u0003%\t%a\u001f\t\u0013\u0005u4#!A\u0005B\u0005}\u0004\"CAA'\u0005\u0005I\u0011IAn\u000f%\ty.EA\u0001\u0012#\t\tOB\u0005\u0002\u0018F\t\t\u0011#\u0005\u0002d\"11\r\fC\u0001\u0003cD\u0011\"! -\u0003\u0003%)%a \t\u0013\u0005MH&!A\u0005\u0002\u0006U\b\"CA\u0000Y\u0005\u0005I\u0011\u0011B\u0001\u0011%\u0011\u0019\u0002LA\u0001\n\u0013\u0011)\u0002C\u0004\u0003\u001eE!\tAa\b\t\u000f\t\r\u0013\u0003\"\u0001\u0003F!I\u00111_\t\u0002\u0002\u0013\u0005%1\u000b\u0005\n\u0003\u007f\f\u0012\u0011!CA\u0005/B\u0011Ba\u0005\u0012\u0003\u0003%IA!\u0006\u0003#\t{G\u000e\u001e>nC:t7\u000b\u001d7jiR,'O\u0003\u0002:u\u000511\u000f\u001d7jiNT!a\u000f\u001f\u0002\u000bQ\u0014X-Z:\u000b\u0005ur\u0014\u0001\u00027pY>T!a\u0010!\u0002\u000f\rLGO]5oK*\t\u0011)\u0001\u0002j_\u000e\u00011#\u0002\u0001E\u0015F#\u0006CA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%AB!osJ+g\rE\u0002L\u0019:k\u0011\u0001O\u0005\u0003\u001bb\u0012\u0001b\u00159mSR$XM\u001d\t\u0003\u000b>K!\u0001\u0015$\u0003\r\u0011{WO\u00197f!\t)%+\u0003\u0002T\r\n9\u0001K]8ek\u000e$\bCA+^\u001d\t16L\u0004\u0002X56\t\u0001L\u0003\u0002Z\u0005\u00061AH]8pizJ\u0011aR\u0005\u00039\u001a\u000bq\u0001]1dW\u0006<W-\u0003\u0002_?\na1+\u001a:jC2L'0\u00192mK*\u0011ALR\u0001\fi\u0016l\u0007/\u001a:biV\u0014X-F\u0001O\u00031!X-\u001c9fe\u0006$XO]3!\u0003\u0019a\u0014N\\5u}Q\u0011QM\u001a\t\u0003\u0017\u0002AQ\u0001Y\u0002A\u00029\u000bAbZ3u\u0005\u0016\u001cHo\u00159mSR$b![8{\u007f\u0006\r\u0001\u0003B#kY:K!a\u001b$\u0003\rQ+\b\u000f\\33!\tYU.\u0003\u0002oq\t)1\u000b\u001d7ji\")\u0001\u000f\u0002a\u0001c\u0006!A-\u0019;b!\r)&\u000f^\u0005\u0003g~\u00131aU3r!\r)\bPT\u0007\u0002m*\u0011q\u000fP\u0001\u0004CBL\u0017BA=w\u0005-!&/Y5oS:<'k\\<\t\u000bm$\u0001\u0019\u0001?\u0002\u00179,XNR3biV\u0014Xm\u001d\t\u0003\u000bvL!A $\u0003\u0007%sG\u000f\u0003\u0004\u0002\u0002\u0011\u0001\r\u0001`\u0001\r[&t\u0017J\\:uC:\u001cWm\u001d\u0005\n\u0003\u000b!\u0001\u0013!a\u0001\u0003\u000f\t1A\u001d8h!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007}\u00051!/\u00198e_6LA!!\u0005\u0002\f\t1!+\u00198e_6\fAaY8qsR\u0019Q-a\u0006\t\u000f\u0001,\u0001\u0013!a\u0001\u001d\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u000fU\rq\u0015qD\u0016\u0003\u0003C\u0001B!a\t\u0002.5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0006$\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00020\u0005\u0015\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u000e\u0011\t\u0005]\u0012\u0011I\u0007\u0003\u0003sQA!a\u000f\u0002>\u0005!A.\u00198h\u0015\t\ty$\u0001\u0003kCZ\f\u0017\u0002BA\"\u0003s\u0011aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001?\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QJA*!\r)\u0015qJ\u0005\u0004\u0003#2%aA!os\"A\u0011QK\u0005\u0002\u0002\u0003\u0007A0A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00037\u0002b!!\u0018\u0002d\u00055SBAA0\u0015\r\t\tGR\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA3\u0003?\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111NA9!\r)\u0015QN\u0005\u0004\u0003_2%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003+Z\u0011\u0011!a\u0001\u0003\u001b\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011QGA<\u0011!\t)\u0006DA\u0001\u0002\u0004a\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003q\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003k\ta!Z9vC2\u001cH\u0003BA6\u0003\u000bC\u0011\"!\u0016\u0010\u0003\u0003\u0005\r!!\u0014\u0002#\t{G\u000e\u001e>nC:t7\u000b\u001d7jiR,'\u000f\u0005\u0002L#M!\u0011\u0003RAG!\u0011\ty)a%\u000e\u0005\u0005E%bA!\u0002>%\u0019a,!%\u0015\u0005\u0005%%AD*qY&$H/\u001a:SKN,H\u000e^\n\u0005'\u0011\u000bF+A\u0003ta2LG/F\u0001m\u0003\u0019\u0019\b\u000f\\5uA\u0005Aa/\u0019:jC:\u001cW-A\u0005wCJL\u0017M\\2fA\u0005a!/\u001a2bg\u0016$7kY8sK\u0006i!/\u001a2bg\u0016$7kY8sK\u0002\nAAY1tK\u0006)!-Y:fAQQ\u0011qVAZ\u0003k\u000b9,!/\u0011\u0007\u0005E6#D\u0001\u0012\u0011\u0019\tY\n\ba\u0001Y\"1\u0011\u0011\u0015\u000fA\u00029Ca!!*\u001d\u0001\u0004q\u0005BBAU9\u0001\u0007a\n\u0006\u0006\u00020\u0006u\u0016qXAa\u0003\u0007D\u0001\"a'\u001e!\u0003\u0005\r\u0001\u001c\u0005\t\u0003Ck\u0002\u0013!a\u0001\u001d\"A\u0011QU\u000f\u0011\u0002\u0003\u0007a\n\u0003\u0005\u0002*v\u0001\n\u00111\u0001O+\t\t9MK\u0002m\u0003?\tabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iQ!\u0011QJAi\u0011!\t)\u0006JA\u0001\u0002\u0004aH\u0003BA6\u0003+D\u0011\"!\u0016'\u0003\u0003\u0005\r!!\u0014\u0015\t\u0005U\u0012\u0011\u001c\u0005\t\u0003+:\u0013\u0011!a\u0001yR!\u00111NAo\u0011%\t)FKA\u0001\u0002\u0004\ti%\u0001\bTa2LG\u000f^3s%\u0016\u001cX\u000f\u001c;\u0011\u0007\u0005EFfE\u0003-\u0003K\fi\t\u0005\u0006\u0002h\u00065HN\u0014(O\u0003_k!!!;\u000b\u0007\u0005-h)A\u0004sk:$\u0018.\\3\n\t\u0005=\u0018\u0011\u001e\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DCAAq\u0003\u0015\t\u0007\u000f\u001d7z))\ty+a>\u0002z\u0006m\u0018Q \u0005\u0007\u00037{\u0003\u0019\u00017\t\r\u0005\u0005v\u00061\u0001O\u0011\u0019\t)k\fa\u0001\u001d\"1\u0011\u0011V\u0018A\u00029\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0004\t=\u0001#B#\u0003\u0006\t%\u0011b\u0001B\u0004\r\n1q\n\u001d;j_:\u0004r!\u0012B\u0006Y:se*C\u0002\u0003\u000e\u0019\u0013a\u0001V;qY\u0016$\u0004\"\u0003B\ta\u0005\u0005\t\u0019AAX\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005/\u0001B!a\u000e\u0003\u001a%!!1DA\u001d\u0005\u0019y%M[3di\u0006\u0001r-\u001a;CKN$(+Z1m'Bd\u0017\u000e\u001e\u000b\u000f\u0005C\u0011\u0019C!\n\u00036\te\"Q\bB!!\u0015)%QAAX\u0011\u0015\u0001(\u00071\u0001r\u0011\u001d\u00119C\ra\u0001\u0005S\t!bY1mGVd\u0017\r^8s!\u0011\u0011YC!\r\u000e\u0005\t5\"b\u0001B\u0018u\u0005A\u0011.\u001c9ve&$\u00180\u0003\u0003\u00034\t5\"A\u0005,be&\fgnY3DC2\u001cW\u000f\\1u_JDaAa\u000e3\u0001\u0004a\u0018!B5oI\u0016D\bB\u0002B\u001ee\u0001\u0007A0\u0001\u0005nS:\u001cu.\u001e8u\u0011\u0019\u0011yD\ra\u0001\u001d\u0006!!-\u001a;b\u0011\u001d\t)A\ra\u0001\u0003\u000f\tqcZ3u\u0005\u0016\u001cHoQ1uK\u001e|'/[2bYN\u0003H.\u001b;\u0015\u001d\t\u0005\"q\tB%\u0005\u0017\u0012iEa\u0014\u0003R!)\u0001o\ra\u0001c\"9!qE\u001aA\u0002\t%\u0002B\u0002B\u001cg\u0001\u0007A\u0010\u0003\u0004\u0003<M\u0002\r\u0001 \u0005\u0007\u0005\u007f\u0019\u0004\u0019\u0001(\t\u000f\u0005\u00151\u00071\u0001\u0002\bQ\u0019QM!\u0016\t\u000b\u0001$\u0004\u0019\u0001(\u0015\t\te#1\f\t\u0005\u000b\n\u0015a\n\u0003\u0005\u0003\u0012U\n\t\u00111\u0001f\u0001")
public class BoltzmannSplitter
implements Splitter<Object>,
Product,
Serializable {
    private final double temperature;

    public static Option<Object> unapply(BoltzmannSplitter x$0) {
        return BoltzmannSplitter$.MODULE$.unapply(x$0);
    }

    public static BoltzmannSplitter apply(double temperature) {
        return BoltzmannSplitter$.MODULE$.apply(temperature);
    }

    public static Option<SplitterResult> getBestCategoricalSplit(Seq<TrainingRow<Object>> data, VarianceCalculator calculator, int index, int minCount, double beta, Random rng) {
        return BoltzmannSplitter$.MODULE$.getBestCategoricalSplit(data, calculator, index, minCount, beta, rng);
    }

    public static Option<SplitterResult> getBestRealSplit(Seq<TrainingRow<Object>> data, VarianceCalculator calculator, int index, int minCount, double beta, Random rng) {
        return BoltzmannSplitter$.MODULE$.getBestRealSplit(data, calculator, index, minCount, beta, rng);
    }

    @Override
    public Iterator<String> productElementNames() {
        return Product.productElementNames$(this);
    }

    @Override
    public Random getBestSplit$default$4() {
        return Splitter.getBestSplit$default$4$(this);
    }

    public double temperature() {
        return this.temperature;
    }

    @Override
    public Tuple2<Split, Object> getBestSplit(Seq<TrainingRow<Object>> data, int numFeatures, int minInstances, Random rng) {
        Object object = new Object();
        try {
            VarianceCalculator calculator = VarianceCalculator$.MODULE$.build((Seq)data.map((Function1<TrainingRow, Object> & Serializable)x$1 -> BoxesRunTime.boxToDouble(BoltzmannSplitter.$anonfun$getBestSplit$1(x$1))), (Seq)data.map((Function1<TrainingRow, Object> & Serializable)x$2 -> BoxesRunTime.boxToDouble(x$2.weight())));
            double initialVariance = calculator.getImpurity();
            if (initialVariance == 0.0) {
                return new Tuple2<Split, Object>(new NoSplit(), BoxesRunTime.boxToDouble(0.0));
            }
            double beta = 1.0 / (this.temperature() * initialVariance);
            TrainingRow rep = (TrainingRow)data.head();
            Range featureIndices = rep.inputs().indices();
            Seq possibleSplits = (Seq)((IterableOps)((IterableOps)rng.shuffle(featureIndices, BuildFrom$.MODULE$.buildFromIterableOps())).take(numFeatures)).flatMap((Function1<Object, IterableOnce> & Serializable)index -> BoltzmannSplitter.$anonfun$getBestSplit$3(rep, data, calculator, minInstances, beta, rng, BoxesRunTime.unboxToInt(index)));
            if (possibleSplits.isEmpty()) {
                return new Tuple2<Split, Object>(new NoSplit(), BoxesRunTime.boxToDouble(0.0));
            }
            double rebase = BoxesRunTime.unboxToDouble(((IterableOnceOps)possibleSplits.map((Function1<SplitterResult, Object> & Serializable)x$3 -> BoxesRunTime.boxToDouble(x$3.base()))).max(Ordering$DeprecatedDoubleOrdering$.MODULE$));
            double totalProbability = BoxesRunTime.unboxToDouble(((IterableOnceOps)possibleSplits.map((Function1<SplitterResult, Object> & Serializable)x -> BoxesRunTime.boxToDouble(BoltzmannSplitter.$anonfun$getBestSplit$5(rebase, x)))).sum(Numeric$DoubleIsFractional$.MODULE$));
            double draw = rng.nextDouble() * totalProbability;
            DoubleRef cumSum = DoubleRef.create(0.0);
            possibleSplits.foreach((Function1<SplitterResult, Object> & Serializable)x0$1 -> {
                BoltzmannSplitter.$anonfun$getBestSplit$6(cumSum, rebase, draw, initialVariance, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw new RuntimeException(new StringBuilder(39).append("Draw was beyond all the probabilities ").append(draw).append(" ").append(totalProbability).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Tuple2)ex.value();
        }
    }

    public BoltzmannSplitter copy(double temperature) {
        return new BoltzmannSplitter(temperature);
    }

    public double copy$default$1() {
        return this.temperature();
    }

    @Override
    public String productPrefix() {
        return "BoltzmannSplitter";
    }

    @Override
    public int productArity() {
        return 1;
    }

    @Override
    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToDouble(this.temperature());
                break;
            }
            default: {
                object = Statics.ioobe(x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator(this);
    }

    @Override
    public boolean canEqual(Object x$1) {
        return x$1 instanceof BoltzmannSplitter;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "temperature";
                break;
            }
            default: {
                string = (String)Statics.ioobe(x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.productPrefix().hashCode());
        n = Statics.mix(n, Statics.doubleHash(this.temperature()));
        return Statics.finalizeHash(n, 1);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BoltzmannSplitter)) return false;
        boolean bl = true;
        if (!bl) return false;
        BoltzmannSplitter boltzmannSplitter = (BoltzmannSplitter)x$1;
        if (this.temperature() != boltzmannSplitter.temperature()) return false;
        if (!boltzmannSplitter.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ double $anonfun$getBestSplit$1(TrainingRow x$1) {
        return BoxesRunTime.unboxToDouble(x$1.label());
    }

    public static final /* synthetic */ IterableOnce $anonfun$getBestSplit$3(TrainingRow rep$1, Seq data$1, VarianceCalculator calculator$1, int minInstances$1, double beta$1, Random rng$1, int index) {
        Option<SplitterResult> option;
        Object r = rep$1.inputs().apply(index);
        if (r instanceof Double) {
            option = BoltzmannSplitter$.MODULE$.getBestRealSplit(data$1, calculator$1, index, minInstances$1, beta$1, rng$1);
        } else if (r instanceof Character) {
            option = BoltzmannSplitter$.MODULE$.getBestCategoricalSplit(data$1, calculator$1, index, minInstances$1, beta$1, rng$1);
        } else {
            if (r instanceof Object) {
                throw new IllegalArgumentException("Trying to split unknown feature type");
            }
            throw new MatchError(r);
        }
        return option;
    }

    public static final /* synthetic */ double $anonfun$getBestSplit$5(double rebase$1, SplitterResult x) {
        return x.rebasedScore() * Math.exp(x.base() - rebase$1);
    }

    public static final /* synthetic */ void $anonfun$getBestSplit$6(DoubleRef cumSum$1, double rebase$1, double draw$1, double initialVariance$1, Object nonLocalReturnKey1$1, SplitterResult x0$1) {
        SplitterResult splitterResult = x0$1;
        if (splitterResult != null) {
            Split split2 = splitterResult.split();
            double variance2 = splitterResult.variance();
            double score = splitterResult.rebasedScore();
            double base = splitterResult.base();
            cumSum$1.elem += score * Math.exp(base - rebase$1);
            if (draw$1 < cumSum$1.elem) {
                double deltaImpurity = initialVariance$1 - variance2;
                throw new NonLocalReturnControl<Tuple2<Split, Double>>(nonLocalReturnKey1$1, new Tuple2<Split, Double>(split2, BoxesRunTime.boxToDouble(deltaImpurity)));
            }
        } else {
            throw new MatchError(splitterResult);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public BoltzmannSplitter(double temperature) {
        this.temperature = temperature;
        Product.$init$(this);
        Predef$.MODULE$.require(temperature >= (double)1.4E-45f, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(70).append("Temperature must be >= ").append(Float.MIN_VALUE).append(" to avoid numerical underflows").toString());
    }

    public static class SplitterResult
    implements Product,
    Serializable {
        private final Split split;
        private final double variance;
        private final double rebasedScore;
        private final double base;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        public Split split() {
            return this.split;
        }

        public double variance() {
            return this.variance;
        }

        public double rebasedScore() {
            return this.rebasedScore;
        }

        public double base() {
            return this.base;
        }

        public SplitterResult copy(Split split2, double variance2, double rebasedScore, double base) {
            return new SplitterResult(split2, variance2, rebasedScore, base);
        }

        public Split copy$default$1() {
            return this.split();
        }

        public double copy$default$2() {
            return this.variance();
        }

        public double copy$default$3() {
            return this.rebasedScore();
        }

        public double copy$default$4() {
            return this.base();
        }

        @Override
        public String productPrefix() {
            return "SplitterResult";
        }

        @Override
        public int productArity() {
            return 4;
        }

        @Override
        public Object productElement(int x$1) {
            Serializable serializable;
            int n = x$1;
            switch (n) {
                case 0: {
                    serializable = this.split();
                    break;
                }
                case 1: {
                    serializable = BoxesRunTime.boxToDouble(this.variance());
                    break;
                }
                case 2: {
                    serializable = BoxesRunTime.boxToDouble(this.rebasedScore());
                    break;
                }
                case 3: {
                    serializable = BoxesRunTime.boxToDouble(this.base());
                    break;
                }
                default: {
                    serializable = Statics.ioobe(x$1);
                    break;
                }
            }
            return serializable;
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof SplitterResult;
        }

        @Override
        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "split";
                    break;
                }
                case 1: {
                    string = "variance";
                    break;
                }
                case 2: {
                    string = "rebasedScore";
                    break;
                }
                case 3: {
                    string = "base";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe(x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.split()));
            n = Statics.mix(n, Statics.doubleHash(this.variance()));
            n = Statics.mix(n, Statics.doubleHash(this.rebasedScore()));
            n = Statics.mix(n, Statics.doubleHash(this.base()));
            return Statics.finalizeHash(n, 4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SplitterResult)) return false;
            boolean bl = true;
            if (!bl) return false;
            SplitterResult splitterResult = (SplitterResult)x$1;
            if (this.variance() != splitterResult.variance()) return false;
            if (this.rebasedScore() != splitterResult.rebasedScore()) return false;
            if (this.base() != splitterResult.base()) return false;
            Split split2 = this.split();
            Split split3 = splitterResult.split();
            if (split2 == null) {
                if (split3 != null) {
                    return false;
                }
            } else if (!split2.equals(split3)) return false;
            if (!splitterResult.canEqual(this)) return false;
            return true;
        }

        public SplitterResult(Split split2, double variance2, double rebasedScore, double base) {
            this.split = split2;
            this.variance = variance2;
            this.rebasedScore = rebasedScore;
            this.base = base;
            Product.$init$(this);
            Predef$.MODULE$.require(rebasedScore >= 1.0);
            Predef$.MODULE$.require(!RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(base)));
        }
    }
}

