/*
 * Decompiled with CFR 0.152.
 */
package io.citrine.lolo.hypers;

import io.citrine.lolo.api.Learner;
import io.citrine.lolo.api.TrainingResult;
import io.citrine.lolo.api.TrainingRow;
import io.citrine.lolo.hypers.HyperOptimizer;
import io.citrine.random.Random;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005Y4A!\u0003\u0006\u0001'!)\u0001\u0004\u0001C\u00013!91\u0004\u0001a\u0001\n\u0003a\u0002bB\u0019\u0001\u0001\u0004%\tA\r\u0005\u0007q\u0001\u0001\u000b\u0015B\u000f\t\u000fe\u0002\u0001\u0019!C\u0001u!9a\b\u0001a\u0001\n\u0003y\u0004BB!\u0001A\u0003&1\bC\u0003C\u0001\u0011\u00053I\u0001\u000bSC:$w.\u001c%za\u0016\u0014x\n\u001d;j[&TXM\u001d\u0006\u0003\u00171\ta\u0001[=qKJ\u001c(BA\u0007\u000f\u0003\u0011aw\u000e\\8\u000b\u0005=\u0001\u0012aB2jiJLg.\u001a\u0006\u0002#\u0005\u0011\u0011n\\\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u0016-5\t!\"\u0003\u0002\u0018\u0015\tq\u0001*\u001f9fe>\u0003H/[7ju\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001\u001b!\t)\u0002!\u0001\u0003cKN$X#A\u000f\u0011\ty9#&\f\b\u0003?\u0015\u0002\"\u0001I\u0012\u000e\u0003\u0005R!A\t\n\u0002\rq\u0012xn\u001c;?\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001&\u000b\u0002\u0004\u001b\u0006\u0004(B\u0001\u0014$!\tq2&\u0003\u0002-S\t11\u000b\u001e:j]\u001e\u0004\"AL\u0018\u000e\u0003\rJ!\u0001M\u0012\u0003\u0007\u0005s\u00170\u0001\u0005cKN$x\fJ3r)\t\u0019d\u0007\u0005\u0002/i%\u0011Qg\t\u0002\u0005+:LG\u000fC\u00048\u0007\u0005\u0005\t\u0019A\u000f\u0002\u0007a$\u0013'A\u0003cKN$\b%\u0001\u0003m_N\u001cX#A\u001e\u0011\u00059b\u0014BA\u001f$\u0005\u0019!u.\u001e2mK\u0006AAn\\:t?\u0012*\u0017\u000f\u0006\u00024\u0001\"9qGBA\u0001\u0002\u0004Y\u0014!\u00027pgN\u0004\u0013\u0001C8qi&l\u0017N_3\u0016\u0005\u0011[F#B#IC\u001at\u0007\u0003\u0002\u0018G;mJ!aR\u0012\u0003\rQ+\b\u000f\\33\u0011\u0015I\u0005\u00021\u0001K\u00031!(/Y5oS:<G)\u0019;b!\rY\u0005k\u0015\b\u0003\u0019:s!\u0001I'\n\u0003\u0011J!aT\u0012\u0002\u000fA\f7m[1hK&\u0011\u0011K\u0015\u0002\u0004'\u0016\f(BA($!\r!v+W\u0007\u0002+*\u0011a\u000bD\u0001\u0004CBL\u0017B\u0001-V\u0005-!&/Y5oS:<'k\\<\u0011\u0005i[F\u0002\u0001\u0003\u00069\"\u0011\r!\u0018\u0002\u0002)F\u0011a,\f\t\u0003]}K!\u0001Y\u0012\u0003\u000f9{G\u000f[5oO\"9!\r\u0003I\u0001\u0002\u0004\u0019\u0017!\u00048v[&#XM]1uS>t7\u000f\u0005\u0002/I&\u0011Qm\t\u0002\u0004\u0013:$\b\"B4\t\u0001\u0004A\u0017a\u00022vS2$WM\u001d\t\u0005]%l2.\u0003\u0002kG\tIa)\u001e8di&|g.\r\t\u0004)2L\u0016BA7V\u0005\u001daU-\u0019:oKJDqa\u001c\u0005\u0011\u0002\u0003\u0007\u0001/A\u0002s]\u001e\u0004\"!\u001d;\u000e\u0003IT!a\u001d\b\u0002\rI\fg\u000eZ8n\u0013\t)(O\u0001\u0004SC:$w.\u001c")
public class RandomHyperOptimizer
extends HyperOptimizer {
    private Map<String, Object> best = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    private double loss = Double.MAX_VALUE;

    public Map<String, Object> best() {
        return this.best;
    }

    public void best_$eq(Map<String, Object> x$1) {
        this.best = x$1;
    }

    public double loss() {
        return this.loss;
    }

    public void loss_$eq(double x$1) {
        this.loss = x$1;
    }

    @Override
    public <T> Tuple2<Map<String, Object>, Object> optimize(Seq<TrainingRow<T>> trainingData, int numIterations, Function1<Map<String, Object>, Learner<T>> builder, Random rng) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numIterations).foreach$mVc$sp(x$1 -> {
            block1: {
                Map testHypers = (Map)this.hyperGrids().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    String n = (String)tuple2._1();
                    Seq v = (Seq)tuple2._2();
                    Tuple2 tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(n), ((IterableOps)rng.shuffle(v, BuildFrom$.MODULE$.buildFromIterableOps())).head());
                    return tuple22;
                });
                Learner testLearner = (Learner)builder.apply(testHypers);
                TrainingResult res = testLearner.train(trainingData, rng);
                if (res.loss().isEmpty()) {
                    throw new IllegalArgumentException("Trying to optimize hyper-paramters for a learner without getLoss");
                }
                double thisLoss = BoxesRunTime.unboxToDouble(res.loss().get());
                if (!(thisLoss < this.loss())) break block1;
                this.best_$eq(testHypers);
                this.loss_$eq(thisLoss);
                Predef$.MODULE$.println(new StringBuilder(27).append("Improved the loss to ").append(this.loss()).append(" with ").append(this.best()).toString());
            }
        });
        return new Tuple2<Map<String, Object>, Object>(this.best(), BoxesRunTime.boxToDouble(this.loss()));
    }
}

