/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.hypothesis;

import breeze.linalg.support.CanTraverseValues;
import breeze.linalg.support.CanTraverseValues$;
import breeze.stats.distributions.Gamma;
import breeze.stats.distributions.RandBasis$;
import breeze.stats.distributions.StudentsT;
import breeze.stats.hypothesis.package;
import breeze.stats.meanAndVariance;
import breeze.stats.meanAndVariance$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.IterableOnceExtensionMethods$;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public final class package$ {
    public static final package$ MODULE$ = new package$();

    public <T> double tTest(IterableOnce<T> it1, Iterable<T> it2, Numeric<T> numeric) {
        return this.tTest(IterableOnceExtensionMethods$.MODULE$.map$extension(IterableOnce$.MODULE$.iterableOnceExtensionMethods(it1), (Function1<Object, Object> & Serializable)x -> BoxesRunTime.boxToDouble(numeric.toDouble(x))), it2.map((Function1<Object, Object> & Serializable)x -> BoxesRunTime.boxToDouble(numeric.toDouble(x))), CanTraverseValues$.MODULE$.canTraverseTraversable());
    }

    public <X> double tTest(X it1, X it2, CanTraverseValues<X, Object> ct) {
        meanAndVariance.MeanAndVariance meanAndVariance2 = meanAndVariance$.MODULE$.apply(it1, meanAndVariance$.MODULE$.reduce_Double(ct));
        if (meanAndVariance2 == null) {
            throw new MatchError(meanAndVariance2);
        }
        double mu1 = meanAndVariance2.mean();
        double var1 = meanAndVariance2.variance();
        long n1 = meanAndVariance2.count();
        Tuple3<Double, Double, Long> tuple3 = new Tuple3<Double, Double, Long>(BoxesRunTime.boxToDouble(mu1), BoxesRunTime.boxToDouble(var1), BoxesRunTime.boxToLong(n1));
        Tuple3<Double, Double, Long> tuple32 = tuple3;
        double mu12 = BoxesRunTime.unboxToDouble(tuple32._1());
        double var12 = BoxesRunTime.unboxToDouble(tuple32._2());
        long n12 = BoxesRunTime.unboxToLong(tuple32._3());
        meanAndVariance.MeanAndVariance meanAndVariance3 = meanAndVariance$.MODULE$.apply(it2, meanAndVariance$.MODULE$.reduce_Double(ct));
        if (meanAndVariance3 == null) {
            throw new MatchError(meanAndVariance3);
        }
        double mu2 = meanAndVariance3.mean();
        double var2 = meanAndVariance3.variance();
        long n2 = meanAndVariance3.count();
        Tuple3<Double, Double, Long> tuple33 = new Tuple3<Double, Double, Long>(BoxesRunTime.boxToDouble(mu2), BoxesRunTime.boxToDouble(var2), BoxesRunTime.boxToLong(n2));
        Tuple3<Double, Double, Long> tuple34 = tuple33;
        double mu22 = BoxesRunTime.unboxToDouble(tuple34._1());
        double var22 = BoxesRunTime.unboxToDouble(tuple34._2());
        long n22 = BoxesRunTime.unboxToLong(tuple34._3());
        Predef$.MODULE$.require(var12 > 0.0 && var22 > 0.0, (Function0<Object>)(Function0<String> & Serializable)() -> "Two Sample T Test requires that bothsamples have variance > 0");
        double tScore = (mu12 - mu22) / scala.math.package$.MODULE$.sqrt(var12 / (double)n12 + var22 / (double)n22);
        double dof = scala.math.package$.MODULE$.pow(var12 / (double)n12 + var22 / (double)n22, 2.0) / (scala.math.package$.MODULE$.pow(var12, 2.0) / (scala.math.package$.MODULE$.pow(n12, 2.0) * (double)(n12 - 1L)) + scala.math.package$.MODULE$.pow(var22, 2.0) / (scala.math.package$.MODULE$.pow(n22, 2.0) * (double)(n22 - 1L)));
        return new StudentsT(dof, RandBasis$.MODULE$.mt0()).unnormalizedPdf(BoxesRunTime.boxToDouble(tScore));
    }

    public <T> double tTest(Iterable<T> it1, Numeric<T> numeric) {
        return this.tTest(it1.map((Function1<Object, Object> & Serializable)x -> BoxesRunTime.boxToDouble(numeric.toDouble(x))), CanTraverseValues$.MODULE$.canTraverseTraversable());
    }

    public <X> double tTest(X it1, CanTraverseValues<X, Object> ct) {
        meanAndVariance.MeanAndVariance meanAndVariance2 = meanAndVariance$.MODULE$.apply(it1, meanAndVariance$.MODULE$.reduce_Double(ct));
        if (meanAndVariance2 == null) {
            throw new MatchError(meanAndVariance2);
        }
        double mu1 = meanAndVariance2.mean();
        double var1 = meanAndVariance2.variance();
        long n1 = meanAndVariance2.count();
        Tuple3<Double, Double, Long> tuple3 = new Tuple3<Double, Double, Long>(BoxesRunTime.boxToDouble(mu1), BoxesRunTime.boxToDouble(var1), BoxesRunTime.boxToLong(n1));
        Tuple3<Double, Double, Long> tuple32 = tuple3;
        double mu12 = BoxesRunTime.unboxToDouble(tuple32._1());
        double var12 = BoxesRunTime.unboxToDouble(tuple32._2());
        long n12 = BoxesRunTime.unboxToLong(tuple32._3());
        double Z = mu12 / scala.math.package$.MODULE$.sqrt(var12 / (double)n12);
        long dof = n12 - 1L;
        return new StudentsT(dof, RandBasis$.MODULE$.mt0()).unnormalizedPdf(BoxesRunTime.boxToDouble(Z));
    }

    private double chiSquaredTerm(double e, double o) {
        return (e - o) * (e - o) / e;
    }

    public package.Chi2Result chi2Test(int successControl, int trialsControl, int successVariant, int trialsVariant) {
        double meanP = (double)(successControl + successVariant) / (double)(trialsControl + trialsVariant);
        double chi2 = this.chiSquaredTerm(meanP * (double)trialsControl, successControl) + this.chiSquaredTerm((1.0 - meanP) * (double)trialsControl, trialsControl - successControl) + this.chiSquaredTerm(meanP * (double)trialsVariant, successVariant) + this.chiSquaredTerm((1.0 - meanP) * (double)trialsVariant, trialsVariant - successVariant);
        double pVal = 1.0 - new Gamma(0.5, 2.0, RandBasis$.MODULE$.mt0()).cdf(chi2);
        return new package.Chi2Result(chi2, pVal);
    }

    public Seq<package.Chi2Result> chi2Test(Tuple2<Object, Object> control, Seq<Tuple2<Object, Object>> trials) {
        int numTrials = trials.size();
        return (Seq)((IterableOps)trials.map((Function1<Tuple2, package.Chi2Result> & Serializable)x -> MODULE$.chi2Test(control._1$mcI$sp(), control._2$mcI$sp(), x._1$mcI$sp(), x._2$mcI$sp()))).map((Function1<package.Chi2Result, package.Chi2Result> & Serializable)r -> new package.Chi2Result(r.chi2(), MODULE$.sidakCorrectedPVal(r.pVal(), numTrials)));
    }

    public double sidakCorrectedPVal(double p, int n) {
        return 1.0 - scala.math.package$.MODULE$.pow(1.0 - p, n);
    }

    public double sidakCorrectedPValCutoff(double p, int n) {
        return 1.0 - scala.math.package$.MODULE$.pow(1.0 - p, 1.0 / (double)n);
    }

    private package$() {
    }
}

