## Latest Changes

## 1.2.0

### Features

* 🔧 Update Python versions for `mypy` workflow. PR [#603](https://github.com/yezz123/authx/pull/603) by [@yezz123](https://github.com/yezz123).

### Refactors

* 🔧 Remove `no-untyped-def` from disabled error codes. PR [#621](https://github.com/yezz123/authx/pull/621) by [@yezz123](https://github.com/yezz123).
* 🔧 Remove `arg-type` from disabled error codes. PR [#619](https://github.com/yezz123/authx/pull/619) by [@yezz123](https://github.com/yezz123).
* 🔧 Remove `dict-item` from disabled error codes. PR [#617](https://github.com/yezz123/authx/pull/617) by [@yezz123](https://github.com/yezz123).
* 🔧 Remove `call-arg` from disabled error codes. PR [#616](https://github.com/yezz123/authx/pull/616) by [@yezz123](https://github.com/yezz123).
* 🔧 Remove return-value from disabled error codes. PR [#615](https://github.com/yezz123/authx/pull/615) by [@yezz123](https://github.com/yezz123).
* 🔧 Remove `call-overload` from disabled error codes. PR [#613](https://github.com/yezz123/authx/pull/613) by [@yezz123](https://github.com/yezz123).
* 🔧 Remove `type-arg` from disabled error codes. PR [#612](https://github.com/yezz123/authx/pull/612) by [@yezz123](https://github.com/yezz123).
* 🐛  remove `print()` in the release file. PR [#594](https://github.com/yezz123/authx/pull/594) by [@pinchXOXO](https://github.com/pinchXOXO).

### Upgrades

* ⬆️ Bump urllib3 from 2.2.1 to 2.2.2 in /requirements. PR [#622](https://github.com/yezz123/authx/pull/622) by [@dependabot[bot]](https://github.com/apps/dependabot).
* ⬆️ Bump `ruff-pre-commit` from v0.4.8 to v0.4.9. PR [#623](https://github.com/yezz123/authx/pull/623) by [@pre-commit-ci[bot]](https://github.com/apps/pre-commit-ci).
* ⬆️ Bump pypa/gh-action-pypi-publish from 1.8.14 to 1.9.0. PR [#620](https://github.com/yezz123/authx/pull/620) by [@dependabot[bot]](https://github.com/apps/dependabot).
* ⬆️ Bump `ruff-pre-commit` from v0.4.7 to v0.4.8. PR [#601](https://github.com/yezz123/authx/pull/601) by [@pre-commit-ci[bot]](https://github.com/apps/pre-commit-ci).
* ⬆️ Bump the python-packages group with 2 updates. PR [#600](https://github.com/yezz123/authx/pull/600) by [@dependabot[bot]](https://github.com/apps/dependabot).
* ⬆️ Bump `ruff-pre-commit` from v0.4.5 to v0.4.7. PR [#598](https://github.com/yezz123/authx/pull/598) by [@pre-commit-ci[bot]](https://github.com/apps/pre-commit-ci).
* ⬆️ [pre-commit.ci] pre-commit autoupdate. PR [#597](https://github.com/yezz123/authx/pull/597) by [@pre-commit-ci[bot]](https://github.com/apps/pre-commit-ci).
* ⬆️ Bump the python-packages group with 4 updates. PR [#596](https://github.com/yezz123/authx/pull/596) by [@dependabot[bot]](https://github.com/apps/dependabot).
* ⬆️ Update uv version to `0.2.3`. PR [#595](https://github.com/yezz123/authx/pull/595) by [@pinchXOXO](https://github.com/pinchXOXO).

### Docs

* 📝 Update meta information. PR [#614](https://github.com/yezz123/authx/pull/614) by [@yezz123](https://github.com/yezz123).

### Internal

* 🔨 Integrate `mypy` and enhance `typing` in code. PR [#532](https://github.com/yezz123/authx/pull/532) by [@yezz123](https://github.com/yezz123).
* 🔧 Separate CI of testing from Release one . PR [#593](https://github.com/yezz123/authx/pull/593) by [@yezz123](https://github.com/yezz123).

## 1.1.3

### Features

* ♻️ Replaces use of default mutable arguments. PR [#589](https://github.com/yezz123/authx/pull/589) by [@yezz123](https://github.com/yezz123).

### Upgrades

* Bump requests from 2.31.0 to 2.32.2 in /requirements. PR [#592](https://github.com/yezz123/authx/pull/592) by [@dependabot[bot]](https://github.com/apps/dependabot).
* ☔ [pre-commit.ci] pre-commit autoupdate. PR [#590](https://github.com/yezz123/authx/pull/590) by [@pre-commit-ci[bot]](https://github.com/apps/pre-commit-ci).
* ☔ [pre-commit.ci] pre-commit autoupdate. PR [#585](https://github.com/yezz123/authx/pull/585) by [@pre-commit-ci[bot]](https://github.com/apps/pre-commit-ci).
* ⬆️ Bump jinja2 from 3.1.3 to 3.1.4 in /requirements. PR [#584](https://github.com/yezz123/authx/pull/584) by [@dependabot[bot]](https://github.com/apps/dependabot).

### Internal

* 🔧 Update CI workflow, by adding release process. PR [#586](https://github.com/yezz123/authx/pull/586) by [@yezz123](https://github.com/yezz123).
* 🔧 Update build targets & add `hatch-fancy-pypi-readme`. PR [#588](https://github.com/yezz123/authx/pull/588) by [@yezz123](https://github.com/yezz123).
* 🔧 Add codespell hook for spell checking. PR [#587](https://github.com/yezz123/authx/pull/587) by [@yezz123](https://github.com/yezz123).

## 1.1.2

### Docs

* 📝 Update badges and links in README. PR [#583](https://github.com/yezz123/authx/pull/583) by [@yezz123](https://github.com/yezz123).
* 📝  Refactor route decorators to use `@app.get` instead of `@app.route`. PR [#576](https://github.com/yezz123/authx/pull/576) by [@yezz123](https://github.com/yezz123).

### Internal

* 🔧 remove linting step from CI. PR [#578](https://github.com/yezz123/authx/pull/578) by [@yezz123](https://github.com/yezz123).
* :recycle: refactor `datetime` function. PR [#580](https://github.com/yezz123/authx/pull/580) by [@yezz123](https://github.com/yezz123).
* 👷 Add extra job to run additional tests with Redis service. PR [#581](https://github.com/yezz123/authx/pull/581) by [@yezz123](https://github.com/yezz123).

### Dependencies

* ⬆️ Update `uv` version in CI. PR [#582](https://github.com/yezz123/authx/pull/582) by [@pinchXOXO](https://github.com/pinchXOXO).
* [pre-commit.ci] pre-commit autoupdate. PR [#579](https://github.com/yezz123/authx/pull/579) by [@pre-commit-ci[bot]](https://github.com/apps/pre-commit-ci).

## 1.1.1

### Internal

* ✅ Fix skipped tests & Add coverage pragmas. PR [#571](https://github.com/yezz123/authx/pull/571) by [@yezz123](https://github.com/yezz123).
* 🔧 drop The action `hynek/build-and-inspect-python-package`. PR [#570](https://github.com/yezz123/authx/pull/570) by [@yezz123](https://github.com/yezz123).

### Dependencies

* ⬆️ Upgrade Pydantic version. PR [#574](https://github.com/yezz123/authx/pull/574) by [@yezz123](https://github.com/yezz123).
* ⬆️  Bump `idna` from 3.6 to 3.7. PR [#573](https://github.com/yezz123/authx/pull/573) by [@dependabot[bot]](https://github.com/apps/dependabot).

### Documentation

* ♻️ Refactor Installation of `authx_extra` package. PR [#575](https://github.com/yezz123/authx/pull/575) by [@yezz123](https://github.com/yezz123).
* 📝 Add extra API documentation files. PR [#569](https://github.com/yezz123/authx/pull/569) by [@yezz123](https://github.com/yezz123).

## 1.1.0

### Core

* ✨ Add FastAPI dependencies for token operations in route logic. PR [#566](https://github.com/yezz123/authx/pull/566) by [@yezz123](https://github.com/yezz123).
* ♻️ Refactor error message constants. PR [#565](https://github.com/yezz123/authx/pull/565) by [@yezz123](https://github.com/yezz123).

### Internal

* ✅ Add new test cases for access location and blocklist token. PR [#568](https://github.com/yezz123/authx/pull/568) by [@yezz123](https://github.com/yezz123).

### Dependencies

* ⬆️ Bump dependencies in requirements files. PR [#567](https://github.com/yezz123/authx/pull/567) by [@yezz123](https://github.com/yezz123).
* ⬆️ Bump pillow from 10.2.0 to 10.3.0 in /requirements. PR [#564](https://github.com/yezz123/authx/pull/564) by [@dependabot[bot]](https://github.com/apps/dependabot).

## 1.0.0

### Core

* ✨ AuthX Revamp - V1.0.0. PR [#446](https://github.com/yezz123/authx/pull/446) by [@yezz123](https://github.com/yezz123)
* ♻️ Refactor & Rebuild Functionalities in authx. PR [#454](https://github.com/yezz123/authx/pull/454) by [@yezz123](https://github.com/yezz123)
* ✨ Migrate Authx to use pydantic v2. PR [#531](https://github.com/yezz123/authx/pull/531) by [@yezz123](https://github.com/yezz123)
* ✨ Handle catch-all signature errors. PR [#538](https://github.com/yezz123/authx/pull/538) by [@yezz123](https://github.com/yezz123)
* ♻️ Drop External Libraries in favour of `authx-extra`. PR [#506](https://github.com/yezz123/authx/pull/506) by [@yezz123](https://github.com/yezz123)

### Internal

* 🐛 fix Continuous Integration Badge. PR [#455](https://github.com/yezz123/authx/pull/455) by [@yezz123](https://github.com/yezz123)
* ♻️ use pip-tool to autogenerate dependencies. PR [#478](https://github.com/yezz123/authx/pull/478) by [@yezz123](https://github.com/yezz123)
* 🔧 Run tests against `py38`. PR [#480](https://github.com/yezz123/authx/pull/480) by [@yezz123](https://github.com/yezz123)
* ✨ add support for ruff linter. PR [#497](https://github.com/yezz123/authx/pull/497) by [@yezz123](https://github.com/yezz123)
* 🔧 Group dependencies on dependabot updates. PR [#523](https://github.com/yezz123/authx/pull/523) by [@yezz123](https://github.com/yezz123)
* 👷 Add setup for uv and use uv for dependency installation. PR [#537](https://github.com/yezz123/authx/pull/537) by [@yezz123](https://github.com/yezz123)
* 💸 Add Support for Polar. PR [#536](https://github.com/yezz123/authx/pull/536) by [@yezz123](https://github.com/yezz123)
* ✅ Add test case for garbage collection of old sessions. PR [#539](https://github.com/yezz123/authx/pull/539) by [@yezz123](https://github.com/yezz123)
* 🍻 Add tests for several functions & Bump coverage. PR [#540](https://github.com/yezz123/authx/pull/540) by [@yezz123](https://github.com/yezz123)
* 🔨 Update `setup-uv` and specify virtual environment path. PR [#542](https://github.com/yezz123/authx/pull/542) by [@yezz123](https://github.com/yezz123)
* 🍱 update `pydantic` classifiers from v1 to v2. PR [#545](https://github.com/yezz123/authx/pull/545) by [@yezz123](https://github.com/yezz123)
* 🔨 Update script to use uv instead of pip-compile. PR [#549](https://github.com/yezz123/authx/pull/549) by [@yezz123](https://github.com/yezz123)
* 👷 Add uv-version for uv action. PR [#551](https://github.com/yezz123/authx/pull/551) by [@yezz123](https://github.com/yezz123)
* 🔨 Add Latest Changes workflow. PR [#562](https://github.com/yezz123/authx/pull/562) by [@yezz123](https://github.com/yezz123)

### Documentation

* 📝 overrides template & Include google analytics. PR [#482](https://github.com/yezz123/authx/pull/482) by [@yezz123](https://github.com/yezz123)
* 📝 Add Extra documentation to AuthX. PR [#483](https://github.com/yezz123/authx/pull/483) by [@yezz123](https://github.com/yezz123)
* 📝 Update `OAuth2` external middleware. PR [#514](https://github.com/yezz123/authx/pull/514) by [@yezz123](https://github.com/yezz123)
* 📝 Add Basic Documentation for AuthX core. PR [#513](https://github.com/yezz123/authx/pull/513) by [@yezz123](https://github.com/yezz123)
* 📝 Add `mkdocstrings` to mkdocs configuration. PR [#552](https://github.com/yezz123/authx/pull/552) by [@yezz123](https://github.com/yezz123)
* ♻️ refactor documentation. PR [#557](https://github.com/yezz123/authx/pull/557) by [@yezz123](https://github.com/yezz123)
* 📝 Add guide on accessing payload data in routes. PR [#558](https://github.com/yezz123/authx/pull/558) by [@yezz123](https://github.com/yezz123)
* ✨ Add Documentation & Fix Linting Rules. PR [#559](https://github.com/yezz123/authx/pull/559) by [@yezz123](https://github.com/yezz123)
* ✨ Update social plugin configuration. PR [#561](https://github.com/yezz123/authx/pull/561) by [@yezz123](https://github.com/yezz123)

### Dependencies

* ⬆️ Update typing-extensions requirement from <4.6.0,>=3.7.4 to >=3.7.4,<4.7.0. PR [#458](https://github.com/yezz123/authx/pull/458) by @dependabot
* ⬆️ Bump itsdangerous from 2.0.1 to 2.1.2. PR [#457](https://github.com/yezz123/authx/pull/457) by @dependabot
* ⬆️ Bump sqlalchemy from 1.4.37 to 2.0.15. PR [#456](https://github.com/yezz123/authx/pull/456) by @dependabot
* ⬆️ Update fastapi requirement from <0.96.0,>=0.65.2 to >=0.65.2,<0.97.0. PR [#463](https://github.com/yezz123/authx/pull/463) by @dependabot
* ⬆️ Update starlette requirement from <0.27.1,>=0.14.02 to >=0.14.02,<0.28.1. PR [#468](https://github.com/yezz123/authx/pull/468) by @dependabot
* ⬆️ Update pyinstrument requirement from <4.5.0,>=4.1.1 to >=4.1.1,<4.6.0. PR [#466](https://github.com/yezz123/authx/pull/466) by @dependabot
* ⬆️ Bump pytest from 7.3.1 to 7.3.2. PR [#464](https://github.com/yezz123/authx/pull/464) by @dependabot
* ⬆️ Bump sqlalchemy from 2.0.15 to 2.0.16. PR [#465](https://github.com/yezz123/authx/pull/465) by @dependabot
* ⬆️ Update fastapi requirement from <0.97.0,>=0.65.2 to >=0.65.2,<0.98.0. PR [#467](https://github.com/yezz123/authx/pull/467) by @dependabot
* ⬆️ Bump pre-commit from 3.3.2 to 3.3.3. PR [#469](https://github.com/yezz123/authx/pull/469) by @dependabot
* ⬆️ Bump sqlalchemy from 2.0.16 to 2.0.17. PR [#471](https://github.com/yezz123/authx/pull/471) by @dependabot
* ⬆️ Bump mypy from 1.3.0 to 1.4.0. PR [#472](https://github.com/yezz123/authx/pull/472) by @dependabot
* ⬆️ Bump pytest from 7.3.2 to 7.4.0. PR [#473](https://github.com/yezz123/authx/pull/473) by @dependabot
* ⬆️ Update fastapi requirement from <0.98.0,>=0.65.2 to >=0.65.2,<0.99.0. PR [#474](https://github.com/yezz123/authx/pull/474) by @dependabot
* ⬆️ Update redis requirement from <4.5.6,>=4.3.3 to >=4.3.3,<4.6.1. PR [#477](https://github.com/yezz123/authx/pull/477) by @dependabot
* ⬆️ Bump mypy from 1.4.0 to 1.4.1. PR [#476](https://github.com/yezz123/authx/pull/476) by @dependabot
* ⬆️ Bump pypa/gh-action-pypi-publish from 1.8.6 to 1.8.7. PR [#479](https://github.com/yezz123/authx/pull/479) by @dependabot
* ⬆️️ Bump cryptography from 41.0.1 to 41.0.2. PR [#485](https://github.com/yezz123/authx/pull/485) by @dependabot
* ⬆️ Bump pypa/gh-action-pypi-publish from 1.8.7 to 1.8.8. PR [#486](https://github.com/yezz123/authx/pull/486) by @dependabot
* ⬆️️ Bump certifi from 2023.5.7 to 2023.7.22. PR [#487](https://github.com/yezz123/authx/pull/487) by @dependabot
* ⬆️️ Bump cryptography from 41.0.2 to 41.0.3. PR [#488](https://github.com/yezz123/authx/pull/488) by @dependabot
* ⬆️ Bump pypa/gh-action-pypi-publish from 1.8.8 to 1.8.10. PR [#489](https://github.com/yezz123/authx/pull/489) by @dependabot
* ⬆️ Bump actions/checkout from 3 to 4. PR [#491](https://github.com/yezz123/authx/pull/491) by @dependabot
* ⬆️️ Upgrade Dependencies. PR [#492](https://github.com/yezz123/authx/pull/492) by [@yezz123](https://github.com/yezz123)
* ⬆️️ Bump urllib3 from 2.0.5 to 2.0.6. PR [#493](https://github.com/yezz123/authx/pull/493) by @dependabot
* ⬆️️ Include Python 3.12. PR [#494](https://github.com/yezz123/authx/pull/494) by [@yezz123](https://github.com/yezz123)
* ⬆️️ Bump urllib3 from 2.0.6 to 2.0.7. PR [#495](https://github.com/yezz123/authx/pull/495) by @dependabot
* ⬆️️ Bump cryptography from 41.0.4 to 41.0.6. PR [#498](https://github.com/yezz123/authx/pull/498) by @dependabot
* ⬆️ Bump pypa/gh-action-pypi-publish from 1.8.10 to 1.8.11. PR [#499](https://github.com/yezz123/authx/pull/499) by @dependabot
* ⬆️ Upgrade Dependencies. PR [#500](https://github.com/yezz123/authx/pull/500) by [@yezz123](https://github.com/yezz123)
* ⬆️ Bump actions/setup-python from 4 to 5. PR [#503](https://github.com/yezz123/authx/pull/503) by @dependabot
* ⬆️️ Bump jinja2 from 3.1.2 to 3.1.3. PR [#505](https://github.com/yezz123/authx/pull/505) by @dependabot
* ⬆️ Bump ruff from 0.1.8 to 0.1.13. PR [#510](https://github.com/yezz123/authx/pull/510) by @dependabot
* ⬆️ Bump fastapi from 0.98.0 to 0.109.0. PR [#509](https://github.com/yezz123/authx/pull/509) by @dependabot
* ⬆️ Bump black from 23.12.0 to 23.12.1. PR [#508](https://github.com/yezz123/authx/pull/508) by @dependabot
* ⬆️ Bump ruff from 0.1.13 to 0.1.14. PR [#515](https://github.com/yezz123/authx/pull/515) by @dependabot
* ⬆️ Bump mkdocs-material from 9.5.3 to 9.5.4. PR [#517](https://github.com/yezz123/authx/pull/517) by @dependabot
* ⬆️ Bump mypy from 1.7.1 to 1.8.0. PR [#516](https://github.com/yezz123/authx/pull/516) by @dependabot
* ⬆️ Bump black from 23.12.1 to 24.1.1. PR [#519](https://github.com/yezz123/authx/pull/519) by @dependabot
* ⬆️ Bump mkdocs-material from 9.5.4 to 9.5.6. PR [#521](https://github.com/yezz123/authx/pull/521) by @dependabot
* ⬆️ Bump pytest-asyncio from 0.23.3 to 0.23.4. PR [#520](https://github.com/yezz123/authx/pull/520) by @dependabot
* ⬆️ Bump codecov/codecov-action from 3 to 4. PR [#524](https://github.com/yezz123/authx/pull/524) by @dependabot
* ⬆️ Bump the python-packages group with 3 updates. PR [#525](https://github.com/yezz123/authx/pull/525) by @dependabot
* ⬆️️ Upgrade configuration for Ruff v0.2.0. PR [#526](https://github.com/yezz123/authx/pull/526) by [@yezz123](https://github.com/yezz123)
* ⬆️ Bump the python-packages group with 3 updates. PR [#527](https://github.com/yezz123/authx/pull/527) by @dependabot
* ⬆️️ Bump fastapi from 0.98.0 to 0.109.2. PR [#529](https://github.com/yezz123/authx/pull/529) by @dependabot
* ⬆️️ Bump cryptography from 41.0.7 to 42.0.0. PR [#530](https://github.com/yezz123/authx/pull/530) by @dependabot
* ⬆️ Bump the python-packages group with 3 updates. PR [#535](https://github.com/yezz123/authx/pull/535) by @dependabot
* ⬆️ Bump pre-commit/action from 3.0.0 to 3.0.1. PR [#534](https://github.com/yezz123/authx/pull/534) by @dependabot
* ⬆️ Bump the python-packages group with 6 updates. PR [#541](https://github.com/yezz123/authx/pull/541) by @dependabot
* ⬆️️ Update version for uv. PR [#546](https://github.com/yezz123/authx/pull/546) by [@yezz123](https://github.com/yezz123)
* ⬆️ Bump the python-packages group with 5 updates. PR [#548](https://github.com/yezz123/authx/pull/548) by @dependabot
* ⬆️ Bump pypa/gh-action-pypi-publish from 1.8.11 to 1.8.12. PR [#550](https://github.com/yezz123/authx/pull/550) by @dependabot
* ⬆️ Bump uv version to 0.1.17. PR [#554](https://github.com/yezz123/authx/pull/554) by [@pinchXOXO](https://github.com/pinchXOXO)
* ⬆️ Bump pypa/gh-action-pypi-publish from 1.8.12 to 1.8.14. PR [#556](https://github.com/yezz123/authx/pull/556) by @dependabot

## 1.0.1b1

!!! warning
    This is a beta release. Please do not use in production.

### Documentations

* 📝 Add Basic Documentation for AuthX core. PR [#513](https://github.com/yezz123/authx/pull/513) by [@yezz123](https://github.com/yezz123).
* 📝 Add Documentation for AuthX core. PR [#562](https://github.com/yezz123/authx/pull/562) by [@yezz123](https://github.com/yezz123).

### Core

* ✨ Migrate Authx to use pydantic v2. PR [#531](https://github.com/yezz123/authx/pull/531) by [@yezz123](https://github.com/yezz123).
* ✨ Handle catch-all signature errors. PR [#538](https://github.com/yezz123/authx/pull/538) by [@yezz123](https://github.com/yezz123).
* ✅ Add test case for garbage collection of old sessions. PR [#539](https://github.com/yezz123/authx/pull/539) by [@yezz123](https://github.com/yezz123).
* 🍻 Add tests for several functions & Bump coverage. PR [#540](https://github.com/yezz123/authx/pull/540) by [@yezz123](https://github.com/yezz123).

### CI/CD

* 💸 Add Support for Polar. PR [#536](https://github.com/yezz123/authx/pull/536) by [@yezz123](https://github.com/yezz123).
* 👷 Add setup for uv and use uv for dependency installation. PR [#537](https://github.com/yezz123/authx/pull/537) by [@yezz123](https://github.com/yezz123).
* 🔨 Update `setup-uv` and specify virtual environment path. PR [#542](https://github.com/yezz123/authx/pull/542) by [@yezz123](https://github.com/yezz123).

### Dependencies

* ⬆ Bump the python-packages group with 3 updates. PR [#535](https://github.com/yezz123/authx/pull/535) by @dependabot.
* ⬆ Bump pre-commit/action from 3.0.0 to 3.0.1. PR [#534](https://github.com/yezz123/authx/pull/534) by @dependabot.
* ⬆ Bump the python-packages group with 6 updates. PR [#541](https://github.com/yezz123/authx/pull/541) by @dependabot.

## 1.0.0b0

!!! warning
    This is a beta release. Please do not use in production.

<!-- package description limit -->

### Major Changes 🚑️

* ➖ Remove Documentation Workflow. PR [#414](https://github.com/yezz123/authx/pull/414) by [@yezz123](https://github.com/yezz123).
* ♻️ chore(revamp): AuthX Revamp - V1.0.0. PR [#446](https://github.com/yezz123/authx/pull/446) by [@yezz123](https://github.com/yezz123).
* 🔧 Feat: Refactor & Rebuild Functionalities in authx. PR [#454](https://github.com/yezz123/authx/pull/454) by [@yezz123](https://github.com/yezz123).
* 🐛 fix Continuous Integration Badge. [PR #455](https://github.com/yezz123/authx/pull/455) by [@yezz123](https://github.com/yezz123).
* ♻️ use pip-tool to autogenerate dependencies[PR #478](https://github.com/yezz123/authx/pull/478) by [@yezz123](https://github.com/yezz123)
* 🔧 Run tests against `py38`. [PR #480](https://github.com/yezz123/authx/pull/480) by [@yezz123](https://github.com/yezz123)
* 📝 overrides template & Include google analytics. [PR #482](https://github.com/yezz123/authx/pull/482) by [@yezz123](https://github.com/yezz123)
* 📝 Add Extra documentation to AuthX. [PR #483](https://github.com/yezz123/authx/pull/483) by [@yezz123](https://github.com/yezz123)
* 🔧 Include Python 3.12. [PR #494](https://github.com/yezz123/authx/pull/494) by [@yezz123](https://github.com/yezz123)
* ✨ add support for ruff linter. [PR #497](https://github.com/yezz123/authx/pull/497) by [@yezz123](https://github.com/yezz123)
* ♻️ Drop External Libraries in favour of `authx-extra`. [PR #506](https://github.com/yezz123/authx/pull/506) by [@yezz123](https://github.com/yezz123)

## 0.9.1

### Fixes 🐛

* Remove Documentation Workflow by @yezz123. PR [#414](https://github.com/yezz123/authx/pull/414) by @yezz123.

### Dependencies 📦

* Update sqlalchemy requirement from <2.0.4,>=1.4.37 to >=1.4.37,<2.0.5 by @dependabot. PR [#370](https://github.com/yezz123/authx/pull/370) by @dependabot.
* Bump pre-commit from 3.0.4 to 3.1.0 by @dependabot. PR [#371](https://github.com/yezz123/authx/pull/371) by @dependabot.
* Bump pre-commit from 3.1.0 to 3.1.1 by @dependabot. PR [#372](https://github.com/yezz123/authx/pull/372) by @dependabot.
* Bump cryptography from 39.0.1 to 39.0.2 by @dependabot. PR [#373](https://github.com/yezz123/authx/pull/373) by @dependabot.
* Update sqlalchemy requirement from <2.0.5,>=1.4.37 to >=1.4.37,<2.0.6 by @dependabot. PR [#374](https://github.com/yezz123/authx/pull/374) by @dependabot.
* Bump pymdown-extensions from 9.9.2 to 9.10 by @dependabot. PR [#375](https://github.com/yezz123/authx/pull/375) by @dependabot.
* Bump pytest from 7.2.1 to 7.2.2 by @dependabot. PR [#376](https://github.com/yezz123/authx/pull/376) by @dependabot.
* Update fastapi requirement from <0.93.0,>=0.65.2 to >=0.65.2,<0.94.0 by @dependabot. PR [#380](https://github.com/yezz123/authx/pull/380) by @dependabot.
* Bump pydantic from 1.10.5 to 1.10.6 by @dependabot. PR [#381](https://github.com/yezz123/authx/pull/381) by @dependabot.
* Bump uvicorn from 0.20.0 to 0.21.0 by @dependabot. PR [#382](https://github.com/yezz123/authx/pull/382) by @dependabot.
* Update starlette requirement from <0.25.1,>=0.14.02 to >=0.14.02,<0.26.1 by @dependabot. PR [#383](https://github.com/yezz123/authx/pull/383) by @dependabot.
* Update fastapi requirement from <0.94.0,>=0.65.2 to >=0.65.2,<0.95.0 by @dependabot. PR [#385](https://github.com/yezz123/authx/pull/385) by @dependabot.
* Bump pypa/gh-action-pypi-publish from 1.6.4 to 1.7.1 by @dependabot. PR [#386](https://github.com/yezz123/authx/pull/386) by @dependabot.
* Update sqlalchemy requirement from <2.0.6,>=1.4.37 to >=1.4.37,<2.0.7 by @dependabot. PR [#387](https://github.com/yezz123/authx/pull/387) by @dependabot.
* Update starlette requirement from <0.26.1,>=0.14.02 to >=0.14.02,<0.26.2 by @dependabot. PR [#388](https://github.com/yezz123/authx/pull/388) by @dependabot.
* Bump pypa/gh-action-pypi-publish from 1.7.1 to 1.8.0 by @dependabot. PR [#389](https://github.com/yezz123/authx/pull/389) by @dependabot.
* Bump uvicorn from 0.21.0 to 0.21.1 by @dependabot. PR [#390](https://github.com/yezz123/authx/pull/390) by @dependabot.
* Update python-socketio requirement from <5.7.3,>=4.6.0 to >=4.6.0,<5.8.1 by @dependabot. PR [#391](https://github.com/yezz123/authx/pull/391) by @dependabot.
* Bump pypa/gh-action-pypi-publish from 1.8.0 to 1.8.1 by @dependabot. PR [#392](https://github.com/yezz123/authx/pull/392) by @dependabot.
* Bump pre-commit from 3.1.1 to 3.2.0 by @dependabot. PR [#394](https://github.com/yezz123/authx/pull/394) by @dependabot.
* Bump pytest-asyncio from 0.20.3 to 0.21.0 by @dependabot. PR [#395](https://github.com/yezz123/authx/pull/395) by @dependabot.
* Update fastapi requirement from <0.95.0,>=0.65.2 to >=0.65.2,<0.96.0 by @dependabot. PR [#396](https://github.com/yezz123/authx/pull/396) by @dependabot.
* Update sqlalchemy requirement from <2.0.7,>=1.4.37 to >=1.4.37,<2.0.8 by @dependabot. PR [#397](https://github.com/yezz123/authx/pull/397) by @dependabot.
* Update redis requirement from <4.5.2,>=4.3.3 to >=4.3.3,<4.5.3 by @dependabot. PR [#398](https://github.com/yezz123/authx/pull/398) by @dependabot.
* Bump pydantic from 1.10.6 to 1.10.7 by @dependabot. PR [#399](https://github.com/yezz123/authx/pull/399) by @dependabot.
* Update redis requirement from <4.5.3,>=4.3.3 to >=4.3.3,<4.5.4 by @dependabot. PR [#400](https://github.com/yezz123/authx/pull/400) by @dependabot.
* Bump pypa/gh-action-pypi-publish from 1.8.1 to 1.8.3 by @dependabot. PR [#401](https://github.com/yezz123/authx/pull/401) by @dependabot.
* Bump cryptography from 39.0.2 to 40.0.0 by @dependabot. PR [#402](https://github.com/yezz123/authx/pull/402) by @dependabot.
* Bump cryptography from 40.0.0 to 40.0.1 by @dependabot. PR [#404](https://github.com/yezz123/authx/pull/404) by @dependabot.
* Bump pre-commit from 3.2.0 to 3.2.1 by @dependabot. PR [#405](https://github.com/yezz123/authx/pull/405) by @dependabot.
* Bump pytz from 2022.7.1 to 2023.2 by @dependabot. PR [#403](https://github.com/yezz123/authx/pull/403) by @dependabot.
* Bump pytz from 2023.2 to 2023.3 by @dependabot. PR [#406](https://github.com/yezz123/authx/pull/406) by @dependabot.
* Update redis requirement from <4.5.4,>=4.3.3 to >=4.3.3,<4.5.5 by @dependabot. PR [#407](https://github.com/yezz123/authx/pull/407) by @dependabot.
* Update sqlalchemy requirement from <2.0.8,>=1.4.37 to >=1.4.37,<2.0.9 by @dependabot. PR [#408](https://github.com/yezz123/authx/pull/408) by @dependabot.
* Bump pypa/gh-action-pypi-publish from 1.8.3 to 1.8.4 by @dependabot. PR [#410](https://github.com/yezz123/authx/pull/410) by @dependabot.
* Bump websockets from 10.4 to 11.0 by @dependabot. PR [#409](https://github.com/yezz123/authx/pull/409) by @dependabot.
* Bump pre-commit from 3.2.1 to 3.2.2 by @dependabot. PR [#411](https://github.com/yezz123/authx/pull/411) by @dependabot.
* Bump motor from 3.1.1 to 3.1.2 by @dependabot. PR [#412](https://github.com/yezz123/authx/pull/412) by @dependabot.
* Bump pypa/gh-action-pypi-publish from 1.8.4 to 1.8.5 by @dependabot. PR [#413](https://github.com/yezz123/authx/pull/413) by @dependabot.
* Update sqlalchemy requirement from <2.0.9,>=1.4.37 to >=1.4.37,<2.0.10 by @dependabot. PR [#415](https://github.com/yezz123/authx/pull/415) by @dependabot.
* Bump websockets from 11.0 to 11.0.1 by @dependabot. PR [#416](https://github.com/yezz123/authx/pull/416) by @dependabot.
* Bump pytest from 7.2.2 to 7.3.0 by @dependabot. PR [#417](https://github.com/yezz123/authx/pull/417) by @dependabot.
* Bump pymdown-extensions from 9.10 to 9.11 by @dependabot. PR [#418](https://github.com/yezz123/authx/pull/418) by @dependabot.
* Bump httpx from 0.23.3 to 0.24.0 by @dependabot. PR [#419](https://github.com/yezz123/authx/pull/419) by @dependabot.
* Update email-validator requirement from <1.3.2,>=1.1.0 to >=1.1.0,<2.0.1 by @dependabot. PR [#420](https://github.com/yezz123/authx/pull/420) by @dependabot.
* Bump pytest from 7.3.0 to 7.3.1 by @dependabot. PR [#421](https://github.com/yezz123/authx/pull/421) by @dependabot.
* Bump websockets from 11.0.1 to 11.0.2 by @dependabot. PR [#424](https://github.com/yezz123/authx/pull/424) by @dependabot.
* Bump cryptography from 40.0.1 to 40.0.2 by @dependabot. PR [#422](https://github.com/yezz123/authx/pull/422) by @dependabot.
* Update sqlalchemy requirement from <2.0.10,>=1.4.37 to >=1.4.37,<2.0.11 by @dependabot. PR [#425](https://github.com/yezz123/authx/pull/425) by @dependabot.
* Update sqlalchemy requirement from <2.0.11,>=1.4.37 to >=1.4.37,<2.0.12 by @dependabot. PR [#426](https://github.com/yezz123/authx/pull/426) by @dependabot.
* Bump requests from 2.28.2 to 2.29.0 by @dependabot. PR [#427](https://github.com/yezz123/authx/pull/427) by @dependabot.
* Bump uvicorn from 0.21.1 to 0.22.0 by @dependabot. PR [#428](https://github.com/yezz123/authx/pull/428) by @dependabot.
* Update sqlalchemy requirement from <2.0.12,>=1.4.37 to >=1.4.37,<2.0.13 by @dependabot. PR [#429](https://github.com/yezz123/authx/pull/429) by @dependabot.
* Bump pre-commit from 3.2.2 to 3.3.0 by @dependabot. PR [#430](https://github.com/yezz123/authx/pull/430) by @dependabot.
* Bump pypa/gh-action-pypi-publish from 1.8.5 to 1.8.6 by @dependabot. PR [#432](https://github.com/yezz123/authx/pull/432) by @dependabot.
* Bump pre-commit from 3.3.0 to 3.3.1 by @dependabot. PR [#431](https://github.com/yezz123/authx/pull/431) by @dependabot.
* Bump requests from 2.29.0 to 2.30.0 by @dependabot. PR [#433](https://github.com/yezz123/authx/pull/433) by @dependabot.
* Update redis requirement from <4.5.5,>=4.3.3 to >=4.3.3,<4.5.6 by @dependabot. PR [#435](https://github.com/yezz123/authx/pull/435) by @dependabot.
* Bump websockets from 11.0.2 to 11.0.3 by @dependabot. PR [#434](https://github.com/yezz123/authx/pull/434) by @dependabot.
* Bump pyjwt from 2.6.0 to 2.7.0 by @dependabot. PR [#436](https://github.com/yezz123/authx/pull/436) by @dependabot.
* Update sqlalchemy requirement from <2.0.13,>=1.4.37 to >=1.4.37,<2.0.14 by @dependabot. PR [#437](https://github.com/yezz123/authx/pull/437) by @dependabot.
* Bump pymdown-extensions from 9.11 to 10.0 by @dependabot. PR [#438](https://github.com/yezz123/authx/pull/438) by @dependabot.
* Bump starlette from 0.25.0 to 0.27.0 in /tests/middleware/example by @dependabot. PR [#439](https://github.com/yezz123/authx/pull/439) by @dependabot.
* Bump pymdown-extensions from 10.0 to 10.0.1 by @dependabot. PR [#440](https://github.com/yezz123/authx/pull/440) by @dependabot.
* Update starlette requirement from <0.26.2,>=0.14.02 to >=0.14.02,<0.27.1 by @dependabot. PR [#441](https://github.com/yezz123/authx/pull/441) by @dependabot.
* Bump pre-commit from 3.3.1 to 3.3.2 by @dependabot. PR [#442](https://github.com/yezz123/authx/pull/442) by @dependabot.
* Update sqlalchemy requirement from <2.0.14,>=1.4.37 to >=1.4.37,<2.0.15 by @dependabot. PR [#444](https://github.com/yezz123/authx/pull/444) by @dependabot.
* Bump httpx from 0.24.0 to 0.24.1 by @dependabot. PR [#443](https://github.com/yezz123/authx/pull/443) by @dependabot.
* Update sqlalchemy requirement from <2.0.15,>=1.4.37 to >=1.4.37,<2.0.16 by @dependabot. PR [#445](https://github.com/yezz123/authx/pull/445) by @dependabot.
* Bump requests from 2.30.0 to 2.31.0 by @dependabot. PR [#450](https://github.com/yezz123/authx/pull/450) by @dependabot.
* Bump pytest-cov from 4.0.0 to 4.1.0 by @dependabot. PR [#452](https://github.com/yezz123/authx/pull/452) by @dependabot.
* Bump cryptography from 40.0.2 to 41.0.0 by @dependabot. PR [#453](https://github.com/yezz123/authx/pull/453) by @dependabot.

## 0.9.0

### Internal

* Support Python 3.11 by @yezz123. PR [#355](https://github.com/yezz123/authx/pull/355) by @yezz123.
* Support `aioredis` from redis package by @yezz123. PR [#369](https://github.com/yezz123/authx/pull/369) by @yezz123.

### Dependencies

* Update email-validator requirement from <1.3.1,>=1.1.0 to >=1.1.0,<1.3.2 by @dependabot. PR [#347](https://github.com/yezz123/authx/pull/347) by @dependabot.
* Bump pymdown-extensions from 9.9.1 to 9.9.2 by @dependabot. PR [#346](https://github.com/yezz123/authx/pull/346) by @dependabot.
* Bump pre-commit from 2.21.0 to 3.0.0 by @dependabot. PR [#348](https://github.com/yezz123/authx/pull/348) by @dependabot.
* Update sqlalchemy requirement from <1.4.47,>=1.4.37 to >=1.4.37,<2.0.1 by @dependabot. PR [#350](https://github.com/yezz123/authx/pull/350) by @dependabot.
* Bump pre-commit from 3.0.0 to 3.0.1 by @dependabot. PR [#349](https://github.com/yezz123/authx/pull/349) by @dependabot.
* Bump pre-commit from 3.0.1 to 3.0.4 by @dependabot. PR [#354](https://github.com/yezz123/authx/pull/354) by @dependabot.
* Update sqlalchemy requirement from <2.0.1,>=1.4.37 to >=1.4.37,<2.0.2 by @dependabot. PR [#353](https://github.com/yezz123/authx/pull/353) by @dependabot.
* Update starlette requirement from <0.23.2,>=0.14.02 to >=0.14.02,<0.24.1 by @dependabot. PR [#356](https://github.com/yezz123/authx/pull/356) by @dependabot.
* Update sqlalchemy requirement from <2.0.2,>=1.4.37 to >=1.4.37,<2.0.3 by @dependabot. PR [#357](https://github.com/yezz123/authx/pull/357) by @dependabot.
* Bump cryptography from 39.0.0 to 39.0.1 by @dependabot. PR [#358](https://github.com/yezz123/authx/pull/358) by @dependabot.
* Update redis requirement from <4.4.3,>=4.3.3 to >=4.3.3,<4.5.1 by @dependabot. PR [#359](https://github.com/yezz123/authx/pull/359) by @dependabot.
* Bump markdown-include from 0.8.0 to 0.8.1 by @dependabot. PR [#360](https://github.com/yezz123/authx/pull/360) by @dependabot.
* Update fastapi requirement from <0.90.0,>=0.65.2 to >=0.65.2,<0.91.0 by @dependabot. PR [#361](https://github.com/yezz123/authx/pull/361) by @dependabot.
* Update redis requirement from <4.5.1,>=4.3.3 to >=4.3.3,<4.5.2 by @dependabot. PR [#362](https://github.com/yezz123/authx/pull/362) by @dependabot.
* Update sqlalchemy requirement from <2.0.3,>=1.4.37 to >=1.4.37,<2.0.4 by @dependabot. PR [#363](https://github.com/yezz123/authx/pull/363) by @dependabot.
* Update fastapi requirement from <0.91.0,>=0.65.2 to >=0.65.2,<0.92.0 by @dependabot. PR [#364](https://github.com/yezz123/authx/pull/364) by @dependabot.
* Update starlette requirement from <0.24.1,>=0.14.02 to >=0.14.02,<0.25.1 by @dependabot. PR [#366](https://github.com/yezz123/authx/pull/366) by @dependabot.
* Update fastapi requirement from <0.92.0,>=0.65.2 to >=0.65.2,<0.93.0 by @dependabot. PR [#367](https://github.com/yezz123/authx/pull/367) by @dependabot.
* Bump pydantic from 1.10.4 to 1.10.5 by @dependabot. PR [#368](https://github.com/yezz123/authx/pull/368) by @dependabot.
* Bump starlette from 0.17.1 to 0.25.0 in /tests/middleware/example by @dependabot. PR [#365](https://github.com/yezz123/authx/pull/365) by @dependabot.

## 0.8.3

### Fixes

* Fixes a few imports in the documentation by @alobbs. PR [#343](https://github.com/yezz123/authx/pull/343) by @alobbs.
* Use Ruff for linting by @yezz123. PR [#344](https://github.com/yezz123/authx/pull/344) by @yezz123.

### Docs

* Add @alobbs as a contributor for doc by @allcontributors. PR [#345](https://github.com/yezz123/authx/pull/345) by @allcontributors.

### Dependencies

* Bump pymdown-extensions from 9.9 to 9.9.1 by @dependabot. PR [#338](https://github.com/yezz123/authx/pull/338) by @dependabot.
* Update redis requirement from <4.4.2,>=4.3.3 to >=4.3.3,<4.4.3 by @dependabot. PR [#337](https://github.com/yezz123/authx/pull/337) by @dependabot.
* Bump requests from 2.28.1 to 2.28.2 by @dependabot. PR [#339](https://github.com/yezz123/authx/pull/339) by @dependabot.
* Bump pytz from 2022.7 to 2022.7.1 by @dependabot. PR [#340](https://github.com/yezz123/authx/pull/340) by @dependabot.
* Bump pytest from 7.2.0 to 7.2.1 by @dependabot. PR [#341](https://github.com/yezz123/authx/pull/341) by @dependabot.

## 0.8.2

### Dependencies

* Bump jinja2 from 3.0.3 to 3.1.2 by @dependabot. PR [#268](https://github.com/yezz123/authx/pull/268) by @dependabot.
* Bump databases from 0.6.0 to 0.6.1 by @dependabot. PR [#270](https://github.com/yezz123/authx/pull/270) by @dependabot.
* Update email-validator requirement from <1.2.1,>=1.1.0 to >=1.1.0,<1.3.1 by @dependabot. PR [#271](https://github.com/yezz123/authx/pull/271) by @dependabot.
* Bump pytz from 2022.1 to 2022.6 by @dependabot. PR [#273](https://github.com/yezz123/authx/pull/273) by @dependabot.
* Update pyinstrument requirement from <4.2.0,>=4.1.1 to >=4.1.1,<4.4.0 by @dependabot. PR [#274](https://github.com/yezz123/authx/pull/274) by @dependabot.
* Bump pymdown-extensions from 9.5 to 9.7 by @dependabot. PR [#275](https://github.com/yezz123/authx/pull/275) by @dependabot.
* Bump pytest-cov from 3.0.0 to 4.0.0 by @dependabot. PR [#276](https://github.com/yezz123/authx/pull/276) by @dependabot.
* Update redis requirement from <4.3.4,>=4.3.3 to >=4.3.3,<4.3.5 by @dependabot. PR [#277](https://github.com/yezz123/authx/pull/277) by @dependabot.
* Bump pytest from 7.1.3 to 7.2.0 by @dependabot. PR [#278](https://github.com/yezz123/authx/pull/278) by @dependabot.
* Update fastapi requirement from <=0.81.0,>=0.65.2 to >=0.65.2,<0.87.0 by @dependabot. PR [#279](https://github.com/yezz123/authx/pull/279) by @dependabot.
* Bump bcrypt from 3.2.2 to 4.0.1 by @dependabot. PR [#281](https://github.com/yezz123/authx/pull/281) by @dependabot.
* Bump pytest-asyncio from 0.19.0 to 0.20.1 by @dependabot. PR [#280](https://github.com/yezz123/authx/pull/280) by @dependabot.
* Bump pydantic from 1.9.1 to 1.10.2 by @dependabot. PR [#282](https://github.com/yezz123/authx/pull/282) by @dependabot.
* Update sqlalchemy requirement from <=1.4.40,>=1.4.37 to >=1.4.37,<1.4.43 by @dependabot. PR [#283](https://github.com/yezz123/authx/pull/283) by @dependabot.
* Bump aiosmtplib from 1.1.6 to 2.0.0 by @dependabot. PR [#285](https://github.com/yezz123/authx/pull/285) by @dependabot.
* Update pyinstrument requirement from <4.4.0,>=4.1.1 to >=4.1.1,<4.5.0 by @dependabot. PR [#286](https://github.com/yezz123/authx/pull/286) by @dependabot.
* Bump pymdown-extensions from 9.7 to 9.8 by @dependabot. PR [#287](https://github.com/yezz123/authx/pull/287) by @dependabot.
* Update python-socketio requirement from <5.7.1,>=4.6.0 to >=4.6.0,<5.7.3 by @dependabot. PR [#288](https://github.com/yezz123/authx/pull/288) by @dependabot.
* Bump databases from 0.6.1 to 0.6.2 by @dependabot. PR [#289](https://github.com/yezz123/authx/pull/289) by @dependabot.
* Update starlette requirement from <0.20.4,>=0.14.02 to >=0.14.02,<0.21.1 by @dependabot. PR [#290](https://github.com/yezz123/authx/pull/290) by @dependabot.
* Update sqlalchemy requirement from <1.4.43,>=1.4.37 to >=1.4.37,<1.4.44 by @dependabot. PR [#291](https://github.com/yezz123/authx/pull/291) by @dependabot.
* Bump cryptography from 37.0.4 to 38.0.3 by @dependabot. PR [#292](https://github.com/yezz123/authx/pull/292) by @dependabot.
* Bump uvloop from 0.16.0 to 0.17.0 by @dependabot. PR [#293](https://github.com/yezz123/authx/pull/293) by @dependabot.
* Bump websockets from 10.3 to 10.4 by @dependabot. PR [#294](https://github.com/yezz123/authx/pull/294) by @dependabot.
* Bump pyjwt from 2.4.0 to 2.6.0 by @dependabot. PR [#296](https://github.com/yezz123/authx/pull/296) by @dependabot.
* Bump motor from 3.0.0 to 3.1.1 by @dependabot. PR [#297](https://github.com/yezz123/authx/pull/297) by @dependabot.
* Bump pytest-asyncio from 0.20.1 to 0.20.2 by @dependabot. PR [#300](https://github.com/yezz123/authx/pull/300) by @dependabot.
* Update sqlalchemy requirement from <1.4.44,>=1.4.37 to >=1.4.37,<1.4.45 by @dependabot. PR [#298](https://github.com/yezz123/authx/pull/298) by @dependabot.
* Update starlette requirement from <0.21.1,>=0.14.02 to >=0.14.02,<0.22.1 by @dependabot. PR [#301](https://github.com/yezz123/authx/pull/301) by @dependabot.
* Bump httpx from 0.23.0 to 0.23.1 by @dependabot. PR [#303](https://github.com/yezz123/authx/pull/303) by @dependabot.
* Bump uvicorn from 0.18.3 to 0.20.0 by @dependabot. PR [#302](https://github.com/yezz123/authx/pull/302) by @dependabot.
* Update redis requirement from <4.3.5,>=4.3.3 to >=4.3.3,<4.3.6 by @dependabot. PR [#304](https://github.com/yezz123/authx/pull/304) by @dependabot.
* Bump pymdown-extensions from 9.8 to 9.9 by @dependabot. PR [#305](https://github.com/yezz123/authx/pull/305) by @dependabot.
* Bump markdown-include from 0.7.0 to 0.8.0 by @dependabot. PR [#306](https://github.com/yezz123/authx/pull/306) by @dependabot.
* Bump cryptography from 38.0.3 to 38.0.4 by @dependabot. PR [#307](https://github.com/yezz123/authx/pull/307) by @dependabot.
* Bump pypa/gh-action-pypi-publish from 1.5.1 to 1.6.1 by @dependabot. PR [#312](https://github.com/yezz123/authx/pull/312) by @dependabot.
* Bump jsmrcaga/action-netlify-deploy from 1.1.0 to 1.8.1 by @dependabot. PR [#309](https://github.com/yezz123/authx/pull/309) by @dependabot.
* Revert "Bump jsmrcaga/action-netlify-deploy from 1.1.0 to 1.8.1" by @yezz123. PR [#314](https://github.com/yezz123/authx/pull/314) by @yezz123.
* Update redis requirement from <4.3.6,>=4.3.3 to >=4.3.3,<4.4.1 by @dependabot. PR [#311](https://github.com/yezz123/authx/pull/311) by @dependabot.
* Update starlette requirement from <0.22.1,>=0.14.02 to >=0.14.02,<0.23.1 by @dependabot. PR [#315](https://github.com/yezz123/authx/pull/315) by @dependabot.
* Bump pypa/gh-action-pypi-publish from 1.6.1 to 1.6.4 by @dependabot. PR [#318](https://github.com/yezz123/authx/pull/318) by @dependabot.
* Bump pytest-asyncio from 0.20.2 to 0.20.3 by @dependabot. PR [#319](https://github.com/yezz123/authx/pull/319) by @dependabot.
* Update sqlalchemy requirement from <1.4.45,>=1.4.37 to >=1.4.37,<1.4.46 by @dependabot. PR [#320](https://github.com/yezz123/authx/pull/320) by @dependabot.
* Update starlette requirement from <0.23.1,>=0.14.02 to >=0.14.02,<0.23.2 by @dependabot. PR [#321](https://github.com/yezz123/authx/pull/321) by @dependabot.
* Bump databases from 0.6.2 to 0.7.0 by @dependabot. PR [#324](https://github.com/yezz123/authx/pull/324) by @dependabot.
* Bump pytz from 2022.6 to 2022.7 by @dependabot. PR [#323](https://github.com/yezz123/authx/pull/323) by @dependabot.
* Bump pre-commit from 2.20.0 to 2.21.0 by @dependabot. PR [#325](https://github.com/yezz123/authx/pull/325) by @dependabot.
* Bump pydantic from 1.10.2 to 1.10.3 by @dependabot. PR [#326](https://github.com/yezz123/authx/pull/326) by @dependabot.
* Bump cryptography from 38.0.4 to 39.0.0 by @dependabot. PR [#328](https://github.com/yezz123/authx/pull/328) by @dependabot.
* Bump pydantic from 1.10.3 to 1.10.4 by @dependabot. PR [#327](https://github.com/yezz123/authx/pull/327) by @dependabot.
* Update mkdocs-material requirement from <9.0.0,>=8.1.4 to >=8.1.4,<10.0.0 by @dependabot. PR [#330](https://github.com/yezz123/authx/pull/330) by @dependabot.
* Bump httpx from 0.23.1 to 0.23.2 by @dependabot. PR [#329](https://github.com/yezz123/authx/pull/329) by @dependabot.
* Bump aiosmtplib from 2.0.0 to 2.0.1 by @dependabot. PR [#334](https://github.com/yezz123/authx/pull/334) by @dependabot.
* Update redis requirement from <4.4.1,>=4.3.3 to >=4.3.3,<4.4.2 by @dependabot. PR [#335](https://github.com/yezz123/authx/pull/335) by @dependabot.
* Update fastapi requirement from <0.87.0,>=0.65.2 to >=0.65.2,<0.90.0 by @dependabot. PR [#336](https://github.com/yezz123/authx/pull/336) by @dependabot.

## 0.8.1

* Increment postfix to find the possible username to use by @iftenet. PR [#266](https://github.com/yezz123/authx/pull/266) by @iftenet.
* Docs: Add @iftenet as a contributor for bug. PR [#267](https://github.com/yezz123/authx/pull/267) by @allcontributors.

## 0.8.0

* Chore(dev): Support middleware for Prometheus metrics by @yezz123. PR [#262](https://github.com/yezz123/authx/pull/262) by @yezz123.

## 0.7.0

* Migrate to Hatchling by @yezz123. PR [#261](https://github.com/yezz123/authx/pull/261) by @yezz123.

## 0.6.1

* Chore(refactor): Improve Errors by @yezz123. PR [#257](https://github.com/yezz123/authx/pull/257) by @yezz123.
* Update Dependencies by @yezz123. PR [#259](https://github.com/yezz123/authx/pull/259) by @yezz123.
* [WIP] fix client issue by @yezz123. PR [#260](https://github.com/yezz123/authx/pull/260) by @yezz123.

## 0.6.0

* Support Profiling for checking service performance by @yezz123. PR [#240](https://github.com/yezz123/authx/pull/240) by @yezz123.
* Chore(fix): Fix Failed tests for OAuth2 by @yezz123. PR [#241](https://github.com/yezz123/authx/pull/241) by @yezz123.
* Clean codebase from unread Docstrings by @yezz123. PR [#242](https://github.com/yezz123/authx/pull/242) by @yezz123.
* Docs: Upgrade pre-commit and add new markdown's linter by @yezz123. PR [#243](https://github.com/yezz123/authx/pull/243) by @yezz123.
* Upgrade all Github Actions by @yezz123. PR [#249](https://github.com/yezz123/authx/pull/249) by @yezz123.
* Bump jsmrcaga/action-netlify-deploy from 1.1.0 to 1.8.0 by @dependabot. PR [#250](https://github.com/yezz123/authx/pull/250) by @dependabot.
* Add license scan report and status by @fossabot. PR [#253](https://github.com/yezz123/authx/pull/253) by @fossabot.
* Release 0.6.0 - Supporting Profiling by @yezz123. PR [#255](https://github.com/yezz123/authx/pull/255) by @yezz123.

## 0.5.1

* Username Validation Fixed by [@YogeshUpdhyay](https://yogeshupadhyay.netlify.app/). PR [#238](https://github.com/yezz123/authx/pull/238) by [@YogeshUpdhyay](https://yogeshupadhyay.netlify.app/).

## 0.5.0

* Chore(ref): Improve API and refactor users management code by @yezz123. PR [#222](https://github.com/yezz123/authx/pull/222) by @yezz123.
* Fix Issue of Missing requirements by @yezz123. PR [#225](https://github.com/yezz123/authx/pull/225) by @yezz123.
* Update dependencies by @yezz123. PR [#233](https://github.com/yezz123/authx/pull/233) by @yezz123.
* Change domain from `.codes` to `.me` by @yezz123. PR [#235](https://github.com/yezz123/authx/pull/235) by @yezz123.
* Support SocketIO in AuthX ✨ by @yezz123. PR [#234](https://github.com/yezz123/authx/pull/234) by @yezz123.

## 0.4.0

* Chore(docs): Improve Documentation. PR [#209](https://github.com/yezz123/authx/pull/209) by @yezz123.
* Chore(dev): Refactor code & improve some exceptions ✨. PR [#212](https://github.com/yezz123/authx/pull/212) by @yezz123.
* Ref: Use the built-in function `next` instead of a for-loop. PR [#213](https://github.com/yezz123/authx/pull/213) by @yezz123.
* Chore(docs): Add New Sponsors ✨❤️. PR [#214](https://github.com/yezz123/authx/pull/214) by @yezz123.
* Docs(mkdocs.yml): Change name from `middlewares` to `middleware`. PR [#215](https://github.com/yezz123/authx/pull/215) by @theoohoho.
* Chore(f/l): Integrate `Pyupgrade` to AuthX Environment. PR [#216](https://github.com/yezz123/authx/pull/216) by @yezz123.
* Chore(feat): Integrate HTTP Caching Model for AuthX ✨. PR [#217](https://github.com/yezz123/authx/pull/217) by @yezz123.
* Docs: Add theoohoho as a contributor for doc. PR [#218](https://github.com/yezz123/authx/pull/218) by @allcontributors.
* Chore(Example): Provide New Cache Example✨. PR [#219](https://github.com/yezz123/authx/pull/219) by @yezz123.

## 0.3.1

* Chore(dev): Add Sessions Requirements. PR [#207](https://github.com/yezz123/authx/pull/207) by @yezz123.
* Chore(docs): Document the Functionality of Session Storing. PR [#208](https://github.com/yezz123/authx/pull/208) by @yezz123.

## 0.3.0

**Note:** This release does not have any changes, but it was released to fix the versioning issue.

## 0.2.0

* Chore(deps-dev): Bump pymdown-extensions from 9.0 to 9.1. PR [#155](https://github.com/yezz123/authx/pull/155) by @dependabot.
* Chore: Add FastAPI to Classifiers. PR [#163](https://github.com/yezz123/authx/pull/163) by @yezz123.
* Chore: Fix CI & Delete Docker Configuration ✨. PR [#165](https://github.com/yezz123/authx/pull/165) by @yezz123.
* CI: Ignore some Directories 🪨. PR [#168](https://github.com/yezz123/authx/pull/168) by @yezz123.

## 0.1.3

* Chore: Add sameSite attribute to the http-only cookie. PR [#134](https://github.com/yezz123/authx/pull/134) by @smakosh.
* Docs: Add smakosh as a contributor for code, security. PR [#138](https://github.com/yezz123/authx/pull/138) by @allcontributors.
* Chore: Update Requirements ✨. PR [#139](https://github.com/yezz123/authx/pull/139) by @yezz123.
* CI: Add Code Security Analyse ✨. PR [#140](https://github.com/yezz123/authx/pull/140) by @yezz123.
* Chore: Add JWT Algorithm Choices ✨. PR [#143](https://github.com/yezz123/authx/pull/143) by @yezz123.
* Docs: Add financial Supporters ✨. PR [#144](https://github.com/yezz123/authx/pull/144) by @yezz123.
* Bump PyJWT version from 1.7.1 to 2.3.0. PR [#151](https://github.com/yezz123/authx/pull/151) by @MojixCoder.
* Docs: Add MojixCoder as a contributor for code, bug. PR [#152](https://github.com/yezz123/authx/pull/152) by @allcontributors.
* Chore: Remove Todos assign 🖇. PR [#153](https://github.com/yezz123/authx/pull/153) by @yezz123.
* Upgrade `pre-commit` requirements ✨. PR [#154](https://github.com/yezz123/authx/pull/154) by @yezz123.

## 0.1.2

* Bump mkdocs-material from 7.2.6 to 7.3.5 by @dependabot in
  [PR #101](https://github.com/yezz123/authx/pull/101)
* Docs: Prepare Project for Being Public ✨ by @yezz123 in
  [PR #102](https://github.com/yezz123/authx/pull/102)
* Bump mkdocs-material from 7.3.5 to 7.3.6 by @dependabot in
  [PR #103](https://github.com/yezz123/authx/pull/103)
* Bump python from 3.9.2 to 3.10.0 by @dependabot in
  [PR #104](https://github.com/yezz123/authx/pull/104)
* Docs: add yezz123 as a contributor for code, doc, maintenance, infra by
  @allcontributors in [PR #105](https://github.com/yezz123/authx/pull/105)
* Docs: add AbderrahimSoubaiElidrissi as a contributor for review, doc by
  @allcontributors in [PR #106](https://github.com/yezz123/authx/pull/106)
* CI: Delete Docs Build ✨ by @yezz123 in
  [PR #108](https://github.com/yezz123/authx/pull/108)
* Docs: Delete a part of FAQ ✨ by @yezz123 in
  [PR #109](https://github.com/yezz123/authx/pull/109)
* chore: Fix workflows ✨ by @yezz123 in
  [PR #112](https://github.com/yezz123/authx/pull/112)
* chore: Rename Website name & Fix Build Issue 🚀 by @yezz123 in
  [PR #113](https://github.com/yezz123/authx/pull/113)
* Chore: Delete `aiohttp` by @yezz123 in
  [PR #114](https://github.com/yezz123/authx/pull/114)
* WIP: Add Code owner 🖇 by @yezz123 in
  [PR #117](https://github.com/yezz123/authx/pull/117)
* Chore: Fix Key Directory 🔑 by @yezz123 in
  [PR #115](https://github.com/yezz123/authx/pull/115)
* Configure `.pyup` ✨ by @yezz123 in
  [PR #120](https://github.com/yezz123/authx/pull/120)
* pep-0008: Fix Package and Module Names✨ by @yezz123 in
  [PR #126](https://github.com/yezz123/authx/pull/126)
* chore: Change project Name by @yezz123 in
  [PR #128](https://github.com/yezz123/authx/pull/128)
* chore: fix dockerfile commands by @yezz123 in
  [PR #130](https://github.com/yezz123/authx/pull/130)
* Chore: change Name from `AuthX` to `authx` ✨ by @yezz123 in
  [PR #131](https://github.com/yezz123/authx/pull/131)
* Bump version from 0.1.1 to 0.1.2 ✨ by @yezz123 in
  [PR #132](https://github.com/yezz123/authx/pull/132)

## 0.1.1

* Add a partial router to Database ✨ by @yezz123 in
  [PR #97](https://github.com/yezz123/AuthX/pull/97)
* Docs: Update documentation by @yezz123 in
  [PR #98](https://github.com/yezz123/AuthX/pull/98)
* Bump from 0.1.0 to 0.1.1 ✨ by @yezz123 in
  [PR #99](https://github.com/yezz123/AuthX/pull/99)

## 0.1.0

* docs: Add All Contributor by @yezz123 in
  [PR #89](https://github.com/yezz123/AuthX/pull/89)
* 📃 Docs: Add Codacy Review ✨ by @yezz123 in
  [PR #90](https://github.com/yezz123/AuthX/pull/90)
* CI: Fix Workflows ✨. [PR #92](https://github.com/yezz123/AuthX/pull/92)
* chore: Provide all requirements relate to `Setup.py` ✨ by @yezz123 in
  [PR #93](https://github.com/yezz123/AuthX/pull/93)
* ⬆️ Bump from 0.0.9 to 0.1.0 by @yezz123 in
  [PR #94](https://github.com/yezz123/AuthX/pull/94)

## 0.0.9

* Bump mkdocs from 1.2.2 to 1.2.3 by @dependabot in
  [PR #78](https://github.com/yezz123/AuthX/pull/78)
* Bump pytest-asyncio from 0.14.0 to 0.16.0 by @dependabot in
  [PR #77](https://github.com/yezz123/AuthX/pull/77)
* 🐳 DockerFile Checker ✨ by @yezz123 in
  [PR #80](https://github.com/yezz123/AuthX/pull/80)
* chore: Provide DocString for Functions ✨ by @yezz123 in
  [PR #84](https://github.com/yezz123/AuthX/pull/84)
* Docs: Create a Release Notes ✨ by @yezz123 in
  [PR #85](https://github.com/yezz123/AuthX/pull/85)
* Chore: Add Local Testing & Code Coverage ✨ by @yezz123 in
  [PR #86](https://github.com/yezz123/AuthX/pull/86)
* Docs: Add Coverage Badge ✨ by @yezz123 in
  [PR #87](https://github.com/yezz123/AuthX/pull/87)
* ⬆️ Bump Version from 0.0.8 to 0.0.9 by @yezz123 in
  [PR #88](https://github.com/yezz123/AuthX/pull/88)

## 0.0.8

* Fix Highlighting Issue ✨ by @yezz123 in
  [PR #69](https://github.com/yezz123/AuthX/pull/69)
* Docs: Add some Typo ✨ by @yezz123 in
  [PR #70](https://github.com/yezz123/AuthX/pull/70)
* Add Code of Conducts & License ✨ by @yezz123 in
  [PR #71](https://github.com/yezz123/AuthX/pull/71)
* Switch to MIT License ✨ by @yezz123 in
  [PR #73](https://github.com/yezz123/AuthX/pull/73)
* Test Documentation Build ✨ by @yezz123 in
  [PR #74](https://github.com/yezz123/AuthX/pull/74)
* ⬆️ Bump from 0.0.7 to 0.0.8 ✨ by @yezz123 in
  [PR #75](https://github.com/yezz123/AuthX/pull/75)

## 0.0.7

* Implement DocStrings ✨. PR [#60](https://github.com/yezz123/AuthX/pull/60) by @yezz123.
* Create a Global Documentation using Mkdocs. PR [#63](https://github.com/yezz123/AuthX/pull/63) by @yezz123.
* Fix Requirements. PR [#66](https://github.com/yezz123/AuthX/pull/66) by @yezz123.
* Fix Documentation. PR [#67](https://github.com/yezz123/AuthX/pull/67) by @yezz123.
* Version 0.0.7 ✨. PR [#68](https://github.com/yezz123/AuthX/pull/68) by @yezz123.

## 0.0.6

* Fix Environment Files. PR [#54](https://github.com/yezz123/AuthX/pull/54) by @yezz123.
* Provide More Classifiers ✨. PR [#57](https://github.com/yezz123/AuthX/pull/57) by @yezz123.
* Setup Tests DocStrings ✨. PR [#58](https://github.com/yezz123/AuthX/pull/58) by @yezz123.

## 0.0.5

* ✨ Fix Documentation issue. PR [#45](https://github.com/yezz123/AuthX/pull/45) by @yezz123.

## 0.0.4

* Setup docstring & Create Documentation. PR [#44](https://github.com/yezz123/AuthX/pull/44) by @yezz123.

## 0.0.3

* Test: All functions in the Services and Fix some issues related to Raise(). PR [#23](https://github.com/yezz123/AuthX/pull/23) by @yezz123.
* Release the first Version of AuthX ✨. PR [#28](https://github.com/yezz123/AuthX/pull/28) by @yezz123.
* Create a Simple Readme. PR [#42](https://github.com/yezz123/AuthX/pull/42) by @yezz123.
* Create 0.0.3 version. PR [#43](https://github.com/yezz123/AuthX/pull/43) by @yezz123.

## 0.0.2

* Create a test for Email ✨. PR [#25](https://github.com/yezz123/AuthX/pull/25) by @yezz123.

## 0.0.1

* Chore: Create Package Core. PR [#1](https://github.com/yezz123/AuthX/pull/1) by @yezz123.
* Chore: Provide The Full Functionality of Routers and Services. PR [#2](https://github.com/yezz123/AuthX/pull/2) by @yezz123.
* Chore: Create the Package Main file. PR [#3](https://github.com/yezz123/AuthX/pull/3) by @yezz123.
* Chore: Add Testing and Building Configuration. PR [#5](https://github.com/yezz123/AuthX/pull/5) by @yezz123.
* Chore: Add Last Build Addons to Test Branch. PR [#8](https://github.com/yezz123/AuthX/pull/8) by @yezz123.
* Chore: Create Dev work for testing the Package. PR [#4](https://github.com/yezz123/AuthX/pull/4) by @yezz123.
* Chore: Fix Build Files. PR [#10](https://github.com/yezz123/AuthX/pull/10) by @yezz123.
* Isort AuthX path and Fix Missing packages for test. PR [#18](https://github.com/yezz123/AuthX/pull/18) by @yezz123.
* Adding test case to workflow. PR [#19](https://github.com/yezz123/AuthX/pull/19) by @yezz123.
