# coding: utf-8

"""
    ioTium Orchestrator REST API

    The ioTium Orchestrator REST API allows you to interact with the Orchestrator programmatically. Use the REST APIs to script your interactions with, integrate with, or build your applications on top of ioTium Orchestrator.  # noqa: E501

    OpenAPI spec version: 21.10
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

class ServiceListenerCreationVO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'metadata': 'MetadataVO',
        'name': 'str',
        'type': 'str',
        'node_id': 'str',
        'service_selector': 'ServiceSelectorVO',
        'allow_access_from': 'list[str]',
        'service_ports': 'list[ServicePortsVO]'
    }

    attribute_map = {
        'metadata': 'metadata',
        'name': 'name',
        'type': 'type',
        'node_id': 'node_id',
        'service_selector': 'service_selector',
        'allow_access_from': 'allow_access_from',
        'service_ports': 'service_ports'
    }

    def __init__(self, metadata=None, name=None, type=None, node_id=None, service_selector=None, allow_access_from=None, service_ports=None):  # noqa: E501
        """ServiceListenerCreationVO - a model defined in Swagger"""  # noqa: E501
    
        self._metadata = None
        self._name = None
        self._type = None
        self._node_id = None
        self._service_selector = None
        self._allow_access_from = None
        self._service_ports = None
        self.discriminator = None

        if metadata is not None:
            self.metadata = metadata
        self.name = name
        self.type = type
        self.node_id = node_id
        self.service_selector = service_selector
        if allow_access_from is not None:
            self.allow_access_from = allow_access_from
        self.service_ports = service_ports

    @property
    def metadata(self):
        """Gets the metadata of this ServiceListenerCreationVO.  # noqa: E501

        Metadata  # noqa: E501

        :return: The metadata of this ServiceListenerCreationVO.  # noqa: E501
        :rtype: MetadataVO
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this ServiceListenerCreationVO.

        Metadata  # noqa: E501

        :param metadata: The metadata of this ServiceListenerCreationVO.  # noqa: E501
        :type: MetadataVO
        """

        self._metadata = metadata

    @property
    def name(self):
        """Gets the name of this ServiceListenerCreationVO.  # noqa: E501

        Name of a service listener  # noqa: E501

        :return: The name of this ServiceListenerCreationVO.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ServiceListenerCreationVO.

        Name of a service listener  # noqa: E501

        :param name: The name of this ServiceListenerCreationVO.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (name is not None and len(name) > 30):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `30`")  # noqa: E501
        if (name is not None and len(name) < 2):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `2`")  # noqa: E501
        if (name is not None and not re.search(r'^[A-Za-z0-9]+[A-Za-z0-9 .&,_-]*$', name)):  # noqa: E501
            raise ValueError(r"Invalid value for `name`, must be a follow pattern or equal to `/^[A-Za-z0-9]+[A-Za-z0-9 .&,_-]*$/`")  # noqa: E501

        self._name = name

    @property
    def type(self):
        """Gets the type of this ServiceListenerCreationVO.  # noqa: E501

        Type of listener.  NODEPORT - Will expose the service in a given node port  # noqa: E501

        :return: The type of this ServiceListenerCreationVO.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ServiceListenerCreationVO.

        Type of listener.  NODEPORT - Will expose the service in a given node port  # noqa: E501

        :param type: The type of this ServiceListenerCreationVO.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        allowed_values = ["NODEPORT"]  # noqa: E501
        if (type not in allowed_values):
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def node_id(self):
        """Gets the node_id of this ServiceListenerCreationVO.  # noqa: E501

        iNode ID  # noqa: E501

        :return: The node_id of this ServiceListenerCreationVO.  # noqa: E501
        :rtype: str
        """
        return self._node_id

    @node_id.setter
    def node_id(self, node_id):
        """Sets the node_id of this ServiceListenerCreationVO.

        iNode ID  # noqa: E501

        :param node_id: The node_id of this ServiceListenerCreationVO.  # noqa: E501
        :type: str
        """
        if node_id is None:
            raise ValueError("Invalid value for `node_id`, must not be `None`")  # noqa: E501

        self._node_id = node_id

    @property
    def service_selector(self):
        """Gets the service_selector of this ServiceListenerCreationVO.  # noqa: E501

        Service selector  # noqa: E501

        :return: The service_selector of this ServiceListenerCreationVO.  # noqa: E501
        :rtype: ServiceSelectorVO
        """
        return self._service_selector

    @service_selector.setter
    def service_selector(self, service_selector):
        """Sets the service_selector of this ServiceListenerCreationVO.

        Service selector  # noqa: E501

        :param service_selector: The service_selector of this ServiceListenerCreationVO.  # noqa: E501
        :type: ServiceSelectorVO
        """
        if service_selector is None:
            raise ValueError("Invalid value for `service_selector`, must not be `None`")  # noqa: E501

        self._service_selector = service_selector

    @property
    def allow_access_from(self):
        """Gets the allow_access_from of this ServiceListenerCreationVO.  # noqa: E501

        List of IPaddress(CIDR) that are allowed access   # noqa: E501

        :return: The allow_access_from of this ServiceListenerCreationVO.  # noqa: E501
        :rtype: list[str]
        """
        return self._allow_access_from

    @allow_access_from.setter
    def allow_access_from(self, allow_access_from):
        """Sets the allow_access_from of this ServiceListenerCreationVO.

        List of IPaddress(CIDR) that are allowed access   # noqa: E501

        :param allow_access_from: The allow_access_from of this ServiceListenerCreationVO.  # noqa: E501
        :type: list[str]
        """

        self._allow_access_from = allow_access_from

    @property
    def service_ports(self):
        """Gets the service_ports of this ServiceListenerCreationVO.  # noqa: E501

        List of listener port configuration   # noqa: E501

        :return: The service_ports of this ServiceListenerCreationVO.  # noqa: E501
        :rtype: list[ServicePortsVO]
        """
        return self._service_ports

    @service_ports.setter
    def service_ports(self, service_ports):
        """Sets the service_ports of this ServiceListenerCreationVO.

        List of listener port configuration   # noqa: E501

        :param service_ports: The service_ports of this ServiceListenerCreationVO.  # noqa: E501
        :type: list[ServicePortsVO]
        """
        if service_ports is None:
            raise ValueError("Invalid value for `service_ports`, must not be `None`")  # noqa: E501

        self._service_ports = service_ports

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ServiceListenerCreationVO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ServiceListenerCreationVO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ServiceListenerCreationVO):
            return True

        return self.to_dict() != other.to_dict()
