import { ReactWidget, showDialog, Dialog } from '@jupyterlab/apputils';
import { defaultSanitizer } from '@jupyterlab/apputils';
import { renderText } from '@jupyterlab/rendermime';
import { ServerConnection } from '@jupyterlab/services';
import { URLExt } from '@jupyterlab/coreutils';
import React from 'react';
export default class StatusMaster extends ReactWidget {
    constructor() {
        super();
        this.ws = null;
        this.status = false;
        this.dispose = () => {
            console.log("disposed");
            this.ws.close();
            this.ws = null;
        };
        this.onOpen = (msg) => { this.ws.send(JSON.stringify({ cmd: "start" })); };
        this.onError = (msg) => console.error(msg);
        this.onClose = (msg) => { };
        this.onMessage = (message) => {
            const msg = JSON.parse(message.data);
            if (msg['error']) {
                const body = document.createElement('div');
                renderText({ host: body, sanitizer: defaultSanitizer, source: msg['error'] });
                showDialog({
                    title: "Master: WARNING",
                    body: React.createElement("div", { className: ".jp-RenderedText", dangerouslySetInnerHTML: { __html: body.innerHTML } }),
                    buttons: [Dialog.okButton()]
                });
            }
            else if (msg['output']) {
                const body = document.createElement('div');
                renderText({ host: body, sanitizer: defaultSanitizer, source: msg['output'] });
                showDialog({
                    title: "Master FINNISHED",
                    body: React.createElement("div", { className: ".jp-RenderedText", dangerouslySetInnerHTML: { __html: body.innerHTML } }),
                    buttons: [Dialog.okButton()]
                });
            }
            this.status = msg['status'];
            this.update();
        };
        this.start = () => {
            showDialog({
                title: "Master",
                body: React.createElement("pre", { className: ".jp-RenderedText" }, "Do you want to START ROS Master?"),
                buttons: [Dialog.okButton(), Dialog.cancelButton()]
            }).then(res => {
                if (res.button.label != "OK")
                    return;
                this.ws.send(JSON.stringify({ cmd: "start" }));
            }).catch(e => console.log(e));
        };
        this.stop = () => {
            showDialog({
                title: "Master",
                body: React.createElement("pre", { className: ".jp-RenderedText" }, "Do you want to STOP ROS Master?"),
                buttons: [Dialog.okButton(), Dialog.cancelButton()]
            }).then(res => {
                if (res.button.label != "OK")
                    return;
                this.ws.send(JSON.stringify({ cmd: "stop" }));
            }).catch(e => console.log(e));
        };
        this.toggle = () => {
            if (this.status == false)
                this.start();
            else
                this.stop();
        };
        this.node.title = "ROS Master";
        this.addClass('jp-ReactWidget');
        const server = ServerConnection.makeSettings();
        const url = URLExt.join(server.wsUrl, 'ros/master');
        this.ws = new WebSocket(url);
        this.ws.onopen = this.onOpen;
        this.ws.onmessage = this.onMessage;
        this.ws.onerror = this.onError;
        this.ws.onclose = this.onClose;
        this.status = false;
    }
    render() {
        return (React.createElement("a", { href: "#", onClick: this.toggle, className: "main" },
            React.createElement("div", { className: "ros-logo" }),
            this.status ?
                React.createElement("div", { className: "ok" })
                :
                    React.createElement("div", { className: "ko" })));
    }
}
