import { ReactWidget, showDialog, Dialog } from '@jupyterlab/apputils';
import { renderText } from '@jupyterlab/rendermime';
import { defaultSanitizer } from '@jupyterlab/apputils';
import { ServerConnection } from '@jupyterlab/services';
import { URLExt } from '@jupyterlab/coreutils';
import React from 'react';
export default class StatusLaunch extends ReactWidget {
    constructor() {
        super();
        this.paths = null;
        this.ws = null;
        this.onOpen = (event) => { }; // console.log(event); }
        this.onError = (event) => { console.error(event); };
        this.onClose = (event) => { }; // console.log(event); }
        this.onMessage = (message) => {
            const msg = JSON.parse(message.data);
            const body = document.createElement('div');
            switch (msg.code) {
                case 0:
                    this.paths = msg.paths;
                    break;
                case 1:
                    this.paths.push(msg.path);
                    break;
                case 2:
                    renderText({ host: body, sanitizer: defaultSanitizer, source: msg.msg });
                    showDialog({
                        title: "WARNING: " + msg.path,
                        body: React.createElement("div", { className: ".jp-RenderedText", dangerouslySetInnerHTML: { __html: body.innerHTML } }),
                        buttons: [Dialog.okButton()]
                    });
                    break;
                case 3:
                case 4:
                    var index = this.paths.indexOf(msg.path);
                    if (index !== -1)
                        this.paths.splice(index, 1);
                    renderText({ host: body, sanitizer: defaultSanitizer, source: msg.msg });
                    showDialog({
                        title: (msg.code == 3 ? "FINISHED: " : "ERROR: ") + msg.path,
                        body: React.createElement("div", { className: ".jp-RenderedText", dangerouslySetInnerHTML: { __html: body.innerHTML } }),
                        buttons: [Dialog.okButton()]
                    });
                    break;
                default:
                    break;
            }
            this.update();
        };
        this.launch = (path) => {
            this.ws.send(JSON.stringify({ cmd: 'start', path }));
        };
        this.toggle = (path) => {
            showDialog({
                title: path,
                body: React.createElement("pre", { className: ".jp-RenderedText" }, "This execution will be stoped. Are you sure?"),
                buttons: [Dialog.okButton(), Dialog.cancelButton()]
            }).then(res => {
                if (res.button.label != "OK")
                    return;
                this.ws.send(JSON.stringify({ cmd: 'stop', path }));
            }).catch(e => console.log(e));
        };
        this.node.title = 'Launch status.';
        this.addClass('jp-ReactWidget');
        this.paths = [];
        const server = ServerConnection.makeSettings();
        const url = URLExt.join(server.wsUrl, 'ros/launch');
        this.ws = new WebSocket(url);
        this.ws.onopen = this.onOpen;
        this.ws.onmessage = this.onMessage;
        this.ws.onerror = this.onError;
        this.ws.onclose = this.onClose;
    }
    render() {
        return (React.createElement("a", { href: "#", className: "main" }, this.paths.map((path, i) => {
            return (React.createElement("span", { key: i, style: { margin: '3px' }, onClick: () => this.toggle(path) }, path.split('/').pop()));
        })));
    }
}
