"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EfsVolume = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_efs_1 = require("@aws-cdk/aws-efs");
const core_1 = require("@aws-cdk/core");
class EfsVolume extends core_1.Construct {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.fileSystem = new aws_efs_1.FileSystem(this, 'FileSystem', {
            vpc: props.vpc,
            performanceMode: aws_efs_1.PerformanceMode.GENERAL_PURPOSE,
            lifecyclePolicy: aws_efs_1.LifecyclePolicy.AFTER_30_DAYS,
            throughputMode: aws_efs_1.ThroughputMode.BURSTING,
            encrypted: true,
            removalPolicy: props.removalPolicy,
        });
        const fileSystemAccessPoint = this.fileSystem.addAccessPoint('AccessPoint');
        this.name = (_b = props.name) !== null && _b !== void 0 ? _b : 'efs';
        this.efsVolumeConfiguration = {
            fileSystemId: this.fileSystem.fileSystemId,
            transitEncryption: 'ENABLED',
            authorizationConfig: {
                accessPointId: fileSystemAccessPoint.accessPointId,
            },
        };
    }
    allowDefaultPortFrom(other, description) {
        this.fileSystem.connections.allowDefaultPortFrom(other, description);
    }
}
exports.EfsVolume = EfsVolume;
_a = JSII_RTTI_SYMBOL_1;
EfsVolume[_a] = { fqn: "@cloudcomponents/cdk-wordpress.EfsVolume", version: "1.47.0" };
//# sourceMappingURL=data:application/json;base64,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