"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Database = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const aws_rds_1 = require("@aws-cdk/aws-rds");
const core_1 = require("@aws-cdk/core");
class Database extends core_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        const databaseName = (_b = props.databaseName) !== null && _b !== void 0 ? _b : 'wordpress';
        this.instance = new aws_rds_1.DatabaseInstance(this, 'Database', {
            databaseName,
            vpc: props.vpc,
            engine: (_c = props.engine) !== null && _c !== void 0 ? _c : aws_rds_1.DatabaseInstanceEngine.mariaDb({
                version: aws_rds_1.MariaDbEngineVersion.VER_10_5,
            }),
            allocatedStorage: (_d = props.allocatedStorage) !== null && _d !== void 0 ? _d : 10,
            instanceType: (_e = props.instanceType) !== null && _e !== void 0 ? _e : aws_ec2_1.InstanceType.of(aws_ec2_1.InstanceClass.BURSTABLE3, aws_ec2_1.InstanceSize.MICRO),
            deleteAutomatedBackups: props.removalPolicy === core_1.RemovalPolicy.DESTROY,
            removalPolicy: props.removalPolicy,
        });
        this.environment = {
            WORDPRESS_DB_NAME: databaseName,
        };
        this.secrets = {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            WORDPRESS_DB_HOST: aws_ecs_1.Secret.fromSecretsManager(this.instance.secret, 'host'),
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            WORDPRESS_DB_USER: aws_ecs_1.Secret.fromSecretsManager(this.instance.secret, 'username'),
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            WORDPRESS_DB_PASSWORD: aws_ecs_1.Secret.fromSecretsManager(this.instance.secret, 'password'),
        };
    }
    allowDefaultPortFrom(other, description) {
        this.instance.connections.allowDefaultPortFrom(other, description);
    }
}
exports.Database = Database;
_a = JSII_RTTI_SYMBOL_1;
Database[_a] = { fqn: "@cloudcomponents/cdk-wordpress.Database", version: "1.47.0" };
//# sourceMappingURL=data:application/json;base64,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