import { InstanceType, IConnectable, IVpc } from '@aws-cdk/aws-ec2';
import { Secret } from '@aws-cdk/aws-ecs';
import { IInstanceEngine } from '@aws-cdk/aws-rds';
import { Construct, RemovalPolicy } from '@aws-cdk/core';
export interface DatabaseProps {
    readonly vpc: IVpc;
    readonly databaseName?: string;
    readonly engine?: IInstanceEngine;
    readonly allocatedStorage?: number;
    readonly instanceType?: InstanceType;
    readonly removalPolicy?: RemovalPolicy;
}
export declare class Database extends Construct {
    readonly environment: Record<string, string>;
    readonly secrets: Record<string, Secret>;
    private readonly instance;
    constructor(scope: Construct, id: string, props: DatabaseProps);
    allowDefaultPortFrom(other: IConnectable, description?: string): void;
}
