# Generated by Django 3.2.8 on 2021-10-17 19:27

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Limit',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=254, unique=True)),
                ('default', models.IntegerField(help_text="If a Plan hasn't set this limit, the Plan will use this default value.")),
            ],
        ),
        migrations.CreateModel(
            name='Plan',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=254, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('display_price', models.PositiveIntegerField(help_text='Price displayed to users for plan')),
                ('price_id', models.CharField(blank=True, help_text="Paid plans must set this and it may only be set if the Plan's type is Paid.", max_length=254, null=True, unique=True, verbose_name='Stripe Price ID.')),
                ('type', models.CharField(choices=[('free_default', 'Free (Default)'), ('free_private', 'Free (Private)'), ('paid_public', 'Paid (Public)')], default='free_default', help_text='The type of plan', max_length=254)),
            ],
        ),
        migrations.CreateModel(
            name='StripeEvent',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('event_id', models.CharField(max_length=254)),
                ('type', models.CharField(blank=True, max_length=254)),
                ('payload_type', models.CharField(max_length=254)),
                ('received_at', models.DateTimeField(auto_now_add=True)),
                ('info', models.JSONField(blank=True, help_text='For convenience, import information from the body and other sources.', null=True)),
                ('body', models.TextField()),
                ('headers', models.JSONField()),
                ('note', models.TextField(blank=True)),
                ('status', models.CharField(choices=[('new', 'New'), ('pending', 'Pending'), ('processed', 'Processed'), ('ignored', 'Ignored'), ('error', 'Error')], default='new', max_length=127)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='PlanLimit',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.IntegerField()),
                ('limit', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='billing.limit')),
                ('plan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='billing.plan')),
            ],
        ),
        migrations.AddField(
            model_name='plan',
            name='limits',
            field=models.ManyToManyField(related_name='plans', through='billing.PlanLimit', to='billing.Limit'),
        ),
        migrations.CreateModel(
            name='Customer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('customer_id', models.CharField(blank=True, max_length=254, null=True, unique=True, verbose_name='Stripe Customer ID')),
                ('current_period_end', models.DateTimeField(blank=True, null=True)),
                ('subscription_id', models.CharField(blank=True, max_length=254, null=True, unique=True, verbose_name='Stripe Subscription ID')),
                ('payment_state', models.CharField(choices=[('off', 'Off'), ('ok', 'Ok'), ('error', 'Error'), ('requires_payment_method', 'Requires Payment Method'), ('requires_action', 'Requires Action')], default='off', max_length=128)),
                ('plan', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='billing.plan')),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddConstraint(
            model_name='planlimit',
            constraint=models.UniqueConstraint(fields=('plan', 'limit'), name='unique_plan_limit'),
        ),
        migrations.AddConstraint(
            model_name='plan',
            constraint=models.UniqueConstraint(condition=models.Q(('type', 'free_default')), fields=('type',), name='max_1_free_default_plan'),
        ),
        migrations.AddConstraint(
            model_name='customer',
            constraint=models.CheckConstraint(check=models.Q(('payment_state', 'off'), ('subscription_id__isnull', False), _connector='OR'), name='subscription_payment_state_constraint'),
        ),
    ]
