/*
 * Decompiled with CFR 0.152.
 */
package org.happy.controllers.decorators;

import com.google.common.base.Preconditions;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import org.happy.commons.patterns.Lockable_1x0;
import org.happy.commons.patterns.decorator.Decorator_1x0;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;
import org.happy.commons.patterns.observer.listener.ActionListener_1x0;
import org.happy.commons.util.Random_1x0;
import org.happy.controllers.Controller_1x3;
import org.happy.controllers.impl.AbstractController_1x3;

public class ForkJoinPoolController_1x3<P, R>
extends AbstractController_1x3<P, R>
implements Decorator_1x0<Controller_1x3<P, R>>,
Lockable_1x0 {
    private ForkJoinPool forkJoinPool;
    private Controller_1x3<P, R> decorated;
    private Object lock;
    private CountDownLatch waitLatch = new CountDownLatch(1);
    private AtomicBoolean isStarted = new AtomicBoolean(false);
    private AtomicBoolean isCanceled = new AtomicBoolean(false);

    public static <P, R> ForkJoinPoolController_1x3<P, R> of(Controller_1x3<P, R> decorated, ForkJoinPool forkJoinPool) {
        return new ForkJoinPoolController_1x3<P, R>(decorated, forkJoinPool);
    }

    public static <P, R> ForkJoinPoolController_1x3<P, R> of(Controller_1x3<P, R> decorated, ForkJoinPool forkJoinPool, Object lock) {
        return new ForkJoinPoolController_1x3<P, R>(decorated, forkJoinPool, lock);
    }

    public ForkJoinPoolController_1x3(Controller_1x3<P, R> decorated, ForkJoinPool forkJoinPool) {
        this(decorated, forkJoinPool, new Object());
    }

    public ForkJoinPoolController_1x3(Controller_1x3<P, R> decorated, ForkJoinPool forkJoinPool, Object lock) {
        Preconditions.checkNotNull((Object)forkJoinPool);
        Preconditions.checkNotNull(decorated);
        this.decorated = decorated;
        this.forkJoinPool = forkJoinPool;
        this.lock = lock;
        this.decorated.getOnErrorEvent().add(new ActionListener_1x0<ActionEventAfter_1x0<Throwable>>(){

            @Override
            public void actionPerformedImpl(ActionEventAfter_1x0<Throwable> event) {
                ForkJoinPoolController_1x3.this.fireOnErrorEvent(event.getData());
            }
        });
        this.decorated.getOnStateChanged().add(new ActionListener_1x0<ActionEventAfter_1x0<Controller_1x3.State_1x3>>(){

            @Override
            public void actionPerformedImpl(ActionEventAfter_1x0<Controller_1x3.State_1x3> event) {
                Controller_1x3.State_1x3 state = event.getData();
                ForkJoinPoolController_1x3.this.setState(state);
                if (Controller_1x3.State_1x3.Finished.equals((Object)state) || Controller_1x3.State_1x3.Canceled.equals((Object)state)) {
                    ForkJoinPoolController_1x3.this.waitLatch.countDown();
                }
            }
        });
    }

    public ForkJoinPool getForkJoinPool() {
        return this.forkJoinPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean start() {
        this.setState(Controller_1x3.State_1x3.Started);
        Object object = this.lock;
        synchronized (object) {
            this.forkJoinPool.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Boolean started = false;
                        Object object = ForkJoinPoolController_1x3.this.lock;
                        synchronized (object) {
                            block11: {
                                if (!ForkJoinPoolController_1x3.this.isCanceled.get()) break block11;
                                return;
                            }
                            started = ForkJoinPoolController_1x3.this.decorated.start();
                            Preconditions.checkNotNull((Object)started);
                            ForkJoinPoolController_1x3.this.isStarted.set(started);
                        }
                        if (!started.booleanValue()) {
                            this.fireErrror(null);
                        }
                    }
                    catch (Throwable e) {
                        this.fireErrror(e);
                    }
                    finally {
                        ForkJoinPoolController_1x3.this.waitLatch.countDown();
                    }
                }

                private void fireErrror(Throwable e) {
                    ForkJoinPoolController_1x3 source = ForkJoinPoolController_1x3.this;
                    int id = Random_1x0.randomInt();
                    String command = "controller couldn't be started in ForkJoinPoolController decorator!";
                    IllegalStateException data = null;
                    data = e == null ? new IllegalStateException(command) : new IllegalStateException(command, e);
                    ActionEventAfter_1x0<IllegalStateException> event = new ActionEventAfter_1x0<IllegalStateException>((Object)source, id, command, data);
                    ForkJoinPoolController_1x3.this.getOnErrorEvent().fire(event);
                }
            });
            return true;
        }
    }

    @Override
    public R waitForFinish() {
        if (Controller_1x3.State_1x3.Created.equals((Object)this.getState())) {
            return this.decorated.waitForFinish();
        }
        try {
            this.waitLatch.await();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Exception during waitForFinish() method was thrown!", e);
        }
        if (Controller_1x3.State_1x3.Started.equals((Object)this.getState())) {
            return this.decorated.waitForFinish();
        }
        Controller_1x3.State_1x3 state = this.getState();
        Preconditions.checkState((Controller_1x3.State_1x3.Finished.equals((Object)state) || Controller_1x3.State_1x3.Canceled.equals((Object)state) ? 1 : 0) != 0, (Object)("state was " + (Object)((Object)state)));
        return this.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (Controller_1x3.State_1x3.Finished.equals((Object)this.getState())) {
                return false;
            }
            if (this.isStarted.get()) {
                return this.decorated.cancel();
            }
            this.isCanceled.set(true);
        }
        this.setState(Controller_1x3.State_1x3.Canceled);
        return true;
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.3f);
    }

    @Override
    public P getProgress() {
        return this.decorated.getProgress();
    }

    @Override
    public Controller_1x3<P, R> getDecorated() {
        return this.decorated;
    }

    @Override
    public void setDecorated(Controller_1x3<P, R> decorated) {
        if (!Controller_1x3.State_1x3.Created.equals((Object)this.getState())) {
            throw new IllegalStateException("you can't set decorateable controller, if the controller was started! The controller state was: " + (Object)((Object)this.getState()));
        }
        Preconditions.checkNotNull(decorated);
        this.decorated = decorated;
    }

    @Override
    public Object getLockObject() {
        return this.lock;
    }

    @Override
    public void setLockObject(Object lock) {
        if (!Controller_1x3.State_1x3.Created.equals((Object)this.getState())) {
            throw new IllegalStateException("you can't set lock object, if the controller was started! The controller state was: " + (Object)((Object)this.getState()));
        }
        this.lock = lock;
    }
}

