/*
 * Decompiled with CFR 0.152.
 */
package org.happy.concurrent.synchronizers.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.happy.collections.decorators.UnmodifiableStrategy_1x0;
import org.happy.collections.maps.EntryImpl_1x0;
import org.happy.collections.maps.decorators.EventMap_1x2;
import org.happy.collections.maps.decorators.UnmodifiableMap_1x0;
import org.happy.commons.patterns.Lockable_1x0;
import org.happy.commons.patterns.observer.Delegate_1x0;
import org.happy.commons.patterns.observer.Delegate_1x0Impl;
import org.happy.commons.patterns.observer.decorators.SynchronizedDelegate_1x0;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;
import org.happy.commons.patterns.observer.event.ActionEventBefore_1x0;
import org.happy.commons.patterns.observer.listener.ActionListener_1x0;
import org.happy.concurrent.synchronizers.MultiLock_1x3;
import org.happy.concurrent.synchronizers.exception.MultiLockException_1x3;

public abstract class AbstractMultiLock_1x3<L>
implements MultiLock_1x3<L>,
Lockable_1x0 {
    private static AtomicLong idGenerator = new AtomicLong(0L);
    private long id;
    private Object lock = new Object();
    private AbstractMultiLock_1x3<L> parent;
    private MultiLock_1x3.State_1x3 state;
    private AtomicInteger eventIDGenerator = new AtomicInteger(0);
    private Delegate_1x0<ActionEventAfter_1x0<MultiLock_1x3.State_1x3>> onStateChanged;
    private Delegate_1x0<ActionEventAfter_1x0<Map<L, MultiLock_1x3.Permission_1x3>>> onPermissionChanged;
    private Map<L, MultiLock_1x3.Permission_1x3> locksMap;
    private UnmodifiableMap_1x0<L, MultiLock_1x3.Permission_1x3> partllyUnmodifieableLocksMap;
    private long level = 0L;
    private Set<AbstractMultiLock_1x3<L>> dependencyMultiLockSet;
    private Object onStateChangedLock = new Object();
    private Object onPermissionChangedLock = new Object();
    private Thread thread;

    public AbstractMultiLock_1x3() {
        this(Thread.currentThread());
    }

    public AbstractMultiLock_1x3(Thread thread) {
        Preconditions.checkNotNull((Object)thread);
        this.thread = thread;
        this.init(null);
    }

    public AbstractMultiLock_1x3(AbstractMultiLock_1x3<L> parent) {
        Preconditions.checkNotNull(parent);
        this.thread = parent.getThread();
        this.init(parent);
    }

    private void init(AbstractMultiLock_1x3<L> parent) {
        this.id = idGenerator.incrementAndGet();
        this.parent = parent;
        EventMap_1x2<L, MultiLock_1x3.Permission_1x3> eventLockMap = EventMap_1x2.of(new HashMap());
        eventLockMap.getOnBeforePutEvent().add(new ActionListener_1x0<ActionEventBefore_1x0<EntryImpl_1x0<L, MultiLock_1x3.Permission_1x3>>>(){

            @Override
            public void actionPerformedImpl(ActionEventBefore_1x0<EntryImpl_1x0<L, MultiLock_1x3.Permission_1x3>> event) {
                EntryImpl_1x0 entry = (EntryImpl_1x0)event.getData();
                Object lock = entry.getKey();
                Preconditions.checkNotNull(lock, (Object)"one of added locks is null! But null as lock is not allowed!");
                MultiLock_1x3.Permission_1x3 perm = (MultiLock_1x3.Permission_1x3)((Object)entry.getValue());
                Preconditions.checkNotNull((Object)((Object)perm), (Object)("Permision of lock " + lock + " can't be null!"));
            }
        });
        this.locksMap = eventLockMap;
        this.state = MultiLock_1x3.State_1x3.Created;
        this.partllyUnmodifieableLocksMap = UnmodifiableMap_1x0.of(this.locksMap, UnmodifiableStrategy_1x0.Modifiable);
        this.dependencyMultiLockSet = new HashSet<AbstractMultiLock_1x3<L>>();
    }

    @Override
    public Long getID() {
        return this.id;
    }

    @Override
    public AbstractMultiLock_1x3<L> getParent() {
        return this.parent;
    }

    @Override
    public MultiLock_1x3.State_1x3 getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(MultiLock_1x3.State_1x3 state) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkNotNull((Object)((Object)state));
            Preconditions.checkState((this.state.ordinal() <= state.ordinal() ? 1 : 0) != 0);
            boolean bl = changed = !this.state.equals((Object)state);
            if (changed) {
                Preconditions.checkArgument((this.state.ordinal() < state.ordinal() ? 1 : 0) != 0, (Object)("The state:" + (Object)((Object)state) + " couldn't be seted because current state was:" + (Object)((Object)this.state)));
            }
            this.state = state;
            if (MultiLock_1x3.State_1x3.Activated.equals((Object)state)) {
                this.partllyUnmodifieableLocksMap.setStrategy(UnmodifiableStrategy_1x0.RemoveAllowed);
            } else if (MultiLock_1x3.State_1x3.Finished.equals((Object)state)) {
                Preconditions.checkState((boolean)this.locksMap.isEmpty(), (Object)("not all ressources were removed from MultiLock, although the state was " + state.name()));
            }
        }
        if (changed) {
            this.fireOnStateChanged(state);
        }
    }

    public long getLevel() {
        return this.level;
    }

    public void setLevel(long level) {
        this.level = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Map<L, MultiLock_1x3.Permission_1x3> permissionsMap) throws MultiLockException_1x3 {
        HashMap<L, MultiLock_1x3.Permission_1x3> permissionsChangedMap = new HashMap<L, MultiLock_1x3.Permission_1x3>();
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkNotNull(permissionsMap);
            Preconditions.checkArgument((!permissionsMap.isEmpty() ? 1 : 0) != 0);
            for (Map.Entry<L, MultiLock_1x3.Permission_1x3> entry : permissionsMap.entrySet()) {
                L lock = entry.getKey();
                Preconditions.checkNotNull(lock);
                MultiLock_1x3.Permission_1x3 newPerm = entry.getValue();
                MultiLock_1x3.Permission_1x3 oldPerm = this.locksMap.get(lock);
                Preconditions.checkNotNull((Object)((Object)newPerm), (Object)("resource:" + lock + " doesn't belong to the ressources of MultiLock with id=" + this.getID() + " and can be updated!"));
                if (!this.permissionUpdateAllowed(newPerm, oldPerm)) {
                    throw new MultiLockException_1x3("The ressource " + lock + " can't be updated from permission:" + oldPerm.name() + " to " + newPerm.name());
                }
                if (oldPerm.equals((Object)newPerm)) continue;
                permissionsChangedMap.put(lock, newPerm);
            }
            if (!permissionsChangedMap.isEmpty()) {
                this.locksMap.putAll(permissionsChangedMap);
            }
        }
        if (!permissionsChangedMap.isEmpty()) {
            this.fireOnPermissionChanged(permissionsChangedMap);
        }
    }

    protected abstract boolean permissionUpdateAllowed(MultiLock_1x3.Permission_1x3 var1, MultiLock_1x3.Permission_1x3 var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Set<L> locks) {
        Object object = this.lock;
        synchronized (object) {
            HashMap<L, MultiLock_1x3.Permission_1x3> permissions = new HashMap<L, MultiLock_1x3.Permission_1x3>();
            for (L key : locks) {
                permissions.put(key, MultiLock_1x3.Permission_1x3.Unlocked);
            }
            permissions.keySet().retainAll(this.locksMap.keySet());
            this.update(permissions);
            this.locksMap.keySet().removeAll(permissions.keySet());
        }
    }

    @Override
    public Map<L, MultiLock_1x3.Permission_1x3> getLocksMap() {
        return this.partllyUnmodifieableLocksMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        Object object = this.lock;
        synchronized (object) {
            this.unlock(this.locksMap.keySet());
            Preconditions.checkState((boolean)this.locksMap.isEmpty());
            this.setState(MultiLock_1x3.State_1x3.Finished);
            Preconditions.checkState((boolean)MultiLock_1x3.State_1x3.Finished.equals((Object)this.getState()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Delegate_1x0<ActionEventAfter_1x0<MultiLock_1x3.State_1x3>> getOnStateChanged() {
        Object object = this.onStateChangedLock;
        synchronized (object) {
            if (this.onStateChanged == null) {
                this.onStateChanged = SynchronizedDelegate_1x0.of(new Delegate_1x0Impl());
            }
            return this.onStateChanged;
        }
    }

    protected void fireOnStateChanged(MultiLock_1x3.State_1x3 state) {
        if (this.onStateChanged == null) {
            return;
        }
        AbstractMultiLock_1x3 surce = this;
        int eventID = this.eventIDGenerator.incrementAndGet();
        String command = "State_1x3 Changed : " + (Object)((Object)state);
        ActionEventAfter_1x0<MultiLock_1x3.State_1x3> e = new ActionEventAfter_1x0<MultiLock_1x3.State_1x3>((Object)surce, eventID, command, state);
        this.onStateChanged.fire(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Delegate_1x0<ActionEventAfter_1x0<Map<L, MultiLock_1x3.Permission_1x3>>> getOnPermissionChanged() {
        Object object = this.onPermissionChangedLock;
        synchronized (object) {
            if (this.onPermissionChanged == null) {
                this.onPermissionChanged = SynchronizedDelegate_1x0.of(new Delegate_1x0Impl());
            }
            return this.onPermissionChanged;
        }
    }

    protected void fireOnPermissionChanged(Map<L, MultiLock_1x3.Permission_1x3> permissions) {
        if (this.onPermissionChanged == null) {
            return;
        }
        AbstractMultiLock_1x3 surce = this;
        int eventID = this.eventIDGenerator.incrementAndGet();
        String command = "Permissions Changed : " + permissions;
        ActionEventAfter_1x0<Map<L, MultiLock_1x3.Permission_1x3>> e = new ActionEventAfter_1x0<Map<L, MultiLock_1x3.Permission_1x3>>((Object)surce, eventID, command, Collections.unmodifiableMap(permissions));
        this.onPermissionChanged.fire(e);
    }

    @Override
    public Object getLockObject() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLockObject(Object lockObject) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)MultiLock_1x3.State_1x3.Created.equals((Object)this.getState()), (Object)("The lock object could be seted because the state of the MultiLock was: " + (Object)((Object)this.getState())));
            this.lock = lockObject;
        }
    }

    protected Set<AbstractMultiLock_1x3<L>> getDependencyMultiLockSet() {
        return this.dependencyMultiLockSet;
    }

    @Override
    public Thread getThread() {
        return this.thread;
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.3f);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMultiLock_1x3 other = (AbstractMultiLock_1x3)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "AbstractMultiLock_1x3 [id=" + this.id + ", state=" + (Object)((Object)this.state) + ", level=" + this.level + "]";
    }
}

