/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.happy.commons.generators.RandomCharGenerator_1x0;
import org.happy.commons.generators.RandomDoubleGenerator_1x0;
import org.happy.commons.generators.RandomFloatGenerator_1x0;
import org.happy.commons.generators.RandomIntegerGenerator_1x0;
import org.happy.commons.generators.RandomLongGenerator_1x0;
import org.happy.commons.generators.RandomObjectFromArrayGenerator_1x0;
import org.happy.commons.generators.RandomStringGenerator_1x0;
import org.happy.commons.patterns.Generator_1x0;

public final class Random_1x0 {
    private static Random r = new Random();

    private Random_1x0() {
    }

    public static boolean randomBoolean() {
        return r.nextBoolean();
    }

    public static double randomDouble() {
        return r.nextDouble();
    }

    public static double randomDouble(double value) {
        double res = r.nextDouble() * value;
        return res;
    }

    public static double randomDouble(double min, double max) {
        return new RandomDoubleGenerator_1x0(min, max, Random_1x0.singelton()).generate();
    }

    public static void randomBytes(byte[] bytes) {
        r.nextBytes(bytes);
    }

    public static float randomFloat() {
        return r.nextFloat();
    }

    public static float randomFloat(float value) {
        float res = r.nextFloat() * value;
        return res;
    }

    public static float randomFloat(float min, float max) {
        return new RandomFloatGenerator_1x0(min, max, Random_1x0.singelton()).generate().floatValue();
    }

    public static int randomInt() {
        return r.nextInt();
    }

    public static int randomInt(int n) {
        return r.nextInt(n);
    }

    public static int randomInt(int min, int max) {
        return new RandomIntegerGenerator_1x0(min, max, Random_1x0.singelton()).generate();
    }

    public static long randomLong() {
        return r.nextLong();
    }

    public static long randomLong(long n) {
        if (n < 1L) {
            throw new IllegalArgumentException("n must be biger then 0!");
        }
        long value = (long)(r.nextDouble() * (double)(n - 1L) + 0.5);
        return value;
    }

    public static long randomLong(long min, long max) {
        return new RandomLongGenerator_1x0(min, max, Random_1x0.singelton()).generate();
    }

    public static Random singelton() {
        return r;
    }

    public static char randomChar() {
        return new RandomCharGenerator_1x0('\u0000', '\uffff', Random_1x0.singelton()).generate().charValue();
    }

    public static char randomChar(char min, char max) {
        return new RandomCharGenerator_1x0(min, max, Random_1x0.singelton()).generate().charValue();
    }

    public static String randomString(int length, char minCharValue, char maxCharValue) {
        return new RandomStringGenerator_1x0(length, minCharValue, maxCharValue).generate();
    }

    public static String randomString(int minStringLength, int maxStringLength) {
        return new RandomStringGenerator_1x0(minStringLength, maxStringLength).generate();
    }

    public static String randomString(int minStringLength, int maxStringLength, char minCharValue, char maxCharValue) {
        return new RandomStringGenerator_1x0(minStringLength, maxStringLength, minCharValue, maxCharValue).generate();
    }

    public static <K, V> Map<K, V> randomSubMap(Map<K, V> map, int size) {
        Preconditions.checkArgument((0 <= size ? 1 : 0) != 0);
        Preconditions.checkArgument((size <= map.size() ? 1 : 0) != 0, (Object)"The size of original map is smaller then the number of elements, which should be used for map creation!");
        if (size == 0) {
            return Collections.emptyMap();
        }
        if (map.size() == size) {
            return ImmutableMap.copyOf(map);
        }
        RandomObjectFromArrayGenerator_1x0<Map.Entry<K, V>> g = new RandomObjectFromArrayGenerator_1x0<Map.Entry<K, V>>(Collections.unmodifiableSet(map.entrySet()));
        final Set<Map.Entry<K, V>> lockSet = Generator_1x0.Utils.generateSet(g, size);
        return new AbstractMap<K, V>(){

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return lockSet;
            }
        };
    }

    public static byte[] randomByteArray(int length) {
        Preconditions.checkArgument((0 < length ? 1 : 0) != 0, (Object)"length for random byte array must be bigger then 0!");
        RandomCharGenerator_1x0 g = new RandomCharGenerator_1x0('\u0000', '\uffff');
        byte[] arr = new byte[length];
        for (int i = 0; i < length; ++i) {
            char charValue = g.generate().charValue();
            arr[i] = (byte)charValue;
        }
        return arr;
    }
}

