/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.generators;

import java.util.Random;
import org.happy.commons.patterns.Generator_1x0;
import org.happy.commons.patterns.version.Version_1x0;
import org.happy.commons.util.Random_1x0;

public class RandomIntegerGenerator_1x0
implements Generator_1x0<Integer>,
Version_1x0<Float> {
    private int min;
    private int max;
    Random random = null;

    public RandomIntegerGenerator_1x0(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("MIN must be smaller or equals to MAX");
        }
        this.min = min;
        this.max = max;
    }

    public RandomIntegerGenerator_1x0(int min, int max, Random random) {
        this(min, max);
        this.random = random;
    }

    @Override
    public Integer generate() {
        if (this.min == this.max) {
            return this.min;
        }
        if (this.random == null) {
            return this.min + Random_1x0.randomInt(this.max - this.min);
        }
        return this.min + this.random.nextInt(this.max - this.min);
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.0f);
    }

    public String toString() {
        return "RandomIntegerGenerator_1x0 [min=" + this.min + ", max=" + this.max + "]";
    }
}

