/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.maps.decorators;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.happy.collections.maps.EntryImpl_1x0;
import org.happy.collections.maps.decorators.MapDecorator_1x0;
import org.happy.collections.sets.decorators.EventSet_1x0;
import org.happy.commons.patterns.observer.Delegate_1x0;
import org.happy.commons.patterns.observer.Delegate_1x0Impl;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;
import org.happy.commons.patterns.observer.event.ActionEventBefore_1x0;
import org.happy.commons.patterns.observer.listener.ActionListener_1x0;
import org.happy.commons.util.ObjectPointer_1x0;

public class EventMap_1x2<K, V>
extends MapDecorator_1x0<K, V> {
    public static final String CM_BEFORE_PUT = "before put";
    public static final String CM_AFTER_PUT = "after put";
    public static final String CM_BEFORE_REMOVE = "before remove";
    public static final String CM_AFTER_REMOVE = "after remove";
    public static final String CM_BEFORE_CLEAR = "before clear";
    public static final String CM_AFTER_CLEAR = "after clear";
    public static final String CM_BEFORE_GET = "before get";
    public static final String CM_AFTER_GET = "after get";
    protected Delegate_1x0<ActionEventBefore_1x0<EntryImpl_1x0<K, V>>> onBeforePutEvent = null;
    protected Delegate_1x0<ActionEventAfter_1x0<Map.Entry<K, V>>> onAfterPutEvent = null;
    protected Delegate_1x0<ActionEventBefore_1x0<K>> onBeforeRemoveEvent = null;
    protected Delegate_1x0<ActionEventAfter_1x0<Map.Entry<K, V>>> onAfterRemoveEvent = null;
    protected Delegate_1x0<ActionEventBefore_1x0<Map<K, V>>> onBeforeClearEvent = null;
    protected Delegate_1x0<ActionEventAfter_1x0<Map<K, V>>> onAfterClearEvent = null;
    protected Delegate_1x0<ActionEventBefore_1x0<K>> onBeforeModifyEvent = null;
    protected Delegate_1x0<ActionEventAfter_1x0<Map.Entry<K, V>>> onAfterModifyEvent = null;
    protected Delegate_1x0<ActionEventBefore_1x0<Map.Entry<K, V>>> onBeforeGetEvent = null;
    protected Delegate_1x0<ActionEventAfter_1x0<Map.Entry<K, V>>> onAfterGetEvent = null;
    private boolean putExecution = false;
    private static final long serialVersionUID = 5575390146106060647L;

    public static <K, V> EventMap_1x2<K, V> of(Map<K, V> decorated) {
        return new EventMap_1x2<K, V>(decorated);
    }

    public EventMap_1x2(Map<K, V> decorateable) {
        super(decorateable);
    }

    @Override
    public V put(K key, V value) {
        this.putExecution = true;
        EntryImpl_1x0<K, V> entry = new EntryImpl_1x0<K, V>(key, value);
        if (this.fireOnBeforePutEvent(entry)) {
            this.putExecution = false;
            return null;
        }
        value = entry.getValue();
        boolean containskey = ((Map)this.decorated).containsKey(key);
        if (containskey && this.fireOnBeforeRemoveEvent(key)) {
            this.putExecution = false;
            return null;
        }
        V ret = ((Map)this.decorated).put(key, value);
        if (containskey) {
            this.fireOnAfterRemoveEvent(new EntryImpl_1x0<K, V>(key, ret));
        }
        this.fireOnAfterPutEvent(key, value);
        this.putExecution = false;
        return ret;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        if (this.fireOnBeforeRemoveEvent(key)) {
            return null;
        }
        boolean doContains = ((Map)this.decorated).containsKey(key);
        Object ret = ((Map)this.decorated).remove(key);
        if (doContains) {
            this.fireOnAfterRemoveEvent(new EntryImpl_1x0(key, ret));
        }
        return ret;
    }

    @Override
    public void clear() {
        if (this.fireOnBeforeClearEvent()) {
            return;
        }
        HashMap<K, V> mapCanceled = new HashMap<K, V>();
        HashMap<K, V> mapRemoved = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : this.entrySet()) {
            boolean canceled = this.fireOnBeforeRemoveEvent(entry.getKey());
            if (canceled) {
                mapCanceled.put(entry.getKey(), entry.getValue());
                continue;
            }
            mapRemoved.put(entry.getKey(), entry.getValue());
        }
        ((Map)this.decorated).clear();
        if (0 < mapCanceled.size()) {
            ((Map)this.decorated).putAll(mapCanceled);
        }
        if (this.onAfterRemoveEvent != null) {
            for (Map.Entry<K, V> entry : mapRemoved.entrySet()) {
                this.fireOnAfterRemoveEvent(entry);
            }
        }
        this.fireOnAfterClearEvent();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EventSet_1x0 eventSet = new EventSet_1x0(super.entrySet());
        eventSet.getOnBeforeRemoveEvent().add(new ActionListener_1x0<ActionEventBefore_1x0<Map.Entry<K, V>>>(){

            @Override
            public void actionPerformedImpl(ActionEventBefore_1x0<Map.Entry<K, V>> event) {
                Map.Entry entry = (Map.Entry)event.getData();
                if (EventMap_1x2.this.fireOnBeforeRemoveEvent(entry.getKey())) {
                    event.setCanceled(true);
                }
            }
        });
        eventSet.getOnAfterRemoveEvent().add(new ActionListener_1x0<ActionEventAfter_1x0<Map.Entry<K, V>>>(){

            @Override
            public void actionPerformedImpl(ActionEventAfter_1x0<Map.Entry<K, V>> event) {
                Map.Entry entry = event.getData();
                EventMap_1x2.this.fireOnAfterRemoveEvent(entry);
            }
        });
        eventSet.getOnBeforeClearEvent().add(new ActionListener_1x0<ActionEventBefore_1x0<Collection<Map.Entry<K, V>>>>(){

            @Override
            public void actionPerformedImpl(ActionEventBefore_1x0<Collection<Map.Entry<K, V>>> event) {
                if (EventMap_1x2.this.fireOnBeforeClearEvent()) {
                    event.setCanceled(true);
                }
            }
        });
        eventSet.getOnAfterClearEvent().add(new ActionListener_1x0<ActionEventAfter_1x0<Collection<Map.Entry<K, V>>>>(){

            @Override
            public void actionPerformedImpl(ActionEventAfter_1x0<Collection<Map.Entry<K, V>>> event) {
                EventMap_1x2.this.fireOnAfterClearEvent();
            }
        });
        eventSet.getOnBeforeGetEvent().add(new ActionListener_1x0<ActionEventBefore_1x0<Map.Entry<K, V>>>(){

            @Override
            public void actionPerformedImpl(ActionEventBefore_1x0<Map.Entry<K, V>> event) {
                if (EventMap_1x2.this.fireOnBeforeGetEvent((Map.Entry)event.getData())) {
                    event.setCanceled(true);
                }
            }
        });
        eventSet.getOnAfterGetEvent().add(new ActionListener_1x0<ActionEventAfter_1x0<Map.Entry<K, V>>>(){

            @Override
            public void actionPerformedImpl(ActionEventAfter_1x0<Map.Entry<K, V>> event) {
                Map.Entry entry = event.getData();
                EventMap_1x2.this.fireOnAfterGetEvent(entry.getKey(), entry.getValue());
            }
        });
        return eventSet;
    }

    @Override
    public Set<K> keySet() {
        EventSet_1x0 eventSet = new EventSet_1x0(super.keySet());
        eventSet.getOnBeforeRemoveEvent().add(new ActionListener_1x0<ActionEventBefore_1x0<K>>(){

            @Override
            public void actionPerformedImpl(ActionEventBefore_1x0<K> event) {
                if (EventMap_1x2.this.fireOnBeforeRemoveEvent(event.getData())) {
                    event.setCanceled(true);
                }
            }
        });
        final ObjectPointer_1x0<Object> valueToBeRemoved = new ObjectPointer_1x0<Object>(null);
        eventSet.getOnBeforeRemoveEvent().add(new ActionListener_1x0<ActionEventBefore_1x0<K>>(){

            @Override
            public void actionPerformedImpl(ActionEventBefore_1x0<K> event) {
                Object key = event.getData();
                Object value = ((Map)EventMap_1x2.this.decorated).get(key);
                valueToBeRemoved.setObject(value);
            }
        });
        eventSet.getOnAfterRemoveEvent().add(new ActionListener_1x0<ActionEventAfter_1x0<K>>(){

            @Override
            public void actionPerformedImpl(ActionEventAfter_1x0<K> event) {
                EventMap_1x2.this.fireOnAfterRemoveEvent(new EntryImpl_1x0(event.getData(), valueToBeRemoved.getObject()));
            }
        });
        eventSet.getOnBeforeClearEvent().add(new ActionListener_1x0<ActionEventBefore_1x0<Collection<K>>>(){

            @Override
            public void actionPerformedImpl(ActionEventBefore_1x0<Collection<K>> event) {
                if (EventMap_1x2.this.fireOnBeforeClearEvent()) {
                    event.setCanceled(true);
                }
            }
        });
        eventSet.getOnAfterClearEvent().add(new ActionListener_1x0<ActionEventAfter_1x0<Collection<K>>>(){

            @Override
            public void actionPerformedImpl(ActionEventAfter_1x0<Collection<K>> event) {
                EventMap_1x2.this.fireOnAfterClearEvent();
            }
        });
        eventSet.getOnBeforeGetEvent().add(new ActionListener_1x0<ActionEventBefore_1x0<K>>(){

            @Override
            public void actionPerformedImpl(ActionEventBefore_1x0<K> event) {
                Object value;
                Object key = event.getData();
                EntryImpl_1x0 entry = new EntryImpl_1x0(key, value = ((Map)EventMap_1x2.this.decorated).get(key));
                if (EventMap_1x2.this.fireOnBeforeGetEvent(entry)) {
                    event.setCanceled(true);
                }
            }
        });
        eventSet.getOnAfterGetEvent().add(new ActionListener_1x0<ActionEventAfter_1x0<K>>(){

            @Override
            public void actionPerformedImpl(ActionEventAfter_1x0<K> event) {
                Object key = event.getData();
                EventMap_1x2.this.fireOnAfterGetEvent(key, null);
            }
        });
        return eventSet;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){
            private Collection<V> valuesCollection;
            private Set<Map.Entry<K, V>> entrySet;
            {
                this.valuesCollection = EventMap_1x2.super.values();
                this.entrySet = EventMap_1x2.this.entrySet();
            }

            @Override
            public boolean add(V e) {
                throw new UnsupportedOperationException("cant't add elements to the set, because the set represents the values of the map. It can't add value without the key");
            }

            @Override
            public boolean addAll(Collection<? extends V> c) {
                throw new UnsupportedOperationException("cant't add elements to the set, because the set represents the values of the map. It can't add value without the key");
            }

            @Override
            public void clear() {
                EventMap_1x2.this.clear();
            }

            @Override
            public Iterator<V> iterator() {
                final Iterator it = this.entrySet.iterator();
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public V next() {
                        return ((Map.Entry)it.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return this.valuesCollection.size();
            }
        };
    }

    @Override
    public V get(Object key) {
        Object value = super.get(key);
        Object k = key;
        if (k != null) {
            EntryImpl_1x0 entry = new EntryImpl_1x0(k, value);
            if (this.fireOnBeforeGetEvent(entry)) {
                throw new NoSuchElementException("the get-operation in EventMap was canceled in an registered ActionListener on the EventMap_1x0.OnBeforeGetEvent");
            }
            value = entry.getValue();
            this.fireOnAfterGetEvent(k, value);
        }
        return value;
    }

    public Delegate_1x0<ActionEventBefore_1x0<EntryImpl_1x0<K, V>>> getOnBeforePutEvent() {
        if (this.onBeforePutEvent == null) {
            this.onBeforePutEvent = new Delegate_1x0Impl<ActionEventBefore_1x0<EntryImpl_1x0<K, V>>>();
        }
        return this.onBeforePutEvent;
    }

    public Delegate_1x0<ActionEventAfter_1x0<Map.Entry<K, V>>> getOnAfterPutEvent() {
        if (this.onAfterPutEvent == null) {
            this.onAfterPutEvent = new Delegate_1x0Impl<ActionEventAfter_1x0<Map.Entry<K, V>>>();
        }
        return this.onAfterPutEvent;
    }

    public Delegate_1x0<ActionEventBefore_1x0<K>> getOnBeforeRemoveEvent() {
        if (this.onBeforeRemoveEvent == null) {
            this.onBeforeRemoveEvent = new Delegate_1x0Impl<ActionEventBefore_1x0<K>>();
        }
        return this.onBeforeRemoveEvent;
    }

    public Delegate_1x0<ActionEventAfter_1x0<Map.Entry<K, V>>> getOnAfterRemoveEvent() {
        if (this.onAfterRemoveEvent == null) {
            this.onAfterRemoveEvent = new Delegate_1x0Impl<ActionEventAfter_1x0<Map.Entry<K, V>>>();
        }
        return this.onAfterRemoveEvent;
    }

    public Delegate_1x0<ActionEventBefore_1x0<Map<K, V>>> getOnBeforeClearEvent() {
        if (this.onBeforeClearEvent == null) {
            this.onBeforeClearEvent = new Delegate_1x0Impl<ActionEventBefore_1x0<Map<K, V>>>();
        }
        return this.onBeforeClearEvent;
    }

    public Delegate_1x0<ActionEventAfter_1x0<Map<K, V>>> getOnAfterClearEvent() {
        if (this.onAfterClearEvent == null) {
            this.onAfterClearEvent = new Delegate_1x0Impl<ActionEventAfter_1x0<Map<K, V>>>();
        }
        return this.onAfterClearEvent;
    }

    protected boolean fireOnBeforePutEvent(EntryImpl_1x0<K, V> entry) {
        if (this.onBeforePutEvent != null) {
            ActionEventBefore_1x0<EntryImpl_1x0<K, V>> actionBefore = new ActionEventBefore_1x0<EntryImpl_1x0<K, V>>((Object)this, 0, CM_BEFORE_PUT, entry);
            this.onBeforePutEvent.fire(actionBefore);
            return actionBefore.isCanceled();
        }
        return false;
    }

    protected void fireOnAfterPutEvent(K key, V value) {
        if (this.onAfterPutEvent != null) {
            this.onAfterPutEvent.fire(new ActionEventAfter_1x0<EntryImpl_1x0<K, V>>((Object)this, 0, CM_AFTER_PUT, new EntryImpl_1x0<K, V>(key, value)));
        }
    }

    protected boolean fireOnBeforeRemoveEvent(K key) {
        if (this.onBeforeRemoveEvent != null) {
            ActionEventBefore_1x0<K> actionBefore = new ActionEventBefore_1x0<K>((Object)this, 0, CM_BEFORE_REMOVE, key);
            this.onBeforeRemoveEvent.fire(actionBefore);
            return actionBefore.isCanceled();
        }
        return false;
    }

    protected void fireOnAfterRemoveEvent(Map.Entry<K, V> entry) {
        if (this.onAfterRemoveEvent != null) {
            this.onAfterRemoveEvent.fire(new ActionEventAfter_1x0<Map.Entry<K, V>>((Object)this, 0, CM_AFTER_REMOVE, entry));
        }
    }

    protected boolean fireOnBeforeClearEvent() {
        if (this.onBeforeClearEvent != null) {
            ActionEventBefore_1x0<EventMap_1x2> actionBefore = new ActionEventBefore_1x0<EventMap_1x2>((Object)this, 0, CM_BEFORE_CLEAR, this);
            this.onBeforeClearEvent.fire(actionBefore);
            return actionBefore.isCanceled();
        }
        return false;
    }

    protected void fireOnAfterClearEvent() {
        if (this.onAfterClearEvent != null) {
            ActionEventAfter_1x0<EventMap_1x2> actionBefore = new ActionEventAfter_1x0<EventMap_1x2>((Object)this, 0, CM_BEFORE_CLEAR, this);
            this.onAfterClearEvent.fire(actionBefore);
        }
    }

    public Delegate_1x0<ActionEventBefore_1x0<K>> getOnBeforeModifyEvent() {
        if (this.onBeforeModifyEvent == null) {
            this.onBeforeModifyEvent = new Delegate_1x0Impl<ActionEventBefore_1x0<K>>();
            this.getOnBeforePutEvent().add(new ActionListener_1x0<ActionEventBefore_1x0<EntryImpl_1x0<K, V>>>(){

                @Override
                public void actionPerformedImpl(ActionEventBefore_1x0<EntryImpl_1x0<K, V>> event) {
                    event.setCanceled(EventMap_1x2.this.fireOnBeforeeModifyEvent(((EntryImpl_1x0)event.getData()).getKey(), event.getActionCommand()));
                }
            });
            this.getOnBeforeRemoveEvent().add(new ActionListener_1x0<ActionEventBefore_1x0<K>>(){

                @Override
                public void actionPerformedImpl(ActionEventBefore_1x0<K> event) {
                    if (!EventMap_1x2.this.putExecution) {
                        event.setCanceled(EventMap_1x2.this.fireOnBeforeeModifyEvent(event.getData(), event.getActionCommand()));
                    }
                }
            });
        }
        return this.onBeforeModifyEvent;
    }

    protected boolean fireOnBeforeeModifyEvent(K key, String modificationOperation) {
        if (this.onBeforeModifyEvent != null) {
            ActionEventBefore_1x0<K> actionBefore = new ActionEventBefore_1x0<K>((Object)this, 0, modificationOperation, key);
            this.onBeforeModifyEvent.fire(actionBefore);
            return actionBefore.isCanceled();
        }
        return false;
    }

    public Delegate_1x0<ActionEventAfter_1x0<Map.Entry<K, V>>> getOnAfterModifyEvent() {
        if (this.onAfterModifyEvent == null) {
            this.onAfterModifyEvent = new Delegate_1x0Impl<ActionEventAfter_1x0<Map.Entry<K, V>>>();
            this.getOnAfterPutEvent().add(new ActionListener_1x0<ActionEventAfter_1x0<Map.Entry<K, V>>>(){

                @Override
                public void actionPerformedImpl(ActionEventAfter_1x0<Map.Entry<K, V>> event) {
                    EventMap_1x2.this.fireOnAfterModifyEvent(event.getData(), event.getActionCommand());
                }
            });
            this.getOnAfterRemoveEvent().add(new ActionListener_1x0<ActionEventAfter_1x0<Map.Entry<K, V>>>(){

                @Override
                public void actionPerformedImpl(ActionEventAfter_1x0<Map.Entry<K, V>> event) {
                    if (!EventMap_1x2.this.putExecution) {
                        EventMap_1x2.this.fireOnAfterModifyEvent(event.getData(), event.getActionCommand());
                    }
                }
            });
        }
        return this.onAfterModifyEvent;
    }

    protected void fireOnAfterModifyEvent(Map.Entry<K, V> entry, String modificationOperation) {
        if (this.onAfterModifyEvent != null) {
            ActionEventAfter_1x0<Map.Entry<K, V>> actionBefore = new ActionEventAfter_1x0<Map.Entry<K, V>>((Object)this, 0, modificationOperation, entry);
            this.onAfterModifyEvent.fire(actionBefore);
        }
    }

    public Delegate_1x0<ActionEventBefore_1x0<Map.Entry<K, V>>> getOnBeforeGetEvent() {
        if (this.onBeforeGetEvent == null) {
            this.onBeforeGetEvent = new Delegate_1x0Impl<ActionEventBefore_1x0<Map.Entry<K, V>>>();
        }
        return this.onBeforeGetEvent;
    }

    public Delegate_1x0<ActionEventAfter_1x0<Map.Entry<K, V>>> getOnAfterGetEvent() {
        if (this.onAfterGetEvent == null) {
            this.onAfterGetEvent = new Delegate_1x0Impl<ActionEventAfter_1x0<Map.Entry<K, V>>>();
        }
        return this.onAfterGetEvent;
    }

    protected boolean fireOnBeforeGetEvent(Map.Entry<K, V> entry) {
        if (this.onBeforeGetEvent != null) {
            ActionEventBefore_1x0<Map.Entry<K, V>> actionBefore = new ActionEventBefore_1x0<Map.Entry<K, V>>((Object)this, 0, CM_BEFORE_PUT, entry);
            this.onBeforeGetEvent.fire(actionBefore);
            entry.setValue(((Map.Entry)actionBefore.getData()).getValue());
            return actionBefore.isCanceled();
        }
        return false;
    }

    protected void fireOnAfterGetEvent(K key, V value) {
        if (this.onAfterGetEvent != null) {
            this.onAfterGetEvent.fire(new ActionEventAfter_1x0<EntryImpl_1x0<K, V>>((Object)this, 0, CM_AFTER_PUT, new EntryImpl_1x0<K, V>(key, value)));
        }
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.3f);
    }
}

