/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.lists.decorators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.happy.collections.decorators.EventCollection_1x0;
import org.happy.collections.lists.List_1x0;
import org.happy.collections.lists.decorators.ListDecorator_1x0;
import org.happy.collections.lists.decorators.iterators.ListIteratorDecorator_1x0;
import org.happy.commons.util.ObjectPointer_1x0;

public class EventList_1x0<E>
extends EventCollection_1x0<E>
implements List_1x0<E> {
    ListDecorator_1x0<E, List<E>> listDecoratoror;
    private boolean iteratorLock = false;

    public static <E> EventList_1x0<E> of(List<E> list) {
        return new EventList_1x0<E>(list);
    }

    public static <E> EventList_1x0<E> of() {
        return new EventList_1x0<E>();
    }

    public EventList_1x0(List<E> list) {
        super(list);
        this.listDecoratoror = new ListDecorator_1x0<E, List<E>>(list){

            @Override
            public E get(int index) {
                Object obj = super.get(index);
                ObjectPointer_1x0 p = ObjectPointer_1x0.of(obj);
                if (EventList_1x0.this.fireOnBeforeGetEvent(p)) {
                    throw new NoSuchElementException("EventList.get(int index) method caused the execption, because the get-operation for element at this index was canceled in an registered ActionListener on the BeforeGetEvent");
                }
                obj = p.getObject();
                EventList_1x0.this.fireOnAfterGetEvent(obj);
                return obj;
            }

            @Override
            protected ListIterator<E> listIteratorImpl(int index) {
                ListIteratorDecorator_1x0 it = new ListIteratorDecorator_1x0<E>(super.listIterator(index)){
                    private E obj;

                    @Override
                    public E next() {
                        ObjectPointer_1x0<Object> p;
                        block1: {
                            p = ObjectPointer_1x0.of(null);
                            do {
                                this.obj = super.next();
                                p.setObject(this.obj);
                                if (!EventList_1x0.this.fireOnBeforeGetEvent(p)) break block1;
                            } while (super.hasNext());
                            throw new NoSuchElementException("the EventList.ListIterator.next() caused runntime exception, because it reached the nunmberOfTasks of the List, but couldn't return the last element because the get-operation for it was canceled in BeforeGetEvent!");
                        }
                        this.obj = p.getObject();
                        EventList_1x0.this.fireOnAfterGetEvent(this.obj);
                        return this.obj;
                    }

                    @Override
                    public E previous() {
                        ObjectPointer_1x0<Object> p;
                        block1: {
                            p = ObjectPointer_1x0.of(null);
                            do {
                                this.obj = super.previous();
                                p.setObject(this.obj);
                                if (!EventList_1x0.this.fireOnBeforeGetEvent(p)) break block1;
                            } while (super.hasPrevious());
                            throw new NoSuchElementException("the EventList.ListIterator.previous() caused runntime exception, because it reached the start of the List, but couldn't return first element because the get-operation for it was canceled in BeforeGetEvent!");
                        }
                        this.obj = p.getObject();
                        EventList_1x0.this.fireOnAfterGetEvent(this.obj);
                        return this.obj;
                    }

                    @Override
                    public void add(E e) {
                        ObjectPointer_1x0 p = ObjectPointer_1x0.of(e);
                        if (EventList_1x0.this.fireOnBeforeAddEvent(p)) {
                            return;
                        }
                        e = p.getObject();
                        EventList_1x0.this.iteratorLock = true;
                        super.add(e);
                        EventList_1x0.this.iteratorLock = false;
                        EventList_1x0.this.fireOnAfterAddEvent(e);
                    }

                    @Override
                    public void remove() {
                        ObjectPointer_1x0 p = ObjectPointer_1x0.of(this.obj);
                        if (EventList_1x0.this.fireOnBeforeRemoveEvent(p)) {
                            return;
                        }
                        if (!(this.obj == p.getObject() || this.obj != null && this.obj.equals(p.getObject()))) {
                            throw new IllegalStateException("the object which should be removed was changed in the beforeRemoveEvent and can't be removed, because the iterator points to other object!!");
                        }
                        this.obj = p.getObject();
                        EventList_1x0.this.iteratorLock = true;
                        super.remove();
                        EventList_1x0.this.iteratorLock = false;
                        EventList_1x0.this.fireOnAfterRemoveEvent(this.obj);
                    }

                    @Override
                    public void set(E e) {
                        ObjectPointer_1x0 p = ObjectPointer_1x0.of(e);
                        if (EventList_1x0.this.fireOnBeforeRemoveEvent(p)) {
                            return;
                        }
                        if (EventList_1x0.this.fireOnBeforeAddEvent(p)) {
                            return;
                        }
                        e = p.getObject();
                        EventList_1x0.this.iteratorLock = true;
                        super.set(e);
                        EventList_1x0.this.iteratorLock = false;
                        EventList_1x0.this.fireOnAfterRemoveEvent(e);
                        EventList_1x0.this.fireOnAfterAddEvent(e);
                    }
                };
                return it;
            }

            @Override
            protected Iterator<E> iteratorImpl() {
                return EventList_1x0.super.iterator();
            }

            @Override
            public List<E> subList(int fromIndex, int toIndex) {
                return new EventList_1x0<E>(super.subList(fromIndex, toIndex)){

                    @Override
                    protected boolean fireOnBeforeAddEvent(ObjectPointer_1x0<E> p) {
                        return EventList_1x0.this.fireOnBeforeAddEvent(p);
                    }

                    @Override
                    protected void fireOnAfterAddEvent(E obj) {
                        EventList_1x0.this.fireOnAfterAddEvent(obj);
                    }

                    @Override
                    protected boolean fireOnBeforeClearEvent() {
                        return EventList_1x0.this.fireOnBeforeClearEvent();
                    }

                    @Override
                    protected void fireOnAfterClearEvent() {
                        EventList_1x0.this.fireOnAfterClearEvent();
                    }

                    @Override
                    protected boolean fireOnBeforeRemoveEvent(ObjectPointer_1x0<E> p) {
                        return EventList_1x0.this.fireOnBeforeRemoveEvent(p);
                    }

                    @Override
                    protected void fireOnAfterRemoveEvent(E obj) {
                        EventList_1x0.this.fireOnAfterRemoveEvent(obj);
                    }

                    @Override
                    protected boolean fireOnBeforeGetEvent(ObjectPointer_1x0<E> p) {
                        return EventList_1x0.this.fireOnBeforeGetEvent(p);
                    }

                    @Override
                    protected void fireOnAfterGetEvent(E obj) {
                        EventList_1x0.this.fireOnAfterGetEvent(obj);
                    }
                };
            }
        };
    }

    public EventList_1x0() {
        this(new ArrayList());
    }

    @Override
    public void add(int index, E o) {
        if (this.iteratorLock) {
            this.listDecoratoror.add(index, o);
            return;
        }
        ObjectPointer_1x0<E> p = ObjectPointer_1x0.of(o);
        if (this.fireOnBeforeAddEvent(p)) {
            return;
        }
        o = p.getObject();
        this.listDecoratoror.add(index, o);
        this.fireOnAfterAddEvent(o);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        ArrayList<E> list = new ArrayList<E>();
        boolean ret = true;
        ObjectPointer_1x0<Object> p = ObjectPointer_1x0.of(null);
        for (Object obj : c) {
            if (this.onBeforeAddEvent != null) {
                p.setObject(obj);
                if (this.fireOnBeforeAddEvent(p)) continue;
                obj = p.getObject();
            }
            list.add(obj);
        }
        ret = this.listDecoratoror.addAll(index, list) && ret;
        for (Object obj : list) {
            this.fireOnAfterAddEvent(obj);
        }
        return ret;
    }

    @Override
    public E remove(int index) {
        E obj;
        if (this.iteratorLock) {
            return this.listDecoratoror.remove(index);
        }
        if (this.onBeforeRemoveEvent != null) {
            obj = this.get(index);
            ObjectPointer_1x0<E> p = ObjectPointer_1x0.of(obj);
            if (this.fireOnBeforeRemoveEvent(p)) {
                return null;
            }
            if (obj != p.getObject()) {
                super.remove(obj);
            }
        }
        obj = this.listDecoratoror.remove(index);
        this.fireOnAfterRemoveEvent(obj);
        return obj;
    }

    @Override
    public E set(int index, E o) {
        IndexOutOfBoundsException ex;
        if (this.iteratorLock) {
            this.listDecoratoror.set(index, o);
        }
        if ((ex = this.checkIndex(index)) != null) {
            throw ex;
        }
        E obj = this.get(index);
        if (obj != null) {
            ObjectPointer_1x0<E> p = ObjectPointer_1x0.of(obj);
            if (this.fireOnBeforeRemoveEvent(p)) {
                return null;
            }
            if (this.fireOnBeforeAddEvent(p)) {
                return null;
            }
            obj = p.getObject();
        }
        E ret = this.listDecoratoror.set(index, o);
        this.fireOnAfterRemoveEvent(ret);
        this.fireOnAfterAddEvent(o);
        return ret;
    }

    @Override
    protected IndexOutOfBoundsException checkIndex(int index) {
        int length = ((Collection)this.decorated).size();
        if (index < 0) {
            return new IndexOutOfBoundsException("index must be grater then 0");
        }
        if (length < index) {
            return new IndexOutOfBoundsException("index must be smaler then list.size()");
        }
        return null;
    }

    @Override
    public E get(int index) {
        return this.listDecoratoror.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.listDecoratoror.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object index) {
        return this.listDecoratoror.lastIndexOf(index);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listDecoratoror.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.listDecoratoror.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.listDecoratoror.subList(fromIndex, toIndex);
    }

    @Override
    public ListIterator<E> listIterator(E elem) {
        return this.listDecoratoror.listIterator(elem);
    }
}

