/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.util;

import net.seninp.util.JmotifMapEntry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMapEntry {
    private static final String KEY1 = "key1";
    private static final String KEY2 = "key2";
    private static final Integer KEY3 = 75;
    private static final String VALUE1 = "value1";
    private static final String VALUE2 = "value2";
    private static final Double VALUE3 = 12.77;
    private JmotifMapEntry<String, String> e1;
    private JmotifMapEntry<String, String> e2;
    private JmotifMapEntry<Integer, Double> e3;
    private JmotifMapEntry<String, String> e4;

    @Before
    public void setUp() throws Exception {
        this.e1 = new JmotifMapEntry<String, String>(KEY1, VALUE1);
        this.e2 = new JmotifMapEntry<String, String>(KEY1, VALUE1);
        this.e3 = new JmotifMapEntry<Integer, Double>(KEY3, VALUE3);
        this.e4 = new JmotifMapEntry<String, String>(KEY2, VALUE2);
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals(this.e1.hashCode(), this.e2.hashCode());
        Assert.assertNotEquals(this.e1.hashCode(), this.e3.hashCode());
    }

    @Test
    public void testGetKey() {
        Assert.assertEquals(this.e1.getKey(), KEY1);
        Assert.assertEquals(this.e3.getKey(), KEY3);
        Assert.assertNotEquals(this.e1.getKey(), KEY3);
    }

    @Test
    public void testGetValue() {
        Assert.assertEquals(this.e1.getValue(), VALUE1);
        Assert.assertEquals(this.e3.getValue(), VALUE3);
        Assert.assertNotEquals(this.e1.getValue(), VALUE3);
    }

    @Test
    public void testSetValue() {
        this.e2.setValue(VALUE1);
        Assert.assertEquals(this.e2.getValue(), VALUE1);
    }

    @Test
    public void testEqualsObject() {
        JmotifMapEntry<String, String> e11 = new JmotifMapEntry<String, String>(KEY1, VALUE1);
        Assert.assertTrue(e11.equals(this.e1));
        Assert.assertTrue(this.e1.equals(this.e2));
        Assert.assertTrue(this.e1.equals(this.e1));
        Assert.assertFalse(this.e1.equals(null));
        Assert.assertFalse(this.e1.equals(17));
        Assert.assertFalse(new JmotifMapEntry<Object, Object>(null, null).equals(this.e1));
        Assert.assertFalse(new JmotifMapEntry<String, Object>("key", null).equals(this.e1));
        Assert.assertFalse(new JmotifMapEntry<String, Double>(KEY1, VALUE3).equals(this.e1));
        Assert.assertFalse(e11.equals(this.e4));
    }

    @Test
    public void testToString() {
        Assert.assertTrue(this.e1.toString().contains(VALUE1));
        Assert.assertTrue(this.e1.toString().contains(KEY1));
        Assert.assertFalse(this.e1.toString().contains(VALUE2));
    }
}

