/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.tinker;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.sax.SAXException;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.alphabet.Alphabet;
import net.seninp.jmotif.sax.alphabet.NormalAlphabet;

public class PrintSAXProcess {
    private static final String INPUT_FNAME = "src/resources/test-data/ecg0606_1.csv";
    private static final int SAX_WIN_SIZE = 160;
    private static final int SAX_PAA_SIZE = 4;
    private static final int SAX_A_SIZE = 4;
    private static final double SAX_NORM_THRESHOLD = 0.001;
    private static final TSProcessor tsProcessor = new TSProcessor();
    private static final Alphabet na = new NormalAlphabet();
    private static final SAXProcessor sp = new SAXProcessor();
    private static final String TAB = "\t";
    private static final Object CR = "\n";
    private static final NumerosityReductionStrategy NR_STRATEGY = NumerosityReductionStrategy.EXACT;

    public static void main(String[] args) throws IOException, SAXException {
        double[] ts = TSProcessor.readFileColumn(INPUT_FNAME, 0, 0);
        double[] cuts = na.getCuts(4);
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File("test_sax.txt")));
        char[] previousString = null;
        for (int i = 0; i <= ts.length - 160; ++i) {
            StringBuffer sb = new StringBuffer();
            sb.append(i).append(TAB);
            double[] subSection = Arrays.copyOfRange(ts, i, i + 160);
            sb.append(Arrays.toString(subSection).replaceAll("\\s+", "")).append(TAB);
            subSection = tsProcessor.znorm(subSection, 0.001);
            double[] paa = tsProcessor.paa(subSection, 4);
            sb.append(Arrays.toString(paa).replaceAll("\\s+", "")).append(TAB);
            char[] currentString = tsProcessor.ts2String(paa, cuts);
            sb.append("\"").append(currentString).append("\"").append(TAB);
            if (null != previousString) {
                if (NumerosityReductionStrategy.EXACT.equals((Object)NR_STRATEGY) && Arrays.equals(previousString, currentString)) {
                    sb.append("skipped").append(CR);
                    bw.write(sb.toString());
                    continue;
                }
                if (NumerosityReductionStrategy.MINDIST.equals((Object)NR_STRATEGY) && sp.checkMinDistIsZero(previousString, currentString)) continue;
            }
            previousString = currentString;
            sb.append("kept").append(CR);
            bw.write(sb.toString());
        }
        bw.close();
    }
}

