/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.motif;

import java.util.ArrayList;
import net.seninp.jmotif.distance.EuclideanDistance;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.discord.BruteForceDiscordImplementation;
import net.seninp.jmotif.sax.motif.MotifRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BruteForceMotifImplementation {
    private static final Logger LOGGER = LoggerFactory.getLogger(BruteForceDiscordImplementation.class);
    private static TSProcessor tp = new TSProcessor();
    private static EuclideanDistance ed = new EuclideanDistance();
    public static int eaCounter;
    public static int distCounter;

    public static MotifRecord series2BruteForceMotifs(double[] series, int motifSize, double range, double znormThreshold) throws Exception {
        int bestMotifCount = -1;
        int bestMotifLiocation = -1;
        ArrayList<Integer> bestMotifOccurrences = null;
        for (int i = 0; i < series.length - motifSize; ++i) {
            int count = 0;
            ArrayList<Integer> occurrences = new ArrayList<Integer>();
            for (int j = 0; j < series.length - motifSize; ++j) {
                if (!BruteForceMotifImplementation.isNonTrivialMatch(series, i, j, motifSize, range, znormThreshold)) continue;
                ++count;
                occurrences.add(j);
            }
            if (count <= 0) continue;
            if (count > bestMotifCount) {
                bestMotifCount = count;
                bestMotifLiocation = i;
                bestMotifOccurrences = occurrences;
                LOGGER.debug("current best motif at {} with freq {}", (Object)bestMotifLiocation, (Object)occurrences.size());
                continue;
            }
            if (count != bestMotifCount) continue;
            LOGGER.debug(" ** its's a tie, checking for variation...");
            double[] motifA = tp.subseriesByCopy(series, bestMotifLiocation, bestMotifLiocation + motifSize);
            double[] distancesA = new double[count];
            double[] motifB = tp.subseriesByCopy(series, i, i + motifSize);
            double[] distancesB = new double[count];
            for (int j = 0; j < count; ++j) {
                double distB;
                double distA;
                Integer locA = (Integer)bestMotifOccurrences.get(j);
                distancesA[j] = distA = ed.distance(tp.znorm(motifA, znormThreshold), tp.znorm(tp.subseriesByCopy(series, locA, locA + motifSize), znormThreshold));
                Integer locB = (Integer)occurrences.get(j);
                distancesB[j] = distB = ed.distance(tp.znorm(motifB, znormThreshold), tp.znorm(tp.subseriesByCopy(series, locB, locB + motifSize), znormThreshold));
            }
            double varA = tp.var(distancesA);
            double varB = tp.var(distancesB);
            if (!(varB < varA)) continue;
            bestMotifCount = count;
            bestMotifLiocation = i;
            bestMotifOccurrences = occurrences;
            LOGGER.debug("updated current best motif to one at {} with freq {}", (Object)bestMotifLiocation, (Object)occurrences.size());
        }
        return new MotifRecord(bestMotifLiocation, bestMotifOccurrences);
    }

    private static boolean isNonTrivialMatch(double[] series, int i, int j, Integer motifSize, double range, double znormThreshold) {
        if (Math.abs(i - j) < motifSize) {
            return false;
        }
        Double dd = BruteForceMotifImplementation.eaDistance(series, i, j, motifSize, range, znormThreshold);
        return Double.isFinite(dd);
    }

    private static Double eaDistance(double[] series, int a, int b, Integer motifSize, double range, double znormThreshold) {
        ++distCounter;
        double cutOff2 = range * range;
        double[] seriesA = tp.znorm(tp.subseriesByCopy(series, a, a + motifSize), znormThreshold);
        double[] seriesB = tp.znorm(tp.subseriesByCopy(series, b, b + motifSize), znormThreshold);
        Double res = 0.0;
        for (int i = 0; i < motifSize; ++i) {
            if (!((res = Double.valueOf(res + BruteForceMotifImplementation.distance2(seriesA[i], seriesB[i]))) > cutOff2)) continue;
            ++eaCounter;
            return Double.NaN;
        }
        return Math.sqrt(res);
    }

    private static double distance2(double p1, double p2) {
        return (p1 - p2) * (p1 - p2);
    }
}

