/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.datastructures;

import java.util.ArrayList;
import net.seninp.jmotif.sax.motif.MotifRecord;
import org.junit.Assert;
import org.junit.Test;

public class TestMotifRecord {
    @Test
    public void testMotifRecord() {
        MotifRecord mr = new MotifRecord(1, new ArrayList<Integer>());
        Assert.assertSame("Testing constructor", 1, mr.getLocation());
        Assert.assertTrue("Testing constructor", mr.getOccurrences().isEmpty());
        Assert.assertSame("Testing constructor", 0, mr.getFrequency());
    }

    @Test
    public void testSetLocation() {
        MotifRecord mr = new MotifRecord(1, new ArrayList<Integer>());
        mr.setLocation(77);
        Assert.assertSame("Testing the setter", 77, mr.getLocation());
    }

    @Test
    public void testGetFrequency() {
        MotifRecord mr = new MotifRecord(0, new ArrayList<Integer>());
        Assert.assertTrue("Testing freqs", mr.isEmpty());
        Assert.assertSame("Testing freqs", 0, mr.getFrequency());
        mr.add(1);
        Assert.assertFalse("Testing freqs", mr.isEmpty());
        Assert.assertSame("Testing freqs", 1, mr.getFrequency());
        Assert.assertTrue("Testing freqs", mr.getOccurrences().contains(1));
        mr.add(77);
        Assert.assertSame("Testing freqs", 2, mr.getFrequency());
        Assert.assertTrue("Testing freqs", mr.getOccurrences().contains(77));
        mr.add(77);
        Assert.assertSame("Testing freqs", 2, mr.getOccurrences().size());
    }

    @Test
    public void testToString() {
        MotifRecord mr = new MotifRecord(0, new ArrayList<Integer>());
        mr.add(1);
        mr.add(2);
        Assert.assertNotNull("Testing to string", mr.toString());
    }
}

