/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.datastructures;

import net.seninp.jmotif.sax.datastructure.FrequencyTableEntry;
import org.junit.Assert;
import org.junit.Test;

public class TestFrequencyTableEntry {
    @Test
    public void testFrequencyTableEntryIntInt() {
        FrequencyTableEntry fe1 = new FrequencyTableEntry(10, 11);
        FrequencyTableEntry fe12 = new FrequencyTableEntry(10, 11);
        FrequencyTableEntry fe2 = new FrequencyTableEntry(19, 77);
        Assert.assertTrue(fe1.equals(fe12));
        Assert.assertFalse(fe1.equals(fe2));
        Assert.assertEquals(fe1.hashCode(), fe12.hashCode());
        Assert.assertNotEquals(fe1.hashCode(), fe2.hashCode());
        Assert.assertTrue(fe1.equals(fe12));
        Assert.assertFalse(fe1.equals(fe2));
    }

    @Test
    public void testFrequencyTableEntryIntegerCharArrayInt() {
        FrequencyTableEntry fe1 = new FrequencyTableEntry(10, "abcd".toCharArray(), 11);
        FrequencyTableEntry fe12 = new FrequencyTableEntry(10, "abcd".toCharArray(), 11);
        FrequencyTableEntry fe2 = new FrequencyTableEntry(19, "abcd".toCharArray(), 77);
        Assert.assertTrue(fe1.equals(fe12));
        Assert.assertFalse(fe1.equals(fe2));
        Assert.assertEquals(fe1.hashCode(), fe12.hashCode());
        Assert.assertNotEquals(fe1.hashCode(), fe2.hashCode());
        Assert.assertTrue(fe1.equals(fe12));
        Assert.assertFalse(fe1.equals(fe2));
    }

    @Test
    public void testFrequencyTableEntrySettersGetters() {
        FrequencyTableEntry fe1 = new FrequencyTableEntry(10, "abcd".toCharArray(), 11);
        FrequencyTableEntry fe12 = new FrequencyTableEntry(10, "abcd".toCharArray(), 11);
        FrequencyTableEntry fe2 = new FrequencyTableEntry(19, "abcd".toCharArray(), 77);
        Assert.assertEquals(fe1.getFrequency(), fe12.getFrequency());
        Assert.assertNotEquals(fe1.getFrequency(), fe2.getFrequency());
        Assert.assertEquals(fe1.getPosition(), fe12.getPosition());
        Assert.assertNotEquals(fe1.getPosition(), fe2.getPosition());
        Assert.assertTrue(String.valueOf(fe1.getStr()).equals(String.valueOf(fe12.getStr())));
        Assert.assertTrue(String.valueOf(fe1.getStr()).equals(String.valueOf(fe2.getStr())));
        fe2.setStr("bbbb".toCharArray());
        Assert.assertNotEquals(fe1.getStr(), fe2.getStr());
        Assert.assertTrue(fe2.isTrivial(0));
        Assert.assertTrue(fe1.isTrivial(5));
        Assert.assertFalse(fe1.isTrivial(2));
        fe1.setFrequency(fe2.getFrequency());
        Assert.assertEquals(fe1.getFrequency(), fe2.getFrequency());
    }

    @Test
    public void testToStringAndColne() {
        FrequencyTableEntry fe1 = new FrequencyTableEntry(10, "abcd".toCharArray(), 11);
        FrequencyTableEntry fe_copy = fe1.copy();
        Assert.assertTrue(fe1.toString().equalsIgnoreCase(fe_copy.toString()));
        int newPos = 22;
        fe_copy.setPosition(newPos);
        Assert.assertEquals(newPos, fe_copy.getPosition());
    }

    @Test
    public void testFrequencyTableEntryComplexity() {
        FrequencyTableEntry fe1 = new FrequencyTableEntry(10, "a".toCharArray(), 11);
        Assert.assertTrue(fe1.isTrivial(null));
        Assert.assertTrue(fe1.isTrivial(5));
        fe1.setStr("aaaaaa".toCharArray());
        Assert.assertTrue(fe1.isTrivial(5));
    }

    @Test
    public void testFrequencyTableEntryCmp() {
        FrequencyTableEntry fe1 = new FrequencyTableEntry(10, "a".toCharArray(), 11);
        try {
            fe1.compareTo(null);
            Assert.fail("Exception was not thrown!");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertTrue(fe1.equals(fe1));
        Assert.assertFalse(fe1.equals(null));
        Assert.assertFalse(fe1.equals(new Integer(5)));
    }
}

