/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax;

import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import org.junit.Assert;
import org.junit.Test;

public class TestNRStrategy {
    private static final NumerosityReductionStrategy none = NumerosityReductionStrategy.NONE;
    private static final NumerosityReductionStrategy exact = NumerosityReductionStrategy.EXACT;
    private static final NumerosityReductionStrategy mindist = NumerosityReductionStrategy.MINDIST;

    @Test
    public void testNRStrategy() {
        Assert.assertEquals(0L, none.index());
        Assert.assertEquals(1L, exact.index());
        Assert.assertEquals(2L, mindist.index());
        Assert.assertEquals((Object)NumerosityReductionStrategy.fromValue(0), (Object)none);
        Assert.assertEquals((Object)NumerosityReductionStrategy.fromValue(1), (Object)exact);
        Assert.assertEquals((Object)NumerosityReductionStrategy.fromValue(2), (Object)mindist);
        try {
            Assert.assertEquals((Object)NumerosityReductionStrategy.fromValue(77), (Object)mindist);
            Assert.fail("should throw an exception");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals((Object)NumerosityReductionStrategy.fromString("none"), (Object)none);
        Assert.assertEquals((Object)NumerosityReductionStrategy.fromString("exact"), (Object)exact);
        Assert.assertEquals((Object)NumerosityReductionStrategy.fromString("mindist"), (Object)mindist);
        try {
            Assert.assertEquals((Object)NumerosityReductionStrategy.fromString("oops"), (Object)mindist);
            Assert.fail("should throw an exception");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertTrue("NONE".equalsIgnoreCase(none.toString()));
        Assert.assertTrue("EXACT".equalsIgnoreCase(exact.toString()));
        Assert.assertTrue("MINDIST".equalsIgnoreCase(mindist.toString()));
    }
}

