/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax;

public enum NumerosityReductionStrategy {
    NONE(0),
    EXACT(1),
    MINDIST(2);

    private final int index;

    private NumerosityReductionStrategy(int index) {
        this.index = index;
    }

    public int index() {
        return this.index;
    }

    public static NumerosityReductionStrategy fromValue(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return EXACT;
            }
            case 2: {
                return MINDIST;
            }
        }
        throw new RuntimeException("Unknown index:" + value);
    }

    public String toString() {
        switch (this.index) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "EXACT";
            }
            case 2: {
                return "MINDIST";
            }
        }
        throw new RuntimeException("Unknown index:" + this.index);
    }

    public static NumerosityReductionStrategy fromString(String value) {
        if ("none".equalsIgnoreCase(value)) {
            return NONE;
        }
        if ("exact".equalsIgnoreCase(value)) {
            return EXACT;
        }
        if ("mindist".equalsIgnoreCase(value)) {
            return MINDIST;
        }
        throw new RuntimeException("Unknown index:" + value);
    }
}

