/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.generators.iterators;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class InterpolateDoubleStepIterator_1x3
implements Iterator<Double> {
    private Double end;
    private Double delta;
    private Double current;
    private boolean finished = false;

    public InterpolateDoubleStepIterator_1x3(Double start, Double end, int steps) {
        Preconditions.checkArgument((0 < steps ? 1 : 0) != 0);
        if (start.equals(end)) {
            Preconditions.checkArgument((steps == 1 ? 1 : 0) != 0, (Object)"if start==end -> steps=1");
            this.init(start, end, 0.0);
        } else {
            this.init(start, end, (end - start) / (double)(steps - 1));
        }
    }

    public InterpolateDoubleStepIterator_1x3(Double start, Double end, Double delta) {
        this.init(start, end, delta);
    }

    private void init(Double start, Double end, Double delta) {
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)end);
        if (start.equals(end)) {
            Preconditions.checkArgument((boolean)delta.equals(0.0), (Object)("if start==end; then the delta should be zero, but was " + delta));
        } else {
            Preconditions.checkArgument((start < end ? 1 : 0) != 0, (Object)"start must be smaller then the end!");
            Preconditions.checkArgument((0.0 < delta ? 1 : 0) != 0, (Object)"delta must be bigger then zero!");
        }
        this.end = end;
        this.delta = delta;
        this.current = start - delta;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        return this.current + this.delta <= this.end;
    }

    @Override
    public Double next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("there is no more elemnt to iterate over");
        }
        if (this.delta == 0.0) {
            this.finished = true;
        }
        this.current = this.current + this.delta;
        return this.current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove operation is not supported!");
    }

    public String toString() {
        return "InterpolateDoulbeIterator_1x2 [end=" + this.end + ", delta=" + this.delta + ", current=" + this.current + ", finished=" + this.finished + "]";
    }
}

