/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.generators;

import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.happy.commons.patterns.Generator_1x0;
import org.happy.commons.patterns.version.Version_1x0;
import org.happy.commons.util.Random_1x0;

public class CompositeGenerator_1x0<T>
implements Version_1x0<Float>,
Generator_1x0<T> {
    protected Map<Float, Generator_1x0<T>> generatorsMap;
    protected Random random;

    public static <T> CompositeGenerator_1x0<T> of(Map<Float, Generator_1x0<T>> generatorsMap) {
        return new CompositeGenerator_1x0<T>(generatorsMap);
    }

    public CompositeGenerator_1x0(Map<Float, Generator_1x0<T>> generatorsMap) {
        this(generatorsMap, Random_1x0.singelton());
    }

    public CompositeGenerator_1x0(Map<Float, Generator_1x0<T>> generatorsMap, Random random) {
        this.generatorsMap = generatorsMap;
        this.random = random;
    }

    @Override
    public T generate() {
        if (this.generatorsMap.size() == 0) {
            return null;
        }
        if (this.generatorsMap.size() == 1) {
            Generator_1x0<T> g = this.generatorsMap.entrySet().iterator().next().getValue();
            return g.generate();
        }
        Set<Float> probabilities = this.generatorsMap.keySet();
        Float allP = Float.valueOf(0.0f);
        for (Float p : probabilities) {
            allP = Float.valueOf(allP.floatValue() + p.floatValue());
        }
        Float untilP = Float.valueOf(allP.floatValue() * this.random.nextFloat());
        Float actual = Float.valueOf(0.0f);
        Set<Map.Entry<Float, Generator_1x0<T>>> entrySet = this.generatorsMap.entrySet();
        Generator_1x0<T> g = null;
        for (Map.Entry<Float, Generator_1x0<T>> entry : entrySet) {
            g = entry.getValue();
            actual = Float.valueOf(actual.floatValue() + entry.getKey().floatValue());
            if (!(untilP.floatValue() <= actual.floatValue())) continue;
            break;
        }
        return g.generate();
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.0f);
    }
}

