/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.decorators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.happy.collections.decorators.CollectionDecorator_1x0;
import org.happy.commons.patterns.Commitable_1x0;
import org.happy.commons.patterns.Flushable_1x0;
import org.happy.commons.util.Pair_1x0;

public class BufferedCollection_1x0<E>
extends CollectionDecorator_1x0<E, Collection<E>>
implements Commitable_1x0<Boolean>,
Flushable_1x0<Void> {
    protected transient List<Pair_1x0<E, Operation>> commandList;
    protected transient Map<E, AtomicInteger> objectMap;
    private int size;

    public static <E> BufferedCollection_1x0<E> of(Collection<E> decorateable) {
        return new BufferedCollection_1x0<E>(decorateable);
    }

    public BufferedCollection_1x0(Collection<E> decorateable) {
        super(decorateable, true);
        this.size = decorateable.size();
        this.commandList = new ArrayList<Pair_1x0<E, Operation>>();
        this.objectMap = new HashMap<E, AtomicInteger>();
    }

    protected List<E> createBufferList() {
        ArrayList<E> list = new ArrayList<E>();
        for (Pair_1x0<E, Operation> command : this.commandList) {
            if (Operation.Add.equals((Object)command.getSnd())) {
                list.add(command.getFst());
                continue;
            }
            list.remove(command.getFst());
        }
        return list;
    }

    @Override
    public void setDecorated(Collection<E> decorated) {
        this.flush();
        super.setDecorated(decorated);
        this.size = decorated.size();
    }

    @Override
    public void setDecorateIterators(boolean decorateIterators) {
        throw new UnsupportedOperationException("setDecorateIterators is not supported!");
    }

    protected void addCommand(Pair_1x0<E, Operation> command) {
        this.commandList.add(command);
        AtomicInteger value = this.objectMap.get(command.getFst());
        if (Operation.Add.equals((Object)command.getSnd())) {
            if (value == null) {
                this.objectMap.put(command.getFst(), new AtomicInteger(1));
            } else {
                value.getAndIncrement();
            }
            ++this.size;
        } else {
            if (value == null) {
                this.objectMap.put(command.getFst(), new AtomicInteger(-1));
            } else {
                value.getAndDecrement();
            }
            --this.size;
        }
    }

    @Override
    protected Iterator<E> iteratorImpl() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        return ((Collection)this.decorated).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator itDecorated = ((Collection)this.decorated).iterator();
        final HashMap<E, AtomicInteger> objectMapCopy = new HashMap<E, AtomicInteger>();
        for (Map.Entry<E, AtomicInteger> entry : this.objectMap.entrySet()) {
            objectMapCopy.put(entry.getKey(), new AtomicInteger(entry.getValue().get()));
        }
        final Iterator<E> bufferIterator = this.createBufferList().iterator();
        return new Iterator<E>(){
            private E nextElem = null;
            private boolean hasNextSolved = false;
            private boolean hasNext = false;
            private boolean nextExecuted = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (this.hasNextSolved) {
                    return this.hasNext;
                }
                try {
                    AtomicInteger value = (AtomicInteger)objectMapCopy.get(this.nextElem);
                    while (itDecorated.hasNext()) {
                        this.nextElem = itDecorated.next();
                        if (value != null && value.get() < 0) {
                            value.decrementAndGet();
                            continue;
                        }
                        this.hasNext = true;
                        boolean bl = true;
                        return bl;
                    }
                    this.hasNext = bufferIterator.hasNext();
                    if (this.hasNext) {
                        this.nextElem = bufferIterator.next();
                    }
                    boolean bl = this.hasNext;
                    return bl;
                }
                finally {
                    this.hasNextSolved = true;
                }
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("no more lements, the iterator has riched the end!");
                }
                this.nextExecuted = true;
                this.hasNextSolved = false;
                return this.nextElem;
            }

            @Override
            public void remove() {
                if (!this.nextExecuted) {
                    throw new IllegalStateException("you have to excute iterator.next() before you can call remove() method");
                }
                AtomicInteger value = (AtomicInteger)objectMapCopy.get(this.nextElem);
                if (value != null) {
                    value.decrementAndGet();
                }
                BufferedCollection_1x0.this.addCommand(new Pair_1x0(this.nextElem, Operation.Remove));
                this.nextExecuted = false;
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        Iterator<E> it = this.iterator();
        StringBuilder b = new StringBuilder("[");
        while (it.hasNext()) {
            E e = it.next();
            if (e == null) {
                b.append("null");
            } else {
                b.append(e.toString());
            }
            if (!it.hasNext()) continue;
            b.append(",");
        }
        b.append("]");
        return b.toString();
    }

    @Override
    public boolean add(E o) {
        Pair_1x0<E, Operation> command = new Pair_1x0<E, Operation>(o, Operation.Add);
        this.addCommand(command);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E obj : c) {
            changed = this.add(obj) || changed;
        }
        return changed;
    }

    @Override
    public void clear() {
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    @Override
    public boolean remove(Object o) {
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            E e = it.next();
            if (o == null && e == null) {
                it.remove();
                return true;
            }
            if (e == null || !e.equals(o)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            E e = it.next();
            if (!c.contains(e)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            E e = it.next();
            if (c.contains(e)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean contains(Object o) {
        AtomicInteger value = this.objectMap.get(o);
        if (value == null) {
            return ((Collection)this.decorated).contains(o);
        }
        int number = value.get();
        if (0 < number) {
            return true;
        }
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (0 < number) {
                return true;
            }
            E e = it.next();
            if (o == null || e == null) {
                if (o != e) continue;
                ++number;
                continue;
            }
            if (!e.equals(o)) continue;
            ++number;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray() {
        Iterator<E> it = this.iterator();
        ArrayList<E> arrayList = new ArrayList<E>();
        while (it.hasNext()) {
            arrayList.add(it.next());
        }
        return arrayList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Iterator<E> it = this.iterator();
        ArrayList<E> arrayList = new ArrayList<E>();
        while (it.hasNext()) {
            arrayList.add(it.next());
        }
        return arrayList.toArray(a);
    }

    @Override
    public Void flush() {
        this.commandList.clear();
        this.objectMap.clear();
        this.size = ((Collection)this.decorated).size();
        return null;
    }

    @Override
    public Boolean commit() {
        if (this.commandList.isEmpty()) {
            return true;
        }
        ArrayList<E> tempList = new ArrayList<E>();
        Enum lastOperation = null;
        for (Pair_1x0<E, Operation> command : this.commandList) {
            if (lastOperation == null || lastOperation.equals((Object)command.getSnd())) {
                tempList.add(command.getFst());
            } else {
                if (Operation.Add.equals(lastOperation)) {
                    ((Collection)this.decorated).addAll(tempList);
                } else {
                    for (Object obj : tempList) {
                        ((Collection)this.decorated).remove(obj);
                    }
                }
                tempList.clear();
                tempList.add(command.getFst());
            }
            lastOperation = command.getSnd();
        }
        if (Operation.Add.equals(lastOperation)) {
            ((Collection)this.decorated).addAll(tempList);
        } else {
            for (Pair_1x0<Object, Operation> obj : tempList) {
                ((Collection)this.decorated).remove(obj);
            }
        }
        this.flush();
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Collection) {
            Collection s = (Collection)object;
            try {
                return this.size() == s.size() && this.containsAll(s);
            }
            catch (NullPointerException ignored) {
                return false;
            }
            catch (ClassCastException ignored) {
                return false;
            }
        }
        return false;
    }

    protected static enum Operation {
        Add,
        Remove;

    }
}

