/*
 * Decompiled with CFR 0.152.
 */
package motifSets;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;

public class SlidingWindow {
    public static double[] sampling(double[] series, int sampling) {
        if (series.length > sampling) {
            int factor = series.length / sampling;
            double[] resampled = new double[series.length / factor];
            System.out.println("Factor:" + factor + " " + resampled.length);
            for (int i = 0; i < resampled.length; ++i) {
                resampled[i] = series[i * factor];
            }
            return resampled;
        }
        return series;
    }

    public static double[][] loadSegments(String dataSet, int w) {
        try {
            ArrayList<Double> ts = new ArrayList<Double>();
            String line = null;
            try (BufferedReader br = new BufferedReader(new FileReader(dataSet));){
                while ((line = br.readLine()) != null) {
                    ts.add(Double.parseDouble(line));
                }
            }
            double[] ts2 = new double[ts.size()];
            for (int i = 0; i < ts.size(); ++i) {
                ts2[i] = (Double)ts.get(i);
            }
            ts2 = SlidingWindow.sampling(ts2, 10000);
            return SlidingWindow.slidingWindow(ts2, w);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static double[][] slidingWindow(double[] data, int n) {
        return SlidingWindow.convert(data, n);
    }

    private static double[][] convert(double[] data, int n) {
        int noSub = data.length - (n - 1);
        double[][] newDat = new double[noSub][];
        for (int i = 0; i < noSub; ++i) {
            double[] temp = new double[n];
            int count = 0;
            for (int j = i; j < i + n; ++j) {
                temp[count] = data[j];
                ++count;
            }
            newDat[i] = SlidingWindow.normalise(temp);
        }
        return newDat;
    }

    private static double[] normalise(double[] old) {
        int i;
        double[] data = new double[old.length];
        double mean = 0.0;
        double sd = 0.0;
        for (i = 0; i < old.length; ++i) {
            mean += old[i];
        }
        mean /= (double)old.length;
        for (i = 0; i < old.length; ++i) {
            sd += (old[i] - mean) * (old[i] - mean);
        }
        if (sd != 0.0) {
            sd /= (double)old.length;
            sd = Math.sqrt(sd);
            for (i = 0; i < old.length; ++i) {
                data[i] = (old[i] - mean) / sd;
            }
        } else {
            for (i = 0; i < old.length; ++i) {
                data[i] = old[i] - mean;
            }
        }
        return data;
    }

    public static void writeSubsequencesToFile(String outFileName, double[][] subs) throws IOException {
        PrintWriter cout = new PrintWriter((Writer)new FileWriter(outFileName), true);
        for (int i = 0; i < subs.length; ++i) {
            String line = "";
            for (int j = 0; j < subs[i].length; ++j) {
                line = line + subs[i][j] + ",";
            }
            line = line.substring(0, line.length() - 1);
            cout.println(line);
            cout.flush();
        }
    }
}

