/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;
import EDU.oswego.cs.dl.util.concurrent.misc.Fraction;
import EDU.oswego.cs.dl.util.concurrent.misc.PrioritySemRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.RNG;

class TestLoop {
    final RNG shared;
    final RNG primary;
    final int iters;
    final Fraction pshared;
    final CyclicBarrier barrier;
    final boolean[] useShared;
    final int firstidx;

    public TestLoop(RNG rNG, RNG rNG2, Fraction fraction, int n, CyclicBarrier cyclicBarrier) {
        this.shared = rNG;
        this.primary = rNG2;
        this.pshared = fraction;
        this.iters = n;
        this.barrier = cyclicBarrier;
        this.firstidx = (int)this.primary.get();
        int n2 = (int)this.pshared.numerator();
        int n3 = (int)this.pshared.denominator();
        if (n2 == 0 || this.primary == this.shared) {
            this.useShared = new boolean[1];
            this.useShared[0] = false;
        } else if (n2 >= n3) {
            this.useShared = new boolean[1];
            this.useShared[0] = true;
        } else {
            int n4;
            int n5 = 1024 / n3;
            if (n5 < 1) {
                n5 = 1;
            }
            this.useShared = new boolean[n3 * n5];
            for (n4 = 0; n4 < n2 * n5; ++n4) {
                this.useShared[n4] = true;
            }
            for (n4 = n2 * n5; n4 < n3 * n5; ++n4) {
                this.useShared[n4] = false;
            }
            for (n4 = 1; n4 < this.useShared.length; ++n4) {
                int n6 = (int)(this.shared.next() & Integer.MAX_VALUE) % (n4 + 1);
                boolean bl = this.useShared[n4];
                this.useShared[n4] = this.useShared[n6];
                this.useShared[n6] = bl;
            }
        }
    }

    public Runnable testLoop() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                int n = RNG.itersPerBarrier.get();
                try {
                    int n2 = -1;
                    if (TestLoop.this.primary.getClass().equals(PrioritySemRNG.class)) {
                        n2 = 2 - (int)(TestLoop.this.primary.get() % 5L);
                    }
                    Thread.currentThread().setPriority(5 + n2);
                    int n3 = (int)((double)TestLoop.this.iters * TestLoop.this.pshared.asDouble());
                    int n4 = TestLoop.this.iters - n3;
                    int n5 = TestLoop.this.firstidx;
                    TestLoop.this.barrier.barrier();
                    int n6 = TestLoop.this.iters;
                    while (n6 > 0) {
                        ++n5;
                        if (n6 % n == 0) {
                            TestLoop.this.primary.exchange();
                        } else {
                            RNG rNG;
                            if (n3 > 0 && TestLoop.this.useShared[n5 % TestLoop.this.useShared.length]) {
                                --n3;
                                rNG = TestLoop.this.shared;
                            } else {
                                --n4;
                                rNG = TestLoop.this.primary;
                            }
                            long l = rNG.next();
                            if (l % 2L == 0L && Thread.currentThread().isInterrupted()) {
                                return;
                            }
                        }
                        --n6;
                    }
                    return;
                }
                catch (BrokenBarrierException brokenBarrierException) {
                    try {
                        TestLoop.this.barrier.barrier();
                        return;
                    }
                    catch (BrokenBarrierException brokenBarrierException2) {
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    finally {
                        Thread.currentThread().setPriority(5);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
                finally {
                    try {
                        TestLoop.this.barrier.barrier();
                    }
                    catch (BrokenBarrierException brokenBarrierException) {
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    finally {
                        Thread.currentThread().setPriority(5);
                    }
                }
            }
        };
    }
}

