# HypIgu

**HypIgu** (**HYP**erplane **IGU**sa) is a [SageMath](https://www.sagemath.org/) package that provides functions to compute the Igusa local zeta function associated with hyperplane arrangements. It further contains various constructions of hyperplane arrangements and functions to compute their flag Hilbert&ndash;Poincaré series and other zeta functions. 

## Installation & Setup

The simplest way to install HypIgu in Sage is by running 

```bash
$ sage --pip install hypigu
```

HypIgu source files can be downloaded here: [Latest version](https://github.com/joshmaglione/hypigu/releases/latest)

This package is compatible with SageMath version 9.2 and later and has no external dependencies.

## Documentation

Found [online](https://joshmaglione.github.io/hypigu/) at

[joshmaglione.github.io/hypigu](https://joshmaglione.github.io/hypigu/)

HTML files are also found in the repo in `docs/` folder: 
- Home: `./docs/index.html`
    - Constructors: `./docs/constructors/index.html`
    - Lattices: `./docs/lattices/index.html`
    - Rational Functions: `./docs/rational-functions/index.html`

## Funding 

This package is funded in part by DFG grant [373111162](https://gepris.dfg.de/gepris/projekt/373111162?language=en).

## Copyright & License

Copyright 2021 Joshua Maglione.

HypIgu is distributed with the MIT License.

## References 

1. [Joshua Maglione](https://www.math.uni-bielefeld.de/~jmaglione/) and [Christopher Voll](https://www.math.uni-bielefeld.de/~voll/). Flag Hilbert&ndash;Poincar&#233; series of hyperplane arrangements and their Igusa zeta functions, 2021. [arXiv:2103:03640](https://arxiv.org/abs/2103.03640).
   