"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const core_1 = require("@aws-solutions-constructs/core");
const ecs = require("aws-cdk-lib/aws-ecs");
const test_helper_1 = require("./test-helper");
const integ_tests_alpha_1 = require("@aws-cdk/integ-tests-alpha");
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, (0, core_1.generateIntegStackName)(__filename));
const existingVpc = (0, core_1.getTestVpc)(stack);
const image = ecs.ContainerImage.fromRegistry('nginx');
const destination = (0, test_helper_1.GetTestFirehoseDestination)(stack, 'destination-firehose');
const createFargateServiceResponse = (0, core_1.CreateFargateService)(stack, 'test', {
    constructVpc: existingVpc,
    clientContainerDefinitionProps: { image },
});
new lib_1.FargateToKinesisFirehose(stack, 'test-fargate-kinesisstreams', {
    publicApi: true,
    existingVpc,
    existingFargateServiceObject: createFargateServiceResponse.service,
    existingContainerDefinitionObject: createFargateServiceResponse.containerDefinition,
    existingKinesisFirehose: destination.kinesisFirehose
});
(0, core_1.suppressCustomHandlerCfnNagWarnings)(stack, 'Custom::S3AutoDeleteObjectsCustomResourceProvider');
(0, core_1.suppressCustomHandlerCfnNagWarnings)(stack, 'Custom::VpcRestrictDefaultSGCustomResourceProvider');
new integ_tests_alpha_1.IntegTest(stack, 'Integ', { testCases: [
        stack
    ] });
//# sourceMappingURL=data:application/json;base64,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