"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpUserPoolAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Authorize Http Api routes on whether the requester is registered as part of
 * an AWS Cognito user pool.
 */
class HttpUserPoolAuthorizer {
    /**
     * Initialize a Cognito user pool authorizer to be bound with HTTP route.
     * @param id The id of the underlying construct
     * @param pool The user pool to use for authorization
     * @param props Properties to configure the authorizer
     */
    constructor(id, pool, props = {}) {
        this.id = id;
        this.pool = pool;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_alpha_HttpUserPoolAuthorizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpUserPoolAuthorizer);
            }
            throw error;
        }
    }
    bind(options) {
        if (!this.authorizer) {
            const region = this.props.userPoolRegion ?? aws_cdk_lib_1.Stack.of(options.scope).region;
            const clients = this.props.userPoolClients ?? [this.pool.addClient('UserPoolAuthorizerClient')];
            this.authorizer = new aws_apigatewayv2_alpha_1.HttpAuthorizer(options.scope, this.id, {
                httpApi: options.route.httpApi,
                identitySource: this.props.identitySource ?? ['$request.header.Authorization'],
                type: aws_apigatewayv2_alpha_1.HttpAuthorizerType.JWT,
                authorizerName: this.props.authorizerName ?? this.id,
                jwtAudience: clients.map((c) => c.userPoolClientId),
                jwtIssuer: `https://cognito-idp.${region}.amazonaws.com/${this.pool.userPoolId}`,
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'JWT',
        };
    }
}
exports.HttpUserPoolAuthorizer = HttpUserPoolAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpUserPoolAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers-alpha.HttpUserPoolAuthorizer", version: "2.35.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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