# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function
import tensorflow as tf
import tensorflow.contrib.slim as slim


class ResNetPytorchBackbone(object):

    def __init__(self, cfgs):
        self.cfgs = cfgs
        self._weights_dict = {}
        self.freeze_blocks_node_index = {'resnext50_32x4d': 356, 'resnet50': 356, 'resnext101_32x8d': 662,
                                         'resnet34': 243}
        self.is_training = False
        self.scope_name = 'resnet50'

    def load_weights(self, weight_file):
        import numpy as np

        if weight_file is None:
            return
        try:
            weights_dict = np.load(weight_file, allow_pickle=True).item()
        except:
            weights_dict = np.load(weight_file, allow_pickle=True, encoding='bytes').item()

        return weights_dict

    def resnext50_32x4d(self, inputs, weight_file=None):
        feature_dict = {}
        self._weights_dict = self.load_weights(weight_file)

        # inputs = tf.placeholder(tf.float32, shape=(None, 224, 224, 3), name='inputs')
        node321_pad = tf.pad(inputs, paddings=[[0, 0], [3, 3], [3, 3], [0, 0]])
        node321 = self.convolution(node321_pad, group=1, strides=[2, 2], padding='VALID', name='node321')
        node322 = self.batch_normalization(node321, variance_epsilon=9.999999747378752e-06, name='node322')
        node323 = tf.nn.relu(node322, name='node323')
        node324_pad = tf.pad(node323, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]], constant_values=float('-Inf'))
        node324 = tf.nn.max_pool(node324_pad, [1, 3, 3, 1], [1, 2, 2, 1], padding='VALID', name='node324')
        feature_dict["C1"] = node324
        node325 = self.convolution(node324, group=1, strides=[1, 1], padding='VALID', name='node325')
        node333 = self.convolution(node324, group=1, strides=[1, 1], padding='VALID', name='node333')
        node326 = self.batch_normalization(node325, variance_epsilon=9.999999747378752e-06, name='node326')
        node334 = self.batch_normalization(node333, variance_epsilon=9.999999747378752e-06, name='node334')
        node327 = tf.nn.relu(node326, name='node327')
        node328_pad = tf.pad(node327, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node328 = self.convolution(node328_pad, group=32, strides=[1, 1], padding='VALID', name='node328')
        node329 = self.batch_normalization(node328, variance_epsilon=9.999999747378752e-06, name='node329')
        node330 = tf.nn.relu(node329, name='node330')
        node331 = self.convolution(node330, group=1, strides=[1, 1], padding='VALID', name='node331')
        node332 = self.batch_normalization(node331, variance_epsilon=9.999999747378752e-06, name='node332')
        node335 = node332 + node334
        node336 = tf.nn.relu(node335, name='node336')
        node337 = self.convolution(node336, group=1, strides=[1, 1], padding='VALID', name='node337')
        node338 = self.batch_normalization(node337, variance_epsilon=9.999999747378752e-06, name='node338')
        node339 = tf.nn.relu(node338, name='node339')
        node340_pad = tf.pad(node339, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node340 = self.convolution(node340_pad, group=32, strides=[1, 1], padding='VALID', name='node340')
        node341 = self.batch_normalization(node340, variance_epsilon=9.999999747378752e-06, name='node341')
        node342 = tf.nn.relu(node341, name='node342')
        node343 = self.convolution(node342, group=1, strides=[1, 1], padding='VALID', name='node343')
        node344 = self.batch_normalization(node343, variance_epsilon=9.999999747378752e-06, name='node344')
        node345 = node344 + node336
        node346 = tf.nn.relu(node345, name='node346')
        node347 = self.convolution(node346, group=1, strides=[1, 1], padding='VALID', name='node347')
        node348 = self.batch_normalization(node347, variance_epsilon=9.999999747378752e-06, name='node348')
        node349 = tf.nn.relu(node348, name='node349')
        node350_pad = tf.pad(node349, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node350 = self.convolution(node350_pad, group=32, strides=[1, 1], padding='VALID', name='node350')
        node351 = self.batch_normalization(node350, variance_epsilon=9.999999747378752e-06, name='node351')
        node352 = tf.nn.relu(node351, name='node352')
        node353 = self.convolution(node352, group=1, strides=[1, 1], padding='VALID', name='node353')
        node354 = self.batch_normalization(node353, variance_epsilon=9.999999747378752e-06, name='node354')
        node355 = node354 + node346
        node356 = tf.nn.relu(node355, name='node356')
        feature_dict['C2'] = node356
        node357 = self.convolution(node356, group=1, strides=[1, 1], padding='VALID', name='node357')
        node365 = self.convolution(node356, group=1, strides=[2, 2], padding='VALID', name='node365')
        node358 = self.batch_normalization(node357, variance_epsilon=9.999999747378752e-06, name='node358')
        node366 = self.batch_normalization(node365, variance_epsilon=9.999999747378752e-06, name='node366')
        node359 = tf.nn.relu(node358, name='node359')
        node360_pad = tf.pad(node359, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node360 = self.convolution(node360_pad, group=32, strides=[2, 2], padding='VALID', name='node360')
        node361 = self.batch_normalization(node360, variance_epsilon=9.999999747378752e-06, name='node361')
        node362 = tf.nn.relu(node361, name='node362')
        node363 = self.convolution(node362, group=1, strides=[1, 1], padding='VALID', name='node363')
        node364 = self.batch_normalization(node363, variance_epsilon=9.999999747378752e-06, name='node364')
        node367 = node364 + node366
        node368 = tf.nn.relu(node367, name='node368')
        node369 = self.convolution(node368, group=1, strides=[1, 1], padding='VALID', name='node369')
        node370 = self.batch_normalization(node369, variance_epsilon=9.999999747378752e-06, name='node370')
        node371 = tf.nn.relu(node370, name='node371')
        node372_pad = tf.pad(node371, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node372 = self.convolution(node372_pad, group=32, strides=[1, 1], padding='VALID', name='node372')
        node373 = self.batch_normalization(node372, variance_epsilon=9.999999747378752e-06, name='node373')
        node374 = tf.nn.relu(node373, name='node374')
        node375 = self.convolution(node374, group=1, strides=[1, 1], padding='VALID', name='node375')
        node376 = self.batch_normalization(node375, variance_epsilon=9.999999747378752e-06, name='node376')
        node377 = node376 + node368
        node378 = tf.nn.relu(node377, name='node378')
        node379 = self.convolution(node378, group=1, strides=[1, 1], padding='VALID', name='node379')
        node380 = self.batch_normalization(node379, variance_epsilon=9.999999747378752e-06, name='node380')
        node381 = tf.nn.relu(node380, name='node381')
        node382_pad = tf.pad(node381, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node382 = self.convolution(node382_pad, group=32, strides=[1, 1], padding='VALID', name='node382')
        node383 = self.batch_normalization(node382, variance_epsilon=9.999999747378752e-06, name='node383')
        node384 = tf.nn.relu(node383, name='node384')
        node385 = self.convolution(node384, group=1, strides=[1, 1], padding='VALID', name='node385')
        node386 = self.batch_normalization(node385, variance_epsilon=9.999999747378752e-06, name='node386')
        node387 = node386 + node378
        node388 = tf.nn.relu(node387, name='node388')
        node389 = self.convolution(node388, group=1, strides=[1, 1], padding='VALID', name='node389')
        node390 = self.batch_normalization(node389, variance_epsilon=9.999999747378752e-06, name='node390')
        node391 = tf.nn.relu(node390, name='node391')
        node392_pad = tf.pad(node391, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node392 = self.convolution(node392_pad, group=32, strides=[1, 1], padding='VALID', name='node392')
        node393 = self.batch_normalization(node392, variance_epsilon=9.999999747378752e-06, name='node393')
        node394 = tf.nn.relu(node393, name='node394')
        node395 = self.convolution(node394, group=1, strides=[1, 1], padding='VALID', name='node395')
        node396 = self.batch_normalization(node395, variance_epsilon=9.999999747378752e-06, name='node396')
        node397 = node396 + node388
        node398 = tf.nn.relu(node397, name='node398')
        feature_dict['C3'] = node398
        node399 = self.convolution(node398, group=1, strides=[1, 1], padding='VALID', name='node399')
        node407 = self.convolution(node398, group=1, strides=[2, 2], padding='VALID', name='node407')
        node400 = self.batch_normalization(node399, variance_epsilon=9.999999747378752e-06, name='node400')
        node408 = self.batch_normalization(node407, variance_epsilon=9.999999747378752e-06, name='node408')
        node401 = tf.nn.relu(node400, name='node401')
        node402_pad = tf.pad(node401, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node402 = self.convolution(node402_pad, group=32, strides=[2, 2], padding='VALID', name='node402')
        node403 = self.batch_normalization(node402, variance_epsilon=9.999999747378752e-06, name='node403')
        node404 = tf.nn.relu(node403, name='node404')
        node405 = self.convolution(node404, group=1, strides=[1, 1], padding='VALID', name='node405')
        node406 = self.batch_normalization(node405, variance_epsilon=9.999999747378752e-06, name='node406')
        node409 = node406 + node408
        node410 = tf.nn.relu(node409, name='node410')
        node411 = self.convolution(node410, group=1, strides=[1, 1], padding='VALID', name='node411')
        node412 = self.batch_normalization(node411, variance_epsilon=9.999999747378752e-06, name='node412')
        node413 = tf.nn.relu(node412, name='node413')
        node414_pad = tf.pad(node413, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node414 = self.convolution(node414_pad, group=32, strides=[1, 1], padding='VALID', name='node414')
        node415 = self.batch_normalization(node414, variance_epsilon=9.999999747378752e-06, name='node415')
        node416 = tf.nn.relu(node415, name='node416')
        node417 = self.convolution(node416, group=1, strides=[1, 1], padding='VALID', name='node417')
        node418 = self.batch_normalization(node417, variance_epsilon=9.999999747378752e-06, name='node418')
        node419 = node418 + node410
        node420 = tf.nn.relu(node419, name='node420')
        node421 = self.convolution(node420, group=1, strides=[1, 1], padding='VALID', name='node421')
        node422 = self.batch_normalization(node421, variance_epsilon=9.999999747378752e-06, name='node422')
        node423 = tf.nn.relu(node422, name='node423')
        node424_pad = tf.pad(node423, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node424 = self.convolution(node424_pad, group=32, strides=[1, 1], padding='VALID', name='node424')
        node425 = self.batch_normalization(node424, variance_epsilon=9.999999747378752e-06, name='node425')
        node426 = tf.nn.relu(node425, name='node426')
        node427 = self.convolution(node426, group=1, strides=[1, 1], padding='VALID', name='node427')
        node428 = self.batch_normalization(node427, variance_epsilon=9.999999747378752e-06, name='node428')
        node429 = node428 + node420
        node430 = tf.nn.relu(node429, name='node430')
        node431 = self.convolution(node430, group=1, strides=[1, 1], padding='VALID', name='node431')
        node432 = self.batch_normalization(node431, variance_epsilon=9.999999747378752e-06, name='node432')
        node433 = tf.nn.relu(node432, name='node433')
        node434_pad = tf.pad(node433, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node434 = self.convolution(node434_pad, group=32, strides=[1, 1], padding='VALID', name='node434')
        node435 = self.batch_normalization(node434, variance_epsilon=9.999999747378752e-06, name='node435')
        node436 = tf.nn.relu(node435, name='node436')
        node437 = self.convolution(node436, group=1, strides=[1, 1], padding='VALID', name='node437')
        node438 = self.batch_normalization(node437, variance_epsilon=9.999999747378752e-06, name='node438')
        node439 = node438 + node430
        node440 = tf.nn.relu(node439, name='node440')
        node441 = self.convolution(node440, group=1, strides=[1, 1], padding='VALID', name='node441')
        node442 = self.batch_normalization(node441, variance_epsilon=9.999999747378752e-06, name='node442')
        node443 = tf.nn.relu(node442, name='node443')
        node444_pad = tf.pad(node443, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node444 = self.convolution(node444_pad, group=32, strides=[1, 1], padding='VALID', name='node444')
        node445 = self.batch_normalization(node444, variance_epsilon=9.999999747378752e-06, name='node445')
        node446 = tf.nn.relu(node445, name='node446')
        node447 = self.convolution(node446, group=1, strides=[1, 1], padding='VALID', name='node447')
        node448 = self.batch_normalization(node447, variance_epsilon=9.999999747378752e-06, name='node448')
        node449 = node448 + node440
        node450 = tf.nn.relu(node449, name='node450')
        node451 = self.convolution(node450, group=1, strides=[1, 1], padding='VALID', name='node451')
        node452 = self.batch_normalization(node451, variance_epsilon=9.999999747378752e-06, name='node452')
        node453 = tf.nn.relu(node452, name='node453')
        node454_pad = tf.pad(node453, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node454 = self.convolution(node454_pad, group=32, strides=[1, 1], padding='VALID', name='node454')
        node455 = self.batch_normalization(node454, variance_epsilon=9.999999747378752e-06, name='node455')
        node456 = tf.nn.relu(node455, name='node456')
        node457 = self.convolution(node456, group=1, strides=[1, 1], padding='VALID', name='node457')
        node458 = self.batch_normalization(node457, variance_epsilon=9.999999747378752e-06, name='node458')
        node459 = node458 + node450
        node460 = tf.nn.relu(node459, name='node460')
        feature_dict['C4'] = node460
        node461 = self.convolution(node460, group=1, strides=[1, 1], padding='VALID', name='node461')
        node469 = self.convolution(node460, group=1, strides=[2, 2], padding='VALID', name='node469')
        node462 = self.batch_normalization(node461, variance_epsilon=9.999999747378752e-06, name='node462')
        node470 = self.batch_normalization(node469, variance_epsilon=9.999999747378752e-06, name='node470')
        node463 = tf.nn.relu(node462, name='node463')
        node464_pad = tf.pad(node463, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node464 = self.convolution(node464_pad, group=32, strides=[2, 2], padding='VALID', name='node464')
        node465 = self.batch_normalization(node464, variance_epsilon=9.999999747378752e-06, name='node465')
        node466 = tf.nn.relu(node465, name='node466')
        node467 = self.convolution(node466, group=1, strides=[1, 1], padding='VALID', name='node467')
        node468 = self.batch_normalization(node467, variance_epsilon=9.999999747378752e-06, name='node468')
        node471 = node468 + node470
        node472 = tf.nn.relu(node471, name='node472')
        node473 = self.convolution(node472, group=1, strides=[1, 1], padding='VALID', name='node473')
        node474 = self.batch_normalization(node473, variance_epsilon=9.999999747378752e-06, name='node474')
        node475 = tf.nn.relu(node474, name='node475')
        node476_pad = tf.pad(node475, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node476 = self.convolution(node476_pad, group=32, strides=[1, 1], padding='VALID', name='node476')
        node477 = self.batch_normalization(node476, variance_epsilon=9.999999747378752e-06, name='node477')
        node478 = tf.nn.relu(node477, name='node478')
        node479 = self.convolution(node478, group=1, strides=[1, 1], padding='VALID', name='node479')
        node480 = self.batch_normalization(node479, variance_epsilon=9.999999747378752e-06, name='node480')
        node481 = node480 + node472
        node482 = tf.nn.relu(node481, name='node482')
        node483 = self.convolution(node482, group=1, strides=[1, 1], padding='VALID', name='node483')
        node484 = self.batch_normalization(node483, variance_epsilon=9.999999747378752e-06, name='node484')
        node485 = tf.nn.relu(node484, name='node485')
        node486_pad = tf.pad(node485, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node486 = self.convolution(node486_pad, group=32, strides=[1, 1], padding='VALID', name='node486')
        node487 = self.batch_normalization(node486, variance_epsilon=9.999999747378752e-06, name='node487')
        node488 = tf.nn.relu(node487, name='node488')
        node489 = self.convolution(node488, group=1, strides=[1, 1], padding='VALID', name='node489')
        node490 = self.batch_normalization(node489, variance_epsilon=9.999999747378752e-06, name='node490')
        node491 = node490 + node482
        node492 = tf.nn.relu(node491, name='node492')
        feature_dict['C5'] = node492
        # node493 = tf.nn.avg_pool(node492, [1, 7, 7, 1], [1, 1, 1, 1], padding='VALID', name='node493')
        # node494 = tf.contrib.layers.flatten(node493)
        # node495_flatten = tf.contrib.layers.flatten(node494)
        # node495 = tf.layers.dense(node495_flatten, 1000,
        #                           kernel_initializer=tf.constant_initializer(_weights_dict['node495']['weights']),
        #                           bias_initializer=tf.constant_initializer(_weights_dict['node495']['bias']),
        #                           use_bias=True)
        return feature_dict

    def resnext101_32x8d(self, inputs, weight_file=None):
        feature_dict = {}
        global _weights_dict
        self._weights_dict = self.load_weights(weight_file)

        # inputs = tf.placeholder(tf.float32, shape=(None, 224, 224, 3), name='inputs')
        node627_pad = tf.pad(inputs, paddings=[[0, 0], [3, 3], [3, 3], [0, 0]])
        node627 = self.convolution(node627_pad, group=1, strides=[2, 2], padding='VALID', name='node627')
        node628 = self.batch_normalization(node627, variance_epsilon=9.999999747378752e-06, name='node628')
        node629 = tf.nn.relu(node628, name='node629')
        node630_pad = tf.pad(node629, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]], constant_values=float('-Inf'))
        node630 = tf.nn.max_pool(node630_pad, [1, 3, 3, 1], [1, 2, 2, 1], padding='VALID', name='node630')
        feature_dict['C1'] = node630
        node631 = self.convolution(node630, group=1, strides=[1, 1], padding='VALID', name='node631')
        node639 = self.convolution(node630, group=1, strides=[1, 1], padding='VALID', name='node639')
        node632 = self.batch_normalization(node631, variance_epsilon=9.999999747378752e-06, name='node632')
        node640 = self.batch_normalization(node639, variance_epsilon=9.999999747378752e-06, name='node640')
        node633 = tf.nn.relu(node632, name='node633')
        node634_pad = tf.pad(node633, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node634 = self.convolution(node634_pad, group=32, strides=[1, 1], padding='VALID', name='node634')
        node635 = self.batch_normalization(node634, variance_epsilon=9.999999747378752e-06, name='node635')
        node636 = tf.nn.relu(node635, name='node636')
        node637 = self.convolution(node636, group=1, strides=[1, 1], padding='VALID', name='node637')
        node638 = self.batch_normalization(node637, variance_epsilon=9.999999747378752e-06, name='node638')
        node641 = node638 + node640
        node642 = tf.nn.relu(node641, name='node642')
        node643 = self.convolution(node642, group=1, strides=[1, 1], padding='VALID', name='node643')
        node644 = self.batch_normalization(node643, variance_epsilon=9.999999747378752e-06, name='node644')
        node645 = tf.nn.relu(node644, name='node645')
        node646_pad = tf.pad(node645, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node646 = self.convolution(node646_pad, group=32, strides=[1, 1], padding='VALID', name='node646')
        node647 = self.batch_normalization(node646, variance_epsilon=9.999999747378752e-06, name='node647')
        node648 = tf.nn.relu(node647, name='node648')
        node649 = self.convolution(node648, group=1, strides=[1, 1], padding='VALID', name='node649')
        node650 = self.batch_normalization(node649, variance_epsilon=9.999999747378752e-06, name='node650')
        node651 = node650 + node642
        node652 = tf.nn.relu(node651, name='node652')
        node653 = self.convolution(node652, group=1, strides=[1, 1], padding='VALID', name='node653')
        node654 = self.batch_normalization(node653, variance_epsilon=9.999999747378752e-06, name='node654')
        node655 = tf.nn.relu(node654, name='node655')
        node656_pad = tf.pad(node655, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node656 = self.convolution(node656_pad, group=32, strides=[1, 1], padding='VALID', name='node656')
        node657 = self.batch_normalization(node656, variance_epsilon=9.999999747378752e-06, name='node657')
        node658 = tf.nn.relu(node657, name='node658')
        node659 = self.convolution(node658, group=1, strides=[1, 1], padding='VALID', name='node659')
        node660 = self.batch_normalization(node659, variance_epsilon=9.999999747378752e-06, name='node660')
        node661 = node660 + node652
        node662 = tf.nn.relu(node661, name='node662')
        feature_dict['C2'] = node662
        node663 = self.convolution(node662, group=1, strides=[1, 1], padding='VALID', name='node663')
        node671 = self.convolution(node662, group=1, strides=[2, 2], padding='VALID', name='node671')
        node664 = self.batch_normalization(node663, variance_epsilon=9.999999747378752e-06, name='node664')
        node672 = self.batch_normalization(node671, variance_epsilon=9.999999747378752e-06, name='node672')
        node665 = tf.nn.relu(node664, name='node665')
        node666_pad = tf.pad(node665, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node666 = self.convolution(node666_pad, group=32, strides=[2, 2], padding='VALID', name='node666')
        node667 = self.batch_normalization(node666, variance_epsilon=9.999999747378752e-06, name='node667')
        node668 = tf.nn.relu(node667, name='node668')
        node669 = self.convolution(node668, group=1, strides=[1, 1], padding='VALID', name='node669')
        node670 = self.batch_normalization(node669, variance_epsilon=9.999999747378752e-06, name='node670')
        node673 = node670 + node672
        node674 = tf.nn.relu(node673, name='node674')
        node675 = self.convolution(node674, group=1, strides=[1, 1], padding='VALID', name='node675')
        node676 = self.batch_normalization(node675, variance_epsilon=9.999999747378752e-06, name='node676')
        node677 = tf.nn.relu(node676, name='node677')
        node678_pad = tf.pad(node677, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node678 = self.convolution(node678_pad, group=32, strides=[1, 1], padding='VALID', name='node678')
        node679 = self.batch_normalization(node678, variance_epsilon=9.999999747378752e-06, name='node679')
        node680 = tf.nn.relu(node679, name='node680')
        node681 = self.convolution(node680, group=1, strides=[1, 1], padding='VALID', name='node681')
        node682 = self.batch_normalization(node681, variance_epsilon=9.999999747378752e-06, name='node682')
        node683 = node682 + node674
        node684 = tf.nn.relu(node683, name='node684')
        node685 = self.convolution(node684, group=1, strides=[1, 1], padding='VALID', name='node685')
        node686 = self.batch_normalization(node685, variance_epsilon=9.999999747378752e-06, name='node686')
        node687 = tf.nn.relu(node686, name='node687')
        node688_pad = tf.pad(node687, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node688 = self.convolution(node688_pad, group=32, strides=[1, 1], padding='VALID', name='node688')
        node689 = self.batch_normalization(node688, variance_epsilon=9.999999747378752e-06, name='node689')
        node690 = tf.nn.relu(node689, name='node690')
        node691 = self.convolution(node690, group=1, strides=[1, 1], padding='VALID', name='node691')
        node692 = self.batch_normalization(node691, variance_epsilon=9.999999747378752e-06, name='node692')
        node693 = node692 + node684
        node694 = tf.nn.relu(node693, name='node694')
        node695 = self.convolution(node694, group=1, strides=[1, 1], padding='VALID', name='node695')
        node696 = self.batch_normalization(node695, variance_epsilon=9.999999747378752e-06, name='node696')
        node697 = tf.nn.relu(node696, name='node697')
        node698_pad = tf.pad(node697, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node698 = self.convolution(node698_pad, group=32, strides=[1, 1], padding='VALID', name='node698')
        node699 = self.batch_normalization(node698, variance_epsilon=9.999999747378752e-06, name='node699')
        node700 = tf.nn.relu(node699, name='node700')
        node701 = self.convolution(node700, group=1, strides=[1, 1], padding='VALID', name='node701')
        node702 = self.batch_normalization(node701, variance_epsilon=9.999999747378752e-06, name='node702')
        node703 = node702 + node694
        node704 = tf.nn.relu(node703, name='node704')
        feature_dict['C3'] = node704
        node705 = self.convolution(node704, group=1, strides=[1, 1], padding='VALID', name='node705')
        node713 = self.convolution(node704, group=1, strides=[2, 2], padding='VALID', name='node713')
        node706 = self.batch_normalization(node705, variance_epsilon=9.999999747378752e-06, name='node706')
        node714 = self.batch_normalization(node713, variance_epsilon=9.999999747378752e-06, name='node714')
        node707 = tf.nn.relu(node706, name='node707')
        node708_pad = tf.pad(node707, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node708 = self.convolution(node708_pad, group=32, strides=[2, 2], padding='VALID', name='node708')
        node709 = self.batch_normalization(node708, variance_epsilon=9.999999747378752e-06, name='node709')
        node710 = tf.nn.relu(node709, name='node710')
        node711 = self.convolution(node710, group=1, strides=[1, 1], padding='VALID', name='node711')
        node712 = self.batch_normalization(node711, variance_epsilon=9.999999747378752e-06, name='node712')
        node715 = node712 + node714
        node716 = tf.nn.relu(node715, name='node716')
        node717 = self.convolution(node716, group=1, strides=[1, 1], padding='VALID', name='node717')
        node718 = self.batch_normalization(node717, variance_epsilon=9.999999747378752e-06, name='node718')
        node719 = tf.nn.relu(node718, name='node719')
        node720_pad = tf.pad(node719, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node720 = self.convolution(node720_pad, group=32, strides=[1, 1], padding='VALID', name='node720')
        node721 = self.batch_normalization(node720, variance_epsilon=9.999999747378752e-06, name='node721')
        node722 = tf.nn.relu(node721, name='node722')
        node723 = self.convolution(node722, group=1, strides=[1, 1], padding='VALID', name='node723')
        node724 = self.batch_normalization(node723, variance_epsilon=9.999999747378752e-06, name='node724')
        node725 = node724 + node716
        node726 = tf.nn.relu(node725, name='node726')
        node727 = self.convolution(node726, group=1, strides=[1, 1], padding='VALID', name='node727')
        node728 = self.batch_normalization(node727, variance_epsilon=9.999999747378752e-06, name='node728')
        node729 = tf.nn.relu(node728, name='node729')
        node730_pad = tf.pad(node729, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node730 = self.convolution(node730_pad, group=32, strides=[1, 1], padding='VALID', name='node730')
        node731 = self.batch_normalization(node730, variance_epsilon=9.999999747378752e-06, name='node731')
        node732 = tf.nn.relu(node731, name='node732')
        node733 = self.convolution(node732, group=1, strides=[1, 1], padding='VALID', name='node733')
        node734 = self.batch_normalization(node733, variance_epsilon=9.999999747378752e-06, name='node734')
        node735 = node734 + node726
        node736 = tf.nn.relu(node735, name='node736')
        node737 = self.convolution(node736, group=1, strides=[1, 1], padding='VALID', name='node737')
        node738 = self.batch_normalization(node737, variance_epsilon=9.999999747378752e-06, name='node738')
        node739 = tf.nn.relu(node738, name='node739')
        node740_pad = tf.pad(node739, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node740 = self.convolution(node740_pad, group=32, strides=[1, 1], padding='VALID', name='node740')
        node741 = self.batch_normalization(node740, variance_epsilon=9.999999747378752e-06, name='node741')
        node742 = tf.nn.relu(node741, name='node742')
        node743 = self.convolution(node742, group=1, strides=[1, 1], padding='VALID', name='node743')
        node744 = self.batch_normalization(node743, variance_epsilon=9.999999747378752e-06, name='node744')
        node745 = node744 + node736
        node746 = tf.nn.relu(node745, name='node746')
        node747 = self.convolution(node746, group=1, strides=[1, 1], padding='VALID', name='node747')
        node748 = self.batch_normalization(node747, variance_epsilon=9.999999747378752e-06, name='node748')
        node749 = tf.nn.relu(node748, name='node749')
        node750_pad = tf.pad(node749, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node750 = self.convolution(node750_pad, group=32, strides=[1, 1], padding='VALID', name='node750')
        node751 = self.batch_normalization(node750, variance_epsilon=9.999999747378752e-06, name='node751')
        node752 = tf.nn.relu(node751, name='node752')
        node753 = self.convolution(node752, group=1, strides=[1, 1], padding='VALID', name='node753')
        node754 = self.batch_normalization(node753, variance_epsilon=9.999999747378752e-06, name='node754')
        node755 = node754 + node746
        node756 = tf.nn.relu(node755, name='node756')
        node757 = self.convolution(node756, group=1, strides=[1, 1], padding='VALID', name='node757')
        node758 = self.batch_normalization(node757, variance_epsilon=9.999999747378752e-06, name='node758')
        node759 = tf.nn.relu(node758, name='node759')
        node760_pad = tf.pad(node759, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node760 = self.convolution(node760_pad, group=32, strides=[1, 1], padding='VALID', name='node760')
        node761 = self.batch_normalization(node760, variance_epsilon=9.999999747378752e-06, name='node761')
        node762 = tf.nn.relu(node761, name='node762')
        node763 = self.convolution(node762, group=1, strides=[1, 1], padding='VALID', name='node763')
        node764 = self.batch_normalization(node763, variance_epsilon=9.999999747378752e-06, name='node764')
        node765 = node764 + node756
        node766 = tf.nn.relu(node765, name='node766')
        node767 = self.convolution(node766, group=1, strides=[1, 1], padding='VALID', name='node767')
        node768 = self.batch_normalization(node767, variance_epsilon=9.999999747378752e-06, name='node768')
        node769 = tf.nn.relu(node768, name='node769')
        node770_pad = tf.pad(node769, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node770 = self.convolution(node770_pad, group=32, strides=[1, 1], padding='VALID', name='node770')
        node771 = self.batch_normalization(node770, variance_epsilon=9.999999747378752e-06, name='node771')
        node772 = tf.nn.relu(node771, name='node772')
        node773 = self.convolution(node772, group=1, strides=[1, 1], padding='VALID', name='node773')
        node774 = self.batch_normalization(node773, variance_epsilon=9.999999747378752e-06, name='node774')
        node775 = node774 + node766
        node776 = tf.nn.relu(node775, name='node776')
        node777 = self.convolution(node776, group=1, strides=[1, 1], padding='VALID', name='node777')
        node778 = self.batch_normalization(node777, variance_epsilon=9.999999747378752e-06, name='node778')
        node779 = tf.nn.relu(node778, name='node779')
        node780_pad = tf.pad(node779, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node780 = self.convolution(node780_pad, group=32, strides=[1, 1], padding='VALID', name='node780')
        node781 = self.batch_normalization(node780, variance_epsilon=9.999999747378752e-06, name='node781')
        node782 = tf.nn.relu(node781, name='node782')
        node783 = self.convolution(node782, group=1, strides=[1, 1], padding='VALID', name='node783')
        node784 = self.batch_normalization(node783, variance_epsilon=9.999999747378752e-06, name='node784')
        node785 = node784 + node776
        node786 = tf.nn.relu(node785, name='node786')
        node787 = self.convolution(node786, group=1, strides=[1, 1], padding='VALID', name='node787')
        node788 = self.batch_normalization(node787, variance_epsilon=9.999999747378752e-06, name='node788')
        node789 = tf.nn.relu(node788, name='node789')
        node790_pad = tf.pad(node789, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node790 = self.convolution(node790_pad, group=32, strides=[1, 1], padding='VALID', name='node790')
        node791 = self.batch_normalization(node790, variance_epsilon=9.999999747378752e-06, name='node791')
        node792 = tf.nn.relu(node791, name='node792')
        node793 = self.convolution(node792, group=1, strides=[1, 1], padding='VALID', name='node793')
        node794 = self.batch_normalization(node793, variance_epsilon=9.999999747378752e-06, name='node794')
        node795 = node794 + node786
        node796 = tf.nn.relu(node795, name='node796')
        node797 = self.convolution(node796, group=1, strides=[1, 1], padding='VALID', name='node797')
        node798 = self.batch_normalization(node797, variance_epsilon=9.999999747378752e-06, name='node798')
        node799 = tf.nn.relu(node798, name='node799')
        node800_pad = tf.pad(node799, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node800 = self.convolution(node800_pad, group=32, strides=[1, 1], padding='VALID', name='node800')
        node801 = self.batch_normalization(node800, variance_epsilon=9.999999747378752e-06, name='node801')
        node802 = tf.nn.relu(node801, name='node802')
        node803 = self.convolution(node802, group=1, strides=[1, 1], padding='VALID', name='node803')
        node804 = self.batch_normalization(node803, variance_epsilon=9.999999747378752e-06, name='node804')
        node805 = node804 + node796
        node806 = tf.nn.relu(node805, name='node806')
        node807 = self.convolution(node806, group=1, strides=[1, 1], padding='VALID', name='node807')
        node808 = self.batch_normalization(node807, variance_epsilon=9.999999747378752e-06, name='node808')
        node809 = tf.nn.relu(node808, name='node809')
        node810_pad = tf.pad(node809, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node810 = self.convolution(node810_pad, group=32, strides=[1, 1], padding='VALID', name='node810')
        node811 = self.batch_normalization(node810, variance_epsilon=9.999999747378752e-06, name='node811')
        node812 = tf.nn.relu(node811, name='node812')
        node813 = self.convolution(node812, group=1, strides=[1, 1], padding='VALID', name='node813')
        node814 = self.batch_normalization(node813, variance_epsilon=9.999999747378752e-06, name='node814')
        node815 = node814 + node806
        node816 = tf.nn.relu(node815, name='node816')
        node817 = self.convolution(node816, group=1, strides=[1, 1], padding='VALID', name='node817')
        node818 = self.batch_normalization(node817, variance_epsilon=9.999999747378752e-06, name='node818')
        node819 = tf.nn.relu(node818, name='node819')
        node820_pad = tf.pad(node819, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node820 = self.convolution(node820_pad, group=32, strides=[1, 1], padding='VALID', name='node820')
        node821 = self.batch_normalization(node820, variance_epsilon=9.999999747378752e-06, name='node821')
        node822 = tf.nn.relu(node821, name='node822')
        node823 = self.convolution(node822, group=1, strides=[1, 1], padding='VALID', name='node823')
        node824 = self.batch_normalization(node823, variance_epsilon=9.999999747378752e-06, name='node824')
        node825 = node824 + node816
        node826 = tf.nn.relu(node825, name='node826')
        node827 = self.convolution(node826, group=1, strides=[1, 1], padding='VALID', name='node827')
        node828 = self.batch_normalization(node827, variance_epsilon=9.999999747378752e-06, name='node828')
        node829 = tf.nn.relu(node828, name='node829')
        node830_pad = tf.pad(node829, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node830 = self.convolution(node830_pad, group=32, strides=[1, 1], padding='VALID', name='node830')
        node831 = self.batch_normalization(node830, variance_epsilon=9.999999747378752e-06, name='node831')
        node832 = tf.nn.relu(node831, name='node832')
        node833 = self.convolution(node832, group=1, strides=[1, 1], padding='VALID', name='node833')
        node834 = self.batch_normalization(node833, variance_epsilon=9.999999747378752e-06, name='node834')
        node835 = node834 + node826
        node836 = tf.nn.relu(node835, name='node836')
        node837 = self.convolution(node836, group=1, strides=[1, 1], padding='VALID', name='node837')
        node838 = self.batch_normalization(node837, variance_epsilon=9.999999747378752e-06, name='node838')
        node839 = tf.nn.relu(node838, name='node839')
        node840_pad = tf.pad(node839, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node840 = self.convolution(node840_pad, group=32, strides=[1, 1], padding='VALID', name='node840')
        node841 = self.batch_normalization(node840, variance_epsilon=9.999999747378752e-06, name='node841')
        node842 = tf.nn.relu(node841, name='node842')
        node843 = self.convolution(node842, group=1, strides=[1, 1], padding='VALID', name='node843')
        node844 = self.batch_normalization(node843, variance_epsilon=9.999999747378752e-06, name='node844')
        node845 = node844 + node836
        node846 = tf.nn.relu(node845, name='node846')
        node847 = self.convolution(node846, group=1, strides=[1, 1], padding='VALID', name='node847')
        node848 = self.batch_normalization(node847, variance_epsilon=9.999999747378752e-06, name='node848')
        node849 = tf.nn.relu(node848, name='node849')
        node850_pad = tf.pad(node849, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node850 = self.convolution(node850_pad, group=32, strides=[1, 1], padding='VALID', name='node850')
        node851 = self.batch_normalization(node850, variance_epsilon=9.999999747378752e-06, name='node851')
        node852 = tf.nn.relu(node851, name='node852')
        node853 = self.convolution(node852, group=1, strides=[1, 1], padding='VALID', name='node853')
        node854 = self.batch_normalization(node853, variance_epsilon=9.999999747378752e-06, name='node854')
        node855 = node854 + node846
        node856 = tf.nn.relu(node855, name='node856')
        node857 = self.convolution(node856, group=1, strides=[1, 1], padding='VALID', name='node857')
        node858 = self.batch_normalization(node857, variance_epsilon=9.999999747378752e-06, name='node858')
        node859 = tf.nn.relu(node858, name='node859')
        node860_pad = tf.pad(node859, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node860 = self.convolution(node860_pad, group=32, strides=[1, 1], padding='VALID', name='node860')
        node861 = self.batch_normalization(node860, variance_epsilon=9.999999747378752e-06, name='node861')
        node862 = tf.nn.relu(node861, name='node862')
        node863 = self.convolution(node862, group=1, strides=[1, 1], padding='VALID', name='node863')
        node864 = self.batch_normalization(node863, variance_epsilon=9.999999747378752e-06, name='node864')
        node865 = node864 + node856
        node866 = tf.nn.relu(node865, name='node866')
        node867 = self.convolution(node866, group=1, strides=[1, 1], padding='VALID', name='node867')
        node868 = self.batch_normalization(node867, variance_epsilon=9.999999747378752e-06, name='node868')
        node869 = tf.nn.relu(node868, name='node869')
        node870_pad = tf.pad(node869, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node870 = self.convolution(node870_pad, group=32, strides=[1, 1], padding='VALID', name='node870')
        node871 = self.batch_normalization(node870, variance_epsilon=9.999999747378752e-06, name='node871')
        node872 = tf.nn.relu(node871, name='node872')
        node873 = self.convolution(node872, group=1, strides=[1, 1], padding='VALID', name='node873')
        node874 = self.batch_normalization(node873, variance_epsilon=9.999999747378752e-06, name='node874')
        node875 = node874 + node866
        node876 = tf.nn.relu(node875, name='node876')
        node877 = self.convolution(node876, group=1, strides=[1, 1], padding='VALID', name='node877')
        node878 = self.batch_normalization(node877, variance_epsilon=9.999999747378752e-06, name='node878')
        node879 = tf.nn.relu(node878, name='node879')
        node880_pad = tf.pad(node879, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node880 = self.convolution(node880_pad, group=32, strides=[1, 1], padding='VALID', name='node880')
        node881 = self.batch_normalization(node880, variance_epsilon=9.999999747378752e-06, name='node881')
        node882 = tf.nn.relu(node881, name='node882')
        node883 = self.convolution(node882, group=1, strides=[1, 1], padding='VALID', name='node883')
        node884 = self.batch_normalization(node883, variance_epsilon=9.999999747378752e-06, name='node884')
        node885 = node884 + node876
        node886 = tf.nn.relu(node885, name='node886')
        node887 = self.convolution(node886, group=1, strides=[1, 1], padding='VALID', name='node887')
        node888 = self.batch_normalization(node887, variance_epsilon=9.999999747378752e-06, name='node888')
        node889 = tf.nn.relu(node888, name='node889')
        node890_pad = tf.pad(node889, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node890 = self.convolution(node890_pad, group=32, strides=[1, 1], padding='VALID', name='node890')
        node891 = self.batch_normalization(node890, variance_epsilon=9.999999747378752e-06, name='node891')
        node892 = tf.nn.relu(node891, name='node892')
        node893 = self.convolution(node892, group=1, strides=[1, 1], padding='VALID', name='node893')
        node894 = self.batch_normalization(node893, variance_epsilon=9.999999747378752e-06, name='node894')
        node895 = node894 + node886
        node896 = tf.nn.relu(node895, name='node896')
        node897 = self.convolution(node896, group=1, strides=[1, 1], padding='VALID', name='node897')
        node898 = self.batch_normalization(node897, variance_epsilon=9.999999747378752e-06, name='node898')
        node899 = tf.nn.relu(node898, name='node899')
        node900_pad = tf.pad(node899, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node900 = self.convolution(node900_pad, group=32, strides=[1, 1], padding='VALID', name='node900')
        node901 = self.batch_normalization(node900, variance_epsilon=9.999999747378752e-06, name='node901')
        node902 = tf.nn.relu(node901, name='node902')
        node903 = self.convolution(node902, group=1, strides=[1, 1], padding='VALID', name='node903')
        node904 = self.batch_normalization(node903, variance_epsilon=9.999999747378752e-06, name='node904')
        node905 = node904 + node896
        node906 = tf.nn.relu(node905, name='node906')
        node907 = self.convolution(node906, group=1, strides=[1, 1], padding='VALID', name='node907')
        node908 = self.batch_normalization(node907, variance_epsilon=9.999999747378752e-06, name='node908')
        node909 = tf.nn.relu(node908, name='node909')
        node910_pad = tf.pad(node909, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node910 = self.convolution(node910_pad, group=32, strides=[1, 1], padding='VALID', name='node910')
        node911 = self.batch_normalization(node910, variance_epsilon=9.999999747378752e-06, name='node911')
        node912 = tf.nn.relu(node911, name='node912')
        node913 = self.convolution(node912, group=1, strides=[1, 1], padding='VALID', name='node913')
        node914 = self.batch_normalization(node913, variance_epsilon=9.999999747378752e-06, name='node914')
        node915 = node914 + node906
        node916 = tf.nn.relu(node915, name='node916')
        node917 = self.convolution(node916, group=1, strides=[1, 1], padding='VALID', name='node917')
        node918 = self.batch_normalization(node917, variance_epsilon=9.999999747378752e-06, name='node918')
        node919 = tf.nn.relu(node918, name='node919')
        node920_pad = tf.pad(node919, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node920 = self.convolution(node920_pad, group=32, strides=[1, 1], padding='VALID', name='node920')
        node921 = self.batch_normalization(node920, variance_epsilon=9.999999747378752e-06, name='node921')
        node922 = tf.nn.relu(node921, name='node922')
        node923 = self.convolution(node922, group=1, strides=[1, 1], padding='VALID', name='node923')
        node924 = self.batch_normalization(node923, variance_epsilon=9.999999747378752e-06, name='node924')
        node925 = node924 + node916
        node926 = tf.nn.relu(node925, name='node926')
        node927 = self.convolution(node926, group=1, strides=[1, 1], padding='VALID', name='node927')
        node928 = self.batch_normalization(node927, variance_epsilon=9.999999747378752e-06, name='node928')
        node929 = tf.nn.relu(node928, name='node929')
        node930_pad = tf.pad(node929, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node930 = self.convolution(node930_pad, group=32, strides=[1, 1], padding='VALID', name='node930')
        node931 = self.batch_normalization(node930, variance_epsilon=9.999999747378752e-06, name='node931')
        node932 = tf.nn.relu(node931, name='node932')
        node933 = self.convolution(node932, group=1, strides=[1, 1], padding='VALID', name='node933')
        node934 = self.batch_normalization(node933, variance_epsilon=9.999999747378752e-06, name='node934')
        node935 = node934 + node926
        node936 = tf.nn.relu(node935, name='node936')
        feature_dict['C4'] = node936
        node937 = self.convolution(node936, group=1, strides=[1, 1], padding='VALID', name='node937')
        node945 = self.convolution(node936, group=1, strides=[2, 2], padding='VALID', name='node945')
        node938 = self.batch_normalization(node937, variance_epsilon=9.999999747378752e-06, name='node938')
        node946 = self.batch_normalization(node945, variance_epsilon=9.999999747378752e-06, name='node946')
        node939 = tf.nn.relu(node938, name='node939')
        node940_pad = tf.pad(node939, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node940 = self.convolution(node940_pad, group=32, strides=[2, 2], padding='VALID', name='node940')
        node941 = self.batch_normalization(node940, variance_epsilon=9.999999747378752e-06, name='node941')
        node942 = tf.nn.relu(node941, name='node942')
        node943 = self.convolution(node942, group=1, strides=[1, 1], padding='VALID', name='node943')
        node944 = self.batch_normalization(node943, variance_epsilon=9.999999747378752e-06, name='node944')
        node947 = node944 + node946
        node948 = tf.nn.relu(node947, name='node948')
        node949 = self.convolution(node948, group=1, strides=[1, 1], padding='VALID', name='node949')
        node950 = self.batch_normalization(node949, variance_epsilon=9.999999747378752e-06, name='node950')
        node951 = tf.nn.relu(node950, name='node951')
        node952_pad = tf.pad(node951, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node952 = self.convolution(node952_pad, group=32, strides=[1, 1], padding='VALID', name='node952')
        node953 = self.batch_normalization(node952, variance_epsilon=9.999999747378752e-06, name='node953')
        node954 = tf.nn.relu(node953, name='node954')
        node955 = self.convolution(node954, group=1, strides=[1, 1], padding='VALID', name='node955')
        node956 = self.batch_normalization(node955, variance_epsilon=9.999999747378752e-06, name='node956')
        node957 = node956 + node948
        node958 = tf.nn.relu(node957, name='node958')
        node959 = self.convolution(node958, group=1, strides=[1, 1], padding='VALID', name='node959')
        node960 = self.batch_normalization(node959, variance_epsilon=9.999999747378752e-06, name='node960')
        node961 = tf.nn.relu(node960, name='node961')
        node962_pad = tf.pad(node961, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node962 = self.convolution(node962_pad, group=32, strides=[1, 1], padding='VALID', name='node962')
        node963 = self.batch_normalization(node962, variance_epsilon=9.999999747378752e-06, name='node963')
        node964 = tf.nn.relu(node963, name='node964')
        node965 = self.convolution(node964, group=1, strides=[1, 1], padding='VALID', name='node965')
        node966 = self.batch_normalization(node965, variance_epsilon=9.999999747378752e-06, name='node966')
        node967 = node966 + node958
        node968 = tf.nn.relu(node967, name='node968')
        feature_dict['C5'] = node968
        # node969 = tf.nn.avg_pool(node968, [1, 7, 7, 1], [1, 1, 1, 1], padding='VALID', name='node969')
        # node970 = tf.contrib.layers.flatten(node969)
        # node971_flatten = tf.contrib.layers.flatten(node970)
        # node971 = tf.layers.dense(node971_flatten, 1000,
        #                           kernel_initializer=tf.constant_initializer(_weights_dict['node971']['weights']),
        #                           bias_initializer=tf.constant_initializer(_weights_dict['node971']['bias']),
        #                           use_bias=True)
        return feature_dict

    def resnet34(self, inputs, weight_file=None):
        feature_dict = {}
        global _weights_dict
        self._weights_dict = self.load_weights(weight_file)

        # inputs = tf.placeholder(tf.float32, shape=(None, 224, 224, 3), name='inputs')
        node219_pad = tf.pad(inputs, paddings=[[0, 0], [3, 3], [3, 3], [0, 0]])
        node219 = self.convolution(node219_pad, group=1, strides=[2, 2], padding='VALID', name='node219')
        node220 = self.batch_normalization(node219, variance_epsilon=9.999999747378752e-06, name='node220')
        node221 = tf.nn.relu(node220, name='node221')
        node222_pad = tf.pad(node221, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]], constant_values=float('-Inf'))
        node222 = tf.nn.max_pool(node222_pad, [1, 3, 3, 1], [1, 2, 2, 1], padding='VALID', name='node222')
        feature_dict['C1'] = node222
        node223_pad = tf.pad(node222, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node223 = self.convolution(node223_pad, group=1, strides=[1, 1], padding='VALID', name='node223')
        node224 = self.batch_normalization(node223, variance_epsilon=9.999999747378752e-06, name='node224')
        node225 = tf.nn.relu(node224, name='node225')
        node226_pad = tf.pad(node225, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node226 = self.convolution(node226_pad, group=1, strides=[1, 1], padding='VALID', name='node226')
        node227 = self.batch_normalization(node226, variance_epsilon=9.999999747378752e-06, name='node227')
        node228 = node227 + node222
        node229 = tf.nn.relu(node228, name='node229')
        node230_pad = tf.pad(node229, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node230 = self.convolution(node230_pad, group=1, strides=[1, 1], padding='VALID', name='node230')
        node231 = self.batch_normalization(node230, variance_epsilon=9.999999747378752e-06, name='node231')
        node232 = tf.nn.relu(node231, name='node232')
        node233_pad = tf.pad(node232, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node233 = self.convolution(node233_pad, group=1, strides=[1, 1], padding='VALID', name='node233')
        node234 = self.batch_normalization(node233, variance_epsilon=9.999999747378752e-06, name='node234')
        node235 = node234 + node229
        node236 = tf.nn.relu(node235, name='node236')
        node237_pad = tf.pad(node236, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node237 = self.convolution(node237_pad, group=1, strides=[1, 1], padding='VALID', name='node237')
        node238 = self.batch_normalization(node237, variance_epsilon=9.999999747378752e-06, name='node238')
        node239 = tf.nn.relu(node238, name='node239')
        node240_pad = tf.pad(node239, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node240 = self.convolution(node240_pad, group=1, strides=[1, 1], padding='VALID', name='node240')
        node241 = self.batch_normalization(node240, variance_epsilon=9.999999747378752e-06, name='node241')
        node242 = node241 + node236
        node243 = tf.nn.relu(node242, name='node243')
        feature_dict['C1'] = node243
        node244_pad = tf.pad(node243, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node244 = self.convolution(node244_pad, group=1, strides=[2, 2], padding='VALID', name='node244')
        node249 = self.convolution(node243, group=1, strides=[2, 2], padding='VALID', name='node249')
        node245 = self.batch_normalization(node244, variance_epsilon=9.999999747378752e-06, name='node245')
        node250 = self.batch_normalization(node249, variance_epsilon=9.999999747378752e-06, name='node250')
        node246 = tf.nn.relu(node245, name='node246')
        node247_pad = tf.pad(node246, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node247 = self.convolution(node247_pad, group=1, strides=[1, 1], padding='VALID', name='node247')
        node248 = self.batch_normalization(node247, variance_epsilon=9.999999747378752e-06, name='node248')
        node251 = node248 + node250
        node252 = tf.nn.relu(node251, name='node252')
        node253_pad = tf.pad(node252, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node253 = self.convolution(node253_pad, group=1, strides=[1, 1], padding='VALID', name='node253')
        node254 = self.batch_normalization(node253, variance_epsilon=9.999999747378752e-06, name='node254')
        node255 = tf.nn.relu(node254, name='node255')
        node256_pad = tf.pad(node255, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node256 = self.convolution(node256_pad, group=1, strides=[1, 1], padding='VALID', name='node256')
        node257 = self.batch_normalization(node256, variance_epsilon=9.999999747378752e-06, name='node257')
        node258 = node257 + node252
        node259 = tf.nn.relu(node258, name='node259')
        node260_pad = tf.pad(node259, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node260 = self.convolution(node260_pad, group=1, strides=[1, 1], padding='VALID', name='node260')
        node261 = self.batch_normalization(node260, variance_epsilon=9.999999747378752e-06, name='node261')
        node262 = tf.nn.relu(node261, name='node262')
        node263_pad = tf.pad(node262, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node263 = self.convolution(node263_pad, group=1, strides=[1, 1], padding='VALID', name='node263')
        node264 = self.batch_normalization(node263, variance_epsilon=9.999999747378752e-06, name='node264')
        node265 = node264 + node259
        node266 = tf.nn.relu(node265, name='node266')
        node267_pad = tf.pad(node266, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node267 = self.convolution(node267_pad, group=1, strides=[1, 1], padding='VALID', name='node267')
        node268 = self.batch_normalization(node267, variance_epsilon=9.999999747378752e-06, name='node268')
        node269 = tf.nn.relu(node268, name='node269')
        node270_pad = tf.pad(node269, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node270 = self.convolution(node270_pad, group=1, strides=[1, 1], padding='VALID', name='node270')
        node271 = self.batch_normalization(node270, variance_epsilon=9.999999747378752e-06, name='node271')
        node272 = node271 + node266
        node273 = tf.nn.relu(node272, name='node273')
        feature_dict['C3'] = node273
        node274_pad = tf.pad(node273, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node274 = self.convolution(node274_pad, group=1, strides=[2, 2], padding='VALID', name='node274')
        node279 = self.convolution(node273, group=1, strides=[2, 2], padding='VALID', name='node279')
        node275 = self.batch_normalization(node274, variance_epsilon=9.999999747378752e-06, name='node275')
        node280 = self.batch_normalization(node279, variance_epsilon=9.999999747378752e-06, name='node280')
        node276 = tf.nn.relu(node275, name='node276')
        node277_pad = tf.pad(node276, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node277 = self.convolution(node277_pad, group=1, strides=[1, 1], padding='VALID', name='node277')
        node278 = self.batch_normalization(node277, variance_epsilon=9.999999747378752e-06, name='node278')
        node281 = node278 + node280
        node282 = tf.nn.relu(node281, name='node282')
        node283_pad = tf.pad(node282, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node283 = self.convolution(node283_pad, group=1, strides=[1, 1], padding='VALID', name='node283')
        node284 = self.batch_normalization(node283, variance_epsilon=9.999999747378752e-06, name='node284')
        node285 = tf.nn.relu(node284, name='node285')
        node286_pad = tf.pad(node285, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node286 = self.convolution(node286_pad, group=1, strides=[1, 1], padding='VALID', name='node286')
        node287 = self.batch_normalization(node286, variance_epsilon=9.999999747378752e-06, name='node287')
        node288 = node287 + node282
        node289 = tf.nn.relu(node288, name='node289')
        node290_pad = tf.pad(node289, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node290 = self.convolution(node290_pad, group=1, strides=[1, 1], padding='VALID', name='node290')
        node291 = self.batch_normalization(node290, variance_epsilon=9.999999747378752e-06, name='node291')
        node292 = tf.nn.relu(node291, name='node292')
        node293_pad = tf.pad(node292, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node293 = self.convolution(node293_pad, group=1, strides=[1, 1], padding='VALID', name='node293')
        node294 = self.batch_normalization(node293, variance_epsilon=9.999999747378752e-06, name='node294')
        node295 = node294 + node289
        node296 = tf.nn.relu(node295, name='node296')
        node297_pad = tf.pad(node296, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node297 = self.convolution(node297_pad, group=1, strides=[1, 1], padding='VALID', name='node297')
        node298 = self.batch_normalization(node297, variance_epsilon=9.999999747378752e-06, name='node298')
        node299 = tf.nn.relu(node298, name='node299')
        node300_pad = tf.pad(node299, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node300 = self.convolution(node300_pad, group=1, strides=[1, 1], padding='VALID', name='node300')
        node301 = self.batch_normalization(node300, variance_epsilon=9.999999747378752e-06, name='node301')
        node302 = node301 + node296
        node303 = tf.nn.relu(node302, name='node303')
        node304_pad = tf.pad(node303, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node304 = self.convolution(node304_pad, group=1, strides=[1, 1], padding='VALID', name='node304')
        node305 = self.batch_normalization(node304, variance_epsilon=9.999999747378752e-06, name='node305')
        node306 = tf.nn.relu(node305, name='node306')
        node307_pad = tf.pad(node306, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node307 = self.convolution(node307_pad, group=1, strides=[1, 1], padding='VALID', name='node307')
        node308 = self.batch_normalization(node307, variance_epsilon=9.999999747378752e-06, name='node308')
        node309 = node308 + node303
        node310 = tf.nn.relu(node309, name='node310')
        node311_pad = tf.pad(node310, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node311 = self.convolution(node311_pad, group=1, strides=[1, 1], padding='VALID', name='node311')
        node312 = self.batch_normalization(node311, variance_epsilon=9.999999747378752e-06, name='node312')
        node313 = tf.nn.relu(node312, name='node313')
        node314_pad = tf.pad(node313, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node314 = self.convolution(node314_pad, group=1, strides=[1, 1], padding='VALID', name='node314')
        node315 = self.batch_normalization(node314, variance_epsilon=9.999999747378752e-06, name='node315')
        node316 = node315 + node310
        node317 = tf.nn.relu(node316, name='node317')
        feature_dict['C4'] = node317
        node318_pad = tf.pad(node317, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node318 = self.convolution(node318_pad, group=1, strides=[2, 2], padding='VALID', name='node318')
        node323 = self.convolution(node317, group=1, strides=[2, 2], padding='VALID', name='node323')
        node319 = self.batch_normalization(node318, variance_epsilon=9.999999747378752e-06, name='node319')
        node324 = self.batch_normalization(node323, variance_epsilon=9.999999747378752e-06, name='node324')
        node320 = tf.nn.relu(node319, name='node320')
        node321_pad = tf.pad(node320, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node321 = self.convolution(node321_pad, group=1, strides=[1, 1], padding='VALID', name='node321')
        node322 = self.batch_normalization(node321, variance_epsilon=9.999999747378752e-06, name='node322')
        node325 = node322 + node324
        node326 = tf.nn.relu(node325, name='node326')
        node327_pad = tf.pad(node326, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node327 = self.convolution(node327_pad, group=1, strides=[1, 1], padding='VALID', name='node327')
        node328 = self.batch_normalization(node327, variance_epsilon=9.999999747378752e-06, name='node328')
        node329 = tf.nn.relu(node328, name='node329')
        node330_pad = tf.pad(node329, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node330 = self.convolution(node330_pad, group=1, strides=[1, 1], padding='VALID', name='node330')
        node331 = self.batch_normalization(node330, variance_epsilon=9.999999747378752e-06, name='node331')
        node332 = node331 + node326
        node333 = tf.nn.relu(node332, name='node333')
        node334_pad = tf.pad(node333, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node334 = self.convolution(node334_pad, group=1, strides=[1, 1], padding='VALID', name='node334')
        node335 = self.batch_normalization(node334, variance_epsilon=9.999999747378752e-06, name='node335')
        node336 = tf.nn.relu(node335, name='node336')
        node337_pad = tf.pad(node336, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node337 = self.convolution(node337_pad, group=1, strides=[1, 1], padding='VALID', name='node337')
        node338 = self.batch_normalization(node337, variance_epsilon=9.999999747378752e-06, name='node338')
        node339 = node338 + node333
        node340 = tf.nn.relu(node339, name='node340')
        feature_dict['C5'] = node340
        # node341 = tf.nn.avg_pool(node340, [1, 7, 7, 1], [1, 1, 1, 1], padding='VALID', name='node341')
        # node342 = tf.contrib.layers.flatten(node341)
        # node343_flatten = tf.contrib.layers.flatten(node342)
        # node343 = tf.layers.dense(node343_flatten, 1000,
        #                           kernel_initializer=tf.constant_initializer(_weights_dict['node343']['weights']),
        #                           bias_initializer=tf.constant_initializer(_weights_dict['node343']['bias']),
        #                           use_bias=True)
        return feature_dict
    
    def resnet50(self, inputs, weight_file=None):
        feature_dict = {}
        global _weights_dict
        self._weights_dict = self.load_weights(weight_file)

        # inputs = tf.placeholder(tf.float32, shape=(None, 224, 224, 3), name='inputs')
        node321_pad = tf.pad(inputs, paddings=[[0, 0], [3, 3], [3, 3], [0, 0]])
        node321 = self.convolution(node321_pad, group=1, strides=[2, 2], padding='VALID', name='node321')
        node322 = self.batch_normalization(node321, variance_epsilon=9.999999747378752e-06, name='node322')
        node323 = tf.nn.relu(node322, name='node323')
        node324_pad = tf.pad(node323, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]], constant_values=float('-Inf'))
        node324 = tf.nn.max_pool(node324_pad, [1, 3, 3, 1], [1, 2, 2, 1], padding='VALID', name='node324')
        feature_dict["C1"] = node324
        node325 = self.convolution(node324, group=1, strides=[1, 1], padding='VALID', name='node325')
        node333 = self.convolution(node324, group=1, strides=[1, 1], padding='VALID', name='node333')
        node326 = self.batch_normalization(node325, variance_epsilon=9.999999747378752e-06, name='node326')
        node334 = self.batch_normalization(node333, variance_epsilon=9.999999747378752e-06, name='node334')
        node327 = tf.nn.relu(node326, name='node327')
        node328_pad = tf.pad(node327, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node328 = self.convolution(node328_pad, group=1, strides=[1, 1], padding='VALID', name='node328')
        node329 = self.batch_normalization(node328, variance_epsilon=9.999999747378752e-06, name='node329')
        node330 = tf.nn.relu(node329, name='node330')
        node331 = self.convolution(node330, group=1, strides=[1, 1], padding='VALID', name='node331')
        node332 = self.batch_normalization(node331, variance_epsilon=9.999999747378752e-06, name='node332')
        node335 = node332 + node334
        node336 = tf.nn.relu(node335, name='node336')
        node337 = self.convolution(node336, group=1, strides=[1, 1], padding='VALID', name='node337')
        node338 = self.batch_normalization(node337, variance_epsilon=9.999999747378752e-06, name='node338')
        node339 = tf.nn.relu(node338, name='node339')
        node340_pad = tf.pad(node339, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node340 = self.convolution(node340_pad, group=1, strides=[1, 1], padding='VALID', name='node340')
        node341 = self.batch_normalization(node340, variance_epsilon=9.999999747378752e-06, name='node341')
        node342 = tf.nn.relu(node341, name='node342')
        node343 = self.convolution(node342, group=1, strides=[1, 1], padding='VALID', name='node343')
        node344 = self.batch_normalization(node343, variance_epsilon=9.999999747378752e-06, name='node344')
        node345 = node344 + node336
        node346 = tf.nn.relu(node345, name='node346')
        node347 = self.convolution(node346, group=1, strides=[1, 1], padding='VALID', name='node347')
        node348 = self.batch_normalization(node347, variance_epsilon=9.999999747378752e-06, name='node348')
        node349 = tf.nn.relu(node348, name='node349')
        node350_pad = tf.pad(node349, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node350 = self.convolution(node350_pad, group=1, strides=[1, 1], padding='VALID', name='node350')
        node351 = self.batch_normalization(node350, variance_epsilon=9.999999747378752e-06, name='node351')
        node352 = tf.nn.relu(node351, name='node352')
        node353 = self.convolution(node352, group=1, strides=[1, 1], padding='VALID', name='node353')
        node354 = self.batch_normalization(node353, variance_epsilon=9.999999747378752e-06, name='node354')
        node355 = node354 + node346
        node356 = tf.nn.relu(node355, name='node356')
        feature_dict['C2'] = node356
        node357 = self.convolution(node356, group=1, strides=[1, 1], padding='VALID', name='node357')
        node365 = self.convolution(node356, group=1, strides=[2, 2], padding='VALID', name='node365')
        node358 = self.batch_normalization(node357, variance_epsilon=9.999999747378752e-06, name='node358')
        node366 = self.batch_normalization(node365, variance_epsilon=9.999999747378752e-06, name='node366')
        node359 = tf.nn.relu(node358, name='node359')
        node360_pad = tf.pad(node359, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node360 = self.convolution(node360_pad, group=1, strides=[2, 2], padding='VALID', name='node360')
        node361 = self.batch_normalization(node360, variance_epsilon=9.999999747378752e-06, name='node361')
        node362 = tf.nn.relu(node361, name='node362')
        node363 = self.convolution(node362, group=1, strides=[1, 1], padding='VALID', name='node363')
        node364 = self.batch_normalization(node363, variance_epsilon=9.999999747378752e-06, name='node364')
        node367 = node364 + node366
        node368 = tf.nn.relu(node367, name='node368')
        node369 = self.convolution(node368, group=1, strides=[1, 1], padding='VALID', name='node369')
        node370 = self.batch_normalization(node369, variance_epsilon=9.999999747378752e-06, name='node370')
        node371 = tf.nn.relu(node370, name='node371')
        node372_pad = tf.pad(node371, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node372 = self.convolution(node372_pad, group=1, strides=[1, 1], padding='VALID', name='node372')
        node373 = self.batch_normalization(node372, variance_epsilon=9.999999747378752e-06, name='node373')
        node374 = tf.nn.relu(node373, name='node374')
        node375 = self.convolution(node374, group=1, strides=[1, 1], padding='VALID', name='node375')
        node376 = self.batch_normalization(node375, variance_epsilon=9.999999747378752e-06, name='node376')
        node377 = node376 + node368
        node378 = tf.nn.relu(node377, name='node378')
        node379 = self.convolution(node378, group=1, strides=[1, 1], padding='VALID', name='node379')
        node380 = self.batch_normalization(node379, variance_epsilon=9.999999747378752e-06, name='node380')
        node381 = tf.nn.relu(node380, name='node381')
        node382_pad = tf.pad(node381, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node382 = self.convolution(node382_pad, group=1, strides=[1, 1], padding='VALID', name='node382')
        node383 = self.batch_normalization(node382, variance_epsilon=9.999999747378752e-06, name='node383')
        node384 = tf.nn.relu(node383, name='node384')
        node385 = self.convolution(node384, group=1, strides=[1, 1], padding='VALID', name='node385')
        node386 = self.batch_normalization(node385, variance_epsilon=9.999999747378752e-06, name='node386')
        node387 = node386 + node378
        node388 = tf.nn.relu(node387, name='node388')
        node389 = self.convolution(node388, group=1, strides=[1, 1], padding='VALID', name='node389')
        node390 = self.batch_normalization(node389, variance_epsilon=9.999999747378752e-06, name='node390')
        node391 = tf.nn.relu(node390, name='node391')
        node392_pad = tf.pad(node391, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node392 = self.convolution(node392_pad, group=1, strides=[1, 1], padding='VALID', name='node392')
        node393 = self.batch_normalization(node392, variance_epsilon=9.999999747378752e-06, name='node393')
        node394 = tf.nn.relu(node393, name='node394')
        node395 = self.convolution(node394, group=1, strides=[1, 1], padding='VALID', name='node395')
        node396 = self.batch_normalization(node395, variance_epsilon=9.999999747378752e-06, name='node396')
        node397 = node396 + node388
        node398 = tf.nn.relu(node397, name='node398')
        feature_dict['C3'] = node398
        node399 = self.convolution(node398, group=1, strides=[1, 1], padding='VALID', name='node399')
        node407 = self.convolution(node398, group=1, strides=[2, 2], padding='VALID', name='node407')
        node400 = self.batch_normalization(node399, variance_epsilon=9.999999747378752e-06, name='node400')
        node408 = self.batch_normalization(node407, variance_epsilon=9.999999747378752e-06, name='node408')
        node401 = tf.nn.relu(node400, name='node401')
        node402_pad = tf.pad(node401, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node402 = self.convolution(node402_pad, group=1, strides=[2, 2], padding='VALID', name='node402')
        node403 = self.batch_normalization(node402, variance_epsilon=9.999999747378752e-06, name='node403')
        node404 = tf.nn.relu(node403, name='node404')
        node405 = self.convolution(node404, group=1, strides=[1, 1], padding='VALID', name='node405')
        node406 = self.batch_normalization(node405, variance_epsilon=9.999999747378752e-06, name='node406')
        node409 = node406 + node408
        node410 = tf.nn.relu(node409, name='node410')
        node411 = self.convolution(node410, group=1, strides=[1, 1], padding='VALID', name='node411')
        node412 = self.batch_normalization(node411, variance_epsilon=9.999999747378752e-06, name='node412')
        node413 = tf.nn.relu(node412, name='node413')
        node414_pad = tf.pad(node413, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node414 = self.convolution(node414_pad, group=1, strides=[1, 1], padding='VALID', name='node414')
        node415 = self.batch_normalization(node414, variance_epsilon=9.999999747378752e-06, name='node415')
        node416 = tf.nn.relu(node415, name='node416')
        node417 = self.convolution(node416, group=1, strides=[1, 1], padding='VALID', name='node417')
        node418 = self.batch_normalization(node417, variance_epsilon=9.999999747378752e-06, name='node418')
        node419 = node418 + node410
        node420 = tf.nn.relu(node419, name='node420')
        node421 = self.convolution(node420, group=1, strides=[1, 1], padding='VALID', name='node421')
        node422 = self.batch_normalization(node421, variance_epsilon=9.999999747378752e-06, name='node422')
        node423 = tf.nn.relu(node422, name='node423')
        node424_pad = tf.pad(node423, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node424 = self.convolution(node424_pad, group=1, strides=[1, 1], padding='VALID', name='node424')
        node425 = self.batch_normalization(node424, variance_epsilon=9.999999747378752e-06, name='node425')
        node426 = tf.nn.relu(node425, name='node426')
        node427 = self.convolution(node426, group=1, strides=[1, 1], padding='VALID', name='node427')
        node428 = self.batch_normalization(node427, variance_epsilon=9.999999747378752e-06, name='node428')
        node429 = node428 + node420
        node430 = tf.nn.relu(node429, name='node430')
        node431 = self.convolution(node430, group=1, strides=[1, 1], padding='VALID', name='node431')
        node432 = self.batch_normalization(node431, variance_epsilon=9.999999747378752e-06, name='node432')
        node433 = tf.nn.relu(node432, name='node433')
        node434_pad = tf.pad(node433, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node434 = self.convolution(node434_pad, group=1, strides=[1, 1], padding='VALID', name='node434')
        node435 = self.batch_normalization(node434, variance_epsilon=9.999999747378752e-06, name='node435')
        node436 = tf.nn.relu(node435, name='node436')
        node437 = self.convolution(node436, group=1, strides=[1, 1], padding='VALID', name='node437')
        node438 = self.batch_normalization(node437, variance_epsilon=9.999999747378752e-06, name='node438')
        node439 = node438 + node430
        node440 = tf.nn.relu(node439, name='node440')
        node441 = self.convolution(node440, group=1, strides=[1, 1], padding='VALID', name='node441')
        node442 = self.batch_normalization(node441, variance_epsilon=9.999999747378752e-06, name='node442')
        node443 = tf.nn.relu(node442, name='node443')
        node444_pad = tf.pad(node443, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node444 = self.convolution(node444_pad, group=1, strides=[1, 1], padding='VALID', name='node444')
        node445 = self.batch_normalization(node444, variance_epsilon=9.999999747378752e-06, name='node445')
        node446 = tf.nn.relu(node445, name='node446')
        node447 = self.convolution(node446, group=1, strides=[1, 1], padding='VALID', name='node447')
        node448 = self.batch_normalization(node447, variance_epsilon=9.999999747378752e-06, name='node448')
        node449 = node448 + node440
        node450 = tf.nn.relu(node449, name='node450')
        node451 = self.convolution(node450, group=1, strides=[1, 1], padding='VALID', name='node451')
        node452 = self.batch_normalization(node451, variance_epsilon=9.999999747378752e-06, name='node452')
        node453 = tf.nn.relu(node452, name='node453')
        node454_pad = tf.pad(node453, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node454 = self.convolution(node454_pad, group=1, strides=[1, 1], padding='VALID', name='node454')
        node455 = self.batch_normalization(node454, variance_epsilon=9.999999747378752e-06, name='node455')
        node456 = tf.nn.relu(node455, name='node456')
        node457 = self.convolution(node456, group=1, strides=[1, 1], padding='VALID', name='node457')
        node458 = self.batch_normalization(node457, variance_epsilon=9.999999747378752e-06, name='node458')
        node459 = node458 + node450
        node460 = tf.nn.relu(node459, name='node460')
        feature_dict['C4'] = node460
        node461 = self.convolution(node460, group=1, strides=[1, 1], padding='VALID', name='node461')
        node469 = self.convolution(node460, group=1, strides=[2, 2], padding='VALID', name='node469')
        node462 = self.batch_normalization(node461, variance_epsilon=9.999999747378752e-06, name='node462')
        node470 = self.batch_normalization(node469, variance_epsilon=9.999999747378752e-06, name='node470')
        node463 = tf.nn.relu(node462, name='node463')
        node464_pad = tf.pad(node463, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node464 = self.convolution(node464_pad, group=1, strides=[2, 2], padding='VALID', name='node464')
        node465 = self.batch_normalization(node464, variance_epsilon=9.999999747378752e-06, name='node465')
        node466 = tf.nn.relu(node465, name='node466')
        node467 = self.convolution(node466, group=1, strides=[1, 1], padding='VALID', name='node467')
        node468 = self.batch_normalization(node467, variance_epsilon=9.999999747378752e-06, name='node468')
        node471 = node468 + node470
        node472 = tf.nn.relu(node471, name='node472')
        node473 = self.convolution(node472, group=1, strides=[1, 1], padding='VALID', name='node473')
        node474 = self.batch_normalization(node473, variance_epsilon=9.999999747378752e-06, name='node474')
        node475 = tf.nn.relu(node474, name='node475')
        node476_pad = tf.pad(node475, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node476 = self.convolution(node476_pad, group=1, strides=[1, 1], padding='VALID', name='node476')
        node477 = self.batch_normalization(node476, variance_epsilon=9.999999747378752e-06, name='node477')
        node478 = tf.nn.relu(node477, name='node478')
        node479 = self.convolution(node478, group=1, strides=[1, 1], padding='VALID', name='node479')
        node480 = self.batch_normalization(node479, variance_epsilon=9.999999747378752e-06, name='node480')
        node481 = node480 + node472
        node482 = tf.nn.relu(node481, name='node482')
        node483 = self.convolution(node482, group=1, strides=[1, 1], padding='VALID', name='node483')
        node484 = self.batch_normalization(node483, variance_epsilon=9.999999747378752e-06, name='node484')
        node485 = tf.nn.relu(node484, name='node485')
        node486_pad = tf.pad(node485, paddings=[[0, 0], [1, 1], [1, 1], [0, 0]])
        node486 = self.convolution(node486_pad, group=1, strides=[1, 1], padding='VALID', name='node486')
        node487 = self.batch_normalization(node486, variance_epsilon=9.999999747378752e-06, name='node487')
        node488 = tf.nn.relu(node487, name='node488')
        node489 = self.convolution(node488, group=1, strides=[1, 1], padding='VALID', name='node489')
        node490 = self.batch_normalization(node489, variance_epsilon=9.999999747378752e-06, name='node490')
        node491 = node490 + node482
        node492 = tf.nn.relu(node491, name='node492')
        feature_dict['C5'] = node492
        # node493 = tf.nn.avg_pool(node492, [1, 7, 7, 1], [1, 1, 1, 1], padding='VALID', name='node493')
        # node494 = tf.contrib.layers.flatten(node493)
        # node495_flatten = tf.contrib.layers.flatten(node494)
        # node495 = tf.layers.dense(node495_flatten, 1000,
        #                           kernel_initializer=tf.constant_initializer(_weights_dict['node495']['weights']),
        #                           bias_initializer=tf.constant_initializer(_weights_dict['node495']['bias']),
        #                           use_bias=True)
        return feature_dict

    def convolution(self, inputs, name, group, **kwargs):
        w = tf.Variable(self._weights_dict[name]['weights'], trainable=self.is_training and int(name[4:]) > self.freeze_blocks_node_index[self.scope_name], name=name + "_weight")
        if group == 1:
            layer = tf.nn.convolution(inputs, w, name=name, **kwargs)
        else:
            weight_groups = tf.split(w, num_or_size_splits=group, axis=-1)
            xs = tf.split(inputs, num_or_size_splits=group, axis=-1)
            convolved = [tf.nn.convolution(x, weight, name=name, **kwargs) for
                         (x, weight) in zip(xs, weight_groups)]
            layer = tf.concat(convolved, axis=-1)

        if 'bias' in self._weights_dict[name]:
            b = tf.Variable(self._weights_dict[name]['bias'], trainable=self.is_training and int(name[4:]) > self.freeze_blocks_node_index[self.scope_name], name=name + "_bias")
            layer += b
        return layer

    def batch_normalization(self, inputs, name, **kwargs):
        mean = tf.Variable(self._weights_dict[name]['mean'], name=name + "_mean", trainable=False)
        variance = tf.Variable(self._weights_dict[name]['var'], name=name + "_var", trainable=False)
        offset = tf.Variable(self._weights_dict[name]['bias'], name=name + "_bias", trainable=False) if 'bias' in self._weights_dict[name] else None
        scale = tf.Variable(self._weights_dict[name]['scale'], name=name + "_scale", trainable=False) if 'scale' in self._weights_dict[name] else None
        return tf.nn.batch_normalization(inputs, mean, variance, offset, scale, name=name, **kwargs)

    def resnet_base(self, img_batch, scope_name, is_training=True):
        if not is_training:
            scope_name = 'tower_0/' + scope_name
        with tf.variable_scope(scope_name):
            weight_file = self.cfgs.PRETRAINED_CKPT
            self.is_training = is_training
            self.scope_name = scope_name
            if self.cfgs.NET_NAME == 'resnext50_32x4d':
                feature_dict = self.resnext50_32x4d(img_batch, weight_file)
            elif self.cfgs.NET_NAME == 'resnext101_32x8d':
                feature_dict = self.resnext101_32x8d(img_batch, weight_file)
            elif self.cfgs.NET_NAME == 'resnet34':
                feature_dict = self.resnet34(img_batch, weight_file)
            else:
                feature_dict = self.resnet50(img_batch, weight_file)

            return feature_dict


