//  SuperTuxKart - a fun racing game with go-kart
//  Copyright (C) 2016-2017 SuperTuxKart-Team
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef CCONTEXT_HPP
#define CCONTEXT_HPP

#include "IrrCompileConfig.h"

struct ContextParams
{
    int device_id = 0;
    bool with_alpha_channel = false;
    int pbuffer_width = 0;
    int pbuffer_height = 0;
    bool debug = false;
};


class ContextManager
{
public:
    ContextManager(const ContextParams& params);
    virtual ~ContextManager();
    virtual bool makeCurrent() = 0;
};

#endif
