/**
 * Controls the countries in which content is distributed.
 *
 * @stability stable
 */
export declare class GeoRestriction {
    readonly restrictionType: 'whitelist' | 'blacklist';
    readonly locations: string[];
    /**
     * Whitelist specific countries which you want CloudFront to distribute your content.
     *
     * @param locations Two-letter, uppercase country code for a country that you want to whitelist.
     * @stability stable
     */
    static whitelist(...locations: string[]): GeoRestriction;
    /**
     * Blacklist specific countries which you don't want CloudFront to distribute your content.
     *
     * @param locations Two-letter, uppercase country code for a country that you want to blacklist.
     * @stability stable
     */
    static blacklist(...locations: string[]): GeoRestriction;
    private static LOCATION_REGEX;
    private static validateLocations;
    /**
     * Creates an instance of GeoRestriction for internal use
     *
     * @param restrictionType Specifies the restriction type to impose (whitelist or blacklist)
     * @param locations Two-letter, uppercase country code for a country
     * that you want to whitelist/blacklist. Include one element for each country.
     * See ISO 3166-1-alpha-2 code on the *International Organization for Standardization* website
     */
    private constructor();
}
