# Generated by Django 2.2.10 on 2020-02-05 06:31

from django.db import migrations, models
import django.db.models.deletion


def transform_criteria_mtm(apps, schema_editor):
    DashboardStats = apps.get_model('admin_tools_stats', 'DashboardStats')
    DashboardStatsCriteria = apps.get_model('admin_tools_stats', 'DashboardStatsCriteria')
    MultiSeriesCriteriaToStats = apps.get_model('admin_tools_stats', 'MultiSeriesCriteriaToStats')
    FilterCriteriaToStats = apps.get_model('admin_tools_stats', 'FilterCriteriaToStats')
    for stats in DashboardStats.objects.all():
        for criteria in stats.criteria.filter(use_as='multiple_series'):
            MultiSeriesCriteriaToStats.objects.create(stats=stats, criteria=criteria)
        for criteria in stats.criteria.filter(use_as='chart_filter'):
            FilterCriteriaToStats.objects.create(stats=stats, criteria=criteria)




class Migration(migrations.Migration):

    dependencies = [
        ('admin_tools_stats', '0005_auto_20200203_1537'),
    ]

    operations = [
        migrations.CreateModel(
            name='MultiSeriesCriteriaToStats',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.PositiveIntegerField(unique=True, null=True, blank=True)),
                ('criteria', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='admin_tools_stats.DashboardStatsCriteria')),
                ('stats', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='admin_tools_stats.DashboardStats')),
            ],
            options={
                'ordering': ('order',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='FilterCriteriaToStats',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.PositiveIntegerField(unique=True, null=True, blank=True)),
                ('criteria', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='admin_tools_stats.DashboardStatsCriteria')),
                ('stats', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='admin_tools_stats.DashboardStats')),
            ],
            options={
                'ordering': ('order',),
                'abstract': False,
            },
        ),
        migrations.RunPython(transform_criteria_mtm, reverse_code=migrations.RunPython.noop),
    ]
