"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makePhysicalId = exports.executeStatement = void 0;
/* eslint-disable-next-line import/no-extraneous-dependencies */
const RedshiftData = require("aws-sdk/clients/redshiftdata");
const redshiftData = new RedshiftData();
async function executeStatement(statement, clusterProps) {
    const executeStatementProps = {
        ClusterIdentifier: clusterProps.clusterName,
        Database: clusterProps.databaseName,
        SecretArn: clusterProps.adminUserArn,
        Sql: statement,
    };
    const executedStatement = await redshiftData.executeStatement(executeStatementProps).promise();
    if (!executedStatement.Id) {
        throw new Error('Service error: Statement execution did not return a statement ID');
    }
    await waitForStatementComplete(executedStatement.Id);
}
exports.executeStatement = executeStatement;
const waitTimeout = 100;
async function waitForStatementComplete(statementId) {
    await new Promise((resolve) => {
        setTimeout(() => resolve(), waitTimeout);
    });
    const statement = await redshiftData.describeStatement({ Id: statementId }).promise();
    if (statement.Status !== 'FINISHED' && statement.Status !== 'FAILED' && statement.Status !== 'ABORTED') {
        return waitForStatementComplete(statementId);
    }
    else if (statement.Status === 'FINISHED') {
        return;
    }
    else {
        throw new Error(`Statement status was ${statement.Status}: ${statement.Error}`);
    }
}
function makePhysicalId(resourceName, clusterProps, requestId) {
    return `${clusterProps.clusterName}:${clusterProps.databaseName}:${resourceName}:${requestId}`;
}
exports.makePhysicalId = makePhysicalId;
//# sourceMappingURL=data:application/json;base64,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